<?php
require_once "check.class.php";
class miscellaneous extends check {

	var $vLogin;
	var $nUser_Id;
	var $nStory_Id;
	var $vStory_Title;
	var $tStory;
	var $vPicURL;
	var $dDate;

	var $arrFile;
	var $arrExtns;

	var $now;
	var $dblink;

	var $nCMS_Id;
	var $vTitle;
	var $tContent;
	var $nUserId;
	var $vActive;

	var $nFreeCode_Id;
	var $vCode;
	var $dStart;
	var $dEnd;

	var $nSE_Id;
	var $vDescription;
	var $vVenue;
	var $vCity;
	var $dDate_Event;

	var $nTestimonial_Id;

	var $nBC_Id;
	var $vType;
	var $vStatus;

	var $arrSearch;

	function  miscellaneous($db)
	{
		$this->dblink	= $db;
		$this->now		= date("Y-m-d H:i:s");
		$this->arrFile	= array();
		$this->arrExtns	= array("jpg", "jpeg", "gif", "png", "JPG", "JPEG", "GIF", "PNG");
		$this->arrSearch= array();
	}

	function set_success_story($arr=array())
	{
		$this->nUser_Id		= isset($arr['nUser_Id'])		?	stripslashes(trim($arr['nUser_Id']))	:	"";
		$this->vLogin		= isset($arr['vLogin'])			?	stripslashes(trim($arr['vLogin']))		:	"";
		$this->vStory_Title	= isset($arr['vStory_Title'])	?	stripslashes(trim($arr['vStory_Title'])):	"";
		$this->tStory		= isset($arr['tStory'])			?	stripslashes(trim($arr['tStory']))		:	"";
		$this->vPicURL		= isset($arr['vPicURL'])		?	stripslashes(trim($arr['vPicURL']))		:	"";
		$this->dDate		= isset($arr['dDate'])			?	stripslashes(trim($arr['dDate']))		:	"";
		$this->arrFile		= isset($arr['file']) && !empty($arr['file'])	?	$arr['file']	   :   array();
	}

	function save_success_story($id=0)
	{
		$message	= $this->check_success_story($id);
		if ($message == "") {
			if ($id >= 1) {
				$message	= $this->update_success_story($id);
			} else {
				$message	= $this->insert_success_story();
			}
		}
		return $message;
	}

	function success_story_exists($uid, $id)
	{
		$flag	= 0;
		$sql	= "SELECT * FROM ".TABLEPREFIX."success_story
		           WHERE nUser_Id = '{$uid}' AND nStory_Id NOT LIKE '{$id}'";
		$res	= @mysql_query($sql, $this->dblink);
		$flag	= @mysql_num_rows($res);
		return $flag;
	}

	function check_success_story($id)
	{
		$message	= "";
		if ($this->vLogin == "")
			$message	.= "Please enter username (loginname) of the user.<br>";
		$this->nUser_Id	= $this->get_user_id(addslashes($this->vLogin));
		if (!$this->nUser_Id)
			$message	.= "User with the loginname <b>".$this->vLogin."</b> doesn't exists.<br>";
//		if ($this->success_story_exists($this->nUser_Id, $id))
//			$message	.= "Another success story already exists for this user.<br>";
		if ($this->vStory_Title == "")
			$message	.= "Please enter title for the story.<br>";
		if ($this->tStory == "")
			$message	.= "Please enter description for the story.<br>";
		if ($this->arrFile['size'] > 0) {
			$extn	= substr(strrchr($this->arrFile['name'], "."), 1);
			if (!in_array($extn, $this->arrExtns)) {
				$message	.= "The extension <b>".$extn."</b>is not allowed.<br>";
			} else {
				$message	.= $this->save_image($id);
			}
		}
		return $message;
	}

	function save_image($id)
	{
		$message	= "";
		if ($id <= 0)
			$message	= $this->upload_image();
		else
			$message	= $this->change_image($id);
		return $message;
	}

	function upload_image()
	{
		$message	= "";
		if (@is_uploaded_file($this->arrFile['tmp_name'])) {
			$extn		= substr(strrchr($this->arrFile['name'], "."), 1);
			$uploadfile	= $this->generate_password().".".$extn;
			if (@move_uploaded_file($this->arrFile['tmp_name'], STORY_IMAGE_PATH.DIRECTORY_SEPARATOR.$uploadfile)) {
				$this->vPicURL	= $uploadfile;
/* Thumbnail code */
				require_once "thumbnail.class.php";
				$objCThumb	= new thumbnail(STORY_IMAGE_PATH.DIRECTORY_SEPARATOR.$uploadfile, 100, 100);
				$objCThumb->save($uploadfile, STORY_IMAGE_PATH.DIRECTORY_SEPARATOR, "sthumb_");
/* Thumbnail code */

			} else {
				$message	.= "File cannot be saved due to possible file upload attack (failed to upload).<br>";
			}
		} else {
			$message	.= "File cannot be saved due to possible file upload attack (not uploadable).<br>";
		}
		return $message;
	}

	function change_image($id)
	{ 
		$message		= "";
		$array			= $this->get_success_story($id);
		$this->vPicURL	= $array['vPicURL'];
		if (@is_uploaded_file($this->arrFile['tmp_name'])) {
			$extn		= substr(strrchr($this->arrFile['name'], "."), 1);
			$uploadfile	= $this->generate_password().".".$extn;
			if (@move_uploaded_file($this->arrFile['tmp_name'], STORY_IMAGE_PATH.DIRECTORY_SEPARATOR.$uploadfile)) {
				if (@is_file(STORY_IMAGE_PATH.DIRECTORY_SEPARATOR.$this->vPicURL)) {
					@unlink(STORY_IMAGE_PATH.DIRECTORY_SEPARATOR.$this->vPicURL);
				}

/* Thumbnail code */
				if (@is_file(STORY_IMAGE_PATH.DIRECTORY_SEPARATOR."sthumb_".$this->vPicURL)) {
					@unlink(STORY_IMAGE_PATH.DIRECTORY_SEPARATOR."sthumb_".$this->vPicURL);
				}
				require_once "thumbnail.class.php";
				$objCThumb	= new thumbnail(STORY_IMAGE_PATH.DIRECTORY_SEPARATOR.$uploadfile, 100, 100);
				$objCThumb->save($uploadfile, STORY_IMAGE_PATH.DIRECTORY_SEPARATOR, "sthumb_");
/* Thumbnail code */

				$this->vPicURL	= $uploadfile;
				$messagae	= $this->change_image_in_table($id);
			} else {
				$message	.= "File cannot be saved due to possible file upload attack.(failed to upload)<br>";
			}
		} else {
			$message	.= "File cannot be saved due to possible file upload attack.(not uploadable)<br>";
		}
		return $message;
	}

	function get_user_id($name="")
	{
		$id		= 0;
		$sql	= "SELECT * FROM ".TABLEPREFIX."user 
				   WHERE vLogin LIKE '{$name}'";
		$res	= @mysql_query($sql, $this->dblink);
		if (@mysql_num_rows($res) > 0) {
			$row	= @mysql_fetch_array($res);
			$id		= $row['nUser_Id'];
		}
		return $id;
	}

	function insert_success_story()
	{
		$messagae	= "";
		$sql		= "INSERT INTO ".TABLEPREFIX."success_story (nUser_Id, vStory_Title,
								   tStory, vPicURL, dDate)
					   VALUES ('".addslashes($this->nUser_Id)."',
							   '".addslashes($this->vStory_Title)."',
							   '".addslashes($this->tStory)."', '".addslashes($this->vPicURL)."',
							   '".addslashes($this->now)."')";
		$res		= @mysql_query($sql, $this->dblink);
		if (!$res)
			$message	.= "Unable to add success story, please try later.<br>";
		return $message;
	}

	function update_success_story($id)
	{
		$messagae	= "";
		$sql		= "UPDATE ".TABLEPREFIX."success_story 
					   SET nUser_Id = '".addslashes($this->nUser_Id)."',
					       vStory_Title = '".addslashes($this->vStory_Title)."',
						   tStory = '".addslashes($this->tStory)."'
					   WHERE nStory_Id = '{$id}'";
		$res		= @mysql_query($sql, $this->dblink);
		if (!$res)
			$message	.= "Unable to update success story image, please try later.<br>";
		return $message;
	}

	function change_image_in_table($id)
	{
		$messagae	= "";
		$sql		= "UPDATE ".TABLEPREFIX."success_story 
					   SET vPicURL  = '".addslashes($this->vPicURL)."'
					   WHERE nStory_Id = '{$id}'";
		$res		= @mysql_query($sql, $this->dblink);
		if (!$res)
			$message	.= "Unable to update success story, please try later.<br>";
		return $message;
	}

	function get_all_stories()
	{
		$array	= array();
		$sql	= "SELECT *,DATE_FORMAT(S.dDate, '%D %M %Y') as dDay
		            FROM ".TABLEPREFIX."success_story as S JOIN ".TABLEPREFIX."user as U 
		            ON S.nUser_Id = U.nUser_Id
					ORDER BY S.nStory_Id DESC";
		$res	= @mysql_query($sql, $this->dblink);
		if (@mysql_num_rows($res) > 0) {
			while ($row = @mysql_fetch_array($res)) {
				$array[]	= $row;
			}
		}
		@mysql_free_result($res);
		return $array;
	}

	function get_success_story($id=0)
	{
		$array	= array();
		$sql	= "SELECT *	FROM ".TABLEPREFIX."success_story as s JOIN ".TABLEPREFIX."user as u ON s.nUser_Id = u.nUser_Id
				   WHERE s.nStory_Id = '{$id}'";
		$res	= @mysql_query($sql, $this->dblink);
		if (@mysql_num_rows($res) > 0) {
			$array = @mysql_fetch_array($res);
		}
		@mysql_free_result($res);
		return $array;
	}

	function delete_stories($arr=array())
	{
		$message	= "";
		$ids		= isset($arr['ids'])	?	$arr['ids']	:	array();
		if (empty($ids))
			$message	=  "Please select the success stories which you need to delete.<br>";
		if ($message == "") {
			$idstring	= implode("','", $ids);

			$arrS		= array();
			$sql		= "SELECT * FROM ".TABLEPREFIX."success_story
			               WHERE nStory_Id IN ('$idstring') AND vPicURL != ''";
			$res		= @mysql_query($sql, $this->dblink);
			if (@mysql_num_rows($res) > 0) {
				while($row = @mysql_fetch_array($res)) {
					$arrS[]	= $row;
				}
			}

			$sql		= "DELETE FROM ".TABLEPREFIX."success_story 
						   WHERE nStory_Id IN ('$idstring')"; 
			$res		= @mysql_query($sql, $this->dblink);
			if (!$res)
				$message	= "<font color='red'>Unable to delete the success stories, please try later.<br></font>";
			else {
				$message	= "<font color='green'>Selected success stories have been successfully deleted.<br></font>";
				if (!empty($arrS)) {
					foreach ($arrS as $key => $value) {
						if (@is_file(STORY_IMAGE_PATH.DIRECTORY_SEPARATOR.$value['vPicURL'])) {
							@unlink(STORY_IMAGE_PATH.DIRECTORY_SEPARATOR.$value['vPicURL']);
						}
						if (@is_file(STORY_IMAGE_PATH.DIRECTORY_SEPARATOR."sthumb_".$value['vPicURL'])) {
							@unlink(STORY_IMAGE_PATH.DIRECTORY_SEPARATOR."sthumb_".$value['vPicURL']);
						}
					}
				}
			}
		}
		return $message;
	}

	/*********** PAYMENTS STARTS **********************/

	function get_all_payments()
	{
		$array	= array();
		$sql	= "SELECT U.nUser_Id, U.vLogin, P.*, DATE_FORMAT(P.dDate, '%D %M %Y') as dDay 
				   FROM ".TABLEPREFIX."payments as P JOIN ".TABLEPREFIX."user as U ON P.nUser_Id = U.nUser_Id";
		$res	= @mysql_query($sql, $this->dblink);
		if (@mysql_num_rows($res) > 0) {
			while ($row = @mysql_fetch_array($res)) {
				$array[]	= $row;
			}
		}
		@mysql_free_result($res);
		return $array;
	}


	/*********** PAYMENTS ENDS **********************/

	function get_all_cms($order=' ')
	{
		$array	= array();
		$sql	= "SELECT * FROM ".TABLEPREFIX."cms";
                if($order!=' '){                
			$sql.= 	   " ORDER BY ".$order;
                                
                }
                else{
                    $sql	.=" ORDER BY nCMS_Id DESC";
                }
		
		$res	= @mysql_query($sql, $this->dblink);
		if (@mysql_num_rows($res) > 0) {
			while ($row = @mysql_fetch_array($res)) {
				$array[]	= $row;
			}
		}
		@mysql_free_result($res);
		return $array;
	}

	/*********** CMS STARTS **********************/

	function set_cms($arr=array())
	{
		$this->nCMS_Id	= isset($arr['nCMS_Id'])	?	stripslashes(trim($arr['nCMS_Id']))	:	"";
		$this->vTitle	= isset($arr['vTitle'])		?	stripslashes(trim($arr['vTitle']))	:	"";
		$this->tContent	= isset($arr['tContent'])	?	stripslashes(trim($arr['tContent'])):	"";
	}

	function get_cms($id=0)
	{
		$array	= array();
		$sql	= "SELECT * FROM ".TABLEPREFIX."cms
		           WHERE nCMS_Id = '{$id}'";
		$res	= @mysql_query($sql, $this->dblink);
		if (@mysql_num_rows($res) > 0) {
			$array = @mysql_fetch_array($res);
		}
		@mysql_free_result($res);
		return $array;
	}

	function save_cms($id=0)
	{
            
		$message	= $this->check_cms($id);
		if ($message == "") {
			echo $sql	= "UPDATE ".TABLEPREFIX."cms
					   SET tContent = '".addslashes($this->tContent)."',vTitle = '".addslashes($this->vTitle)."'
					   WHERE nCMS_Id = '{$id}'";
			$res	= @mysql_query($sql, $this->dblink);
			if (!$res)
				$message	= "Unable to update page content, please try later.<br>";
		}

		return $message;
	}

	function check_cms($id)
	{
		$message	= "";
		if ($id <= 0)
			$message	.= "Invalid page.<br>";
		if ($this->vTitle == "")
			$message	.= "Please enter the title of the page.<br>";
		if ($this->tContent == "")
			$message	.= "Please enter the content of the page.<br>";
		return $message;
	}
	/*********** CMS ENDS **********************/

	/*********** FREE CODE STARTS **********************/

	function set_free_codes($arr=array())
	{
		$this->nFreeCode_Id	= isset($arr['nFreeCode_Id'])	?	stripslashes(trim($arr['nFreeCode_Id'])): "";
		$this->vCode		= isset($arr['vCode'])			?	stripslashes(trim($arr['vCode']))		: "";
		$this->dStart		= isset($arr['dStart'])			?	stripslashes(trim($arr['dStart']))	: date("m/d/Y");
		$this->dEnd			= isset($arr['dEnd'])			?	stripslashes(trim($arr['dEnd']))	: date("m/d/Y");

	}

	function get_all_free_codes()
	{
		$array	= array();
		$sql	= "SELECT nFreeCode_Id, vCode,
		                  DATE_FORMAT(dStart, '%D %M %Y') as dStart,
						  DATE_FORMAT(dEnd, '%D %M %Y') as dEnd
				   FROM ".TABLEPREFIX."free_code 
		           ORDER BY nFreeCode_Id DESC";
		$res	= @mysql_query($sql, $this->dblink);
		if (@mysql_num_rows($res) > 0) {
			while($row = @mysql_fetch_array($res)) {
				$array[]	= $row;
			}
			@mysql_free_result($res);
		}
		return $array;
	}

	function get_free_code($id=0)
	{
		$array	= array();
		$sql	= "SELECT * FROM ".TABLEPREFIX."free_code
		           WHERE nFreeCode_Id = '{$id}'";
		$res	= @mysql_query($sql, $this->dblink);
		if (@mysql_num_rows($res) > 0) {
			$array	= @mysql_fetch_array($res);
		}
		@mysql_free_result($res);
		return $array;
	}

	function free_code_exists($code="", $id=0)
	{
		$flag	= false;
		$sql	= "SELECT * FROM ".TABLEPREFIX."free_code
		           WHERE vCode = '".addslashes($code)."' AND nFreeCode_Id NOT LIKE '{$id}'";
		$res	= @mysql_query($sql, $this->dblink);
		if (@mysql_num_rows($res) > 0)
			$flag	= true;
		return $flag;
	}

	function save_free_code($id=0)
	{
		$message	= $this->check_free_code($id);
		
		//$arrDate1=explode("-",$this->dStart);
                $arrDate1=explode("/",$this->dStart);
		list($month,$date,$year1)=$arrDate1;
		
		//$arrDate2=explode("-",$this->dEnd);
                $arrDate2=explode("/",$this->dEnd);
		list($month,$date,$year2)=$arrDate2;

		if ($message == "") {
			if ($id > 0) {
				$message	= $this->update_free_code($id);
			} else {
					//checking same year or different year
					if($year1==$year2)
					{
						if ($this->dEnd <= date("m/d/Y"))
							$message	.= "End should be greater than today's date.<br>";
					}//end if
					if($year1>$year2)
					{
						if ($this->dEnd >= date("m/d/Y"))
							$message	.= "End should be greater than today's date.<br>";
					}//end else
				    else
					{
						$message	= $this->insert_free_code();
					}
			}
		}
		return $message;
	}

	function check_free_code($id)
	{
		$message	= "";
		
		//$arrDate1=explode("-",$this->dStart);
                $arrDate1=explode("/",$this->dStart);
		list($month,$date,$year1)=$arrDate1;
		
		//$arrDate2=explode("-",$this->dEnd);
                $arrDate2=explode("/",$this->dEnd);
		list($month,$date,$year2)=$arrDate2;

		if ($this->vCode == "")
			$message	.= "Please enter the free code.<br>";
		if ($this->free_code_exists($this->vCode, $id))
			$message	.= "This free code <b>".$this->code."</b> already exists.<br>";
		if (!$this->check_date($this->dStart))
			$message	.= "Please enter a valid date for start date.<br>";
		if (!$this->check_date($this->dEnd))
			$message	.= "Please enter a valid date for end date.<br>";
                //echo strtotime($this->dEnd);
                       // echo"<br>",strtotime($this->dStart);exit;
		//checking same year or different year
		//if($year1==$year2)
		//{
			//if ($this->dEnd <= $this->dStart)
				//$message	.= "End date should be greater than Start date.<br>";
		//}//end if
		//else
		//{
			if (strtotime($this->dEnd) <= strtotime($this->dStart)){
				$message	.= "<font color='red'>End date should be greater than Start date.</font><br>";
		}//end else*/
		return $message;
	}

	function insert_free_code()
	{
		$message	= "";
		
		//$arrDate1=explode("-",$this->dStart);
                $arrDate1=explode("/",$this->dStart);
		list($month,$date,$year)=$arrDate1;
		$newDate1=$year."-".$month."-".$date;

		//$arrDate2=explode("-",$this->dEnd);
                $arrDate2=explode("/",$this->dEnd);
		list($month,$date,$year)=$arrDate2;
		$newDate2=$year."-".$month."-".$date;

		$sql		= "INSERT INTO ".TABLEPREFIX."free_code (vCode, dStart, dEnd)
				       VALUES ('".addslashes($this->vCode)."', '".addslashes($newDate1)."',
					           '".addslashes($newDate2)."')";
		$res	= @mysql_query($sql, $this->dblink);
		if (!$res)
			$message	= "Unable to add free code, please try later.<br>";
		return $message;
	}

	function update_free_code($id)
	{
		$message	= "";

		//$arrDate1=explode("-",$this->dStart);
                $arrDate1=explode("/",$this->dStart);
		list($month,$date,$year)=$arrDate1;
		$newDate1=$year."-".$month."-".$date;

		//$arrDate2=explode("-",$this->dEnd);
                $arrDate2=explode("/",$this->dEnd);
		list($month,$date,$year)=$arrDate2;
		$newDate2=$year."-".$month."-".$date;


		$sql		= "UPDATE ".TABLEPREFIX."free_code
		               SET vCode = '".addslashes($this->vCode)."',
					       dStart = '".addslashes($newDate1)."',
						   dEnd = '".addslashes($newDate2)."'
					   WHERE nFreeCode_Id = '{$id}'";
		$res		= @mysql_query($sql, $this->dblink);
		if (!$res)
			$message	.= "Unable to update free code, please try later.<br>";
		return $message;
	}

	function delete_free_codes($arrID=array())
	{
		$message	= "";
		$ids		= isset($arrID['ids'])	?	$arrID['ids']	:	array();
		if (empty($ids))
			$message	.= "Please select free codes which you need to delete.<br>";
		if ($message == "") {
			$idstring	= implode("','", $ids);
			$sql		= "DELETE FROM ".TABLEPREFIX."free_code
						   WHERE nFreeCode_Id IN ('{$idstring}')";
			$res		= @mysql_query($sql, $this->dblink);
			if (!$res)
				$message	.= "Unable to delete free codes, please try later.<br>";
			else
				$message	.= "<font color='green'> Selected free code(s) deleted successfully.</font><br>";
		}
		return $message;
	}
	/*********** FREE CODE ENDS **********************/

	/*********** FREE SINGLE EVENTS **********************/

	function set_single_events($arr=array())
	{
		$this->nSE_Id	= isset($arr['nSE_Id'])	?	stripslashes(trim($arr['nSE_Id']))	:	"";
		$this->vTitle	= isset($arr['vTitle'])	?	stripslashes(trim($arr['vTitle']))	:	"";
		$this->vVenue	= isset($arr['vVenue'])	?	stripslashes(trim($arr['vVenue']))	:	"";
		$this->vCity	= isset($arr['vCity'])	?	stripslashes(trim($arr['vCity']))	:	"";
		$this->vType	= isset($arr['vType'])	?	stripslashes(trim($arr['vType']))	:	"SE";
		$this->vDescription	= isset($arr['vDescription'])	?	
											stripslashes(trim($arr['vDescription']))	:	"";
		$this->dDate	= isset($arr['dDate'])	?	stripslashes(trim($arr['dDate']))	:	$this->now;
		$this->dDate_Event	= isset($arr['dDate_Event'])	?	
												stripslashes(trim($arr['dDate_Event']))	:	$this->now;
	}

	function get_all_single_events()
	{
		$array	= array();
		$sql	= "SELECT *, DATE_FORMAT(dDate_Event, '%D %M %Y') as dDay
		           FROM ".TABLEPREFIX."single_events
				   ORDER BY nSE_Id DESC";
		$res	= @mysql_query($sql, $this->dblink);
		if (@mysql_num_rows($res) > 0) {
			while($row = @mysql_fetch_array($res)) {
				$array[]	= $row;
			}
			@mysql_free_result($res);
		}
		return $array;
	}

	function get_single_event($id=0)
	{
		$array	= array();
		$sql	= "SELECT * FROM ".TABLEPREFIX."single_events
		           WHERE nSE_Id = '{$id}'";
		$res	= @mysql_query($sql, $this->dblink);
		if (@mysql_num_rows($res) > 0) {
			$array	= @mysql_fetch_array($res);
		}
		@mysql_free_result($res);
		return $array;
	}

	function delete_single_events($arrID=array())
	{
		$message	= "";
		$ids		= isset($arrID['ids'])	?	$arrID['ids']	:	array();
		if (empty($ids))
			$message	.= "Please select event(s) which you need to delete.<br>";
		if ($message == "") {
			$idstring	= implode("','", $ids);
			$sql		= "DELETE FROM ".TABLEPREFIX."single_events
						   WHERE nSE_Id IN ('{$idstring}')";
			$res		= @mysql_query($sql, $this->dblink);
			if (!$res)
				$message	.= "Unable to delete event(s), please try later.<br>";
			else
				$message	.= "<font color='green'>Selected event(s) deleted successfully.</font><br>";
		}
		return $message;
	}

	function save_single_event($id=0)
	{
		$message	= $this->check_single_event($id);
		if ($message == "") {
			if ($id > 0) {
				$message	= $this->update_single_event($id);
			} else {
				$message	= $this->insert_single_event();
			}
		}
		return $message;
	}

	function check_single_event($id)
	{
		$message	= "";
		if ($this->vTitle == "")
			$message	.= "Please enter the title of the event.<br>";
		if ($this->vVenue == "")
			$message	.= "Please enter the venue of the event.<br>";
		if ($this->vCity == "")
			$message	.= "Please enter the city of the event.<br>";
		if ($this->vDescription == "")
			$message	.= "Please enter the description of the event.<br>";
		if ($this->dDate_Event == "")
			$message	.= "Please enter the date of the event.<br>";
		return $message;
	}

	function insert_single_event()
	{
		$message	= "";
		$sql		= "INSERT INTO ".TABLEPREFIX."single_events (vTitle, vDescription,
								   vVenue, vCity, dDate_Event, dDate, vType)
				       VALUES ('".addslashes($this->vTitle)."', '".addslashes($this->vDescription)."',
							   '".addslashes($this->vVenue)."', '".addslashes($this->vCity)."',
							   '".addslashes($this->dDate_Event)."', '".addslashes($this->dDate)."',
							   '".addslashes($this->vType)."')";
		$res		= @mysql_query($sql, $this->dblink);
		if (!$res)
			$message	.= "Unable to add event, please try later.<br>";
		return $message;
	}

	function update_single_event($id)
	{
		$message	= "";
		$sql		= "UPDATE ".TABLEPREFIX."single_events
		               SET vTitle = '".addslashes($this->vTitle)."',
					       vDescription = '".addslashes($this->vDescription)."',
						   vVenue = '".addslashes($this->vVenue)."',
						   vCity = '".addslashes($this->vCity)."',
						   dDate_Event = '".addslashes($this->dDate_Event)."',
						   vType = '".addslashes($this->vType)."' 
					    WHERE nSE_Id = '{$id}'";
		$res		= @mysql_query($sql, $this->dblink);
		if (!$res)
			$message	.= "Unable to update event, please try later.<br>";
		return $message;
	}

	/*********** FREE SINGLE EVENTS **********************/

	function get_all_abuses($order=' ')
	{
		$array	= array();
		$sql	= "SELECT A.*, DATE_FORMAT(A.dDate, '%D %M %Y') as dDay, U.vLogin as vLogin_Abused,
						  U1.vLogin as vLogin_Abusee
		           FROM ".TABLEPREFIX."abuse as A JOIN ".TABLEPREFIX."user as U ON U.nUser_Id = A.nUser_Id_Abused
				   JOIN ".TABLEPREFIX."user as U1 ON U1.nUser_Id = A.nUser_Id_Abusee";
                if($order!=' '){
                    $sql.= 	   " ORDER BY ".$order;
                    
                }
                
                
		$res	= @mysql_query($sql, $this->dblink);
		if (@mysql_num_rows($res) > 0) {
			while($row = @mysql_fetch_array($res)) {
				$array[]	= $row;
			}
			@mysql_free_result($res);
		}
		return $array;
	}

	function delete_abuses($arr=array())
	{
		$message	= "";
		$ids		= isset($arr['ids'])	?	$arr['ids']	:	array();
		if (empty($ids))
			$message	.= "Please select abuses which you need to delete.<br>";
		if ($message == "") {
			$idstring	= implode("','", $ids);
			$sql		= "DELETE FROM ".TABLEPREFIX."abuse
						   WHERE nAbuse_Id IN ('{$idstring}')";
			$res		= @mysql_query($sql, $this->dblink);
			if (!$res)
				$message	.= "Unable to delete abuses, please try later.<br>";
			else
				$message	.= "<font color='green'>Selected abuses deleted successfully.</font><br>";
		}
		return $message;
	}

	function set_testimonial($arr=array())
	{
		$this->nTestimonial_Id	= isset($arr['nTestimonial_Id'])	?	stripslashes(trim($arr['nTestimonial_Id']))	:	"";
		$this->tContent	= isset($arr['tContent'])		?	stripslashes(trim($arr['tContent'])):	"";
		$this->dDate		= $this->now;
		$this->vActive	= isset($arr['vActive'])		?	stripslashes(trim($arr['vActive'])):	"";
	}

	function get_all_testimonials()
	{
		$array	= array();
		$sql	= "SELECT nTestimonial_Id, tContent, nUser_Id, vActive,
		                  DATE_FORMAT(dDate, '%D %M %Y') as dDay
					FROM ".TABLEPREFIX."testimonial ORDER BY nTestimonial_Id DESC";
		$res	= @mysql_query($sql, $this->dblink);
		if (@mysql_num_rows($res) > 0) {
			while($row = @mysql_fetch_array($res)) {
				$array[]	= $row;
			}
			@mysql_free_result($res);
		}
		return $array;
	}

	function get_testimonial($id=0)
	{
		$array	= array();
		$sql	= "SELECT * FROM ".TABLEPREFIX."testimonial
				   WHERE nTestimonial_Id = '{$id}'";
		$res	= @mysql_query($sql, $this->dblink);
		if (@mysql_num_rows($res) > 0) {
			$array	= @mysql_fetch_array($res);
		}
		@mysql_free_result($res);
		return $array;
	}

	function delete_testimonials($arr = array())
	{
		$message	= "";
		$ids		= isset($arr['ids'])	?	$arr['ids']	:	array();
		if (empty($ids))
			$message	.= "Please select testimonial(s) which you need to delete.<br>";
		if ($message == "") {
			$idstring	= implode("','", $ids);
			$sql		= "DELETE FROM ".TABLEPREFIX."testimonial
						   WHERE nTestimonial_Id IN ('{$idstring}')";
			$res		= @mysql_query($sql, $this->dblink);
			if (!$res)
				$message	.= "Unable to delete testimonial(s), please try later.<br>";
			else
				$message	.= "<font color='green'>Selected testimonial(s) deleted successfully.</font><br>";
		}
		return $message;
	}

	function change_service_status($arr = array(), $status='F')
	{
		$message	= "";
		$ids		= isset($arr['ids'])	?	$arr['ids']	:	array();
		if (empty($ids))
			$message	.= "Please select service(s) which you need to make as 'Finished'.<br>";
		if ($message == "") {
			$idstring	= implode("','", $ids);
			$sql		= "UPDATE ".TABLEPREFIX."orders SET vOrdStatus = '{$status}' 
						   WHERE nOrdId IN ('{$idstring}')";
			$res		= @mysql_query($sql, $this->dblink);
			if (!$res)
				$message	.= "Unable to make service(s) as 'Finished', please try later.<br>";
			else
				$message	.= "Selected services(s) turned as 'Finished' successfully.<br>";
		}
		return $message;
	}

	function save_testimonial($id=0,$userid=0,$active=0)
	{
		$message	= $this->check_testimonial();
		if ($message == "") {
			if ($id > 0) {
				$message	.= $this->update_testimonial($id,$active,$userid);
			} else {
				$message	.= $this->insert_testimonial($userid,$active);
			}
		}
		return $message;
	}

	function check_testimonial()
	{
		$message	= "";
		/*if (!$this->check_date_time($this->dDate))
			$message	.= "Please enter the date of the testimonial.<br>";
		if ($this->dDate <= date("Y-m-d"))
			$message	.= "Please enter a future date.<br>";*/
		if ($this->tContent == "")
			$message	.= "Please enter the content of the testimonial.<br>";
		return $message;
	}

	function update_testimonial($id,$active,$userid)
	{
		$message	= "";
		$sql		= "UPDATE ".TABLEPREFIX."testimonial
		               SET tContent = '".addslashes($this->tContent)."',
					       dDate = '".addslashes($this->dDate)."',
						   vActive = '{$active}'
					   WHERE nTestimonial_Id = '{$id}' and nUser_Id='".$userid."'";
		$res		= @mysql_query($sql, $this->dblink);
		if (!$res)
			$message	.= "Unable to update testimonial, please try later.<br>";
		return $message;
	}

	function insert_testimonial($userid,$active)
	{
		$message	= "";
		$sql		= "INSERT INTO ".TABLEPREFIX."testimonial (tContent, dDate, nUser_Id,vActive)
		               VALUES ('".addslashes($this->tContent)."', '".addslashes($this->dDate)."'
					   			 ,'{$userid}','{$active}')";
		$res		= @mysql_query($sql, $this->dblink);
		if (!$res)
			$message	.= "Unable to add testimonial, please try later.<br>";
		return $message;
	}

	function get_all_apicalls()
	{
		$array	= array();
		$sql	= "SELECT D.*, DATE_FORMAT(D.dDate, '%D %M %Y') as dDay, U.vLogin 
		           FROM ".TABLEPREFIX."background_check as D JOIN ".TABLEPREFIX."user U
				   ON D.nUser_Id = U.nUser_Id
				   ORDER BY D.nBC_Id DESC";
		$res	= @mysql_query($sql, $this->dblink);
		if (@mysql_num_rows($res) > 0) {
			while($row = @mysql_fetch_array($res)) {
				$array[]	= $row;
			}
		}
		return $array;
	}

	function search_apicalls($arrP=array(), $flag=false,$order=' ')
	{
		$array					= array();
		$arraysearch			= array();
		$string					= "";

		$search	= isset($arrP['api_search'])	?	stripslashes(trim($arrP['api_search']))	:	"";

		if ($flag) {
			$_SESSION['api_search']	= "";

			$string	= "";
			$user	= isset($arrP['user'])	?	stripslashes(trim($arrP['user']))	:	"";
			$type	= isset($arrP['type'])	?	stripslashes(trim($arrP['type']))	:	"";
			$date	= isset($arrP['date'])	?	stripslashes(trim($arrP['date']))	:	date("Y-m-d");
			$status	= isset($arrP['status'])	?	stripslashes(trim($arrP['status']))	:	"";
			if ($user <> "")
				$string	.= "U.vLogin LIKE '".addslashes($user)."' AND ";
			if ($type <> "")
				$string	.= "D.vType LIKE '".addslashes($type)."' AND ";
			if ($status <> "")
				$string	.= "D.vStatus LIKE '".addslashes($status)."' AND ";
			if ($date <> "")
				$string	.= "D.dDate >= '".addslashes($date)."' AND ";

			if ($string <> "")
				$string	= " WHERE ".$string." 1=1";

			$arraysearch['search']		= $string;
			$arraysearch['user']		= addslashes($user);
			$arraysearch['type']		= addslashes($type);
			$arraysearch['date']		= addslashes($date);
			$arraysearch['status']		= addslashes($status);

			$this->arrSearch			= $arraysearch;
			$_SESSION['api_search']		= serialize($arraysearch);

		} else {
			if ($search <> "") {
				$this->arrSearch = unserialize($search);
				$string	= $this->arrSearch['search'];
			}
		}

		$sql	= "SELECT D.*, DATE_FORMAT(D.dDate, '%D %M %Y') as dDay, U.vLogin 
		           FROM ".TABLEPREFIX."background_check as D JOIN ".TABLEPREFIX."user U
				   ON D.nUser_Id = U.nUser_Id ".$string;
                if($order!=' '){                
                        $sql.= 	   " ORDER BY ".$order;

                }
                else{
                    $sql.= 	   " ORDER BY D.nBC_Id DESC";
                }
				   
		$res	= @mysql_query($sql, $this->dblink);
		if (@mysql_num_rows($res) > 0) {
			while($row = @mysql_fetch_array($res)) {
				$array[]	= $row;
			}
		}
		return $array;

	}

	function search_testimonials($arrP=array(), $flag=false,$order=' ')
	{
		$array	= array();
		$arraysearch			= array();
		$string					= "";

		$search	= isset($arrP['api_search'])	?	stripslashes(trim($arrP['api_search']))	:	"";

		if ($flag) {
			$_SESSION['api_search']	= "";

			$string	= "";
			$datef	= isset($arrP['datef'])	?	stripslashes(trim($arrP['datef']))	:	"";
			$date	= isset($arrP['date'])	?	stripslashes(trim($arrP['date']))	:	"";
			if ($datef <> "" AND $date <> "")
				$string	.= "DATE_FORMAT(dDate, '%m/%d/%Y') >= '".addslashes($datef)."' AND DATE_FORMAT(dDate, '%m/%d/%Y') <= '".addslashes($date)."' AND ";

			if ($string <> "")
				$string	= " WHERE ".$string." 1=1";

			$arraysearch['search']		= $string;
			$arraysearch['date']		= addslashes($date);
			$arraysearch['datef']		= addslashes($datef);

			$this->arrSearch			= $arraysearch;
			$_SESSION['api_search']		= serialize($arraysearch);

		} else {
			if ($search <> "") {
				$this->arrSearch = unserialize($search);
				$string	= $this->arrSearch['search'];
			}
		}

		$sql	= "SELECT nTestimonial_Id, tContent, nUser_Id, vActive,
		                  DATE_FORMAT(dDate, '%D %M %Y') as dDay
					FROM ".TABLEPREFIX."testimonial ".$string;
                 if($order!=' '){                
                        $sql.= 	   " ORDER BY ".$order;

                }
                else{
                    $sql.= 	   " ORDER BY nTestimonial_Id DESC";
                }
					
		$res	= @mysql_query($sql, $this->dblink);
		if (@mysql_num_rows($res) > 0) {
			while($row = @mysql_fetch_array($res)) {
				$array[]	= $row;
			}
			@mysql_free_result($res);
		}
		return $array;
	}

	function search_free_codes($arrP=array(), $flag=false,$order=' ')
	{
		$array			= array();
		$arraysearch	= array();
		$string			= "";

		$search	= isset($arrP['api_search'])	?	stripslashes(trim($arrP['api_search']))	:	"";

		if ($flag) {
			$_SESSION['api_search']	= "";

			$string	= "";
			$datef	= isset($arrP['datef'])	?	stripslashes(trim($arrP['datef']))	:	"";
			$date	= isset($arrP['date'])	?	stripslashes(trim($arrP['date']))	:	"";
			$code	= isset($arrP['code'])	?	stripslashes(trim($arrP['code']))	:	"";
			if ($datef <> "")
				$string	.= "DATE_FORMAT(dStart, '%m/%d/%Y') = '".addslashes($datef)."' AND ";
			if ($date <> "")
				$string	.= "DATE_FORMAT(dEnd, '%m/%d/%Y') = '".addslashes($date)."' AND ";
			if ($code <> "")
				$string	.= "vCode = '".addslashes($code)."' AND ";

			if ($string <> "")
				$string	= " WHERE ".$string." 1=1";

			$arraysearch['search']		= $string;
			$arraysearch['date']		= addslashes($date);
			$arraysearch['datef']		= addslashes($datef);
			$arraysearch['code']		= addslashes($code);

			$this->arrSearch			= $arraysearch;
			$_SESSION['api_search']		= serialize($arraysearch);

		} else {
			if ($search <> "") {
				$this->arrSearch = unserialize($search);
				$string	= $this->arrSearch['search'];
			}
		}

		$sql	= "SELECT nFreeCode_Id, vCode,
		                  DATE_FORMAT(dStart, '%D %M %Y') as dStart,
						  DATE_FORMAT(dEnd, '%D %M %Y') as dEnd
				   FROM ".TABLEPREFIX."free_code ".$string; 
                                       
                if($order!=' '){                
                        $sql.= 	   " ORDER BY ".$order;

                }
                else{
                    $sql.= 	   " ORDER BY nFreeCode_Id DESC";
                }
		           
		$res	= @mysql_query($sql, $this->dblink);
		if (@mysql_num_rows($res) > 0) {
			while($row = @mysql_fetch_array($res)) {
				$array[]	= $row;
			}
			@mysql_free_result($res);
		}
		return $array;

	}

	function search_single_events($arrP=array(), $flag=false,$order=' ')
	{
		$array			= array();
		$arraysearch	= array();
		$string			= "";

		$search	= isset($arrP['api_search'])	?	stripslashes(trim($arrP['api_search']))	:	"";

		if ($flag) {
			$_SESSION['api_search']	= "";

			$string	= "";
			$title	= isset($arrP['title'])	?	stripslashes(trim($arrP['title']))	:	"";
			$date	= isset($arrP['date'])	?	stripslashes(trim($arrP['date']))	:	"";
			$city	= isset($arrP['city'])	?	stripslashes(trim($arrP['city']))	:	"";
			$venue	= isset($arrP['venue'])	?	stripslashes(trim($arrP['venue']))	:	"";
			if ($title <> "")
				$string	.= "LOWER(vTitle) LIKE '%".strtolower(addslashes($title))."%' AND ";
			if ($date <> "")
				$string	.= "DATE_FORMAT(dDate_Event, '%m/%d/%Y') = '".addslashes($date)."' AND ";
			if ($city <> "")
				$string	.= "LOWER(vCity) LIKE '%".strtolower(addslashes($city))."%' AND ";
			if ($venue <> "")
				$string	.= "LOWER(vVenue) LIKE '%".strtolower(addslashes($venue))."%' AND ";

			if ($string <> "")
				$string	= " WHERE ".$string." 1=1";

			$arraysearch['search']		= $string;
			$arraysearch['date']		= addslashes($date);
			$arraysearch['title']		= addslashes($title);
			$arraysearch['city']		= addslashes($city);
			$arraysearch['venue']		= addslashes($venue);

			$this->arrSearch			= $arraysearch;
			$_SESSION['api_search']		= serialize($arraysearch);

		} else {
			if ($search <> "") {
				$this->arrSearch = unserialize($search);
				$string	= $this->arrSearch['search'];
			}
		}

		$sql	= "SELECT *, DATE_FORMAT(dDate_Event, '%D %M %Y') as dDay
		           FROM ".TABLEPREFIX."single_events ".$string;
                if($order!=' '){                
			$sql.= 	   " ORDER BY ".$order;
                                
                }
                else{
                    $sql.= 	   " ORDER BY nSE_Id DESC";
                }
				   
		$res	= @mysql_query($sql, $this->dblink);
		if (@mysql_num_rows($res) > 0) {
			while($row = @mysql_fetch_array($res)) {
				$array[]	= $row;
			}
			@mysql_free_result($res);
		}
		return $array;
	}

	function search_stories($arrP=array(), $flag=false,$order=' ')
	{
		$array	= array();
		$arraysearch	= array();
		$string			= "";

		$search	= isset($arrP['api_search'])	?	stripslashes(trim($arrP['api_search']))	:	"";

		if ($flag) {
			$_SESSION['api_search']	= "";

			$string	= "";
			$title	= isset($arrP['title'])	?	stripslashes(trim($arrP['title']))	:	"";
			$date	= isset($arrP['date'])	?	stripslashes(trim($arrP['date']))	:	"";
			$user	= isset($arrP['user'])	?	stripslashes(trim($arrP['user']))	:	"";
			if ($title <> "")
				$string	.= "LOWER(S.vStory_Title) LIKE '".strtolower(addslashes($title))."%' AND ";
			if ($date <> "")
				$string	.= "DATE_FORMAT(S.dDate, '%m/%d/%Y') = '".addslashes($date)."' AND ";
			if ($user <> "")
				$string	.= "U.vLogin = '".addslashes($user)."' AND ";

			if ($string <> "")
				$string	= " WHERE ".$string." 1=1";

			$arraysearch['search']		= $string;
			$arraysearch['date']		= addslashes($date);
			$arraysearch['title']		= addslashes($title);
			$arraysearch['user']		= addslashes($user);

			$this->arrSearch			= $arraysearch;
			$_SESSION['api_search']		= serialize($arraysearch);

		} else {
			if ($search <> "") {
				$this->arrSearch = unserialize($search);
				$string	= $this->arrSearch['search'];
			}
		}

		$sql	= "SELECT *,DATE_FORMAT(S.dDate, '%D %M %Y') as dDay
		            FROM ".TABLEPREFIX."success_story as S JOIN ".TABLEPREFIX."user as U 
		            ON S.nUser_Id = U.nUser_Id ".$string;
                if($order!=' '){                
			$sql.= 	   " ORDER BY ".$order;
                                
                }
                else{
                    $sql.= 	   " ORDER BY S.nStory_Id DESC";
                }
					
		$res	= @mysql_query($sql, $this->dblink);
		if (@mysql_num_rows($res) > 0) {
			while ($row = @mysql_fetch_array($res)) {
				$array[]	= $row;
			}
		}
		@mysql_free_result($res);
		return $array;
	}

	function search_payments($arrP=array(), $flag=false,$order=' ')
	{
		$array	= array();
		$arraysearch	= array();
		$string			= "";

		$search	= isset($arrP['api_search'])	?	stripslashes(trim($arrP['api_search']))	:	"";

		if ($flag) {
			$_SESSION['api_search']	= "";

			$string	= "";
			$trans	= isset($arrP['trans'])	?	stripslashes(trim($arrP['trans']))	:	"";
			$date	= isset($arrP['date'])	?	stripslashes(trim($arrP['date']))	:	"";
			$user	= isset($arrP['user'])	?	stripslashes(trim($arrP['user']))	:	"";
			if ($trans <> "")
				$string	.= "LOWER(P.vTxn_Id) LIKE '".strtolower(addslashes($trans))."' AND ";
			if ($date <> "")
				$string	.= "DATE_FORMAT(P.dDate, '%m/%d/%Y') = '".addslashes($date)."' AND ";
			if ($user <> "")
				$string	.= "U.vLogin = '".addslashes($user)."' AND ";

			if ($string <> "")
				$string	= " WHERE ".$string." 1=1 ";

			$arraysearch['search']		= $string;
			$arraysearch['date']		= addslashes($date);
			$arraysearch['trans']		= addslashes($trans);
			$arraysearch['user']		= addslashes($user);

			$this->arrSearch			= $arraysearch;
			$_SESSION['api_search']		= serialize($arraysearch);

		} else {
			if ($search <> "") {
				$this->arrSearch = unserialize($search);
				$string	= $this->arrSearch['search'];
			}
		}

		$sql	= "SELECT U.nUser_Id, U.vLogin, P.*, DATE_FORMAT(P.dDate, '%D %M %Y') as dDay 
				   FROM ".TABLEPREFIX."payments as P JOIN ".TABLEPREFIX."user as U ON P.nUser_Id = U.nUser_Id ".$string;
                if($order!=' '){
                    $sql.= 	   " ORDER BY ".$order;
                    
                }
                else{
                    $sql	.= "ORDER BY P.nPayment_Id DESC";
                }
              
		$res	= @mysql_query($sql, $this->dblink);
		if (@mysql_num_rows($res) > 0) {
			while ($row = @mysql_fetch_array($res)) {
				$array[]	= $row;
			}
		}
		@mysql_free_result($res);
		return $array;
	}

	function search_services($arrP=array(), $flag=false)
	{
		$array	= array();
		$arraysearch	= array();
		$string			= "";

		$search	= isset($arrP['api_search'])	?	stripslashes(trim($arrP['api_search']))	:	"";

		if ($flag) {
			$_SESSION['api_search']	= "";

			$string	= "";
			$trans	= isset($arrP['trans'])	?	stripslashes(trim($arrP['trans']))	:	"";
			$date	= isset($arrP['date'])	?	stripslashes(trim($arrP['date']))	:	"";
			$user	= isset($arrP['user'])	?	stripslashes(trim($arrP['user']))	:	"";
			if ($trans <> "")
				$string	.= "LOWER(P.vTxn_Id) LIKE '".strtolower(addslashes($trans))."' AND ";
			if ($date <> "")
				$string	.= "DATE_FORMAT(P.dDate, '%Y-%m-%d') = '".addslashes($date)."' AND ";
			if ($user <> "")
				$string	.= "U.vLogin = '".addslashes($user)."' AND ";

			if ($string <> "")
				$string	= " WHERE ".$string." 1=1";

			$arraysearch['search']		= $string;
			$arraysearch['date']		= addslashes($date);
			$arraysearch['trans']		= addslashes($trans);
			$arraysearch['user']		= addslashes($user);

			$this->arrSearch			= $arraysearch;
			$_SESSION['api_search']		= serialize($arraysearch);

		} else {
			if ($search <> "") {
				$this->arrSearch = unserialize($search);
				$string	= $this->arrSearch['search'];
			}
		}
/*
			$sql	= "SELECT U.nUser_Id, U.vLogin, P.*, DATE_FORMAT(P.dDate, '%D %M %Y') as dDay 
				   FROM ".TABLEPREFIX."payments as P JOIN ".TABLEPREFIX."user as U ON P.nUser_Id = U.nUser_Id ".$string." 
				   ORDER BY P.nPayment_Id DESC";
*/
		$sql	= "SELECT U.nUser_Id, U.vLogin, P.*, O.nOrdId, O.vOrdStatus, 
		                  DATE_FORMAT(P.dDate, '%D %M %Y') as dDay
				   FROM ".TABLEPREFIX."products as PP JOIN ".TABLEPREFIX."orders as O 
				        ON PP.nProdId = O.nProdId AND PP.vType IN ('P', 'W') 
				   JOIN ".TABLEPREFIX."payments as P ON O.nPayment_Id = P.nPayment_Id 
				   JOIN ".TABLEPREFIX."user as U ON P.nUser_Id = U.nUser_Id ".$string."
				   ORDER BY O.nOrdId DESC";

		$res	= @mysql_query($sql, $this->dblink);
		if (@mysql_num_rows($res) > 0) {
			while ($row = @mysql_fetch_array($res)) {
				$array[]	= $row;
			}
		}
		@mysql_free_result($res);
		return $array;
	}
        
        function get_coupon_code($id=0)
	{
		$array	= array();
		$sql	= "SELECT *	FROM ".TABLEPREFIX."coupons WHERE nId = $id";
		$res	= @mysql_query($sql, $this->dblink);
		if (@mysql_num_rows($res) > 0) {
		$array = @mysql_fetch_array($res);
		}
		@mysql_free_result($res);
		return $array;
	}
}
?>