drop table if exists cyber_abuse;

CREATE TABLE cyber_abuse (
  nAbuse_Id bigint(20) NOT NULL auto_increment,
  nUser_Id_Abused bigint(20) default NULL,
  nUser_Id_Abusee bigint(20) default NULL,
  dDate datetime default NULL,
  PRIMARY KEY  (nAbuse_Id)
) ENGINE=MyISAM;

drop table if exists cyber_alert;

CREATE TABLE cyber_alert (
  nAlert_Id bigint(20) NOT NULL auto_increment,
  nUser_Id bigint(20) default NULL,
  nNewUser char(1) default NULL,
  nAddFavourites char(1) default NULL,
  nProfileViewed char(1) default NULL,
  nAddHot char(1) default NULL,
  nNewMessageMobile char(1) default 'N',
  nNewInterestMobile char(1) default 'N',
  PRIMARY KEY  (nAlert_Id)
) ENGINE=MyISAM;

drop table if exists cyber_background_check;

CREATE TABLE cyber_background_check (
  nBC_Id bigint(20) NOT NULL auto_increment,
  nUser_Id bigint(20) default NULL,
  vType varchar(10) default NULL,
  dDate datetime default NULL,
  vStatus varchar(10) default NULL,
  vScore varchar(10) default '0',
  vMsg text,
  PRIMARY KEY  (nBC_Id)
) ENGINE=MyISAM;

drop table if exists cyber_cc;

CREATE TABLE cyber_cc (
  nCC_Id bigint(20) NOT NULL auto_increment,
  nUser_Id bigint(20) default NULL,
  nNumber varchar(100) default NULL,
  vType varchar(10) default NULL,
  nCvv2 varchar(100) default NULL,
  dExp_Date varchar(10) default NULL,
  vFirstName varchar(100) default NULL,
  vLastName varchar(100) default NULL,
  vAddress varchar(100) default NULL,
  vCountry varchar(100) default NULL,
  vState varchar(100) default NULL,
  vCity varchar(100) default NULL,
  vPostCode varchar(100) default NULL,
  vPhone varchar(100) default NULL,
  vEmail varchar(100) default NULL,
  vMM varchar(100) default NULL,
  vYYYY varchar(100) default NULL,
  vRoutingNumber varchar(100) NOT NULL default '',
  vAccountNumber varchar(100) NOT NULL default '',
  vAccountType varchar(100) NOT NULL default '',
  vBankName varchar(100) NOT NULL default '',
  vBankHolderName varchar(100) NOT NULL default '',
  PRIMARY KEY  (nCC_Id)
) ENGINE=MyISAM;

drop table if exists cyber_chat;

CREATE TABLE cyber_chat (
  nChat_Id bigint(20) NOT NULL auto_increment,
  nUser_Id bigint(20) default NULL,
  nUser_Id_Friend bigint(20) default NULL,
  vLogin_Friend varchar(100) default NULL,
  vName_Friend varchar(100) default NULL,
  tMatter longtext,
  vStatus varchar(10) default NULL,
  dDate datetime default NULL,
  PRIMARY KEY  (nChat_Id)
) ENGINE=MyISAM;

drop table if exists cyber_chats;

CREATE TABLE cyber_chats (
  nChat_Id bigint(20) NOT NULL auto_increment,
  nUser_Id_To bigint(20) default '0',
  nUser_Id_From bigint(20) default '0',
  tMessage text,
  tTimeOf bigint(20) default NULL,
  vStatus char(1) default 'N',
  dDate date default NULL,
  PRIMARY KEY  (nChat_Id)
) ENGINE=MyISAM;

drop table if exists cyber_chats_back;

CREATE TABLE cyber_chats_back (
  nChat_Id bigint(20) NOT NULL auto_increment,
  nUser_Id_To bigint(20) default '0',
  nUser_Id_From bigint(20) default '0',
  tMessage text,
  tTimeOf bigint(20) default NULL,
  vStatus char(1) default 'N',
  dDate date default NULL,
  PRIMARY KEY  (nChat_Id)
) ENGINE=MyISAM;

drop table if exists cyber_cms;

CREATE TABLE cyber_cms (
  nCMS_Id bigint(20) NOT NULL auto_increment,
  vTitle varchar(100) default NULL,
  tContent longtext,
  PRIMARY KEY  (nCMS_Id)
) ENGINE=MyISAM;

drop table if exists cyber_country;

CREATE TABLE cyber_country (
  tc_id bigint(20) NOT NULL auto_increment,
  tc_code varchar(20) default NULL,
  tc_name varchar(250) default NULL,
  tc_status char(1) default 'A',
  PRIMARY KEY  (tc_id)
) ENGINE=MyISAM;

drop table if exists cyber_county;

CREATE TABLE cyber_county (
  tco_id bigint(20) NOT NULL auto_increment,
  ts_id bigint(20) default '0',
  tco_code varchar(20) default NULL,
  tco_name varchar(250) default NULL,
  tco_status char(1) default 'A',
  PRIMARY KEY  (tco_id)
) ENGINE=MyISAM;

drop table if exists cyber_favorite;

CREATE TABLE cyber_favorite (
  nFavorite_Id bigint(20) NOT NULL auto_increment,
  nUser_Id bigint(20) default NULL,
  nUser_Id_Favorite bigint(20) default NULL,
  vLogin_Favorite varchar(100) default NULL,
  dDate datetime default NULL,
  PRIMARY KEY  (nFavorite_Id)
) ENGINE=MyISAM;

drop table if exists cyber_free_code;

CREATE TABLE cyber_free_code (
  nFreeCode_Id bigint(20) NOT NULL auto_increment,
  vCode varchar(100) default NULL,
  dStart date default NULL,
  dEnd date default NULL,
  PRIMARY KEY  (nFreeCode_Id)
) ENGINE=MyISAM;

drop table if exists cyber_gateways;

CREATE TABLE cyber_gateways (
  id bigint(20) NOT NULL auto_increment,
  provider varchar(200) NOT NULL default '',
  vSMSgateway varchar(200) NOT NULL default '',
  vMMSgateway varchar(200) NOT NULL default '',
  vActive enum('0','1') NOT NULL default '1',
  PRIMARY KEY  (id)
) ENGINE=MyISAM;

drop table if exists cyber_hot;

CREATE TABLE cyber_hot (
  nHot_Id bigint(20) NOT NULL auto_increment,
  nUser_Id bigint(20) default NULL,
  nUser_Id_Hot bigint(20) default NULL,
  vLogin_Hot varchar(100) default NULL,
  dDate datetime default NULL,
  PRIMARY KEY  (nHot_Id)
) ENGINE=MyISAM;

drop table if exists cyber_imfriends;

CREATE TABLE cyber_imfriends (
  nImf_Id bigint(20) NOT NULL auto_increment,
  nUser_Id bigint(20) default NULL,
  nUser_Id_Friend bigint(20) default NULL,
  vLogin_Friend varchar(100) default NULL,
  vName_Friend varchar(100) default NULL,
  vStatus varchar(10) default NULL,
  PRIMARY KEY  (nImf_Id)
) ENGINE=MyISAM;

drop table if exists cyber_imfriends_back;

CREATE TABLE cyber_imfriends_back (
  nImf_Id bigint(20) NOT NULL auto_increment,
  nUser_Id bigint(20) default NULL,
  nUser_Id_Friend bigint(20) default NULL,
  vLogin_Friend varchar(100) default NULL,
  vName_Friend varchar(100) default NULL,
  vStatus varchar(10) default NULL,
  PRIMARY KEY  (nImf_Id)
) ENGINE=MyISAM;

drop table if exists cyber_interests;

CREATE TABLE cyber_interests (
  nInterest_Id bigint(20) NOT NULL auto_increment,
  nUser_Id_From bigint(20) default NULL,
  nUser_Id_To bigint(20) default NULL,
  dDate datetime default NULL,
  vStatus varchar(10) default 'NN',
  PRIMARY KEY  (nInterest_Id)
) ENGINE=MyISAM;

drop table if exists cyber_lookup;

CREATE TABLE cyber_lookup (
  vName varchar(100) NOT NULL default '',
  vValue text NOT NULL
) ENGINE=MyISAM;

drop table if exists cyber_message;

CREATE TABLE cyber_message (
  nMessage_Id bigint(20) NOT NULL auto_increment,
  nUser_Id_From bigint(20) default NULL,
  nUser_Id_To bigint(20) default NULL,
  vTitle varchar(250) default NULL,
  tContent longtext,
  dDate datetime default NULL,
  vStatus varchar(10) default 'NN',
  PRIMARY KEY  (nMessage_Id)
) ENGINE=MyISAM;

drop table if exists cyber_MetaTags;

CREATE TABLE cyber_MetaTags (
  nId int(11) NOT NULL auto_increment,
  vTitle varchar(200) default NULL,
  vKeywords text,
  vDescription text,
  vPageName varchar(20) default NULL,
  PRIMARY KEY  (nId)
) ENGINE=MyISAM;

drop table if exists cyber_orders;

CREATE TABLE cyber_orders (
  nOrdId bigint(20) NOT NULL auto_increment,
  nProdId bigint(20) default '0',
  nUserId bigint(20) default '0',
  nPayment_Id bigint(20) default '0',
  dDate datetime NOT NULL,
  vOrdStatus char(1) NOT NULL default 'N',
  PRIMARY KEY  (nOrdId)
) ENGINE=MyISAM;

drop table if exists cyber_partner_preferance;

CREATE TABLE cyber_partner_preferance (
  nPartner_Pref_Id bigint(20) NOT NULL auto_increment,
  nUser_Id bigint(20) default NULL,
  nAge_Low int(5) default NULL,
  nAge_High int(5) default NULL,
  vBody_Type varchar(100) default NULL,
  nHeight_Low int(5) default NULL,
  nHeight_High int(5) default NULL,
  vDrinking varchar(100) default NULL,
  vSmoking varchar(100) default NULL,
  vEye_Color varchar(100) default NULL,
  vHair_Color varchar(100) default NULL,
  vEthinicity varchar(100) default NULL,
  vRelegion varchar(100) default NULL,
  vEducation varchar(100) default NULL,
  vLanguages varchar(250) default NULL,
  vProfession varchar(100) default NULL,
  vIncome varchar(100) default NULL,
  vRelationship varchar(100) default NULL,
  vChildren varchar(100) default NULL,
  PRIMARY KEY  (nPartner_Pref_Id)
) ENGINE=MyISAM;

drop table if exists cyber_payments;

CREATE TABLE cyber_payments (
  nPayment_Id bigint(20) NOT NULL auto_increment,
  vMethod varchar(50) default NULL,
  vTxn_Id varchar(100) default NULL,
  dDate datetime default NULL,
  nUser_Id bigint(20) default NULL,
  vReason varchar(100) default NULL,
  vAmountStatus char(1) default 'N',
  fAmount float(20,2) default '0.00',
  PRIMARY KEY  (nPayment_Id)
) ENGINE=MyISAM;

drop table if exists cyber_photos;

CREATE TABLE cyber_photos (
  nPhoto_Id bigint(20) NOT NULL auto_increment,
  nUser_Id bigint(20) default NULL,
  vTitle varchar(100) default NULL,
  vUrl varchar(100) default NULL,
  dDate datetime default NULL,
  PRIMARY KEY  (nPhoto_Id)
) ENGINE=MyISAM;

drop table if exists cyber_products;

CREATE TABLE cyber_products (
  nProdId bigint(20) NOT NULL auto_increment,
  vProdName varchar(250) default NULL,
  vStatus char(1) default 'N',
  vType char(1) default 'N',
  vDesc text,
  fAmount float(20,2) default '0.00',
  vDeleted char(1) default 'N',
  PRIMARY KEY  (nProdId)
) ENGINE=MyISAM;

drop table if exists cyber_single_events;

CREATE TABLE cyber_single_events (
  nSE_Id bigint(20) NOT NULL auto_increment,
  vTitle varchar(250) default NULL,
  vDescription text,
  vVenue varchar(100) default NULL,
  vCity varchar(100) default NULL,
  dDate_Event datetime default NULL,
  dDate datetime default NULL,
  vType char(2) default 'SE',
  PRIMARY KEY  (nSE_Id)
) ENGINE=MyISAM;

drop table if exists cyber_smilies;

CREATE TABLE cyber_smilies (
  smilies_id smallint(5) unsigned NOT NULL auto_increment,
  code varchar(50) default NULL,
  smile_url varchar(100) default NULL,
  emoticon varchar(100) default NULL,
  PRIMARY KEY  (smilies_id)
) ENGINE=MyISAM;

drop table if exists cyber_sms;

CREATE TABLE cyber_sms (
  sms_id bigint(20) NOT NULL auto_increment,
  nUserId bigint(20) default NULL,
  sms_code varchar(250) default NULL,
  sms_date date default NULL,
  sms_message text,
  PRIMARY KEY  (sms_id)
) ENGINE=MyISAM;

drop table if exists cyber_state;

CREATE TABLE cyber_state (
  ts_id bigint(20) NOT NULL auto_increment,
  tc_id bigint(20) default '0',
  ts_code varchar(20) default NULL,
  ts_name varchar(250) default NULL,
  ts_status char(1) default 'A',
  PRIMARY KEY  (ts_id)
) ENGINE=MyISAM;

drop table if exists cyber_success_story;

CREATE TABLE cyber_success_story (
  nStory_Id bigint(20) NOT NULL auto_increment,
  nUser_Id bigint(20) default NULL,
  vStory_Title varchar(250) default NULL,
  tStory longtext,
  vPicURL varchar(100) default NULL,
  dDate datetime default NULL,
  PRIMARY KEY  (nStory_Id)
) ENGINE=MyISAM;

drop table if exists cyber_testimonial;

CREATE TABLE cyber_testimonial (
  nTestimonial_Id bigint(20) NOT NULL auto_increment,
  tContent text,
  dDate datetime default NULL,
  nUser_Id int(11) NOT NULL default '0',
  vActive enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (nTestimonial_Id)
) ENGINE=MyISAM;

drop table if exists cyber_user;

CREATE TABLE cyber_user (
  nUser_Id bigint(20) NOT NULL auto_increment,
  vLogin varchar(100) default NULL,
  vPass varchar(100) default NULL,
  vEmail varchar(200) default NULL,
  vGender varchar(20) default NULL,
  vFirstName varchar(100) default NULL,
  vMiddleName varchar(100) default NULL,
  vLastName varchar(100) default NULL,
  vHearing_Source varchar(100) default NULL,
  dDob date default NULL,
  vRealtion_Status varchar(250) default NULL,
  vCountry varchar(100) default NULL,
  vState varchar(100) default NULL,
  vCounty varchar(100) default NULL,
  vCity varchar(100) default NULL,
  vAstro_Sign varchar(100) default NULL,
  nHeight float default NULL,
  vBody_Type varchar(100) default NULL,
  vEye_Color varchar(100) default NULL,
  vHair_Color varchar(100) default NULL,
  vBody_Art varchar(100) default NULL,
  vBest_Feature varchar(10) default NULL,
  vHobbies text,
  vTravel_Destination varchar(250) default NULL,
  vFauvorite_Things text,
  vLast_Read varchar(100) default NULL,
  vSports_Enjoyed text,
  vOther_Interests text,
  vExcersise varchar(200) default NULL,
  vEating_Habits varchar(100) default NULL,
  vSmoking varchar(100) default NULL,
  vDrinking varchar(100) default NULL,
  vProfession varchar(250) default NULL,
  vAnual_Income varchar(100) default NULL,
  vLiving_Situation varchar(100) default NULL,
  nChildren int(2) default NULL,
  vPets varchar(25) default NULL,
  vEthinicity varchar(100) default NULL,
  vReligion varchar(100) default NULL,
  vEducation varchar(100) default NULL,
  vLanguages text,
  vPolitcal_Outlook varchar(25) default NULL,
  vTitle varchar(250) default NULL,
  tAbout_Me text,
  tAbout_Partner text,
  tSharePartner text,
  vStatus varchar(10) default NULL,
  vOnline varchar(10) default NULL,
  vFeatured varchar(10) default NULL,
  vId_Varified varchar(10) default NULL,
  vBC_Verified varchar(10) default NULL,
  dActive_Date date default NULL,
  vIntro_Check varchar(100) default NULL,
  dLast_Login date default '2008-01-01',
  vMobile varchar(30) default NULL,
  vBilling char(1) default 'D',
  dStartDate datetime default NULL,
  vAlertStatus char(1) default 'N',
  dLast_Login_Time datetime default NULL,
  vProvider varchar(200) default 'email.uscc.net',
  vIP varchar(100) default NULL,
  tmy_looks_today text,
  tmy_likes_onanyday text,
  taday_in_my_life text,
  tmy_personality text,
  tmy_mood_today text,
  tmy_perfect_mate text,
  tmy_music text,
  tmy_movies text,
  tmy_tv text,
  tmy_sports_play text,
  tmy_sports_watch text,
  tmy_travel_been text,
  tmy_travel_going text,
  vmy_night_life_out varchar(250) default NULL,
  vmy_night_life_in varchar(250) default NULL,
  tmy_food text,
  tmy_money text,
  tmy_last_restaurant text,
  tmy_last_restaurant_review text,
  tmy_scenario_question_one text,
  tmy_scenario_answer_one text,
  tmy_charity text,
  tmy_poison_place text,
  tmy_scenario_question_two text,
  tmy_scenario_answer_two text,
  tmy_politics text,
  tmy_major_world_issue text,
  tmy_arts_culture_events text,
  tmy_dislikes_onanyday text,
  tmy_doings_on_major_world_issue text,
  vProfileType char(1) default 'I',
  tmy_profile longtext,
  nCredits int(11) NOT NULL default '0',
  PRIMARY KEY  (nUser_Id)
) ENGINE=MyISAM;

drop table if exists cyber_views;

CREATE TABLE cyber_views (
  nViewId bigint(20) NOT NULL auto_increment,
  nUserId bigint(20) default '0',
  nUserViewId bigint(20) default '0',
  dDate date default NULL,
  PRIMARY KEY  (nViewId)
) ENGINE=MyISAM;

drop table if exists cyber_Help;

CREATE TABLE cyber_Help (
  hid int(11) NOT NULL auto_increment,
  hcid int(11) default NULL,
  htitle varchar(100) default NULL,
  hdescription text,
  hposition int(11) default NULL,
  active enum('0','1') default NULL,
  himage varchar(100) default NULL,
  PRIMARY KEY  (hid)
) ENGINE=MyISAM;

drop table if exists cyber_HelpCategory;

CREATE TABLE cyber_HelpCategory (
  hcid int(11) NOT NULL auto_increment,
  htype varchar(6) default NULL,
  hctitle varchar(100) default NULL,
  hcposition int(11) default NULL,
  active enum('0','1') default NULL,
  PRIMARY KEY  (hcid)
) ENGINE=MyISAM;

drop table if exists cyber_Banners;

CREATE TABLE cyber_Banners (
  nBId int(11) NOT NULL auto_increment,
  vName varchar(200) default NULL,
  vlocUrl varchar(200) default NULL,
  vImg varchar(200) default NULL,
  nDate date default  NULL,
  vWidth varchar(100) default NULL,
  vHeight varchar(100) default NULL,
  nPosition int(11) default NULL,
  vActive enum('1','0') default '0',
  vLocation varchar(10) default NULL,
  nCount int(11) default '0',
  nType char(6) default 'Normal',
  vOpenxDes text,
  PRIMARY KEY  (nBId)
) ENGINE=MyISAM;

drop table if exists cyber_SignUpField;

CREATE TABLE cyber_SignUpField (
  nSId int(11) NOT NULL auto_increment,
  vTitle varchar(250) default NULL,
  vActive enum('1','0') default '1',
  PRIMARY KEY  (nSId)
) ENGINE=MyISAM;

ALTER TABLE `cyber_Help` ADD COLUMN `helptext` TEXT NULL AFTER `himage`;

CREATE TABLE `cyber_user_devices` (
  `user_device_id` INT(10) NULL AUTO_INCREMENT,
  `user_id` INT(10) NULL DEFAULT '0',
  `device` VARCHAR(255) NULL,
  `device_id` VARCHAR(255) NULL,
  PRIMARY KEY (`user_device_id`)
) ENGINE=MyISAM;

ALTER TABLE `cyber_user` ADD COLUMN `fbId` VARCHAR(255) NULL DEFAULT NULL AFTER `nCredits`;
ALTER TABLE `cyber_user` ADD COLUMN `premiumUser` ENUM('Y','N') NULL DEFAULT 'N' AFTER `fbId`;

ALTER TABLE `cyber_user` ADD COLUMN `vDate_Preference` VARCHAR(250) NULL DEFAULT NULL AFTER `dDob`;

CREATE TABLE `cyber_matching_profiles` (
       `match_id` INT(10) NOT NULL AUTO_INCREMENT,
       `nUser_Id` INT(10) NOT NULL DEFAULT '0',
       `profile_Id` INT(10) NOT NULL DEFAULT '0',
       `match_date` DATE NULL DEFAULT NULL,
       PRIMARY KEY (`match_id`)
)
ENGINE=MyISAM;
ALTER TABLE `cyber_matching_profiles` CHANGE COLUMN `match_date` `match_date` DATE NULL DEFAULT NULL AFTER `profile_Id`;
       