<?php
require_once dirname(__FILE__) . '/class.cropcanvas.php';
class cropInterface extends canvasCrop
{
	var $file;
	var $img;
	var $crop;
	var $useFilter;


	/**
	* @return cropInterface
	* @param bool $debug
	* @desc Class initializer
	*/
	function cropInterface($debug = false)
	{
		parent::canvasCrop($debug);
		
		$this->img  = array();
		$this->crop = array();
		$this->useFilter = false;

		$agent = trim($_SERVER['HTTP_USER_AGENT']);
		if ((stristr($agent, 'wind') || stristr($agent, 'winnt')) && (preg_match('|MSIE ([0-9.]+)|', $agent) || preg_match('|Internet Explorer/([0-9.]+)|', $agent)))
		{
			$this->useFilter = true;
		}
		else
		{
			$this->useFilter = false;
		}
		$this->setResizing();
		$this->setCropMinSize();
	}

	
	/**
	* @return void
	* @param unknown $do
	* @desc Sets whether you want resizing options for the cropping area.
	* This is handy to use in conjunction with the setCropSize function if you want a set cropping size.
	*/
	function setResizing($do = true)
	{
	  
		$this->crop['resize'] = ($do) ? true : false;
	}
	
	
	/**
	* @return void
	* @param int $w
	* @param int $h
	* @desc Sets the initial size of the cropping area.
	* If this is not specifically set, then the cropping size will be a fifth of the image size.
	*/
	function setCropDefaultSize($w, $h)
	{
	   if($w>600)
	     $w=600;
	   if($_GET['act']=="tx"){
	    $this->crop['width']  = 40;
		$this->crop['height'] = 2;
	   }else{
	   //echo "hereee";
	   //exit;
		$this->crop['width']  = ($w < 5) ? 5 : $w;
		$this->crop['height'] = ($h < 5) ? 5 : $h;
	   }	
	}
	
	
	/**
	* @return void
	* @param int $w
	* @param int $h
	* @desc Sets the minimum size the crop area can be
	*/
	function setCropMinSize($w = 25, $h = 25)
	{
		$this->crop['min-width']  = ($w < 5) ? 5 : $w;
		$this->crop['min-height'] = ($h < 5) ? 5 : $h;
	}
	

	function loadInterfaceText($filename,$sampletext)
	{
	
	    $relativepathtoserver="../";
	    $fontsize="<select name=cmbfontsize id=cmbfontsize class=selectbox>";
		for($i=10;$i<50;$i++){
		 $fontsize .="<option value=$i>$i</option>";
		}
		$fontname="<select name=cmbfontname id=cmbfontname class=selectbox>";
		//select the font from fonts directory
		
		$fontname .="<option value='times.ttf'>Times</option>";
		$fontname .="<option value='timesi.ttf'>Times Italic</option>";
		$fontname .="<option value='timesbd.ttf'>Times Bold</option>";
		$fontname .="<option value='timesbi.ttf'>Times Bold Italic</option>";
		$fontname .="<option value='arial.ttf'>Arial</option>";
		$fontname .="<option value='ariali.ttf'>Arial Italic</option>";
		$fontname .="<option value='arialbd.ttf'>Arial Bold</option>";
		$fontname .="<option value='arialbi.ttf'>Arial Bold Italic</option>";
		$fontname .="</select>";
		if (!file_exists($filename))
		{
			die("The file '$filename' cannot be found.");
		}
		else
		{
		
			$this->file = $filename;
			$this->img['sizes'] = @getimagesize($filename);
			
			
			if($this->img['sizes'][0]>450 and $this->img['sizes'][1]>450 ){
			  $this->img['sizes'][0]=450;
			  $this->img['sizes'][1]=450;
			  $imgw=450;
			  $imgh=450;
			  $this->img['sizes'][3]="width=\"".$imgw."\" height=\"".$imgh."\"";
			}else if($this->img['sizes'][0]>450){
			 $this->img['sizes'][0]=450;
			 $imgw=450;
			 
			 $imgh=$this->img['sizes'][1];
			 $this->img['sizes'][3]="width=\"".$imgw."\" height=\"".$imgh."\"";
			}else if($this->img['sizes'][1]>450){
			  $imgw=$this->img['sizes'][0];
			  $imgh=450;
			  $this->img['sizes'][3]="width=\"".$imgw."\" height=\"".$imgh."\"";
            }else{
			 ;
			}
			
			
			
			$this->setCropDefaultSize(5,5);
			
			if($this->crop['width']>450){
			  $this->crop['width']=450;
			}
		}
	     $defaultcols=(int)($this->img['sizes'][0]/10);
		 $defaultrows=(int)($this->img['sizes'][1]/20);
		
		$txtboxrow=$defaultrows;
		$txtboxcols=$defaultcols;
	
		echo '<script type="text/javascript" src="./includes/wz_dragdrop.js"></script>', "\n";
		echo '<div id="theCrop" style="position:absolute;background-color:transparent;border:3px solid yellow;width:', $this->crop['width'], 'px;height:', $this->crop['height'], 'px;';
		echo "\"><form name=frmtxtvalnew method=post action=editgallery.php onsubmit=\"my_Submittext(this);\">";
		
		echo "<textarea name=textval id=textval cols=$txtboxcols rows=$txtboxrow>$sampletext</textarea></div>\n";
		echo "<table width=\"10%\"  border=\"0\" cellspacing=\"0\" cellpadding=\"0\">";
	    echo "<tr>
                                              <td width=\"76%\" align=\"center\">&nbsp;</td>
                                              <td width=\"24%\" align=\"center\">&nbsp;</td>
                                            </tr>
                                            <tr>
                                              <td align=\"center\"><table width=\"15%\"  border=\"0\" cellspacing=\"0\" cellpadding=\"0\" bgcolor=\"#FFFFFF\">
                                                <tr>
                                                  <td width=\"19%\"><img src=\"../images/cr1.jpg\" width=\"23\" height=\"24\"></td>
                                                  <td width=\"66%\" background=\"../images/cr5.jpg\">&nbsp;</td>
                                                  <td width=\"15%\" align=\"right\"><img src=\"../images/cr2.jpg\" width=\"23\" height=\"24\"></td>
                                                </tr>
                                                <tr>
                                                  <td height=\"65\" background=\"../images/cr6.jpg\">&nbsp;</td>
                                                  <td align=\"center\"><table width=\"82%\"  border=\"0\" cellspacing=\"0\" cellpadding=\"0\">";
												echo '<tr><td><img id=cropimage src="', $this->file, '" ', $this->img['sizes'][3], ' alt="Add Text " name="theImage"></td></tr>', "\n";
												//echo '<tr><td><img id=cropimage src="./images/t.jpg" ', $this->img['sizes'][3], ' alt="Add Text " name="theImage"></td></tr>', "\n";
												echo " </table></td>
                                                  <td align=\"right\" background=\"../images/cr9.jpg\">&nbsp;</td>
                                                </tr>
                                                <tr>
                                                  <td height=\"19\" align=\"left\" valign=\"bottom\"><img src=\"../images/cr4.jpg\" width=\"23\" height=\"24\"></td>
                                                  <td background=\"../images/cr7.jpg\">&nbsp;</td>
                                                  <td align=\"right\" valign=\"top\"><img src=\"../images/cr3.jpg\" width=\"23\" height=\"24\"></td>
                                                </tr>
												
                                              </table>";
		
		echo "\n</table>\n";
		
		
	}
	
	function loadJavaScript()
	{
	
	   // $this->crop['min-height']=1;
	   	$params = '"theCrop"+MAXOFFLEFT+0+MAXOFFRIGHT+' . $this->img['sizes'][0] . '+MAXOFFTOP+0+MAXOFFBOTTOM+' . $this->img['sizes'][1] . ($this->crop['resize'] ? '+RESIZABLE' : '') . '+MAXWIDTH+' . $this->img['sizes'][0] . '+MAXHEIGHT+' . $this->img['sizes'][1] . '+MINHEIGHT+' . $this->crop['min-height'] . '+MINWIDTH+' . $this->crop['min-width'] . ',"theImage"+NO_DRAG';
		echo <<< EOT
			
	
     
<script type="text/javascript">
<!--

    SET_DHTML($params);

    
	dd.elements.theCrop.moveTo(dd.elements.theImage.x, dd.elements.theImage.y);
	dd.elements.theCrop.setZ(dd.elements.theImage.z+1);
	dd.elements.theImage.addChild("theCrop");
	dd.elements.theCrop.defx = dd.elements.theImage.x;
	function my_DragFunc()
	{
		dd.elements.theCrop.maxoffr = dd.elements.theImage.w - dd.elements.theCrop.w;
		dd.elements.theCrop.maxoffb = dd.elements.theImage.h - dd.elements.theCrop.h;
		dd.elements.theCrop.maxw    = {$this->img['sizes'][0]};
		dd.elements.theCrop.maxh    = {$this->img['sizes'][1]};
	}

	function my_ResizeFunc()
	{
		dd.elements.theCrop.maxw = (dd.elements.theImage.w + dd.elements.theImage.x) - dd.elements.theCrop.x;
		dd.elements.theCrop.maxh = (dd.elements.theImage.h + dd.elements.theImage.y) - dd.elements.theCrop.y;
	}

	function my_Submittext(frm)
	{ 
	       var txtvalue,k; 
		   document.getElementById('htextval').value=document.getElementById('textval').value;
		   //alert(txtvalue);
		   document.getElementById('hfontcolor').value=document.getElementById('yourcol').value
		   document.getElementById('hsx').value=dd.elements.theCrop.x - dd.elements.theImage.x;
		   document.getElementById('hsy').value=dd.elements.theCrop.y - dd.elements.theImage.y;
		   document.getElementById('hfile').value='{$this->file}';
		   document.getElementById('haction').value='addtext';
		   return true;
		
			
	}
	
//-->
</script>
EOT;

		}
}

?>
