<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: 			*/
// +----------------------------------------------------------------------+
// | PHP version 4/5                                                      |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004-2011 ARMIA INC                                    |
// +----------------------------------------------------------------------+
// | This source file is a part of iScripts PrintLogic                    |
// +----------------------------------------------------------------------+
// | Authors: Sarath Kumar<sarath.k@armiasystems.com>             		          |
// +----------------------------------------------------------------------+
App::uses('Controller', 'Controller');
App::uses('AppController', 'Controller');
App::uses('Sanitize', 'Utility');
class BrandsController extends AppController
{
	var $name 			= "Brand";
	var $helpers 		= array('Html', 'Form','Paginator','Js','Flash','Csv','Xls');
	var $components = array('RequestHandler','Paginator'); // Added
	var $uses 			= array('Product','Brand','Category','Cmspage','Font','Palette','Ruler','Dynamicpage','Template','Cart','Currency');
	var $paginate 	= array('limit' => 25,'order' => array('Brand.brandname' => 'asc'));

	function index() {
			$this->__validateLoginStatus();
			$admsess	=	$this->Session->read('Admin');
			if($admsess["products"] <> 1) {
					$this->redirect(array('controller' => 'admins', 'action' => 'index'));
						exit();
			}

			$criteria="Brand.status = 'A'";
			$cmbSearchType	=	"";
			$txtSearch		=	"";
			if(isset($_GET["cmbSearchType"]) && isset($_GET["txtSearch"])) {
					$cmbSearchType	=	$_GET["cmbSearchType"];
					$txtSearch		=	$_GET["txtSearch"];
					if($cmbSearchType == "name") {
							$data = $this->paginate('Brand', array('Brand.brandname  LIKE ' => "%".addslashes($txtSearch)."%",'Brand.status  = ' => "A"));
					}else {
							$data = $this->paginate('Brand', array('Brand.status  = ' => "A"));
					}
			}
			else if(isset($this->passedArgs["cmbSearchType"]) && isset($this->passedArgs["txtSearch"]) &&
							$this->passedArgs["txtSearch"] <> '') {
					$cmbSearchType	=	$this->passedArgs["cmbSearchType"];
					$txtSearch		=	$this->passedArgs["txtSearch"];
					if($cmbSearchType == "name") {
							$data = $this->paginate('Brand', array('Brand.brandname  LIKE ' => "%".addslashes($txtSearch)."%"));
					}else {
							$data = $this->paginate('Brand', array('Brand.status  = ' => "A"));
					}
			}
			else {
					$data = $this->paginate('Brand', array('Brand.status  = ' => "A"));
			}

			$this->set('cmbSearchType', $cmbSearchType);
			$this->set('txtSearch', $txtSearch);
			$this->passedArgs['limit']=$this->paginate["limit"];
			$this->set('passedarg',$this->passedArgs);
			$this->set('brand', $data);
			$this->layout = 'adm';
	}

	function allbrands() {
			$sus	=	$this->Session->read('Userlog');
			if(isset($sus) && empty($sus) === false){
					$this->set('sus', $sus);
					$citem    =   $this->Cart->find('all', array('conditions' => array('Cart.type <>' => 'G','user_id' => $sus['id'])));
			}
			else{
				$this->set('sus', '');
				$sessid   =   $this->Session->id();
				$citem    =   $this->Cart->find('all', array('conditions' => array('Cart.type <>' => 'G','sess_id' => $sessid)));
			}
			$this->set('cartcount', count($citem));

			$this->loadModel('Setting');
			$this->Setting->load();
			global $page_title;
			 $cnfg 				=	Configure::read('Neutrino');
			 $sus	=	$this->Session->read('Userlog');
			 $this->set('sus',$sus);
			if($cnfg["page_title"] <> '')
					$page_title = $cnfg["page_title"];
			$this->pageTitle = $page_title	;

			//Facebook Setting
			$facebookKeys='';
			if($this->Session->check('facebookKey')) {
					$facebookKeys=$this->Session->read('facebookKey');
			}
			$this->set('facebookKey', $facebookKeys);
			//Facebook Setting Ends

			// Twitter App Setting
			$twitterKeys='';
			if($this->Session->check('twitterKey')) {
					$twitterKeys=$this->Session->read('twitterKey');
			}
			$this->set('twitterKey', $twitterKeys);
			// Twitter App Setting Ends

			//Code Added By shyam for Category Menu Listing starts here..
			$lst	=	$this->Category->find('all');
			foreach($lst as $det)
					$menu_array[$det["Category"]["id"]] = array('name' => $det["Category"]["cname"],'parent' => $det["Category"]["parent_id"]);
			$this->set('menu_array', $menu_array);

			$footer_links = $this->Cmspage->find('list',array('conditions' => array('Cmspage.type' => 'content','Cmspage.status' => 'Y')));
			$this->set('footerlinks', $footer_links);

			//Code Added By shyam for Category Menu Listing ends here..
			$criteria = "Brand.status = 'A'";
			//list($order,$limit,$page) = $this->Pagination->settings($criteria); // Added

			//list($order,$limit,$page) = $this->Paginator->settings(array("conditions" =>array("Product.status" => 'A','Product.stock' > 0))); // Added

			$this->paginate = array(
					'conditions' 	=> array("Brand.status" => 'A'),
					'limit' 			=> $cnfg["items_perpage"],
			);
			$this->Paginator->settings = $this->paginate;



			//list($order,$limit,$page) = array($data,$this->counter('{:limit}'),$this->counter('{:page}'));
			$data = $this->paginate('Brand');
			list($order,$limit,$page) = array($data,$this->request->params['paging']['Brand']['limit'],$this->request->params['paging']['Brand']['page']); // Added

			//$data = $this->Product->findAll($criteria, NULL, 'Product.id DESC', $limit, $page); // Extra parameters added
			$data   =   $this->Brand->find('all',array("order" => array('Brand.brandname ASC'),"conditions"=>array("Brand.status"=> 'A'),"limit"=>$limit,"page"=>$page));
			//echo '<pre>';print_r($data); echo '</pre>'; die();
			$brands	=	$data;
			// echo "<pre>";
			// print_r($data);exit;
			/* for($c=0; $c < sizeof($brands); $c++) {
					if(isset($brands[$c]["Productimages"][0]["imagename"])) {
							$defimg	=	$pdct[$c]["Productimages"][0]["imagename"];
							$pdct[$c]["Productimages"]	=	$defimg;
					}
					else {
							$pdct[$c]["Productimages"]	= '';
					}
			} */
			$this->set('brands', $brands);
	}

	public function show_brand($name='',$brandid=0){
			$this->loadModel('Setting');
			$this->Setting->load();
			$cnfg               =   Configure::read('Neutrino');
			/*if (isset($this->Setting) && !empty($this->Setting->table)) {
					$this->Setting->load();
			}*/
			$sus    = $this->Session->read('Userlog');
			if(isset($sus) && empty($sus)===false){
				$this->set('sus', $sus);
				$citem    =   $this->Cart->find('all', array('conditions' => array('Cart.type <>' => 'G','user_id' => $sus['id'])));
			}
			else{
				$this->set('sus', '');
				$sessid   =   $this->Session->id();
				$citem    =   $this->Cart->find('all', array('conditions' => array('Cart.type <>' => 'G','sess_id' => $sessid)));
			}
			$this->set('cartcount', count($citem));
			$pages =    $this->Dynamicpage->getpages();
			//echo "hello<pre>";print_r($pages);
			$this->set('pagesdynamic', $pages);
			global $page_title;
			$cnfg               =   Configure::read('Neutrino');
			$page_title         =   $name;
			if($cnfg["page_title"] <> '')
					$page_title.=' - '.$cnfg["page_title"];
			$this->pageTitle = $page_title  ;

			global $currency;
			$curr       =   $this->Currency->findByCode($currency);
			$this->set('curlogo',$curr["Currency"]["logo"]);
			//Facebook Setting
			$facebookKeys='';
			if($this->Session->check('facebookKey')){
					$facebookKeys=$this->Session->read('facebookKey');
			}
			$this->set('facebookKey', $facebookKeys);
			//Facebook Setting Ends
			//Twitter App Setting
			$twitterKeys='';
			if($this->Session->check('twitterKey')) {
					$twitterKeys=$this->Session->read('twitterKey');
			}
			$this->set('twitterKey', $twitterKeys);
			// Twitter App Setting Ends
			//Code Added By shyam for Category Menu Listing starts here..
			$lst    = $this->Category->find('all',array("order"=>'position ASC'));
			foreach($lst as $det)
					$menu_array[$det["Category"]["id"]] = array('name' => $det["Category"]["cname"],'parent' => $det["Category"]["parent_id"], 'position' => $det["Category"]["position"]);
			$this->set('menu_array', $menu_array);

			$footer_links = $this->Cmspage->find('list',array('conditions' => array('Cmspage.type' => 'content','Cmspage.status' => 'Y')));
			$this->set('footerlinks', $footer_links);

			//Code Added By shyam for Category Menu Listing ends here..

			$bdet = $this->Brand->find('first', array('conditions' => array('Brand.id' => $brandid,'Brand.id' => $brandid)), array('order' => array('Brand.brandname ASC')));
			//echo '<pre>'; print_r($cdet); echo '</pre>';


			//print_r($cdet["Childcategory"]);exit;
			if(isset($bdet["Brand"]["id"])) {
					$id     =   $bdet["Brand"]["id"];
					$bt     =   $this->Brand->findById($id);
					$this->set('pbranddet', $bt);

					$criteria = "Product.brand_id = '".$id."' AND Product.status = 'A' AND Product.stock > 0";

					//list($order,$limit,$page) = $this->Pagination->init($criteria); // Added
					//$data = $this->Product->findAll($criteria, NULL, 'Product.id DESC', $limit, $page); // Extra parameters added
					//echopre($data);

					$perPage = 9;
					isset($_GET['page']) ? $cur = $_GET['page'] - 1 : $cur = 0;
					$totalRecs = $this->Brand->getProductCountByBrand($id);
					$max = ceil($totalRecs/$perPage);
					$pagingArray = array('cur' => $cur, 'max' => $max);
					$this->set("pagingArray", $pagingArray);

					$data  = $this->Brand->getProductDataByBrand($id,$perPage, $cur);
					//echo "<pre>"; print_r($data); echo "</pre>";

	         for($c=0; $c < sizeof($data); $c++){
	            if(isset($data[$c]["Productimages"]["imagename"])){
	                $defimg	=	$data[$c]["Productimages"]["imagename"];
	                $data[$c]["Productimages"]	=	$defimg;
	            }
	            else{
	                $data[$c]["Productimages"]	= '';
	            }
	        }

					$pdct   =   $data;
					$this->set('products', $pdct);
					$this->set('name', $name);
					$this->set('brandid', $brandid);
			}else {
					$this->redirect(array('controller' => 'pages','action'=>'display'));
			}
	}

	function add(){
			$this->__validateLoginStatus();
			$admsess	=	$this->Session->read('Admin');
			if($admsess["products"] <> 1) {
					$this->redirect(array('controller' => 'admins', 'action' => 'index'));
					exit();
			}
			if (!empty($this->data)){
					//echo "<pre>"; print_r($this->data); echo "</pre>"; die();

					$brand_cnt = $this->Brand->find('count', array('fields' => 'COUNT(Brand.id) as count','conditions' => array('Brand.brandname' => $this->data["Brand"]["brandname"])));
					if($brand_cnt > 0) {
							$this->Session->setFlash('The specified brand name is exists, Please add a unique brand name!', 'default',array('class'=> 'failure'));
							$this->redirect(array('controller' => 'brands','action'=>'add'));
							exit();
					}

				$params_data = $this->data;
				//Brand Main Image Upload Starts.
		        $brandMainImageName='';
		        if(!empty($this->data["Brand"]["brandfileImage"]["tmp_name"])) {
		            list($width,$height,$type) = @getimagesize($this->data["Brand"]["brandfileImage"]["tmp_name"]);
		            if($width >= 25 && $height >= 25) {
		                $brandfileImageFile = $this->Brand->generateUniqueFilename($this->data["Brand"]["brandfileImage"]["name"]);
		                $error = $this->Brand->handleFileUpload($this->data["Brand"]["brandfileImage"], $brandfileImageFile);

		                if(empty($error)) {
		                    if(!empty($brandfileImageFile)) {
		                        $brandMainImageName = $brandfileImageFile;
								$params_data['Brand']['image1'] = $brandMainImageName;
		                    }
		                        $brandfileImageFile='';
		                        $error=false;
		                } else
		                    $size_err.="<br />".$error;
		            }
		            else {
		                $size_err.="<br />Please Upload Image of size greater than 25x25 pixels for brand";
		            }
		        }
		        //Brand Main Image Upload Ends.
		        $this->data = $params_data;
		        //echo "<pre>"; print_r($this->data); echo "</pre>"; die();
					if ($this->Brand->save($this->data)){
							$brandid = $this->Brand->id;
					}
					$this->Session->setFlash('The brand has been saved!', 'default',array('class'=> 'success'));
					$this->redirect(array('controller' => 'brands','action'=>'index'));
					$this->layout = 'adm';
					$this->render();
			}
			else {
					$this->layout = 'adm';
			}
	}

	function edit($id=0,$tab=''){
			if($id == 0) {
					$this->redirect(array('controller' => 'products','action'=>'brands'));
					exit();
			}
			$this->__validateLoginStatus();
			$admsess	=	$this->Session->read('Admin');
			if($admsess["products"] <> 1) {
					$this->redirect(array('controller' => 'admins', 'action' => 'index'));
					exit();
			}
			$this->Brand->id = $id;
			if (!empty($this->data)){ //echopre1($this->data);
					//echo "<pre>"; print_r($this->data); echo "</pre>"; echo $id; //die();
					$brand_cnt = $this->Brand->find('count', array('fields' => 'COUNT(Brand.id) as count','conditions' => array('Brand.brandname' => $this->data["Brand"]["brandname"],'Brand.id != ' => $this->Brand->id)));
					if($brand_cnt > 0) {
							$this->Session->setFlash('The specified brand name is exists, Please add a unique brand name!', 'default',array('class'=> 'failure'));
							$this->redirect(array('controller' => 'brands','action'=>'edit/'.$this->Brand->id));
							exit();
					}

					$params_data = $this->data;
					$brandid=$id;
					$err = false;
			//echo "<pre>"; print_r($params_data); echo "</pre>"; die();
		//Brand Main Image Upload Starts.
        $brandMainImageName='';
        if(!empty($this->data["Brand"]["brandfileImage"]["tmp_name"])) {
            list($width,$height,$type) = @getimagesize($this->data["Brand"]["brandfileImage"]["tmp_name"]);
            if($width >= 25 && $height >= 25) {
                $brandfileImageFile = $this->Brand->generateUniqueFilename($this->data["Brand"]["brandfileImage"]["name"]);



                $error = $this->Brand->handleFileUpload($this->data["Brand"]["brandfileImage"], $brandfileImageFile);

                if(empty($error)) {
                    if(!empty($brandfileImageFile)) {
                        $brandMainImageName = $brandfileImageFile;
                        $params_data['Brand']['image1'] = $brandMainImageName;
                        //unlink old brand image start
                        $cnfg     = Configure::read('Neutrino');
                        $pimagePathMainProImage = WWW_ROOT.IMAGES_URL.'brands/';

                        $mainProimage = $this->data["rmbrandfileImage"];
                        $mainProimageEx = explode(".",$mainProimage);
                        $mainProimageOrigin = $mainProimageEx[0];
                        $mainProimageExtension = $mainProimageEx[1];
                        $mainProimageOrigin_thumb = $mainProimageOrigin.'_thumb.'.$mainProimageExtension;
                        $mainProimageOrigin_disp = $mainProimageOrigin.'_disp.'.$mainProimageExtension;

                        $mainProimagePath = $pimagePathMainProImage.$mainProimage;
                        $mainProimagePath_thumb = $pimagePathMainProImage.$mainProimageOrigin_thumb;
                        $mainProimagePath_disp = $pimagePathMainProImage.$mainProimageOrigin_disp;

                        if(file_exists($mainProimagePath)) {
                            unlink($mainProimagePath);
                        }

                        if(file_exists($mainProimagePath_thumb)) {
                            unlink($mainProimagePath_thumb);
                        }

                        if(file_exists($mainProimagePath_disp)) {
                            unlink($mainProimagePath_disp);
                        }
                        //unlink old brand image ends
                    }
                        $brandfileImageFile='';
                        $error=false;
                } else
                    $size_err.="<br />".$error;
            }
            else {
                $size_err.="<br />Please Upload Image of size greater than 25x25 pixels for brand";
            }
        }
        //Brand Main Image Upload Ends.

					$this->data = $params_data;
					$this->Brand->save($this->data);

					if(isset($size_err) && !empty($size_err))
							$this->Session->setFlash('The brand details has been updated.'.$size_err, 'default',array('class'=> 'success'));
					else
							$this->Session->setFlash('Brand has been updated successfully.', 'default',array('class'=> 'success'));						// $this->redirect(array('controller' => 'products','action'=>'edit/'.$productid.'/'.$categoryid));

					$this->redirect(array('controller' => 'brands','action'=>'index'));

			}
			else{
					$this->data = $this->Brand->read();
					$prod= array($this->data);
					$this->set('branddet', $this->data);
					$this->set('totcnt',$totcnt);
					$this->layout = 'adm';
			}
	}

	function delete($id) {
			$this->__validateLoginStatus();
			$admsess	=	$this->Session->read('Admin');
			if($admsess["products"] <> 1) {
					$this->redirect(array('controller' => 'admins', 'action' => 'index'));
					exit();
			}
			//$del_brand = $this->Brand->findById($id);

			$this->Product->delete_brand($id);
			$this->Session->setFlash('Brand has been deleted.', 'default',array('class'=> 'success'));
			$this->redirect('index');
	}

	function __validateLoginStatus($typ='A')
    {
	   if($typ == 'A'){
			if($this->Session->check('Admin') == false)
			{
				$this->Session->setFlash('The URL you have followed requires you login.', 'default',array('class'=> 'failure'));
				$this->redirect(array('controller' => 'admins', 'action' => 'login'));
			}
		}else{
			if($this->Session->check('Userlog') == false)
			{
				$this->Session->setFlash('The URL you have followed requires you login.', 'default',array('class'=> 'failure'));
				$this->redirect(array('controller' => 'users', 'action' => 'login'));
			}
		}
    }

		function getcsv($cmbSearchType = '',$txtSearch=''){
        $this->__validateLoginStatus();
        $admsess	=	$this->Session->read('Admin');
        if($admsess["products"] <> 1) {
            $this->redirect(array('controller' => 'admins', 'action' => 'index'));
            exit();
        }
        if($cmbSearchType == "name"){
                $datas = $this->Brand->find('all',array('conditions'=>array('Brand.brandname LIKE ' => "%".addslashes($txtSearch)."%",'Brand.status  = ' => "A")));
        }else{
                $datas = $this->Brand->find('all',array('conditions'=>array('Brand.status  = ' => "A")));
      	}
        $data=$this->brandexport($datas);
        $this->set('data',$data);
        $this->layout	=	'csvexp';
    }

		function getxls($cmbSearchType = '',$txtSearch=''){
        $this->__validateLoginStatus();
        $admsess	=	$this->Session->read('Admin');
        if($admsess["products"] <> 1) {
            $this->redirect(array('controller' => 'admins', 'action' => 'index'));
            exit();
        }
        if($cmbSearchType == "name") {
        		$datas = $this->Brand->find('all',array('conditions'=>array('Brand.brandname LIKE ' => "%".addslashes($txtSearch)."%",'Brand.status  = ' => "A")));
        }else{
            $datas = $this->Brand->find('all',array('conditions'=>array('Brand.status  = ' => "A")));
        }
				//echo "<pre>"; print_r($datas);echo "</pre>";
        $data=$this->brandexport($datas);
				//echo "<pre>"; print_r($data);echo "</pre>";
        $this->set('data',$data);
        $this->layout	=	'csvexp';
    }

		function brandexport($datas){
	    	$i=0;
	    	foreach ($datas as $data){
	    		set_time_limit(30);
	    		$mportdata[$i]['brandname']=$data['Brand']['brandname'];
	    		$mportdata[$i]['descr']=$data['Brand']['descr'];
					$i++;
	    	}
	    	return $mportdata;
    }

		function beforeFilter(){
			 /* if (isset($this->Setting) && !empty($this->Setting->table)) {
						$this->Setting->load();
				}*/
				$this->loadModel('Setting');
				$this->Setting->load();
				global $sitefolder;
				global $meta_description;
				global $meta_keywords;
				global $page_title;
				global $currency;
				$cnfg 				=	Configure::read('Neutrino');
				$currency			=	$cnfg["currency"];
				$sitefolder			=	$cnfg["sitebasefolder"];
				$meta_description	=	$cnfg["meta_description"];
				$meta_keywords		=	$cnfg["meta_keywords"];
				$page_title			=	$cnfg["page_title"];
				global $style;
				$style				=	$cnfg["style"];
				$this->set('style', $style);
				$this->set('meta_description', $meta_description);
				$this->set('meta_keywords', $meta_keywords);
				$this->pageTitle = $page_title	;
				$this->set('cnfg',$cnfg);
				$this->paginate["limit"]=$cnfg["items_perpage"]; //Setting pagination limit per page.
				$this->set('sitefolder', $sitefolder);
				$httpHost	=	$_SERVER['HTTP_HOST'];
				$this->set('sitebase',FULL_BASE_URL);

		}

		function beforeRender() {
				$lst	=	$this->Category->find('all',array('order' => array('position' => 'ASC')));
				if(empty($lst)===false) {
						foreach($lst as $det)
								$menu_array[$det["Category"]["id"]] = array('name' => $det["Category"]["cname"],'parent' => $det["Category"]["parent_id"], 'position' => $det["Category"]["position"]);
						$this->set('menu_array', $menu_array);
				}
				$footer_links = $this->Cmspage->find('list',array('conditions' => array('Cmspage.type' => 'content','Cmspage.status' => 'Y')));
				$this->set('footerlinks', $footer_links);
				$pages =    $this->Dynamicpage->getpages();
				//echo "hello<pre>";print_r($pages);
				$this->set('pagesdynamic', $pages);
		}
}
