<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: 			*/
// +----------------------------------------------------------------------+
// | PHP version 4/5                                                      |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004-2011 ARMIA INC                                    |
// +----------------------------------------------------------------------+
// | This source file is a part of iScripts PrintLogic                     |
// +----------------------------------------------------------------------+
// | Authors: Jipson<jipson.thomas@armiasystems.com>             		  |
// +----------------------------------------------------------------------+
App::uses('Component', 'Controller');
class GooglemerchantcalculationsComponent extends Component
{
	var $results_arr;
    var $currency;
    var $schema_url = "http://checkout.google.com/schema/2";
	var $components = array('Xmlbuilder');	
    function GoogleMerchantCalculationsch($currency = "USD") {
      $this->results_arr = array();
      $this->currency = $currency;
    }

    function AddResult($results) {
      $this->results_arr[] = $results;
    }

    function GetXML() {
      $this->Xmlbuilder->Xmlbuilderch();
      $this->Xmlbuilder->Push('merchant-calculation-results', 
          array('xmlns' => $this->schema_url));
      $this->Xmlbuilder->Push('results');

      foreach($this->results_arr as $result) {
        if($result->shipping_name != "") {
          $this->Xmlbuilder->Push('result', array('shipping-name' => 
              $result->shipping_name, 'address-id' => $result->address_id));
          $this->Xmlbuilder->Element('shipping-rate', $result->ship_price, 
              array('currency' => $this->currency));
          $this->Xmlbuilder->Element('shippable', $result->shippable);
        } else
          $this->Xmlbuilder->Push('result', array('address-id' => $result->address_id));

        if($result->tax_amount != "")   
          $this->Xmlbuilder->Element('total-tax', $result->tax_amount, 
              array('currency' => $this->currency));

        if((count($result->coupon_arr) != 0) || 
            (count($result->giftcert_arr) != 0) )  {
          $this->Xmlbuilder->Push('merchant-code-results');

          foreach($result->coupon_arr as $curr_coupon) {
            $this->Xmlbuilder->Push('coupon-result');  
            $this->Xmlbuilder->Element('valid', $curr_coupon->coupon_valid);
            $this->Xmlbuilder->Element('code', $curr_coupon->coupon_code);
            $this->Xmlbuilder->Element('calculated-amount', $curr_coupon->coupon_amount,
                array('currency'=> $this->currency));
            $this->Xmlbuilder->Element('message', $curr_coupon->coupon_message);
            $this->Xmlbuilder->Pop('coupon-result');  
          }
          foreach($result->giftcert_arr as $curr_gift) {
            $this->Xmlbuilder->Push('gift-result');  
            $this->Xmlbuilder->Element('valid', $curr_gift->gift_valid);
            $this->Xmlbuilder->Element('code', $curr_gift->gift_code);
            $this->Xmlbuilder->Element('calculated-amount', $curr_gift->gift_amount, 
                array('currency'=> $this->currency));
            $this->Xmlbuilder->Element('message', $curr_gift->gift_message);
            $this->Xmlbuilder->Pop('gift-result');  
          }
          $this->Xmlbuilder->Pop('merchant-code-results');
        }
        $this->Xmlbuilder->Pop('result');  
      }
      $this->Xmlbuilder->Pop('results');
      $this->Xmlbuilder->Pop('merchant-calculation-results'); 
      return $this->Xmlbuilder->GetXML();
    }
}?>