<?php
App::uses('Component', 'Controller');
class TextgenComponent extends Component {
    
    public $font;  //default font. directory relative to script directory.
    public $msg = "no text"; // default text to display.
    public $size = 4; // default font size.
    public $rot = 0; // rotation in degrees.
    public $pad = 0; // padding.
    public $transparent = 1; // transparency set to on.
    public $back = 'FFFFFF'; // foreground text...
    public $fore = '000000'; // on white background.
    public $outline; // outline if any.
    public $outlinecolor; // outline color.
    public $sitefolder;
    public $curve;
    public $allignment = 'center';
    public $textShape = 'normal';
    public $textShapeSettings = 12;
    public $imagedepth=64;
	public $imgleft;
	public $imgtop;
	public $imgright;
	public $imgbottom;
    private $gravity;
    private $padding = 2;
    private $dpi = 300;
    

    function __br2nl($s, $useReturn=false) {
    	        return preg_replace('/<br>/i', (($useReturn) ? '/r' : '/n'), $s);      
    }

    function draw() {            
       //echo $this->height; exit;
        //Creating Text        
        $this->msg = $this->__br2nl($this->msg);
        $this->msg=str_replace('\\','1',$this->msg);
        $this->msg = str_replace("/n", "\n", $this->msg);
        $this->msg=str_replace('"','\"',$this->msg);
        $this->msg=preg_replace("/(\r\n|\n|\r|\t)/i", '\n', $this->msg);

        
        
        
        //TEXT Allignment Setting        
        	switch($this->allignment)
        		{
        			case 'left':
        					{
        					$this->gravity="west";
        					break;
        					}
        			case 'right':
        					{
        					$this->gravity="east";
        					break;
        					}
        			default:
        					{
        					$this->gravity="center";
        					break;
        					}
        		}
        	
   
//OUTLINE COLOR//
			       
        	switch($this->outline) {
        		case 'Thin':
        			{
        				$this->padding*=1;
        				break;
        			}
        		case 'Medium':
        			{
        				$this->padding*=2;
        				break;
        			}
        		case 'Thick':
        			{
        				$this->padding*=3;
        				break;
        			}
        		default:
        			{
        				$this->padding*=1;
        				break;
        			}
        	}
        	
//Case for Text ART

        	switch($this->textShape)
        		{
        			case 'normal':
        				{
        					$this->drawNormal();
        					break;
        				}
        			case 'curve':
        				{
        					$this->drawCurve();
        					break;
        				}
        			case 'arc':
        				{
        					$this->drawArc();
        					break;
        				}
        			case 'wedge':
        					{
        						$this->drawWedge();
        						break;
        					}
        			case 'roof':               //Need to write
        				{
        					$this->drawRoof();
        					break;
        				}
        			default:
        				{
        					$this->drawNormal();
        					break;
        				}
        		}
     	
        	

        
  }

private function drawNormal()
{
	$pngName = time().rand(0, 9999).'.png';

//FOR NORMAL DRAWING
	system('convert -depth '.$this->imagedepth.' -density '.$this->dpi.' -units pixelsperinch -background transparent -gravity '.$this->gravity.' -fill "#'.$this->fore.'" -font '.$this->font.' -stroke none -pointsize '.$this->size.' label:"'.$this->msg.'" '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
	//echo 'convert -depth '.$this->imagedepth.' -density '.$this->dpi.' -units pixelsperinch -background transparent -gravity '.$this->gravity.' -fill "#'.$this->fore.'" -font '.$this->font.' -stroke none -pointsize '.$this->size.' label:"'.$this->msg.'" '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName; exit;
//FOR OUTLINE DRAWING	
	if(($this->outline <> 'None')) 
	{
		$stokewidthcmd=' -strokewidth '.$this->padding.' -gravity center -stroke "#'.$this->outlinecolor.'"';
		system('convert -depth '.$this->imagedepth.' -density '.$this->dpi.' -units pixelsperinch -background transparent -gravity '.$this->gravity.' -fill "#'.$this->fore.'" -font '.$this->font.$stokewidthcmd.' -pointsize '.$this->size.' label:"'.$this->msg.'" '.WWW_ROOT.IMAGES_URL.'editorimages/1_'.$pngName);
		system('composite -gravity center '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName.' '.WWW_ROOT.IMAGES_URL.'editorimages/1_'.$pngName.' '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
		unlink(WWW_ROOT.IMAGES_URL.'editorimages/1_'.$pngName);
	}

//FOR ROATATION
	system('convert '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName.' -virtual-pixel transparent -distort Arc 1,'.$this->rot.' '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
	
	
	ob_start();
        header("Content-type: image/png");
        readfile(WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
   	unlink(WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
        exit;
}


private function drawCurve()
{
	$pngName = time().rand(0, 9999).'.png';

	switch($this->textShapeSettings)
	{
		case 1 :                   //Up Very Sharp
			{
				$curve= 270;
				break;
			}
		case 2: 					//Up Sharp
			{
         		$curve = 180;
         		break;
			}
		case 3: 					//Up Medium
			{
         		$curve = 90;
         		break;
			}
		case 4:					    //Up Slight
			{
        		 $curve = 45;
        		 break;
			}
		case 5: 					//Up Very Slight
			{
         		$curve = 22.5;
         		break;
			}
		case 6: 					//Up Super Slight
			{
         		$curve = 11.25;
         		break;
			}
			
		case 7 :                   //Down Very Sharp
				{
					$curve= 270;
					break;
				}
		case 8: 					//Down Sharp
				{
					$curve = 180;
					break;
				}
		case 9: 					//Down Medium
				{
					$curve = 90;
					break;
				}
		case 10:					    //Down Slight
				{
					$curve = 45;
					break;
				}
		case 11: 					//Down Very Slight
				{
					$curve = 22.5;
					break;
				}
		case 12: 					//Down Super Slight
				{
					$curve = 11.25;
					break;
				}

		default:
		{
         		$curve = 0;
        		break;
		}
	}
		// $fp = fopen(WWW_ROOT.IMAGES_URL.'sample1.txt', 'w');
         
 //fwrite($fp,$this->rot.' outside if');
        
	if($this->textShapeSettings>6)
	{
	   
            $this->rot-=180;
	}
	else 
	{
		$this->rot=$this->rot;
	}
	
	//FOR NORMAL DRAWING
	system('convert -depth '.$this->imagedepth.' -density '.$this->dpi.' -units pixelsperinch -background transparent -gravity '.$this->gravity.' -fill "#'.$this->fore.'" -font '.$this->font.' -stroke none -pointsize '.$this->size.' label:"'.$this->msg.'" '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);

	//FOR OUTLINE DRAWING
	if(($this->outline <> 'None'))
	{
		$stokewidthcmd=' -strokewidth '.$this->padding.' -gravity center -stroke "#'.$this->outlinecolor.'"';
		system('convert -depth '.$this->imagedepth.' -density '.$this->dpi.' -units pixelsperinch -background transparent -gravity '.$this->gravity.' -fill "#'.$this->fore.'" -font '.$this->font.$stokewidthcmd.' -pointsize '.$this->size.' label:"'.$this->msg.'" '.WWW_ROOT.IMAGES_URL.'editorimages/1_'.$pngName);
		system('composite -gravity center '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName.' '.WWW_ROOT.IMAGES_URL.'editorimages/1_'.$pngName.' '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
		unlink(WWW_ROOT.IMAGES_URL.'editorimages/1_'.$pngName);
	}

	//FOR Distorted ARC ROATATION
	if($this->textShapeSettings>6)
	{
            
     //  $fp = fopen(WWW_ROOT.IMAGES_URL.'sample1.txt', 'w');
            //fwrite($fp, 'convert '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName.' -virtual-pixel transparent -rotate 180 -distort Arc '.$curve.','.$this->rot.' '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
   // fwrite($fp,$this->rot);
            
            
	system('convert '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName.' -virtual-pixel transparent -rotate 180 -distort Arc '.$curve.','.$this->rot.' '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
	}
	else
	{
		system('convert '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName.' -virtual-pixel transparent -distort Arc '.$curve.','.$this->rot.' '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
	}

	ob_start();
	header("Content-type: image/png");
	readfile(WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
	unlink(WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
	exit;
}


private function drawArc()
{
	$pngName = time().rand(0, 9999).'.png';

	switch($this->textShapeSettings)
	{
		case 1 :                   //Up Very Small
			{
				$arc= 5;
				break;
			}
		case 2: 					//Up Small
			{
				$arc = 4;
				break;
			}
		case 3: 					//Up Medium
			{
				$arc = 3;
				break;
			}
		case 4:					    //Up Large
			{
				$arc = 2;
				break;
			}
		case 5: 					//Up Very Lage
			{
				$arc = 1;
				break;
			}
		case 6: 					//Down Very Small
			{
				$arc = 5;
				break;
			}
				
		case 7 :                   //Down small
			{
				$arc= 4;
				break;
			}
		case 8: 					//Down Medium
			{
				$arc = 3;
				break;
			}
		case 9: 					//Down Large
			{
				$arc = 2;
				break;
			}
		case 10:					    //Down very Large
			{
				$arc = 1;
				break;
			}
	
		default:
			{
				$arc = 1;
				break;
			}
	}

	//FOR NORMAL DRAWING
	system('convert -depth '.$this->imagedepth.' -density '.$this->dpi.' -units pixelsperinch -background transparent -gravity '.$this->gravity.' -fill "#'.$this->fore.'" -font '.$this->font.' -stroke none -pointsize '.$this->size.' label:"'.$this->msg.'" '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);

	//FOR OUTLINE DRAWING
	if(($this->outline <> 'None'))
	{
		$stokewidthcmd=' -strokewidth '.$this->padding.' -gravity center -stroke "#'.$this->outlinecolor.'"';
		system('convert -depth '.$this->imagedepth.' -density '.$this->dpi.' -units pixelsperinch -background transparent -gravity '.$this->gravity.' -fill "#'.$this->fore.'" -font '.$this->font.$stokewidthcmd.' -pointsize '.$this->size.' label:"'.$this->msg.'" '.WWW_ROOT.IMAGES_URL.'editorimages/1_'.$pngName);
		system('composite -gravity center '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName.' '.WWW_ROOT.IMAGES_URL.'editorimages/1_'.$pngName.' '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
		unlink(WWW_ROOT.IMAGES_URL.'editorimages/1_'.$pngName);
	}

	$size = getimagesize(WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
	$width = $size[0] * 2;
	$height = $size[1];
	
	//FOR Distorted ARC ROATATION
	if($this->textShapeSettings>5)
	{
		system('convert '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName.' -background transparent -virtual-pixel transparent -rotate 180 -wave '.$height/$arc.'x'.$width.' -distort Arc 1,'.($this->rot+180).' '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
	}
	else
	{
		system('convert '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName.' -background transparent -virtual-pixel transparent -wave '.($height/$arc).'x'.$width.' -chop 0x'.($height/$arc).' -distort Arc 1,'.$this->rot.' '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
	}

	ob_start();
	header("Content-type: image/png");
	readfile(WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
	unlink(WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
	exit;
}


private function drawWedge()
{
	$pngName = time().rand(0, 9999).'.png';

	switch($this->textShapeSettings)
	{
		case 1 :                   //Up Widen Slow
                {
                        $wedgesize= 4;
                        break;
                }
		case 2: 				//Up Widen Medium
         	{ 
         		$wedgesize=3;
         		break;
         	}
                case 3: 				//Up Widen Fast
                { 
                        $wedgesize=  2;
                        break;
                }
                case 4: 					//Up Narrow Slow
                { 
                        $wedgesize=  4;
                        break;
                }
                case 5: 					//Up Narrow Medium
                { 
                        $wedgesize=  3;
                        break;
                }
                case 6: 					//Up Narrow Fast
                { 
                        $wedgesize=  2;
                        break;
                }
                case 7: 					//Middle Widen Slow
                { 
                        $wedgesize=  5;
                        break;
                }
                case 8: 					//Middle Widen Medium
                { 
                        $wedgesize=  4;
                        break;
                }
                case 9: 					//Middle Widen Fast
                { 
                        $wedgesize=  3;
                        break;
                }
                case 10: 					//Middle Widen Slow
                { 
                        $wedgesize=  5;
                        break;
                }
                case 11: 					//Middle Widen Medium
                { 
                        $wedgesize=  4;
                        break;
                }
                case 12: 					//Middle Widen Fast
                { 
                        $wedgesize=  3;
                        break;
                }
                case 13: 					//Down Widen Slow
                { 
                        $wedgesize=  4;
                        break;
                }
                case 14: 					//Down Widen Medium
                { 
                        $wedgesize=  3;
                        break;
                }
                case 15: 					//Down Widen Fast
                { 
                        $wedgesize=  2;
                        break;
                }
                case 16: 					//Down Narrow Slow
                { 
                        $wedgesize=  4;
                        break;
                }
                case 17: 					//Down Narrow Medium
                { 
                        $wedgesize=  3;
                        break;
                }
                case 18: 					//Down Narrow Fast
                { 
                        $wedgesize=  2;
                        break;
                }
		default:
                {
                        $wedgesize = 4;
                        break;
                }
	}

	//FOR NORMAL DRAWING
	system('convert -depth '.$this->imagedepth.' -density '.$this->dpi.' -units pixelsperinch -background transparent -gravity '.$this->gravity.' -fill "#'.$this->fore.'" -font '.$this->font.' -stroke none -pointsize '.$this->size.' label:"'.$this->msg.'" '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);

	//FOR OUTLINE DRAWING
	if(($this->outline <> 'None'))
	{
		$stokewidthcmd=' -strokewidth '.$this->padding.' -gravity center -stroke "#'.$this->outlinecolor.'"';
		system('convert -depth '.$this->imagedepth.' -density '.$this->dpi.' -units pixelsperinch -background transparent -gravity '.$this->gravity.' -fill "#'.$this->fore.'" -font '.$this->font.$stokewidthcmd.' -pointsize '.$this->size.' label:"'.$this->msg.'" '.WWW_ROOT.IMAGES_URL.'editorimages/1_'.$pngName);
		system('composite -gravity center '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName.' '.WWW_ROOT.IMAGES_URL.'editorimages/1_'.$pngName.' '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
		unlink(WWW_ROOT.IMAGES_URL.'editorimages/1_'.$pngName);
	}
	system('convert "'.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName.'" -trim -bordercolor none -border 1 '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
	$size = getimagesize(WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
	$width = $size[0];
	$height = $size[1];

	//FOR Distorted Wedge 

      if ($this->textShapeSettings == 1 || $this->textShapeSettings == 2 || $this->textShapeSettings == 3)
        system('convert -depth '.$this->imagedepth.' -density '.$this->dpi.' -units pixelsperinch "'.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName.'" -background transparent -distort Bilinear "0,0,0,'.($height/$wedgesize).'  0,'.$height.',0,'.$height.'  '.$width.',0,'.$width.',0  '.$width.','.$height.','.$width.','.$height.'" -trim -rotate '.$this->rot.' -trim '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
      else if ($this->textShapeSettings == 4 || $this->textShapeSettings == 5 || $this->textShapeSettings == 6)
        system('convert -depth '.$this->imagedepth.' -density '.$this->dpi.' -units pixelsperinch "'.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName.'" -background transparent -distort Bilinear "0,0,0,0  0,'.$height.',0,'.$height.'  '.$width.',0,'.$width.','.($height/$wedgesize).'  '.$width.','.$height.','.$width.','.$height.'" -trim -rotate '.$this->rot.' -trim '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
      else if ($this->textShapeSettings == 7 || $this->textShapeSettings == 8 || $this->textShapeSettings == 9)
        system('convert -depth '.$this->imagedepth.' -density '.$this->dpi.' -units pixelsperinch "'.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName.'" -background transparent -distort Bilinear "0,0,0,'.($height/$wedgesize).'  0,'.$height.',0,'.($height-$height/$wedgesize).'  '.$width.',0,'.$width.',0  '.$width.','.$height.','.$width.','.$height.'" -trim -rotate '.$this->rot.' -trim '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
      else if ($this->textShapeSettings == 10 || $this->textShapeSettings == 11 || $this->textShapeSettings == 12)
        system('convert -depth '.$this->imagedepth.' -density '.$this->dpi.' -units pixelsperinch "'.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName.'" -background transparent -distort Bilinear "0,0,0,0  0,'.$height.',0,'.$height.'  '.$width.',0,'.$width.','.($height/$wedgesize).'  '.$width.','.$height.','.$width.','.($height-$height/$wedgesize).'" -trim -rotate '.$this->rot.' -trim '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
      else if ($this->textShapeSettings == 13 || $this->textShapeSettings == 14 || $this->textShapeSettings == 15)
        system('convert -depth '.$this->imagedepth.' -density '.$this->dpi.' -units pixelsperinch "'.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName.'" -background none -distort Bilinear "0,0,0,0  0,'.$height.',0,'.($height-$height/$wedgesize).'  '.$width.',0,'.$width.',0  '.$width.','.$height.','.$width.','.$height.'" -trim -rotate '.$this->rot.' -trim '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
      else if ($this->textShapeSettings == 16 || $this->textShapeSettings == 17 || $this->textShapeSettings == 18)
        system('convert -depth '.$this->imagedepth.' -density '.$this->dpi.' -units pixelsperinch "'.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName.'" -background transparent -distort Bilinear "0,0,0,0  0,'.$height.',0,'.$height.'  '.$width.',0,'.$width.',0  '.$width.','.$height.','.$width.','.($height-$height/$wedgesize).'" -trim -rotate '.$this->rot.' -trim '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);


      //FOR ROATATION
     // system('convert '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName.' -virtual-pixel transparent -trim -distort Arc 1,'.$this->rot.' '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
      
      
	ob_start();
	header("Content-type: image/png");
	readfile(WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
	unlink(WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
	exit;
}

private function drawRoof()
{
	
	$pngName = time().rand(0, 9999).'.png';
	
	
	switch ($this->textShapeSettings)
	{
		case 1: 			//Top Small
			{
				$roofsize = 4;
				break;
			}
		case 2: 			//Top Medium
			{
				$roofsize = 3;
				break;
			}
		case 3: 			//Top Large
			{
				$roofsize = 2;
				break;
			}
		case 4: 			//Middle Small
			{
				$roofsize = 5;
				break;
			}
		case 5: 			//Middle Medium
			{
				$roofsize = 4;
				break;
			}
		case 6: 			//Middle Large
			{
				$roofsize = 3;
				break;
			}
		case 7: 			//Bottom Small
			{
				$roofsize = 4;
				break;
			}
		case 8:				 //Bottom Medium
			{
				$roofsize = 3;
				break;
			}
		case 9: 			//Bottom Large
			{
				$roofsize = 2;
				break;
			}
		case 10: 			//Left Small
			{
				$roofsize = 5;
				break;
			}
		case 11: 			//Left Medium
			{
				$roofsize = 4;
				break;
			}
		case 12: 			//Left Large
			{
				$roofsize = 3;
				break;
			}
		case 13: 			//Right Small
			{
				$roofsize = 5;
				break;
			}
		case 14: 			//Right Medium
			{
				$roofsize = 4;
				break;
			}
			
		case 15: 			//Right Large
			{
				$roofsize = 3;
				break;
			}
		default:
			{
				$roofsize = 4;
				break;
			}
	}
	
	//FOR NORMAL DRAWING
	system('convert -depth '.$this->imagedepth.' -density '.$this->dpi.' -units pixelsperinch -background transparent -gravity '.$this->gravity.' -fill "#'.$this->fore.'" -font '.$this->font.' -stroke none -pointsize '.$this->size.' label:"'.$this->msg.'" '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
	//FOR OUTLINE DRAWING
	
	if(($this->outline <> 'None'))
	{
		$stokewidthcmd=' -strokewidth '.$this->padding.' -gravity center -stroke "#'.$this->outlinecolor.'"';
		system('convert -depth '.$this->imagedepth.' -density '.$this->dpi.' -units pixelsperinch -background transparent -gravity '.$this->gravity.' -fill "#'.$this->fore.'" -font '.$this->font.$stokewidthcmd.' -pointsize '.$this->size.' label:"'.$this->msg.'" '.WWW_ROOT.IMAGES_URL.'editorimages/1_'.$pngName);
		system('composite -gravity center '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName.' '.WWW_ROOT.IMAGES_URL.'editorimages/1_'.$pngName.' '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
		unlink(WWW_ROOT.IMAGES_URL.'editorimages/1_'.$pngName);
	}
	
	//Roof DRAWING
	$size = getimagesize(WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
	$width = $size[0];
	$height = $size[1];
	
	if ($this->textShapeSettings >= 1 && $this->textShapeSettings <= 9)
	{
		system('convert "'.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName.'" -background none -extent '.($width/2).'x'.$height.' '.WWW_ROOT.IMAGES_URL.'editorimages/2_'.$pngName);
		system('convert "'.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName.'" -background none -extent '.($width/2).'x'.$height.'+'.($width/2).'+0 '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
	}
	else if ($this->textShapeSettings >= 10 && $this->textShapeSettings <= 12)
	{
		system('convert "'.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName.'" -background none -extent '.($width/3).'x'.$height.' '.WWW_ROOT.IMAGES_URL.'editorimages/2_'.$pngName);
		system('convert "'.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName.'" -background none -extent '.($width/3*2).'x'.$height.'+'.($width/3).'+0 '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
	}
	else if ($this->textShapeSettings >= 13 && $this->textShapeSettings <= 15)
	{
		system('convert "'.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName.'" -background none -extent '.($width/3*2).'x'.$height.' '.WWW_ROOT.IMAGES_URL.'editorimages/2_'.$pngName);
		system('convert "'.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName.'" -background none -extent '.($width/3).'x'.$height.'+'.($width/3*2).'+0 '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
	}
	
	$size1 = getimagesize(WWW_ROOT.IMAGES_URL.'editorimages/2_'.$pngName);
	$width1 = $size1[0];
	$height1 = $size1[1];
	
	
	$size2 = getimagesize(WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
	$width2 = $size2[0];
	$height2 = $size2[1];
	
	
	if ($this->textShapeSettings == 1 || $this->textShapeSettings == 2 || $this->textShapeSettings == 3)
	{
		system('convert "'.WWW_ROOT.IMAGES_URL.'editorimages/2_'.$pngName.'" -background none -distort Bilinear "0,0,0,'.($height1/$roofsize).' 0,'.$height1.',0,'.$height1.'  '.$width1.',0,'.$width1.',0 '.$width1.','.$height1.','.$width1.','.$height1.'" '.WWW_ROOT.IMAGES_URL.'editorimages/2_'.$pngName);
		system('convert "'.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName.'" -background none -distort Bilinear "0,0,0,0 0,'.$height2.',0,'.$height2.' '.$width2.',0,'.$width2.','.($height2/$roofsize).' '.$width2.','.$height2.','.$width2.','.$height2.'" '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
	}
	else if ($this->textShapeSettings == 7 || $this->textShapeSettings == 8 || $this->textShapeSettings == 9)
	{
		system('convert "'.WWW_ROOT.IMAGES_URL.'editorimages/2_'.$pngName.'" -background none -distort Bilinear "0,0,0,0 0,'.$height1.',0,'.($height1-$height1/$roofsize).' '.$width1.',0,'.$width1.',0 '.$width1.','.$height1.','.$width1.','.$height1.'" '.WWW_ROOT.IMAGES_URL.'editorimages/2_'.$pngName);
		system('convert "'.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName.'" -background none -distort Bilinear "0,0,0,0 0,'.$height2.',0,'.$height2.'  '.$width2.',0,'.$width2.',0 '.$width2.','.$height2.','.$width2.','.($height2-$height2/$roofsize).'" '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
	}
	else
	{
		system('convert "'.WWW_ROOT.IMAGES_URL.'editorimages/2_'.$pngName.'" -background none -distort Bilinear "0,0,0,'.($height1/$roofsize).' 0,'.$height1.',0,'.($height1-$height1/$roofsize).' '.$width1.',0,'.$width1.',0 '.$width1.','.$height1.','.$width1.','.$height1.'" '.WWW_ROOT.IMAGES_URL.'editorimages/2_'.$pngName);
		system('convert "'.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName.'" -background none -distort Bilinear "0,0,0,0 0,'.$height2.',0,'.$height2.' '.$width2.',0,'.$width2.','.($height2/$roofsize).' '.$width2.','.$height2.','.$width2.','.($height2-$height2/$roofsize).'" '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
	}
	
	
	system('convert '.WWW_ROOT.IMAGES_URL.'editorimages/2_'.$pngName.' '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName.' -background none +append -rotate '.$this->rot.' -trim '.WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
	
	
	ob_start();
	header("Content-type: image/png");
	readfile(WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
	unlink(WWW_ROOT.IMAGES_URL.'editorimages/2_'.$pngName);
	unlink(WWW_ROOT.IMAGES_URL.'editorimages/'.$pngName);
	exit;
}

}
?>