<?php

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: 			 */
// +----------------------------------------------------------------------+
// | PHP version 4/5                                                      |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004-2011 ARMIA INC                                    |
// +----------------------------------------------------------------------+
// | This source file is a part of iScripts PrintLogic                    |
// +----------------------------------------------------------------------+
// | Authors: Jipson<jipson.thomas@armiasystems.com>             		  |
// +----------------------------------------------------------------------+

App::uses('Sanitize', 'Utility');
App::uses('AppController', 'Controller');

class OrdersController extends AppController {

    var $name = "Order";
    //var $helpers = array('Html', 'Form','Pagination','Csv','xls');   
    var $helpers = array('Html', 'Form', 'Paginator', 'JS', 'Flash', 'Csv', 'Xls');
    var $components = array('Catmenu', 'Pagination', 'Authorizepayment', 'Customize', 'Download', 'Fedexlatest', 'Bluepay', 'Yourpay', 'Zipdirectoryclass', 'PaypalWPP.PaypalWPP', 'Stripe.Stripe','Email'); // Added
    var $uses = array('Order', 'Product', 'Category', 'Cart', 'Productdetail', 'Currency', 'UserAddress', 'OrderStatus', 'OrderDetail', 'User', 'Cart', 'Cmspage', 'Coupon', 'Country', 'Giftcard', 'State', 'Message', 'Savedimage', 'Customimage', 'Setting', 'Dynamicpage');
    var $paginate = array('limit' => 25, 'order' => array('Order.date' => 'desc'));

    function index($type = "All") {

        $this->__validateLoginStatus();
        if ($this->passedArgs["type"])
            $type = $this->passedArgs["type"];
        $admsess = $this->Session->read('Admin');

        if (isset($_POST["cmbSearchType"])) {
            $this->passedArgs["cmbSearchType"] = $_POST["cmbSearchType"];
            $this->passedArgs["txtSearch"] = str_replace('/', '-', $_POST["txtSearch"]);
        }

        // echo "<pre>";print_r($admsess);exit();       
        if ($admsess["orders"] <> 1) {

            $this->redirect(array('controller' => 'admins', 'action' => 'index'));

            exit();
        }

        $cmbSearchType = "";

        $txtSearch = "";

        if (isset($_POST["cmbSearchType"]) && $_POST["cmbSearchType"] <> '' && isset($_POST["txtSearch"]) && $_POST["txtSearch"] <> '') {



            $cmbSearchType = $_POST["cmbSearchType"];
            $txtSearch = $_POST["txtSearch"];

            if ($cmbSearchType == "oid") {
                //$data = $this->paginate('Order', array('Order.user_id =' =>$user_id,'Order.id =' => addslashes($txtSearch)));	
                $cond = array('Order.id =' => $this->__customaddslashes($txtSearch));
            } elseif ($cmbSearchType == "orderstatus") {
                //$data = $this->paginate('Order', array('Order.user_id =' =>$user_id,'OrderStatus.name  LIKE' =>  addslashes($txtSearch)."%"));
                $cond = array('OrderStatus.name  LIKE' => $this->__customaddslashes($txtSearch) . "%");
            } elseif ($cmbSearchType == "username") {
                //$data = $this->paginate('Order', array('Order.user_id =' =>$user_id,'OrderStatus.name  LIKE' =>  addslashes($txtSearch)."%"));
                $cond = array('USR.uname  LIKE' => "%" . $this->__customaddslashes($txtSearch) . "%");
            } elseif ($cmbSearchType == "dateoforder") {
                $dt = '0000-00-00';
                // echo $txtSearch; exit;
                if ($txtSearch != '') {
                    if (strpos($txtSearch, "-") > 0) {
                        list ($month, $day, $year) = explode("-", $txtSearch); //08-12-2010
                        if (strlen($day) == 1)
                            $day = '0' . $day;
                        if (strlen($month) == 1)
                            $month = '0' . $month;
                        $dt = $year . "-" . $month . "-" . $day; //2010-08-13
                    }

                    else if (strpos($txtSearch, "/") > 0) {
                        list ($month, $day, $year) = explode("/", $txtSearch); //08-12-2010
                        if (strlen($day) == 1)
                            $day = '0' . $day;
                        if (strlen($month) == 1)
                            $month = '0' . $month;
                        $dt = $year . "-" . $month . "-" . $day; //2010-08-13
                    }
                }
                $cond = array('Order.date  LIKE' => $this->__customaddslashes($dt) . "%");
                //$data = $this->paginate('Order', array('Order.user_id =' =>$user_id,'Order.date  LIKE' =>  addslashes($dt)."%"));		
            }
            else {
                $cond = '';
            }
        } else if (isset($this->passedArgs["cmbSearchType"]) && isset($this->passedArgs["txtSearch"]) &&
                $this->passedArgs["txtSearch"] <> '') {
            $cmbSearchType = $this->passedArgs["cmbSearchType"];
            $txtSearch = $this->passedArgs["txtSearch"];
            if ($cmbSearchType == "oid") {
                //$data = $this->paginate('Order', array('Order.user_id =' =>$user_id,'Order.id =' => addslashes($txtSearch)));	
                $cond = array('Order.id =' => $this->__customaddslashes($txtSearch));
            } elseif ($cmbSearchType == "username") {
                //$data = $this->paginate('Order', array('Order.user_id =' =>$user_id,'OrderStatus.name  LIKE' =>  addslashes($txtSearch)."%"));
                $cond = array('USR.uname  LIKE' => $this->__customaddslashes($txtSearch) . "%");
            } elseif ($cmbSearchType == "orderstatus") {
                //$data = $this->paginate('Order', array('Order.user_id =' =>$user_id,'OrderStatus.name  LIKE' =>  addslashes($txtSearch)."%"));
                $cond = array('OrderStatus.name  LIKE' => $this->__customaddslashes($txtSearch) . "%");
            } elseif ($cmbSearchType == "dateoforder") {
                $dt = '0000-00-00';
                if (strpos($txtSearch, "-") > 0) {
                    list ($month, $day, $year) = explode("-", $txtSearch); //08-12-2010
                    if (strlen($day) == 1)
                        $day = '0' . $day;
                    if (strlen($month) == 1)
                        $month = '0' . $month;
                    $dt = $year . "-" . $month . "-" . $day; //2010-08-13
                }

                else if (strpos($txtSearch, "/") > 0) {
                    list ($month, $day, $year) = explode("/", $txtSearch); //08-12-2010
                    if (strlen($day) == 1)
                        $day = '0' . $day;
                    if (strlen($month) == 1)
                        $month = '0' . $month;
                    $dt = $year . "-" . $month . "-" . $day; //2010-08-13
                }
                $cond = array('Order.date  LIKE' => $this->__customaddslashes($dt) . "%");
                //$data = $this->paginate('Order', array('Order.user_id =' =>$user_id,'Order.date  LIKE' =>  addslashes($dt)."%"));		
            }
            else {
                $cond = '';
            }
        } else {
            $cond = '';
        }


        //------------------------------------------------------------------------------------//
        switch ($type) {
            case "All":
                $op = array($cond);
                break;
            case "Purchase":
                //$cond['OrderStatus.name  LIKE'] = "Admin Approved"; 
                /* $cond['OrderStatus.name  LIKE'] = "Customer Paid";
                  $op = array($cond); */
                $cond['OrderStatus.name'] = array("Customer Paid", "Send To Admin", "Item Shipped", "Admin Approved", "Admin Rejected", "Customer Approved", "Customer Rejected", "Phone Order", "Offline Order");
                $op = array('AND' => $cond);
                break;
            case "Invoice":
                $cond['OrderStatus.name'] = array("Customer Paid", "Customer Approved");
                $op = array('OR' => $cond);
                break;
            case "quote":
                $cond['OrderStatus.name  LIKE'] = "New";
                $op = array($cond);
                break;
            default:
                break;
        }
        //------------------------------------------------------------------------------------//
        //getting table names...	
        $usrtbl = $this->Order->getTableName("users");
        $statustbl = $this->Order->getTableName("order_statuses");
        $this->paginate = array(
            'conditions' => $op,
            'fields' => array("Order.id,Order.date,Order.total_price,Order.shipping_price,Order.tax_price,Order.user_id,ORS.name,USR.uname,Order.shipping_method,Order.reduced_amt"),
            'order' => 'Order.id DESC',
            'limit' => $this->paginate["limit"],
            'joins' => array(
                array(
                    'table' => $usrtbl,
                    'alias' => 'USR',
                    'type' => 'LEFT',
                    'conditions' => array('Order.user_id = USR.id')
                ),
                array(
                    'table' => $statustbl,
                    'alias' => 'ORS',
                    'type' => 'LEFT',
                    'conditions' => array('Order.order_status_id = ORS.id')
                )
            ),
            'group' => '',
            'passit' => $this->passedArgs
        );
        $data = $this->paginate('Order');



        $this->set('cmbSearchType', $cmbSearchType);
        $this->set('txtSearch', $txtSearch);
        $this->passedArgs['limit'] = $this->paginate["limit"];
        $this->set('passedarg', $this->passedArgs);
        $this->set('odr', $data);
        $this->set('type', $type);
        $this->layout = 'adm';
    }

    function getcsv($orderstatusId, $searchfield = '', $searchval = '') {

          $this->__validateLoginStatus();

        $admsess = $this->Session->read('Admin');

        if ($admsess["orders"] <> 1) {

            $this->redirect(array('controller' => 'admins', 'action' => 'index'));

            exit();
        }

        $cond = '1=1 ';


        if ($orderstatusId == 1) {
            //    $data	=	$this->Order->findAllByOrder_status_id(1); 
            $cond.= 'AND Order.order_status_id = 1';
        } elseif ($orderstatusId == "all") {

            $cond.= 'AND Order.order_status_id <> 1';
        }


        if (isset($searchfield) && $searchfield <> '' && isset($searchval) && $searchval <> '') {



            $cmbSearchType = $searchfield;
            $txtSearch = str_replace('-', '/', $searchval);
            //echo $txtSearch; exit;
            if ($cmbSearchType == "oid") {
                //$data = $this->paginate('Order', array('Order.user_id =' =>$user_id,'Order.id =' => addslashes($txtSearch)));	
                $cond.= ' AND Order.id = ' . $this->__customaddslashes($txtSearch);
                 $cond = array('Order.id =' => $this->__customaddslashes($txtSearch));
            } elseif ($cmbSearchType == "orderstatus") {
                //$data = $this->paginate('Order', array('Order.user_id =' =>$user_id,'OrderStatus.name  LIKE' =>  addslashes($txtSearch)."%"));
                $cond.=" AND OrderStatus.name  LIKE '" . $this->__customaddslashes($txtSearch) . "%'";
                 $cond = array('OrderStatus.name  LIKE' => $this->__customaddslashes($txtSearch) . "%");
            } elseif ($cmbSearchType == "username") {
                //$data = $this->paginate('Order', array('Order.user_id =' =>$user_id,'OrderStatus.name  LIKE' =>  addslashes($txtSearch)."%"));
                $cond.=" AND User.uname  LIKE " . "'%" . $this->__customaddslashes($txtSearch) . "%'";
                $cond = array('User.uname  LIKE' => "%" . $this->__customaddslashes($txtSearch) . "%");
            } elseif ($cmbSearchType == "dateoforder") {
                $dt = '0000-00-00';
                if ($txtSearch != '') {
                    if (strpos($txtSearch, "-") > 0) {
                        list ($month, $day, $year) = explode("-", $txtSearch); //08-12-2010
                        if (strlen($day) == 1)
                            $day = '0' . $day;
                        if (strlen($month) == 1)
                            $month = '0' . $month;
                        $dt = $year . "-" . $month . "-" . $day; //2010-08-13
                    }

                    else if (strpos($txtSearch, "/") > 0) {
                        list ($month, $day, $year) = explode("/", $txtSearch); //08-12-2010
                        if (strlen($day) == 1)
                            $day = '0' . $day;
                        if (strlen($month) == 1)
                            $month = '0' . $month;
                        $dt = $year . "-" . $month . "-" . $day; //2010-08-13
                    }
                }
                $cond.=" AND Order.date  LIKE '" . $this->__customaddslashes($dt) . "%'";
                //$data = $this->paginate('Order', array('Order.user_id =' =>$user_id,'Order.date  LIKE' =>  addslashes($dt)."%"));		
            
                $cond = array('Order.date  LIKE' => $this->__customaddslashes($dt) . "%");
                
                    }
        }



        if ($orderstatusId == 1) {
            $data = $this->Order->findAllByOrder_status_id(1);
        } elseif ($orderstatusId == "all") {

            $data2 = $this->Order->findAllByOrder_status_id(2);
            $data3 = $this->Order->findAllByOrder_status_id(3);
            $data4 = $this->Order->findAllByOrder_status_id(4);
            $data5 = $this->Order->findAllByOrder_status_id(5);
            $data6 = $this->Order->findAllByOrder_status_id(6);
            $data7 = $this->Order->findAllByOrder_status_id(7);
            $data8 = $this->Order->findAllByOrder_status_id(8);

            $data = array_merge($data2, $data3, $data4, $data5, $data6, $data7, $data8);
        }


 
        $data = $this->Order->find('all', array("conditions"=>$cond,'order' => array('Order.id DESC')));
        //   echo $cond;
         // echo "<pre>"; print_r($data); exit;
        $this->set('data', $data);

        $this->layout = 'csvexp';
    }

    function getxls($orderstatusId, $searchfield = '', $searchval = '') {

        $this->__validateLoginStatus();

        $admsess = $this->Session->read('Admin');

        if ($admsess["orders"] <> 1) {

            $this->redirect(array('controller' => 'admins', 'action' => 'index'));

            exit();
        }

        $cond = '1=1 ';


        if ($orderstatusId == 1) {
            //    $data	=	$this->Order->findAllByOrder_status_id(1); 
            $cond.= 'AND Order.order_status_id = 1';
        } elseif ($orderstatusId == "all") {

            $cond.= 'AND Order.order_status_id <> 1';
        }


        if (isset($searchfield) && $searchfield <> '' && isset($searchval) && $searchval <> '') {



            $cmbSearchType = $searchfield;
            $txtSearch = str_replace('-', '/', $searchval);
            //echo $txtSearch; exit;
            if ($cmbSearchType == "oid") {
                //$data = $this->paginate('Order', array('Order.user_id =' =>$user_id,'Order.id =' => addslashes($txtSearch)));	
                $cond.= ' AND Order.id = ' . $this->__customaddslashes($txtSearch);
                 $cond = array('Order.id =' => $this->__customaddslashes($txtSearch));
            } elseif ($cmbSearchType == "orderstatus") {
                //$data = $this->paginate('Order', array('Order.user_id =' =>$user_id,'OrderStatus.name  LIKE' =>  addslashes($txtSearch)."%"));
                $cond.=" AND OrderStatus.name  LIKE '" . $this->__customaddslashes($txtSearch) . "%'";
                 $cond = array('OrderStatus.name  LIKE' => $this->__customaddslashes($txtSearch) . "%");
            } elseif ($cmbSearchType == "username") {
                //$data = $this->paginate('Order', array('Order.user_id =' =>$user_id,'OrderStatus.name  LIKE' =>  addslashes($txtSearch)."%"));
                $cond.=" AND User.uname  LIKE " . "'%" . $this->__customaddslashes($txtSearch) . "%'";
                $cond = array('User.uname  LIKE' => "%" . $this->__customaddslashes($txtSearch) . "%");
            } elseif ($cmbSearchType == "dateoforder") {
                $dt = '0000-00-00';
                if ($txtSearch != '') {
                    if (strpos($txtSearch, "-") > 0) {
                        list ($month, $day, $year) = explode("-", $txtSearch); //08-12-2010
                        if (strlen($day) == 1)
                            $day = '0' . $day;
                        if (strlen($month) == 1)
                            $month = '0' . $month;
                        $dt = $year . "-" . $month . "-" . $day; //2010-08-13
                    }

                    else if (strpos($txtSearch, "/") > 0) {
                        list ($month, $day, $year) = explode("/", $txtSearch); //08-12-2010
                        if (strlen($day) == 1)
                            $day = '0' . $day;
                        if (strlen($month) == 1)
                            $month = '0' . $month;
                        $dt = $year . "-" . $month . "-" . $day; //2010-08-13
                    }
                }
                $cond.=" AND Order.date  LIKE '" . $this->__customaddslashes($dt) . "%'";
                //$data = $this->paginate('Order', array('Order.user_id =' =>$user_id,'Order.date  LIKE' =>  addslashes($dt)."%"));		
            
                $cond = array('Order.date  LIKE' => $this->__customaddslashes($dt) . "%");
                
                    }
        }



        if ($orderstatusId == 1) {
            $data = $this->Order->findAllByOrder_status_id(1);
        } elseif ($orderstatusId == "all") {

            $data2 = $this->Order->findAllByOrder_status_id(2);
            $data3 = $this->Order->findAllByOrder_status_id(3);
            $data4 = $this->Order->findAllByOrder_status_id(4);
            $data5 = $this->Order->findAllByOrder_status_id(5);
            $data6 = $this->Order->findAllByOrder_status_id(6);
            $data7 = $this->Order->findAllByOrder_status_id(7);
            $data8 = $this->Order->findAllByOrder_status_id(8);

            $data = array_merge($data2, $data3, $data4, $data5, $data6, $data7, $data8);
        }


 
        $data = $this->Order->find('all', array("conditions"=>$cond,'order' => array('Order.id DESC')));
        //   echo $cond;
         // echo "<pre>"; print_r($data); exit;
        $this->set('data', $data);

        $this->layout = 'csvexp';
    }

    function details($id) {
//Configure::write('debug', 2);
        $this->__validateLoginStatus();

        $admsess = $this->Session->read('Admin');

        if ($admsess["orders"] <> 1) {

            $this->redirect(array('controller' => 'admins', 'action' => 'index'));

            exit();
        }

        $this->Order->id = $id;

        global $currency;

        $curr = $this->Currency->findByCode($currency);

        $this->set('curlogo', $curr["Currency"]["logo"]);
        $this->set('curcode', $curr["Currency"]["code"]);

        $data = $this->Order->read();
        //echopre($data);
        $fundid  = ($data['Order']['fundraiser_id'])?$data['Order']['fundraiser_id']:0;

        $this->set('fundid',$fundid);

        for ($j = 0; $j < sizeof($data["OrderDetail"]); $j++) {

            //$pdet	=	$this->Product->findById($data["OrderDetail"][$j]["product_id"]);
            //$data["OrderDetail"][$j]["Product"]	=	$pdet["Product"];			
            //Fetching the  product combination details

            if ($data["OrderDetail"][$j]["type"] == 'P') {
                $pdet = $this->Product->findById($data["OrderDetail"][$j]["product_id"]);
                $data["OrderDetail"][$j]["Product"] = $pdet["Product"]["pname"];
            } else if ($data["OrderDetail"][$j]["type"] == 'G') {
                $gdet = $this->Giftcard->findById($data["OrderDetail"][$j]["product_id"]);
                $data["OrderDetail"][$j]["Product"] = $gdet["Giftcard"]["gift_code"] . '(Gift Card)';
            }


            if ($data["OrderDetail"][$j]["type"] == 'P') {
                if ($pdet["Product"]["combination"] == 'Y') {

                    $pcombndet = $this->Productdetail->findById($data["OrderDetail"][$j]["combination_id"]);

                    $pcmbnid = explode(',', $pcombndet["Productdetail"]["customvalue_id"]);

                    foreach ($pcmbnid as $key => $val) {

                        if ($val != '') {

                            $combnstr[] = $this->Product->getpdctcmbn($val);

                            $combinations = implode(" ,", $combnstr);

                            $data["OrderDetail"][$j]["combinations"] = $combinations;
                        }
                    }

                    $data["OrderDetail"][$j]["skuno"] = $pcombndet["Productdetail"]["skuno"];

                    unset($combnstr);
                    unset($combinations);
                } //end of if stmt.. 
            }
            //Fetching the  product combination details			
        } // end of for loop..		
        //Finding the product type in the order detail
        $ptype_flag = 'Non-Digital';
        $cmbtype_flag = 'no';
        if (count($data["OrderDetail"]) > 0) {
            foreach ($data["OrderDetail"] as $det) {
                $ptype_flag = $det["prodtype"];
                if ($det["Product"]["combination"] <> '')
                    $cmbtype_flag = 'yes';
            }
        }
        $this->set('ptype_flag', $ptype_flag);
        $this->set('cmbtype_flag', $cmbtype_flag);


        //$shipadd	=	$this->UserAddress->findAll("UserAddress.user_id=".$data["User"]["id"]." AND UserAddress.addr_type='Shipping'");

        $shipadd = $this->UserAddress->find("all", array("conditions" => array("UserAddress.user_id" => $data["User"]["id"], "UserAddress.addr_type" => 'Shipping')));


        //$billadd	=	$this->UserAddress->findAll("UserAddress.user_id=".$data["User"]["id"]." AND UserAddress.addr_type='Billing'");

        $billadd = $this->UserAddress->find("all", array("conditions" => array("UserAddress.user_id" => $data["User"]["id"], "UserAddress.addr_type" => 'Billing')));


        $osts = $this->OrderStatus->find('list', array('fields' => array('OrderStatus.id', 'OrderStatus.name')));

        $this->set('osts', $osts);

        $this->set('odr', $data);

        if (isset($shipadd[0]["UserAddress"]))
            $this->set('ship', $shipadd[0]["UserAddress"]);

        $this->set('bill', $billadd[0]["UserAddress"]);

        $this->layout = 'adm';
    }

    function change_status($id) {

        $this->__validateLoginStatus();

        $admsess = $this->Session->read('Admin');

        if ($admsess["orders"] <> 1) {

            $this->redirect(array('controller' => 'admins', 'action' => 'index'));

            exit();
        }

        $oid = $_POST["order_status"];

        if ($oid) {

            $re = $this->Order->changeStatus($id, $oid);

            if (!empty($re)) {

                $this->Session->setFlash('Order Status Changed Successfully.', 'default', array('class' => 'success'));
                $cnfg = Configure::read('Neutrino');

                $this->Order->id = $id;

                $data = $this->Order->read();

                //---------------------------------Insert into message board--------------------------------------//

                if ($oid == 2) {
                    $msg['Message']['user_id'] = $data["User"]["id"];
                    $msg['Message']['admin_id'] = 1;
                    $msg['Message']['by_admin'] = 1;
                    $msg['Message']['content'] = "<b>System Message:</b> Your quote has been approved by the administrator. Click <b><a href='" . FULL_BASE_URL . $cnfg["sitebasefolder"] . "/orders/userorderdetails/{$data['Order']['id']}'>HERE</a></b> to view your quote.";
                    $msg['Message']['posted_date'] = date("Y-m-d H:i:s");
                    $msg['Message']['parent_id'] = 0;

                    $this->Message->save($msg);
                }

                //------------------------------------------------------------------------------------------------//

                for ($j = 0; $j < sizeof($data["OrderDetail"]); $j++) {

                    $pdet = $this->Product->findById($data["OrderDetail"][$j]["product_id"]);

                    $data["OrderDetail"][$j]["Product"] = $pdet["Product"];
                }

                //print_r($data); exit;
                //$shipadd	=	$this->UserAddress->findAll("UserAddress.user_id=".$data["User"]["id"]." AND UserAddress.addr_type='Shipping'");

                $shipadd = $this->UserAddress->find("all", array("conditions" => array("UserAddress.user_id" => $data["User"]["id"], "UserAddress.addr_type" => 'Shipping')));

                //$billadd	=	$this->UserAddress->findAll("UserAddress.user_id=".$data["User"]["id"]." AND UserAddress.addr_type='Billing'");

                $billadd = $this->UserAddress->find("all", array("conditions" => array("UserAddress.user_id" => $data["User"]["id"], "UserAddress.addr_type" => 'Billing')));

                $odr = $data;

                $ship = $shipadd[0]["UserAddress"];

                $bill = $billadd[0]["UserAddress"];
                $curr1 = $this->Currency->findByCode($odr["Order"]["currency_type"]);
                $currlogo1 = $curr1["Currency"]["logo"];

                $content = "<table width='90%'  border='0' cellspacing='2' cellpadding='2' align='center'><tr><td colspan='2' align='center'><h2>Order Details</h2></td></tr><tr><td colspan='2' align='center'>
			<table width='90%' border='0' cellpadding='0' cellspacing='0' class='manage_table' align='center'><tr><td><strong>Order Number</strong></td><td><strong>Order Status</strong></td><td><strong>Order Date</strong></td><td><strong>User Name</strong></td><td><strong>Currency</strong></td></tr><tr><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td></tr><tr><td>" .$odr['Order']['id'] . "</td><td>" .$odr['OrderStatus']['name'] . "</td><td>";



                $dt = strtotime($odr['Order']['date']);

                $content .= date('m/d/Y', $dt);

                $content .= "</td><td> " . $odr['User']['uname'] . "</td><td>" . $odr["Order"]["currency_type"] . "</td></tr></table></td></tr><tr><td colspan='2' align='center'><h3>Item Details</h3></td></tr><tr><td colspan='2'><table width='90%' border='0' cellpadding='2' cellspacing='2' class='manage_table' align='center'><tr><td colspan='2' width='24%' valign='top'><strong>Product Name</strong></td><td width='12%' valign='top'><strong>Quantity</strong></td><td width='15%' valign='top'><strong>Unit Price</strong></td><td width='15%' valign='top'><strong>Additional Cost</strong></td><td width='14%' valign='top'><strong>Discount</strong></td><td colspan='2' valign='top'><strong>Price</strong></td></tr><tr><td colspan='2'>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td></tr>";



                $amt = 0;

                //print_r($odr);exit;

                foreach ($odr['OrderDetail'] as $det) {

                    if ($det['discount_type'] == 'amnt') {
                        $discount = $det['discount'];
                    } elseif ($det['discount_type'] == 'per') {
                        $discount = ($det['product_price'] * $det['discount'] / 100);
                    } else {
                        $discount = 0.00;
                    }

                    $price = (($det['product_price'] - $discount) * $det['quantity']) + ($det['extra_price'] * $det['quantity']);

                    $amt = $amt + $price;

                    $content .= "<tr><td colspan='2' valign='top'>" . $det['Product']['pname'] . "</td><td valign='top'> " . $det['quantity'] . " </td><td valign='top'>" . $currlogo1 . " " . number_format($det['product_price'], 2, '.', '') . " </td><td valign='top'>" . $currlogo1 . " " . number_format($det['extra_price'] * $det['quantity'], 2, '.', '') . " </td><td valign='top'>" . $currlogo1 . " " . number_format($discount * $det['quantity'], 2, '.', '') . " </td><td valign='top'>" . $currlogo1 . " " . number_format($price, 2, '.', '') . " </td></tr><tr><td colspan='2' height='15'>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td></tr>";
                }

                $content .= "</table></td></tr><tr><td width='50%'><table width='100%'border='0' cellpadding='0' cellspacing='0'><tr><td><table width='90%' border='0' cellpadding='0' cellspacing='0' class='manage_table' align='center'><tr><td width='50%'><strong>Shipping Method</strong></td><td  width='5%'>:</td><td width='45%'>" . $odr['Order']['shipping_method'] . "</td></tr><tr><td><strong>Shipping Service</strong></td><td>:</td><td>" . $odr['Order']['shipping_service'] . " </td></tr></table></td></tr><tr><td><table width='90%' border='0' cellpadding='0' cellspacing='0' class='manage_table' align='center'><tr><td width='50%'><strong>Payment Method</strong></td><td width='5%'>:</td><td width='45%'> " . $odr['Order']['payment_method'] . "</td></tr><tr><td><strong>Transaction Id</strong></td><td>:</td><td> " . $odr['Order']['transaction_id'] . " </td></tr></table></td></tr></table></td><td width='50%'><table width='90%' border='0' cellpadding='0' cellspacing='0' class='manage_table' align='center'><tr><td><strong>Total Price</strong></td><td>:</td><td> " . $currlogo1 . " " . number_format($amt, 2, '.', '') . "</td></tr><tr><td><strong>Shipping Price</strong></td><td>:</td><td> " . $currlogo1 . " " . number_format($odr['Order']['shipping_price'], 2, '.', '') . " </td></tr><tr><td><strong>Promo Code Discount</strong></td><td>:</td><td> " . $odr['Order']['reduced_amt'] . "</td></tr><tr><td><strong>Tax Price</strong></td><td>:</td><td> " . $currlogo1 . " " . number_format($odr['Order']['tax_price'], 2, '.', '') . "</td></tr><tr><td><strong>Grand Total</strong></td><td>:</td><td><b> " . $currlogo1 . " " . number_format($odr['Order']['total_price'] - $odr['Order']['reduced_amt'], 2, '.', '') . " </b></td></tr></table></td></tr><tr height='15'><td colspan='2' align='center'>&nbsp;</td></tr> <tr><td><table width='90%' border='0' cellpadding='0' cellspacing='0' class='manage_table' align='center'><tr><td><h3>Shipping Address</h3></td></tr><tr><td> " . $odr['Order']['ship_fname'] . "&nbsp;&nbsp;  " . $odr['Order']['ship_lname'] . " </td></tr><tr><td> " . $odr['Order']['ship_address'] . " </td></tr><tr><td> " . $odr['Order']['ship_city'] . "," . $odr['Order']['ship_state'] . " </td></tr><tr><td> " . $odr['Order']['ship_country'] . "  - " . $odr['Order']['ship_zip'] . " </td></tr><tr><td>Phone &nbsp; : &nbsp; " . $odr['Order']['ship_phone'] . " </td></tr><tr><td>Mobile &nbsp; : &nbsp;" . $odr['Order']['ship_mobile'] . "</td></tr><tr><td>Fax &nbsp; : &nbsp; " . $odr['Order']['ship_fax'] . " </td></tr><tr><td>&nbsp;</td></tr></table></td><td><table width='90%' border='0' cellpadding='0' cellspacing='0' class='manage_table' align='center'><tr><td><h3> Billing Address</h3></td></tr><tr><td> " . $odr['Order']['bill_fname'] . "&nbsp;&nbsp; " . $odr['Order']['bill_lname'] . " </td></tr><tr><td> " . $odr['Order']['bill_address'] . "</td></tr><tr><td>" . $odr['Order']['bill_city'] . " ," . $odr['Order']['bill_state'] . "</td></tr><tr><td>" . $odr['Order']['bill_country'] . " - " . $odr['Order']['bill_zip'] . " </td></tr><tr><td>Phone &nbsp; : &nbsp; " . $odr['Order']['bill_phone'] . "</td></tr><tr><td>Mobile &nbsp; : &nbsp; " . $odr['Order']['bill_mobile'] . " </td></tr><tr><td>Fax &nbsp; : &nbsp; " . $odr['Order']['bill_fax'] . "</td></tr><tr><td>&nbsp;</td></tr></table></td></tr></table> ";

                $subject = "Order status changed at " . $cnfg["site_name"];

                $headers = "MIME-Version: 1.0\r\n";

                $headers .= "Reply-To: " . $cnfg["site_name"] . " <" . $cnfg["admin_email"] . ">" . "\r\n";

                $headers .= "Return-Path: " . $cnfg["site_name"] . " <" . $cnfg["admin_email"] . ">" . "\r\n";

                $headers .= "From: " . $cnfg["site_name"] . "<" . $cnfg["admin_email"] . ">\r\n";

                $headers .= "Organization: " . $cnfg["site_name"] . "\r\n";

                $headers .= "Content-type: text/html; charset=iso-8859-1\r\n";

                $pdt = $this->Cmspage->findByTitle('Order status change mail');

                $path = "SiteLogo_disp.gif";

                $mcont = "<table width='90%'  border='0' cellspacing='2' cellpadding='2' align='center'>
			  <tr><td><a href='" . FULL_BASE_URL . $cnfg["sitebasefolder"] . "' target='_blank'><img src='" . FULL_BASE_URL . $cnfg["sitebasefolder"] . "/app/webroot/" . IMAGES_URL . $path . "' border='0' width='300' ></a></td></tr></table>";

                $cnfg["site_name"] = "<a href='" . FULL_BASE_URL . $cnfg["sitebasefolder"] . "' target='_blank'>" . $cnfg["site_name"] . "</a>";

                $mailcontent = $mcont . $pdt["Cmspage"]["content"];

                $mailcontent = str_replace("[ORDER_DETAILS]", $content, $mailcontent);

                $mailcontent = str_replace("[User_Name]", $odr['User']['uname'], $mailcontent);

                $mailcontent = str_replace("[SITE_NAME]", $cnfg["site_name"], $mailcontent);

                //echo $mailcontent; exit;
                //$mailcontent	=	"Hi ".$user["uname"].", <br> Thank you for registering with ".$cnfg["site_name"]."<br> Thanks and Regards, <br> Administrator";
                //$mailcontentad	=	"Hi Admin, <br> ".$user["uname"]." registered  with ".$cnfg["site_name"]."<br> Thanks and Regards, <br> ".$user["uname"];

                if ($cnfg['smtpEnabled'] == "YES") {  //for SMTP
                    $mailsent = $this->Email->send($odr['User']['email'], $subject, $mailcontent);
                    $this->set('mail', $mailsent);
                    $this->render(false);
                } else
                    $mailsent = mail($odr['User']['email'], $subject, $mailcontent, $headers);
            }else {

                $this->Session->setFlash('Order Status Can not Change now .', 'default', array('class' => 'failure'));
            }
        }

        $this->redirect(array('controller' => 'orders', 'action' => 'details/' . $id));

        exit;
    }

    function change_status_user($id, $oid) {

        $this->__validateLoginStatus('U');

        //$oid = $_POST["order_status"];

        if ($oid) {

            $re = $this->Order->changeStatus($id, $oid);

            if (!empty($re)) {

                $this->Session->setFlash('Order Status Changed Successfully.', 'default', array('class' => 'success'));
            } else {

                $this->Session->setFlash('Order Status Can not Change now .', 'default', array('class' => 'failure'));
            }
        }

        if ($oid == 4)
            $this->redirect(array('controller' => 'orders', 'action' => 'userorderdetails/' . $id));
        else
            $this->redirect(array('controller' => 'orders', 'action' => 'myorder/purchase'));

        exit;
    }

    function beforeFilter() {

        /* if (isset($this->Setting) && !empty($this->Setting->table))  

          {

          $this->Setting->load();

          } */
        $this->loadModel('Setting');
        $this->Setting->load();

        global $sitefolder;

        global $meta_description;

        global $meta_keywords;

        global $page_title;

        global $currency;

        $cnfg = Configure::read('Neutrino');

        $sitefolder = $cnfg["sitebasefolder"];

        $currency = $cnfg["currency"];

        $meta_description = $cnfg["meta_description"];

        $meta_keywords = $cnfg["meta_keywords"];

        $page_title = $cnfg["page_title"];

        $allow_fedexlabel = $cnfg["allow_fedexlabel"];

        global $style;

        $style = $cnfg["style"];

        $this->set('style', $style);

        $this->set('meta_description', $meta_description);

        $this->set('meta_keywords', $meta_keywords);

        $this->pageTitle = $page_title;

        $this->set('cnfg', $cnfg);

        $this->paginate["limit"] = $cnfg["items_perpage"]; //Setting pagination limit per page.

        $this->set('allow_fedexlabel', $allow_fedexlabel);

        $this->set('sitefolder', $sitefolder);
        $httpHost = $_SERVER['HTTP_HOST'];
        
        $this->set('sitebase', FULL_BASE_URL);
    }

    function beforeRender() {

        //$lst	=	$this->Catmenu->getCatList(1);
        //$this->set('catmenu', $lst);
        //Code Added By shyam for Category Menu Listing starts here..

        $lst = $this->Category->find('all', array('order' => array('position' => 'ASC')));

        $menu_array = array();

        foreach ($lst as $det)
            $menu_array[$det["Category"]["id"]] = array('name' => $det["Category"]["cname"], 'parent' => $det["Category"]["parent_id"], 'position' => $det["Category"]["position"]);

        $this->set('menu_array', $menu_array);
        $footer_links = $this->Cmspage->find('list', array('conditions' => array('Cmspage.type' => 'content', 'Cmspage.status' => 'Y')));
        $this->set('footerlinks', $footer_links);
        $pages = $this->Dynamicpage->getpages();
        //echo "hello<pre>";print_r($pages);
        $this->set('pagesdynamic', $pages);

        //Code Added By shyam for Category Menu Listing ends here..
    }

    function __validateLoginStatus($typ = 'A') {
        if ($typ == 'A') {
            if ($this->Session->check('Admin') == false) {
                $this->Session->setFlash('The URL you have followed requires you login.', 'default', array('class' => 'failure'));
                $this->redirect(array('controller' => 'admins', 'action' => 'login'));
            }
        } else {
            if ($this->Session->check('Userlog') == false) {
                $this->Session->setFlash('The URL you have followed requires you login.', 'default', array('class' => 'failure'));
                $this->redirect(array('controller' => 'users', 'action' => 'login'));
            }
        }
    }

    function delete($id) {

        $this->__validateLoginStatus();

        $admsess = $this->Session->read('Admin');

        if ($admsess["orders"] <> 1) {

            $this->redirect(array('controller' => 'admins', 'action' => 'index'));

            exit();
        }

        $this->Order->delete_order($id);

        $this->flash(' Order Removed from Database.', '/users');

        $this->redirect('index');
    }

    ################ Function to view the orders placed by user######################

    function myorder($type = "All", $state = NULL, $flag = '') {
//echo FULL_BASE_URL;
        $this->__validateLoginStatus('U');
        $sus = $this->Session->read('Userlog');
        if (isset($sus) && empty($sus) === false) {
            $this->set('sus', $sus);
            $citem = $this->Cart->find('all', array('conditions' => array('Cart.type <>' => 'G', 'user_id' => $sus['id'])));
        } else {
            $this->set('sus', '');
            $sessid = $this->Session->id();
            $citem = $this->Cart->find('all', array('conditions' => array('Cart.type <>' => 'G', 'sess_id' => $sessid)));
        }
        $this->set('cartcount', count($citem));
        global $currency;
        $curr = $this->Currency->findByCode($currency);
        $this->set('curlogo', $curr["Currency"]["logo"]);
        $this->set('sus', $sus);
        $user_id = $sus["id"];
        $cmbSearchType = "";
        $txtSearch = "";

        if (isset($_POST["cmbSearchType"])) {
            $this->passedArgs["cmbSearchType"] = $_POST["cmbSearchType"];
            $this->passedArgs["txtSearch"] = str_replace('/', '-', $_POST["txtSearch"]);
        }
        if (isset($_POST["cmbSearchType"]) && $_POST["cmbSearchType"] <> '' && isset($_POST["txtSearch"]) && $_POST["txtSearch"] <> '') {
            $cmbSearchType = $_POST["cmbSearchType"];
            $txtSearch = trim($_POST["txtSearch"]);

            if ($cmbSearchType == "oid") {
                //$data = $this->paginate('Order', array('Order.user_id =' =>$user_id,'Order.id =' => addslashes($txtSearch)));	
                $cond = array('Order.user_id =' => $user_id, 'Order.id =' => $this->__customaddslashes($txtSearch));
            } elseif ($cmbSearchType == "orderstatus") {
                //$data = $this->paginate('Order', array('Order.user_id =' =>$user_id,'OrderStatus.name  LIKE' =>  addslashes($txtSearch)."%"));
                $cond = array('Order.user_id =' => $user_id, 'OrderStatus.name  LIKE' => $this->__customaddslashes($txtSearch) . "%");
            } elseif ($cmbSearchType == "dateoforder") {
                $dt = '0000-00-00';
                if ($txtSearch != '') {
                    if (strpos($txtSearch, "-") > 0) {
                        list ($month, $day, $year) = explode("-", $txtSearch); //08-12-2010
                        if (strlen($day) == 1)
                            $day = '0' . $day;
                        if (strlen($month) == 1)
                            $month = '0' . $month;
                        $dt = $year . "-" . $month . "-" . $day; //2010-08-13
                    }

                    else if (strpos($txtSearch, "/") > 0) {
                        list ($month, $day, $year) = explode("/", $txtSearch); //08-12-2010
                        if (strlen($day) == 1)
                            $day = '0' . $day;
                        if (strlen($month) == 1)
                            $month = '0' . $month;
                        $dt = $year . "-" . $month . "-" . $day; //2010-08-13
                    }
                }
                $cond = array('Order.user_id =' => $user_id, 'Order.date  LIKE' => $this->__customaddslashes($dt) . "%");
                //$data = $this->paginate('Order', array('Order.user_id =' =>$user_id,'Order.date  LIKE' =>  addslashes($dt)."%"));		
            }
            else {
                $cond = 'Order.user_id =' . $user_id;
            }
        } else if (isset($this->passedArgs["cmbSearchType"]) && isset($this->passedArgs["txtSearch"]) &&
                $this->passedArgs["txtSearch"] <> '') {
            $cmbSearchType = $this->passedArgs["cmbSearchType"];
            $txtSearch = trim($this->passedArgs["txtSearch"]);
            if ($cmbSearchType == "oid") {
                //$data = $this->paginate('Order', array('Order.user_id =' =>$user_id,'Order.id =' => addslashes($txtSearch)));	
                $cond = array('Order.user_id =' => $user_id, 'Order.id =' => $this->__customaddslashes($txtSearch));
            } elseif ($cmbSearchType == "orderstatus") {
                //$data = $this->paginate('Order', array('Order.user_id =' =>$user_id,'OrderStatus.name  LIKE' =>  addslashes($txtSearch)."%"));
                $cond = array('Order.user_id =' => $user_id, 'OrderStatus.name  LIKE' => $this->__customaddslashes($txtSearch) . "%");
            } elseif ($cmbSearchType == "dateoforder") {
                $dt = '0000-00-00';
                if ($txtSearch != '') {
                    if (strpos($txtSearch, "-") > 0) {
                        list ($month, $day, $year) = explode("-", $txtSearch); //08-12-2010
                        if (strlen($day) == 1)
                            $day = '0' . $day;
                        if (strlen($month) == 1)
                            $month = '0' . $month;
                        $dt = $year . "-" . $month . "-" . $day; //2010-08-13
                    }
                    else if (strpos($txtSearch, "/") > 0) {
                        list ($month, $day, $year) = explode("/", $txtSearch); //08-12-2010
                        if (strlen($day) == 1)
                            $day = '0' . $day;
                        if (strlen($month) == 1)
                            $month = '0' . $month;
                        $dt = $year . "-" . $month . "-" . $day; //2010-08-13
                    }
                }
                $cond = array('Order.user_id =' => $user_id, 'Order.date  LIKE' => $this->__customaddslashes($dt) . "%");
                //$data = $this->paginate('Order', array('Order.user_id =' =>$user_id,'Order.date  LIKE' =>  addslashes($dt)."%"));		
            }
            else {
                $cond = array('Order.user_id =' => $user_id);
            }
        } else {
            $cond = array('Order.user_id =' => $user_id);
        }

        //------------------------------------------------------------------------------------//
        switch ($type) {
            case "All":
                $op = array($cond);
                break;
            case "purchase":
                //$cond['OrderStatus.name  LIKE'] = "Admin Approved";
                $cond['OrderStatus.name'] = array("Customer Paid", "Item Shipped");
                $op = array($cond);
                break;
            case "invoice":
                $cond2['OrderStatus.name'] = array("Customer Paid", "Customer Approved");
                $op = array($cond, 'OR' => $cond2);
                break;
            case "quote":
                $cond['OrderStatus.name'] = array("New", "Admin Approved");
                $op = array($cond);
                //  $this->Session->setFlash('Your order has been successfully placed for approval from site administrator and an e-mail with order details has sent to your e-mail ID!', 'default',array('class'=> 'success'));

                break;
            case "quotesucc":
                $cond['OrderStatus.name  LIKE'] = "New";
                $op = array($cond);
                $this->Session->setFlash('Your Quote has been successfully placed for approval from site administrator and an e-mail with order details has sent to your e-mail ID!', 'default', array('class' => 'success'));

                break;
            case "sendtoadmin":
                $cond['OrderStatus.name'] = array("Send To Admin", "Admin Approved", "Admin Rejected", "Customer Rejected", "Phone Order", "Offline Order");
                $op = array($cond);
                if ($state == "sucess")
                    $this->Session->setFlash('Order placed successfully and order details are sent to your e-mail ID,&nbsp Administrator will contact you soon.', 'default', array('class' => 'success'));
                break;
            default:
                break;
        }

        //------------------------------------------------------------------------------------//
        //getting table names...	
        $statustbl = $this->Order->getTableName("order_statuses");
        $this->paginate = array(
            'conditions' => $op,
            'fields' => array("Order.id,Order.date,Order.total_price,Order.shipping_price,Order.tax_price,ORS.name,Order.reduced_amt"),
            'order' => 'Order.id DESC',
            'limit' => $this->paginate["limit"],
            'joins' => array(
                array(
                    'table' => $statustbl,
                    'alias' => 'ORS',
                    'type' => 'LEFT',
                    'conditions' => array('Order.order_status_id = ORS.id')
                )
            ),
            'group' => '',
            'passit' => $this->passedArgs
        );
        $data = $this->paginate('Order');


        $this->set('cmbSearchType', $cmbSearchType);
        $this->set('txtSearch', $txtSearch);
        $this->passedArgs['limit'] = $this->paginate["limit"];
        $this->set('passedarg', $this->passedArgs);
        $this->set('odr', $data);
        $this->set('type', $type);
    }

    function userorderdetails($id) {
   // Configure::write('debug', 2);

        $this->__validateLoginStatus('U');
        $sus = $this->Session->read('Userlog');
        if (isset($sus) && empty($sus) === false) {
            $this->set('sus', $sus);
            $citem = $this->Cart->find('all', array('conditions' => array('Cart.type <>' => 'G', 'user_id' => $sus['id'])));
        } else {
            $this->set('sus', '');
            $sessid = $this->Session->id();
            $citem = $this->Cart->find('all', array('conditions' => array('Cart.type <>' => 'G', 'sess_id' => $sessid)));
        }
        $this->set('cartcount', count($citem));

        global $currency;
        $curr = $this->Currency->findByCode($currency);

        $this->set('curlogo', $curr["Currency"]["logo"]);
        $this->Order->id = $id;
        $data    = $this->Order->read();
        $fundid  = $data['Order']['fundraiser_id'];
        $fundid  = ($data['Order']['fundraiser_id'])?$data['Order']['fundraiser_id']:0;    
        $this->set('fundid',$fundid);
        // echo "<pre>";print_r($data);
        //echo "<pre>";print_r($data["OrderDetail"]);exit;
        for ($j = 0; $j < sizeof($data["Order"]); $j++) {

            //$pdet	=	$this->Product->findById($data["OrderDetail"][$j]["product_id"]);			
            //$data["OrderDetail"][$j]["Product"]	=	$pdet["Product"];		

            if ($data["OrderDetail"][$j]["type"] == 'P') {
                $pdet = $this->Product->findById($data["OrderDetail"][$j]["product_id"]);
                $data["OrderDetail"][$j]["Product"] = $pdet["Product"]["pname"];
            } else if ($data["OrderDetail"][$j]["type"] == 'G') {
                $gdet = $this->Giftcard->findById($data["OrderDetail"][$j]["product_id"]);
                $data["OrderDetail"][$j]["Product"] = $gdet["Giftcard"]["gift_code"] . '(Gift Card)';
            }

            //Fetching the  product combination details
            if ($data["OrderDetail"][$j]["type"] == 'P') {
                if ($pdet["Product"]["combination"] == 'Y') {

                    $pcombndet = $this->Productdetail->findById($data["OrderDetail"][$j]["combination_id"]);

                    $pcmbnid = explode(',', $pcombndet["Productdetail"]["customvalue_id"]);

                    foreach ($pcmbnid as $key => $val) {

                        if ($val != '') {

                            $combnstr[] = $this->Product->getpdctcmbn($val);

                            $combinations = implode(" ,", $combnstr);

                            $data["OrderDetail"][$j]["combinations"] = $combinations;
                        }
                    }

                    $data["OrderDetail"][$j]["skuno"] = $pcombndet["Productdetail"]["skuno"];

                    unset($combnstr);
                    unset($combinations);
                }
            } //end of if stmt.. 
            //Fetching the  product combination details									  
        } //end of for Loop..		
        //Finding the product type in the order detail
        $ptype_flag = 'Non-Digital';
        if (count($data["OrderDetail"]) > 0) {
            foreach ($data["OrderDetail"] as $det) {
                $ptype_flag = $det["prodtype"];
            }
        }
        $this->set('ptype_flag', $ptype_flag);


        //$shipadd	=	$this->UserAddress->findAll("UserAddress.user_id=".$data["User"]["id"]." AND UserAddress.addr_type='Shipping'");

        $shipadd = $this->UserAddress->find("all", array("conditions" => array("UserAddress.user_id" => $data["User"]["id"], "UserAddress.addr_type" => 'Shipping')));

        //$billadd	=	$this->UserAddress->findAll("UserAddress.user_id=".$data["User"]["id"]." AND UserAddress.addr_type='Billing'");

        $billadd = $this->UserAddress->find("all", array("conditions" => array("UserAddress.user_id" => $data["User"]["id"], "UserAddress.addr_type" => 'Billing')));

        $this->set('odr', $data);
        //echopre($data);
    }

    ########### Function to place an order from admin side...............

    function addadminorder() {

        $this->__validateLoginStatus();

        $admsess = $this->Session->read('Admin');

        if ($admsess["orders"] <> 1) {

            $this->redirect(array('controller' => 'admins', 'action' => 'index'));

            exit();
        }

        $uslist = $this->User->find('list', array('fields' => array('User.id', 'User.uname')));

        $prlist = $this->Product->find('list', array('fields' => array('Product.id', 'Product.pname'), 'conditions' => 'Product.stock > 0'));

        $this->set('usrlist', $uslist);

        $this->set('prdlist', $prlist);

        $this->layout = 'adm';

        if (!empty($this->data)) {

            foreach ($this->data["product_id"] as $pid) {

                $this->Cart->create($data = array());

                $dat["user_id"] = $this->data["user_id"];

                $chk = $this->Cart->find("product_id=" . $pid . " AND user_id=" . $dat["user_id"]);

                if (empty($chk["Cart"])) {

                    $dat["sess_id"] = $this->Session->id();

                    $dat["product_id"] = $pid;

                    $pdet = $this->Product->findById($pid);

                    $dat["product_price"] = $pdet["Product"]["price"];

                    $dat["shipping_charge"] = $pdet["Product"]["shipping_price"];

                    $dat["quantity"] = 1;

                    if ($pdet["Product"]["stock"] < $dat["quantity"]) {

                        $this->Session->setFlash('Sorry,The stock is not enough for the product you requested!', 'default', array('class' => 'failure'));
                    } else {

                        $this->Cart->save($dat);
                    }
                }
            }

            $this->redirect('/carts/showadmincart/' . $dat["user_id"]);

            exit;
        }
    }

    ############# Function to download digital product ....................................

    function pdctdownload($oid = 0, $pid = 0) {

        $this->__validateLoginStatus('U');

        if ($oid <> 0 && $pid <> 0) {

            $this->Order->id = $oid;

            $data = $this->Order->read();

            $sus = $this->Session->read('Userlog');

            $user_id = $sus["id"];

            if ($user_id == $data["Order"]["user_id"]) {

                if ($data["Order"]["exp_time"] > date("Y-m-d H:i:s")) {

                    $pdata = $this->Product->findById($pid);

                    if ($pdata["Product"]["prodtype"] == "Digital") {

                        $filename = $pdata["Product"]["pdctfile"];

                        //header('Content-type: application/zip');
                        // It will be called the file to download file
                        //header("Content-Disposition: attachment; filename=".$filename);
                        // The source file
                        //readfile("/img/products/".$filename);



                        $this->Order->changeStatus($oid, 3);

                        if ($filename <> '') {
                            $this->redirect('/Orders/tesdownload/' . $filename);
                            exit;
                        } else {
                            $this->Session->setFlash('Sorry,There is no file to download.!', 'default', array('class' => 'failure'));
                        }
                    }
                } else {

                    $this->Session->setFlash('Sorry,The download time for this order is expired!', 'default', array('class' => 'failure'));
                }
            } else {

                $this->Session->setFlash('Sorry, You are not authorrized to download the product. Please contact Administrator.!', 'default', array('class' => 'failure'));
            }
        }

        $this->redirect('/index.php');

        exit;
    }

    function tesdownload($filename) {

        $this->view = 'Media';

        $this->__validateLoginStatus('U');

        $nfname = explode(".", $filename);

        $params = array(
            'id' => $filename,
            'name' => $nfname[0],
            'download' => true,
            'extension' => $nfname[1],
            'path' => 'webroot' . DS . 'img' . DS . 'products' . DS
        );

        $this->set($params);
    }

    ############## Function to reset download expiry date for digital products by admin........................................

    function reset_exp_date($id) {

        $this->__validateLoginStatus();

        $admsess = $this->Session->read('Admin');

        if ($admsess["orders"] <> 1) {

            $this->redirect(array('controller' => 'admins', 'action' => 'index'));

            exit();
        }
        $this->loadModel('Setting');
        $this->Setting->load();
        $cnfg = Configure::read('Neutrino');

        $tm = time() + $cnfg["digitalproduct_download_limit"] * 60 * 60;

        $exptm = date("Y-m-d H:i:s", $tm);

        $this->Order->resetexpdate($id, $exptm);

        $this->redirect('/Orders/details/' . $id);

        exit;
    }

    ################### Function to add note on an order by admin...............................

    function addnote($id) {

        $this->__validateLoginStatus();

        $admsess = $this->Session->read('Admin');

        if ($admsess["orders"] <> 1) {

            $this->redirect(array('controller' => 'admins', 'action' => 'index'));

            exit();
        }

        $not = $_POST["note"];

        if ($id) {

            $re = $this->Order->addnote($id, $not);

            if (!empty($re)) {

                $this->Session->setFlash('');
                $this->Session->setFlash('Order Note Updated Successfully.', 'default', array('class' => 'success'));
            } else {

                $this->Session->setFlash('');
                $this->Session->setFlash('Order Note Can not Update now .', 'default', array('class' => 'failure'));
            }
        }

        $this->redirect('/Orders/details/' . $id);

        exit;
    }

    ################### Function to add note on an order by admin...............................

    function addcomment($id) {

        $this->__validateLoginStatus();

        $admsess = $this->Session->read('Admin');

        if ($admsess["orders"] <> 1) {

            $this->redirect(array('controller' => 'admins', 'action' => 'index'));

            exit();
        }

        $cmnt = $_POST["comment"];

        if ($id) {

            $re = $this->Order->addcomment($id, $cmnt);

            if (!empty($re)) {

                $this->Session->setFlash('Comments Updated Successfully.', 'default', array('class' => 'success'));
            } else {

                $this->Session->setFlash('Comments Can not Update now .', 'default', array('class' => 'failure'));
            }
        }

        $this->redirect('/Orders/details/' . $id);

        exit;
    }

    ##########################################################################################################
    ################################ Function to generate shipping label for FEDEX###########################
    ##########################################################################################################

    function fedexlabel($orderid = '') {

        $fedexmeterno = $this->Setting->findByFieldname('fedexmeterno');
        $fedexshipaccno = $this->Setting->findByFieldname('fedexshipaccno');

        $ord_res = $this->Order->findById($orderid);
        $user_id = $ord_res["User"]["id"];
        //echo "<pre>";print_r($ord_res);exit;
        include(WWW_ROOT . "Fedex/fedex-common.php");
        $path_to_wsdl = WWW_ROOT . 'Fedex/ShipService_v8.wsdl';


        $array_ReplaceWith = array("EUROPE_FIRST_INTERNATIONAL_PRIORITY",
            "FEDEX_1_DAY_FREIGHT",
            "FEDEX_2_DAY",
            "FEDEX_2_DAY_FREIGHT",
            "FEDEX_3_DAY_FREIGHT",
            "FEDEX_EXPRESS_SAVER",
            "FEDEX_GROUND",
            "FIRST_OVERNIGHT",
            "GROUND_HOME_DELIVERY",
            "INTERNATIONAL_ECONOMY",
            "INTERNATIONAL_ECONOMY_FREIGHT",
            "INTERNATIONAL_FIRST",
            "INTERNATIONAL_PRIORITY",
            "INTERNATIONAL_PRIORITY_FREIGHT",
            "PRIORITY_OVERNIGHT",
            "STANDARD_OVERNIGHT");

        $array_Replace = array("EUROPE_FIRST_INTERNATIONAL_PRIORITY",
            "FedEx Overnight Freight",
            "FedEx 2 Day",
            "FedEx 2 day Freight",
            "FedEx 3 day Freight",
            "FedEx Express Saver",
            "FedEx Ground",
            "FedEx First Overnight",
            "FedEx Home Delivery",
            "FedEx International Economy",
            "INTERNATIONAL_ECONOMY_FREIGHT",
            "FedEx International First",
            "FedEx International Priority",
            "INTERNATIONAL_PRIORITY_FREIGHT",
            "FedEx Priority Overnight",
            "FedEx Standard Overnight");

        $vshipping_name = $ord_res["Order"]["shipping_service"];
        //$vshipping_name= "STANDARD_OVERNIGHT";
        //Replace shipping service with proper naming
        $vshipping_name = str_replace($array_Replace, $array_ReplaceWith, $vshipping_name);
        $recipient_name = $ord_res["Order"]["ship_fname"] . " " . $ord_res["Order"]["ship_lname"];
        $recipient_company = '';
        $recipient_phone = $ord_res["Order"]["ship_phone"];
        $recipient_address = $ord_res["Order"]["ship_address"];
        $recipient_city = $ord_res["Order"]["ship_city"];
        //$recipient_state   			= $pck_res["Packet"]["ship_state"];
        //$statedet					=	$this->State->findByName($pck_res["Packet"]["ship_state"]);
        $recipient_state = $ord_res["Order"]["ship_state"];
        //$recipient_state 	        =	'CA';

        $recipient_postcode = $ord_res["Order"]["ship_zip"];
        //$recipient_postcode  		=   '90001';
        //$recipient_country   		= $pck_res["Packet"]["ship_country"];
        $cntdet = $this->Country->findByCountryName($ord_res["Order"]["ship_country"]);
        $recipient_country = $cntdet["Country"]["country_iso_code_2"];
        $delivery_place_residential = 'false';
        //Shipper Address Details


        /* Working FEDEX Credentials 
          $key='VH9gpVObdc0EvOIQ';
          $password='wQYp3s0PqmZYSM9piA7EdvWhJ';
          $shipAccount='510088000';
          $meter='100022250';
          $billAccount='510088000';
          $dutyAccount='';
          Working FEDEX Credentials */

        /* Working FEDEX Credentials 
          $width = '20';
          $height = '10';
          $length = '20';
          $units = '10';
          $weight = '50';
          Working FEDEX Credentials */
        //Shipper Address Details
        $shipper_name = 'Shipper Name';
        $shipper_company = 'Shipper Company';
        $shipper_phone = '713-932-6901';
        //$shipper_phone   		= '404-299-0842'; //Original phone
        $shipper_address = '1325 Remington Rd, Suite R';
        $shipper_city = 'Schaumburg';
        $shipper_state = 'IL';
        $shipper_postcode = '60173';
        $shipper_pick_up_zip = '60173';
        $shipper_country = 'US';
        //Shipper Address Details



        $this->loadModel('Setting');
        $this->Setting->load();
        $cnfg = Configure::read('Neutrino');
        $key = $cnfg["fedexkey"];
        $password = $cnfg["fedexpaswd"];
        $shipAccount = $cnfg["fedexshipaccno"];
        $meter = $cnfg["fedexmeterno"];
        $billAccount = $cnfg["fedexbillaccno"];
        $dutyAccount = '';

        $width = $_POST["fed_width"];
        $height = $_POST["fed_height"];
        $length = $_POST["fed_length"];
        $units = $_POST["fed_units"];
        $weight = $_POST["fed_weight"];


        ini_set("soap.wsdl_cache_enabled", "0");
        $client = new SoapClient($path_to_wsdl, array('trace' => true)); // Refer to http://us3.php.net/manual/en/ref.soap.php for more information
        $request['WebAuthenticationDetail'] = array('UserCredential' =>
            array('Key' => $key, 'Password' => $password));
        $request['ClientDetail'] = array('AccountNumber' => $shipAccount, 'MeterNumber' => $meter);
        $request['TransactionDetail'] = array('CustomerTransactionId' => '*** Express Domestic Shipping Request v8 using PHP ***');
        $request['Version'] = array('ServiceId' => 'ship', 'Major' => '8', 'Intermediate' => '0', 'Minor' => '0');

        $request['RequestedShipment'] = array('ShipTimestamp' => date('c'),
            'DropoffType' => 'REGULAR_PICKUP', // valid values REGULAR_PICKUP, REQUEST_COURIER, DROP_BOX, BUSINESS_SERVICE_CENTER and STATION
            /* 				'ServiceType' => strtoupper(str_replace(' ','_',$vshipping_name)),// valid values STANDARD_OVERNIGHT, PRIORITY_OVERNIGHT, FEDEX_GROUND, ... */
            'ServiceType' => strtoupper($vshipping_name), // valid values STANDARD_OVERNIGHT, PRIORITY_OVERNIGHT, FEDEX_GROUND, ...
            'PackagingType' => 'YOUR_PACKAGING', // valid values FEDEX_BOX, FEDEX_PAK, FEDEX_TUBE, YOUR_PACKAGING, ...
            'TotalWeight' => array('Value' => $weight, 'Units' => 'LB'), // valid values LB and KG
            'Shipper' => array('Contact' => array('PersonName' => $shipper_name,
                    'CompanyName' => $shipper_company,
                    'PhoneNumber' => $shipper_phone),
                'Address' => array('StreetLines' => array($shipper_address),
                    'City' => $shipper_city,
                    'StateOrProvinceCode' => $shipper_state,
                    'PostalCode' => $shipper_postcode,
                    'CountryCode' => $shipper_country)),
            'Recipient' => array('Contact' => array('PersonName' => $recipient_name,
                    'CompanyName' => $recipient_company,
                    'PhoneNumber' => $recipient_phone),
                'Address' => array('StreetLines' => array($recipient_address),
                    'City' => $recipient_city,
                    'StateOrProvinceCode' => $recipient_state,
                    'PostalCode' => $recipient_postcode,
                    'CountryCode' => $recipient_country),
                'Residential' => $delivery_place_residential),
            'ShippingChargesPayment' => array('PaymentType' => 'SENDER', // valid values RECIPIENT, SENDER and THIRD_PARTY
                'Payor' => array('AccountNumber' => $billAccount,
                    'CountryCode' => 'US')),
            'SpecialServicesRequested' => array(),
            'LabelSpecification' => array('LabelFormatType' => 'COMMON2D', // valid values COMMON2D, LABEL_DATA_ONLY
                'ImageType' => 'PDF', // valid values DPL, EPL2, PDF, ZPLII and PNG
                'LabelStockType' => 'PAPER_7X4.75'),
            'RateRequestTypes' => array('ACCOUNT'), // valid values ACCOUNT and LIST
            'PackageCount' => 1,
            'PackageDetail' => 'INDIVIDUAL_PACKAGES',
            'RequestedPackageLineItems' => array('0' => array('Weight' => array('Value' => $weight,
                        'Units' => 'LB'))));

        /* echo "<pre>";
          print_r($request);
          exit(); */

        try {
            $response = $client->processShipment($request);  // FedEx web service invocation
            /* echo "<pre>";
              print_r($response);
              exit; */
            if ($response->HighestSeverity != 'FAILURE' && $response->HighestSeverity != 'ERROR') {
                $tracking_no = $response->CompletedShipmentDetail->CompletedPackageDetails->AstraLabelElements[5]->Content;
                $pdftrackno = str_replace(" ", "", $tracking_no);
                /*
                  if(is_object($response->CompletedShipmentDetail->CodReturnDetail)) {
                  $fp = fopen(WWW_ROOT.'Fedex/shipping_label/'.SHIP_CODLABEL, 'w+');
                  fwrite($fp, $response->CompletedShipmentDetail->CodReturnDetail->Label->Parts->Image); //Create COD Return PNG or PDF file
                  fclose($fp);
                  }
                 */

                define('SHIP_LABEL', $pdftrackno . '_label.pdf');  // PNG label file. Change to file-extension .pdf for creating a PDF label (e.g. shiplabel.pdf)
                // Inserting the Trackinh number and PDF path
                $this->Order->id = $ord_res["Order"]["id"];
                $this->Order->saveField('tracking_no', $tracking_no);
                $this->Order->saveField('label_pdf', SHIP_LABEL);
                //define('SHIP_CODLABEL',$pckid.'_returnlabel.pdf');  // PNG label file. Change to file-extension .pdf for creating a PDF label (e.g. CODexpressreturnlabel.pdf)
                //working code ,saved to Fedex/shipping_label folder in root 
                $fp = fopen(WWW_ROOT . 'Fedex/shipping_label/' . SHIP_LABEL, 'w+');
                //Create PNG or PDF file
                fwrite($fp, $response->CompletedShipmentDetail->CompletedPackageDetails->Label->Parts->Image); //Create PNG or PDF file
                fclose($fp);

                /* ob_start();            
                  header('Content-type: application/pdf');
                  header('Content-Disposition: attachment; filename='.SHIP_LABEL);
                  echo($response->CompletedShipmentDetail->CompletedPackageDetails->Label->Parts->Image);
                  exit; */
            } else {
                $res = printError($client, $response);
                //print_r($res);exit;
                $cnt = count($res);
                $errMSGFromFedex = "";
                if ($cnt > 1) {
                    $errMSGFromFedex = "The following error(s) has been returned from FedEx server<hr width='75%' align='left'><br>";
                    for ($counter = 0; $counter <= $cnt - 1; $counter += 1) {
                        $errMSGFromFedex.= $res[$counter]->LocalizedMessage . "<br>";
                    }
                } elseif ($cnt == 1) {
                    $errMSGFromFedex = "The following error(s) has been returned from FedEx server<hr width='75%' align='left'><br>";
                    $errMSGFromFedex.= $res->LocalizedMessage . "<br>";
                } else {
                    $errMSGFromFedex = "The following error(s) has been returned from FedEx server<hr width='75%' align='left'><br>";
                    $errMSGFromFedex.= $res . "<br>";
                }

                if ($errMSGFromFedex <> "") {
                    $errMSGFromFedex = $errMSGFromFedex . 'Shipping label can\'t be created.';
                } else {
                    $errMSGFromFedex = 'Shipping Label Cannot be Created.';
                }

                $this->Session->setFlash(__($errMSGFromFedex, true));
                $this->redirect(array('controller' => 'orders', 'action' => 'details/' . $orderid));
            }

            //writeToLog($client);    // Write to log file
        } catch (SoapFault $exception) {
            printFault($exception, $client);
        }

        /* Generate Labels */
        $this->Session->setFlash(__('Shipping Label Created Successfully.', true));
        $this->redirect(array('controller' => 'orders', 'action' => 'details/' . $orderid));
        exit();
    }

    ##########################################################################################################
    ################################ Function to generate shipping label ends here ###########################
    ##########################################################################################################
    ##########################################################################################################
    ################################ Function to download shipping label starts here ###########################
    ##########################################################################################################

    function dwnldlabel($file = '') {
        $file_path = WWW_ROOT . 'Fedex/shipping_label/' . $file;
        $pdfdat = file_get_contents($file_path);
        header("Content-type: application/octet-stream");
        header("Content-Transfer-Encoding: binary");
        header("Content-Disposition: attachment; filename=\"$file\"");
        echo $pdfdat;
        exit;
    }

    ##########################################################################################################
    ################################ Function to download shipping label ends here ###########################
    ##########################################################################################################
    ##########################################################################################################
    ################################ Function to edit order details starts here ###########################
    ##########################################################################################################

    function editorder($id, $type = '') {
        $this->__validateLoginStatus();
        $admsess = $this->Session->read('Admin');

        if ($type == 'ship') {
            $this->Order->id = $id;
            $this->Order->saveField('ship_fname', $_POST["editship_fname"]);
            $this->Order->saveField('ship_lname', $_POST["editship_lname"]);
            $this->Order->saveField('ship_address', $_POST["editship_address"]);
            $this->Order->saveField('ship_city', $_POST["editship_city"]);
            $this->Order->saveField('ship_state', $_POST["editship_state"]);
            $this->Order->saveField('ship_country', $_POST["editship_country"]);
            $this->Order->saveField('ship_zip', $_POST["editship_zip"]);
            $this->Order->saveField('ship_phone', $_POST["editship_phone"]);
            $this->Order->saveField('ship_mobile', $_POST["editship_mobile"]);
            $this->Order->saveField('ship_fax', $_POST["editship_fax"]);
        }
        if ($type == 'bill') {
            $this->Order->id = $id;
            $this->Order->saveField('bill_fname', $_POST["editbill_fname"]);
            $this->Order->saveField('bill_lname', $_POST["editbill_lname"]);
            $this->Order->saveField('bill_address', $_POST["editbill_address"]);
            $this->Order->saveField('bill_city', $_POST["editbill_city"]);
            $this->Order->saveField('bill_state', $_POST["editbill_state"]);
            $this->Order->saveField('bill_country', $_POST["editbill_country"]);
            $this->Order->saveField('bill_zip', $_POST["editbill_zip"]);
            $this->Order->saveField('bill_phone', $_POST["editbill_phone"]);
            $this->Order->saveField('bill_mobile', $_POST["editbill_mobile"]);
            $this->Order->saveField('bill_fax', $_POST["editbill_fax"]);
        } else if ($type == 'qty') {
            if (isset($_POST["hidtotcnt"])) {
                for ($i = 1; $i <= $_POST["hidtotcnt"]; $i++) {
                    $rowid = $_POST["row_id" . $i];
                    $updqty = $_POST["edit_qty" . $i];
                    $updextprice = $_POST["edit_extp" . $i];
                    $this->OrderDetail->id = $rowid;
                    $this->OrderDetail->saveField('quantity', $updqty);
                    $this->OrderDetail->saveField('extra_price', $updextprice);
                }
            }
            //------------------------------------------calculate tax--------------------------------------------//
            $user = $this->Order->findById($id);
            $tot_price = $this->Order->getOrderTotal($id);
            $taxamt = 0;
            $this->loadModel('Setting');
            $this->Setting->load();
            $cnfg = Configure::read('Neutrino');
            if ($cnfg["taxto"] == "gtotal") {
                $taxableamt = $tot_price + $user['Order']['shipping_price'];
            } else {
                $taxableamt = $tot_price;
            }

            if ($cnfg["tax_option"] == "notax") {
                $taxperc = 0;
                $taxname = "No Tax is applicable";
            } elseif ($cnfg["tax_option"] == "fixedtax") {
                $taxperc = $cnfg["fixedtax_rate"];
                $taxname = $cnfg["fixedtax_name"];
            } else {
                if ($cnfg["taxable_address"] == "shipping") {
                    $billadd = $this->UserAddress->find('UserAddress.user_id = ' . $user['Order']['user_id'] . ' AND UserAddress.addr_type = "Shipping"');
                } else {
                    $billadd = $this->UserAddress->find('UserAddress.user_id = ' . $user['Order']['user_id'] . ' AND UserAddress.addr_type = "Billing"');
                }

                $stdetal = $this->State->find('State.country_id = "' . $billadd["UserAddress"]["country"] . '" AND State.code = "All"');

                if (!empty($stdetal["State"])) {
                    $taxperc = $stdetal["State"]["tax_rate"];
                    $taxname = $stdetal["State"]["tax_name"];
                } else {
                    $stdetal = $this->State->find('State.country_id = "' . $billadd["UserAddress"]["country"] . '" AND State.code ="' . $billadd["UserAddress"]["state"] . '"');
                    if (!empty($stdetal["State"])) {
                        $taxperc = $stdetal["State"]["tax_rate"];
                        $taxname = $stdetal["State"]["tax_name"];
                    } else {
                        $stdetal = $this->State->find('State.country_id = "' . $billadd["UserAddress"]["country"] . '" AND State.name ="' . $billadd["UserAddress"]["state"] . '"');
                        if (!empty($stdetal["State"])) {
                            $taxperc = $stdetal["State"]["tax_rate"];
                            $taxname = $stdetal["State"]["tax_name"];
                        } else {
                            $taxperc = 0;
                            $taxname = "No Tax is applicable";
                        }
                    }
                }
            }

            if ($tot_price > 0) {
                $taxamt = ($taxableamt * $taxperc) / 100;
                $taxamt = number_format($taxamt, 2, ".", "");
                $tot_price = $tot_price + $taxamt;
            }

            $this->Order->id = $id;
            $this->Order->saveField('total_price', $tot_price);
            $this->Order->saveField('tax_price', $taxamt);
            ######################### End of Section to find and add tax amount......................
        }

        $this->redirect(array('controller' => 'orders', 'action' => 'details/' . $id));
        exit();
    }

    //User Activity Report	 
    function useractivity() {
        $ordtbl = $this->Order->getTableName("orders");
        if (isset($_POST["uid"]) && $_POST["uid"] <> '') {
            $uid = $_POST["uid"];
        } else if (isset($this->passedArgs["uid"]) && $this->passedArgs["uid"] <> '') {
            $uid = $this->passedArgs["uid"];
        } else {
            $minid = $this->Order->query("SELECT min(user_id) as default_id FROM " . $ordtbl);
            if (isset($minid) && empty($minid) === false)
                $uid = $minid[0][0]["default_id"];
            else
                $uid = 0;
        }

        $ostbl = $this->Order->getTableName("order_statuses");
        $this->paginate = array(
            'conditions' => array("Order.user_id='" . $uid . "'"),
            'fields' => array("DATE_FORMAT(Order.date,'%m-%d-%Y')as ord_date ,Order.user_id,Order.ship_fname,Order.ship_lname,Order.ship_address, Order.ship_city, Order.ship_state, Order.ship_country, Order.ship_zip, Order.ship_phone,
			 Order.ship_mobile, Order.ship_fax,Order.bill_fname, Order.bill_lname, Order.bill_address, Order.bill_city, 
			 Order.bill_state, Order.bill_country, Order.bill_zip, Order.bill_phone, Order.bill_mobile, Order.bill_fax,Order.total_price,vos.name"),
            'order' => '',
            'limit' => $this->paginate["limit"],
            'joins' => array(
                array(
                    'table' => $ostbl,
                    'alias' => 'vos',
                    'type' => 'LEFT',
                    'conditions' => array('vos.id=Order.order_status_id')
                )
            ),
            'group' => 'Order.id',
            'passit' => $this->passedArgs
        );

        $reportdet = $this->paginate('Order');
        $this->set('reportdet', $reportdet);
        $usersList = $this->User->find('all');
        $this->set('usersList', $usersList);
        $this->passedArgs['limit'] = $this->paginate["limit"];
        $this->set('passedarg', $this->passedArgs);
        $this->set('uid', $uid);
        $this->layout = 'adm';
    }

    //User Order Report	
    function reports() {
        $this->__validateLoginStatus();
        $sales_min_date = explode(" ", $this->Order->getSalesDates("min"));
        $sales_max_date = explode(" ", $this->Order->getSalesDates("max"));
        $this->set('dflt_mindate', $sales_min_date[0]); //Setting the max date for the calendar...
        $this->set('dflt_maxdate', $sales_max_date[0]); //Setting the max date for the calendar...

        if (isset($_POST["sales_fdate"]) && isset($_POST["sales_fdate"]) && $_POST["sales_tdate"] <> '' && $_POST["sales_tdate"] <> '') {
            $frmdate = $_POST["sales_fdate"];
            $todate = $_POST["sales_tdate"];
        } else if (isset($this->passedArgs["frmdate"]) && isset($this->passedArgs["todate"]) &&
                $this->passedArgs["frmdate"] <> '' && $this->passedArgs["todate"] <> '') {
            $frmdate = $this->passedArgs["frmdate"];
            $todate = $this->passedArgs["todate"];
        } else {
            $frmdate = $sales_min_date[0];
            $todate = $sales_max_date[0];
        }
        //$cttbl=$this->Report->getTableName("users");
        $reportdet = array();
        if (isset($frmdate) && $frmdate <> '' && isset($todate) && $todate <> '') {

            $sdate = explode('-', $frmdate);
            $srch_fdate = $sdate[2] . '-' . $sdate[0] . '-' . $sdate[1];
            $tdate = explode('-', $todate);
            $srch_tdate = $tdate[2] . '-' . $tdate[0] . '-' . $tdate[1];

            //$cttb2=$this->User->getTableName("user_addresses");		
            //getting table names...

            $ordtbl = $this->Order->getTableName("orders");
            $usrtbl = $this->Order->getTableName("users");
            $cpntbl = $this->Order->getTableName("coupons");
            $statustbl = $this->Order->getTableName("order_statuses");

            //getting table names...		





            $this->paginate = array(
                'conditions' => array("DATE_FORMAT(Order.date,'%Y-%m-%d')>= '" . $srch_fdate . "' AND  
			DATE_FORMAT(Order.date,'%Y-%m-%d') <= '" . $srch_tdate . "'"),
                'fields' => array("Order.id,Order.date,USR.uname,Order.total_price, Order.discount,CPN.code,ORS.name,Order.order_status_id"),
                'order' => 'Order.date DESC',
                'limit' => $this->paginate["limit"],
                'joins' => array(
                    array(
                        'table' => $usrtbl,
                        'alias' => 'USR',
                        'type' => 'INNER',
                        'conditions' => array('Order.user_id = USR.id')
                    ),
                    array(
                        'table' => $cpntbl,
                        'alias' => 'CPN',
                        'type' => 'LEFT',
                        'conditions' => array('Order.coupon_id = CPN.id')
                    ),
                    array(
                        'table' => $statustbl,
                        'alias' => 'ORS',
                        'type' => 'LEFT',
                        'conditions' => array('Order.order_status_id = ORS.id')
                    )
                ),
                'group' => '',
                'passit' => $this->passedArgs
            );
        }
        $reportdet = $this->paginate('Order');
        $this->set('reportdet', $reportdet);
        $this->set('mindate', $frmdate);
        $this->set('maxdate', $todate);
        $this->passedArgs['limit'] = $this->paginate["limit"];
        $this->set('passedarg', $this->passedArgs);
        $this->layout = 'adm';
    }

    function salesxls($frmdate = '', $todate = '') {
        //getting table names...
        $ordtbl = $this->Order->getTableName("orders");
        $usrtbl = $this->Order->getTableName("users");
        $cpntbl = $this->Order->getTableName("coupons");
        $statustbl = $this->Order->getTableName("order_statuses");
        //getting table names...		



        $sdate = explode('-', $frmdate);
        $srch_fdate = $sdate[2] . '-' . $sdate[0] . '-' . $sdate[1];
        $tdate = explode('-', $todate);
        $srch_tdate = $tdate[2] . '-' . $tdate[0] . '-' . $tdate[1];


        $qry = array(
            'conditions' => array("DATE_FORMAT(Order.date,'%Y-%m-%d')>= '" . $srch_fdate . "' AND  
			DATE_FORMAT(Order.date,'%Y-%m-%d') <= '" . $srch_tdate . "'"),
            'fields' => array("Order.id,Order.date,USR.uname,Order.total_price, Order.discount,CPN.code,ORS.name,Order.order_status_id"),
            'order' => 'Order.date DESC',
            'limit' => '',
            'joins' => array(
                array(
                    'table' => $usrtbl,
                    'alias' => 'USR',
                    'type' => 'INNER',
                    'conditions' => array('Order.user_id = USR.id')
                ),
                array(
                    'table' => $cpntbl,
                    'alias' => 'CPN',
                    'type' => 'LEFT',
                    'conditions' => array('Order.coupon_id = CPN.id')
                ),
                array(
                    'table' => $statustbl,
                    'alias' => 'ORS',
                    'type' => 'LEFT',
                    'conditions' => array('Order.order_status_id = ORS.id')
                )
            ),
            'group' => '',
            'passit' => ''
        );
        $tot_cnt = count($this->Order->find('all', $qry));

        $this->paginate = array(
            'conditions' => array("DATE_FORMAT(Order.date,'%Y-%m-%d')>= '" . $srch_fdate . "' AND  
			DATE_FORMAT(Order.date,'%Y-%m-%d') <= '" . $srch_tdate . "'"),
            'fields' => array("Order.id,Order.date,USR.uname,Order.total_price, Order.discount,CPN.code,ORS.name,Order.order_status_id"),
            'order' => 'Order.date DESC',
            'limit' => $tot_cnt,
            'joins' => array(
                array(
                    'table' => $usrtbl,
                    'alias' => 'USR',
                    'type' => 'INNER',
                    'conditions' => array('Order.user_id = USR.id')
                ),
                array(
                    'table' => $cpntbl,
                    'alias' => 'CPN',
                    'type' => 'LEFT',
                    'conditions' => array('Order.coupon_id = CPN.id')
                ),
                array(
                    'table' => $statustbl,
                    'alias' => 'ORS',
                    'type' => 'LEFT',
                    'conditions' => array('Order.order_status_id = ORS.id')
                )
            ),
            'group' => '',
            'passit' => ''
        );
        $data = $this->paginate('Order');
        //  print_r($data); exit;

        $this->set('data', $data);
        $this->layout = 'csvexp';
    }

    function salescsv($frmdate = '', $todate = '') {
        //getting table names...
        $ordtbl = $this->Order->getTableName("orders");
        $usrtbl = $this->Order->getTableName("users");
        $cpntbl = $this->Order->getTableName("coupons");
        $statustbl = $this->Order->getTableName("order_statuses");
        //getting table names...		


        $cttbl = $this->Order->getTableName("users");
        $sdate = explode('-', $frmdate);
        $srch_fdate = $sdate[2] . '-' . $sdate[0] . '-' . $sdate[1];
        $tdate = explode('-', $todate);
        $srch_tdate = $tdate[2] . '-' . $tdate[0] . '-' . $tdate[1];


        $qry = array(
            'conditions' => array(""),
            'fields' => array("Order.id,Order.date,USR.uname,Order.total_price, Order.discount,CPN.code,ORS.name,Order.order_status_id"),
            'order' => 'Order.date DESC',
            'limit' => '',
            'joins' => array(
                array(
                    'table' => $usrtbl,
                    'alias' => 'USR',
                    'type' => 'INNER',
                    'conditions' => array('Order.user_id = USR.id')
                ),
                array(
                    'table' => $cpntbl,
                    'alias' => 'CPN',
                    'type' => 'LEFT',
                    'conditions' => array('Order.coupon_id = CPN.id')
                ),
                array(
                    'table' => $statustbl,
                    'alias' => 'ORS',
                    'type' => 'LEFT',
                    'conditions' => array('Order.order_status_id = ORS.id')
                )
            ),
            'group' => '',
            'passit' => ''
        );
        $tot_cnt = count($this->Order->find('all', $qry));

        $this->paginate = array(
            'conditions' => array("DATE_FORMAT(Order.date,'%Y-%m-%d')>= '" . $srch_fdate . "' AND  
			DATE_FORMAT(Order.date,'%Y-%m-%d') <= '" . $srch_tdate . "'"),
            'fields' => array("Order.id,Order.date,USR.uname,Order.total_price, Order.discount,CPN.code,ORS.name,Order.order_status_id"),
            'order' => 'Order.date DESC',
            'limit' => $tot_cnt,
            'joins' => array(
                array(
                    'table' => $usrtbl,
                    'alias' => 'USR',
                    'type' => 'INNER',
                    'conditions' => array('Order.user_id = USR.id')
                ),
                array(
                    'table' => $cpntbl,
                    'alias' => 'CPN',
                    'type' => 'LEFT',
                    'conditions' => array('Order.coupon_id = CPN.id')
                ),
                array(
                    'table' => $statustbl,
                    'alias' => 'ORS',
                    'type' => 'LEFT',
                    'conditions' => array('Order.order_status_id = ORS.id')
                )
            ),
            'group' => '',
            'passit' => ''
        );
        $data = $this->paginate('Order');
        $this->set('data', $data);
        $this->layout = 'csvexp';
    }

    //User Order Report	
    function pcreports() {
        $sales_min_date = explode(" ", $this->Order->getSalesDates("min"));
        $sales_max_date = explode(" ", $this->Order->getSalesDates("max"));
        $this->set('dflt_mindate', $sales_min_date[0]); //Setting the max date for the calendar...
        $this->set('dflt_maxdate', $sales_max_date[0]); //Setting the max date for the calendar...

        if (isset($_POST["sales_fdate"]) && isset($_POST["sales_fdate"]) && $_POST["sales_tdate"] <> '' && $_POST["sales_tdate"] <> '') {
            $frmdate = $_POST["sales_fdate"];
            $todate = $_POST["sales_tdate"];
        } else if (isset($this->passedArgs["frmdate"]) && isset($this->passedArgs["todate"]) &&
                $this->passedArgs["frmdate"] <> '' && $this->passedArgs["todate"] <> '') {
            $frmdate = $this->passedArgs["frmdate"];
            $todate = $this->passedArgs["todate"];
        } else {
            $frmdate = $sales_min_date[0];
            $todate = $sales_max_date[0];
        }
        //$cttbl=$this->Report->getTableName("users");
        $reportdet = array();
        if (isset($frmdate) && $frmdate <> '' && isset($todate) && $todate <> '') {

            $sdate = explode('-', $frmdate);
            $srch_fdate = $sdate[2] . '-' . $sdate[0] . '-' . $sdate[1];
            $tdate = explode('-', $todate);
            $srch_tdate = $tdate[2] . '-' . $tdate[0] . '-' . $tdate[1];

            //$cttb2=$this->User->getTableName("user_addresses");		
            //getting table names...

            $ordtbl = $this->Order->getTableName("orders");
            $usrtbl = $this->Order->getTableName("users");
            $cpntbl = $this->Order->getTableName("coupons");
            $statustbl = $this->Order->getTableName("order_statuses");

            //getting table names...		





            $this->paginate = array(
                'conditions' => array("DATE_FORMAT(Order.date,'%Y-%m-%d')>= '" . $srch_fdate . "' AND  
						DATE_FORMAT(Order.date,'%Y-%m-%d') <= '" . $srch_tdate . "' AND Order.coupon_id <> 0"),
                'fields' => array("Order.id,Order.date,USR.uname,Order.total_price, Order.discount,CPN.code,ORS.name"),
                'order' => 'Order.date DESC',
                'limit' => $this->paginate["limit"],
                'joins' => array(
                    array(
                        'table' => $usrtbl,
                        'alias' => 'USR',
                        'type' => 'INNER',
                        'conditions' => array('Order.user_id = USR.id')
                    ),
                    array(
                        'table' => $cpntbl,
                        'alias' => 'CPN',
                        'type' => 'LEFT',
                        'conditions' => array('Order.coupon_id = CPN.id')
                    ),
                    array(
                        'table' => $statustbl,
                        'alias' => 'ORS',
                        'type' => 'LEFT',
                        'conditions' => array('Order.order_status_id = ORS.id')
                    )
                ),
                'group' => '',
                'passit' => $this->passedArgs
            );
        }


        $reportdet = $this->paginate('Order');
        $this->set('reportdet', $reportdet);
        $this->set('mindate', $frmdate);
        $this->set('maxdate', $todate);
        $this->passedArgs['limit'] = $this->paginate["limit"];
        $this->set('passedarg', $this->passedArgs);
        $this->layout = 'adm';
    }

    function pcodecsv() {
        //getting table names...
        $ordtbl = $this->Order->getTableName("orders");
        $usrtbl = $this->Order->getTableName("users");
        $cpntbl = $this->Order->getTableName("coupons");
        $statustbl = $this->Order->getTableName("order_statuses");
        //getting table names...		

        /*
          $cttbl=$this->Report->getTableName("users");
          $sdate=explode('-',$frmdate);
          $srch_fdate=$sdate[2].'-'.$sdate[0].'-'.$sdate[1];
          $tdate=explode('-',$todate);
          $srch_tdate=$tdate[2].'-'.$tdate[0].'-'.$tdate[1];
         */

        $qry = array(
            'conditions' => array("Order.coupon_id <> 0"),
            'fields' => array("Order.id,Order.date,USR.uname,Order.total_price, Order.discount,CPN.code,ORS.name"),
            'order' => 'Order.date DESC',
            'limit' => '',
            'joins' => array(
                array(
                    'table' => $usrtbl,
                    'alias' => 'USR',
                    'type' => 'INNER',
                    'conditions' => array('Order.user_id = USR.id')
                ),
                array(
                    'table' => $cpntbl,
                    'alias' => 'CPN',
                    'type' => 'LEFT',
                    'conditions' => array('Order.coupon_id = CPN.id')
                ),
                array(
                    'table' => $statustbl,
                    'alias' => 'ORS',
                    'type' => 'LEFT',
                    'conditions' => array('Order.order_status_id = ORS.id')
                )
            ),
            'group' => '',
            'passit' => ''
        );
        $tot_cnt = count($this->Order->find('all', $qry));

        $this->paginate = array(
            'conditions' => array("Order.coupon_id <> 0"),
            'fields' => array("Order.id,Order.date,USR.uname,Order.total_price, Order.discount,CPN.code,ORS.name"),
            'order' => 'Order.date DESC',
            'limit' => $tot_cnt,
            'joins' => array(
                array(
                    'table' => $usrtbl,
                    'alias' => 'USR',
                    'type' => 'INNER',
                    'conditions' => array('Order.user_id = USR.id')
                ),
                array(
                    'table' => $cpntbl,
                    'alias' => 'CPN',
                    'type' => 'LEFT',
                    'conditions' => array('Order.coupon_id = CPN.id')
                ),
                array(
                    'table' => $statustbl,
                    'alias' => 'ORS',
                    'type' => 'LEFT',
                    'conditions' => array('Order.order_status_id = ORS.id')
                )
            ),
            'group' => '',
            'passit' => ''
        );
        $data = $this->paginate('Order');
        $this->set('data', $data);
        $this->layout = 'csvexp';
    }

    function pcodexls() {
        //getting table names...
        $ordtbl = $this->Order->getTableName("orders");
        $usrtbl = $this->Order->getTableName("users");
        $cpntbl = $this->Order->getTableName("coupons");
        $statustbl = $this->Order->getTableName("order_statuses");
        //getting table names...		

        /*
          $cttbl=$this->Report->getTableName("users");
          $sdate=explode('-',$frmdate);
          $srch_fdate=$sdate[2].'-'.$sdate[0].'-'.$sdate[1];
          $tdate=explode('-',$todate);
          $srch_tdate=$tdate[2].'-'.$tdate[0].'-'.$tdate[1];
         */

        $qry = array(
            'conditions' => array("Order.coupon_id <> 0"),
            'fields' => array("Order.id,Order.date,USR.uname,Order.total_price, Order.discount,CPN.code,ORS.name"),
            'order' => 'Order.date DESC',
            'limit' => '',
            'joins' => array(
                array(
                    'table' => $usrtbl,
                    'alias' => 'USR',
                    'type' => 'INNER',
                    'conditions' => array('Order.user_id = USR.id')
                ),
                array(
                    'table' => $cpntbl,
                    'alias' => 'CPN',
                    'type' => 'LEFT',
                    'conditions' => array('Order.coupon_id = CPN.id')
                ),
                array(
                    'table' => $statustbl,
                    'alias' => 'ORS',
                    'type' => 'LEFT',
                    'conditions' => array('Order.order_status_id = ORS.id')
                )
            ),
            'group' => '',
            'passit' => ''
        );
        $tot_cnt = count($this->Order->find('all', $qry));

        $this->paginate = array(
            'conditions' => array("Order.coupon_id <> 0"),
            'fields' => array("Order.id,Order.date,USR.uname,Order.total_price, Order.discount,CPN.code,ORS.name"),
            'order' => 'Order.date DESC',
            'limit' => $tot_cnt,
            'joins' => array(
                array(
                    'table' => $usrtbl,
                    'alias' => 'USR',
                    'type' => 'INNER',
                    'conditions' => array('Order.user_id = USR.id')
                ),
                array(
                    'table' => $cpntbl,
                    'alias' => 'CPN',
                    'type' => 'LEFT',
                    'conditions' => array('Order.coupon_id = CPN.id')
                ),
                array(
                    'table' => $statustbl,
                    'alias' => 'ORS',
                    'type' => 'LEFT',
                    'conditions' => array('Order.order_status_id = ORS.id')
                )
            ),
            'group' => '',
            'passit' => ''
        );
        $data = $this->paginate('Order');
        $this->set('data', $data);
        $this->layout = 'xlsexp';
    }

    function redorder($orderID, $type) {
        $orderDetails = $this->Order->findById($orderID);

        //----------------------------Unset the id else, cake updates the row-------------------//
        $orderDetails['Order']['id'] = '';
        $orderDetails['Order']['order_status_id'] = 1;
        $this->Order->save($orderDetails['Order']);
        $id = $this->Order->getLastInsertID();

        $orderDetail = $orderDetails['OrderDetail'];
        //--------------------------insert into orderdetails table as well--------------------//
        $orderDetail[0]['order_id'] = $id;
        $orderDetail[0]['id'] = '';
        $this->OrderDetail->save($orderDetail[0]);

        //--------------------------------------------------------------------------------------//
        $content = "<table width='90%'  border='0' cellspacing='2' cellpadding='2' align='center'>
	    <tr><td colspan='2' align='center'><h2>Order Details</h2></td></tr><tr><td colspan='2' align='center'>
			<table width='90%' border='0' cellpadding='0' cellspacing='0' class='manage_table' align='center'>
			 <tr><td><strong>Order Number</strong></td><td><strong>Order Status</strong></td><td><strong>Order Date</strong></td><td><strong>User Name</strong></td><td><strong>Currency</strong></td></tr><tr>
				<td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td></tr><tr><td> " . $id . "</td><td>" .
                $orderDetails['OrderStatus']['name'] . "</td><td>";

        $dt = strtotime($orderDetails['Order']['date']);
        $edt = strtotime($orderDetails['Order']['exp_time']);
        $content .= date('m-d-Y', $dt);

        $content .= "</td><td> " . $orderDetails['User']['uname'] . "</td><td>" . $orderDetails["Order"]["currency_type"] . "</td></tr></table></td></tr><tr><td colspan='2' align='center'><h3>Item Details</h3></td></tr><tr><td colspan='2'><table width='90%' border='0' cellpadding='2' cellspacing='2' class='manage_table' align='center'><tr><td colspan='2'><strong>Product Name</strong></td><td><strong>Quantity</strong></td><td><strong>Unit Price</strong></td><td><strong>Additional Cost</strong></td><td><strong>Discount</strong></td><td><strong>Price</strong></td><td><strong>Expiry Date</strong></td><td><strong></strong></td></tr><tr><td colspan='3'>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td></tr>";

        $amt = 0;

        foreach ($orderDetails['OrderDetail'] as $det) {
            $price = 0;
            $combined_price = 0;
            $dis_amnt = 0;
            if ($det["discount_type"] == 'per' && $det["discount"] > 0)
                $dis_amnt = (($det["product_price"]) * $det["discount"]) / 100;
            else if ($det["discount_type"] == 'amnt' && $det["discount"] > 0)
                $dis_amnt = $det["discount"];
            $dis_amnt = number_format($dis_amnt, 2, '.', '');

            $combined_price = ($det["product_price"]);

            if (isset($det["discount_type"]) && $det["discount_type"] <> '') {
                if ($det["discount_type"] == 'per') {
                    if (isset($det["discount"]) && $det["discount"] <> '' && $det["discount"] > 0) {
                        $discounted_price = ($combined_price - (($combined_price * $det['discount']) / 100));
                        $price = ($discounted_price * $det['quantity']) + ($det["extra_price"] * $det['quantity']);
                        $amt+= $price;
                    } else
                        $amt+=($combined_price * $det['quantity']) + ($det["extra_price"] * $det['quantity']);
                }

                else if ($det["discount_type"] == 'amnt') {
                    if (isset($det["discount"]) && $det["discount"] <> '' && $det["discount"] > 0) {
                        $discounted_price = ($combined_price - $det['discount']);
                        $price = ($discounted_price * $det['quantity']) + ($det["extra_price"] * $det['quantity']);
                        $amt+= $price;
                    } else
                        $amt+=($combined_price * $det['quantity']) + ($det["extra_price"] * $det['quantity']);
                }
            }

            else {
                $amt+=($combined_price * $det['quantity']) + ($det["extra_price"] * $det['quantity']);
                $amt+= $price;
            }

            $price = number_format($price, 2, ".", "");
            $amt = number_format($amt, 2, ".", "");

//$det['Product']['pname']
            $content .= " <tr><td colspan='2'></td><td> " . $det['quantity'] . " </td><td> " . $det['product_price'] . " </td><td> " . number_format($det['extra_price'] * $det['quantity'], 2, ".", "") . " </td><td> " . number_format($dis_amnt, 2, ".", "") . " </td><td>" . number_format($price, 2, ".", "") . " </td>
			<td>Non-Digital</td><td>&nbsp;</td></tr><tr><td colspan='3' height='15'>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td>
			<td>&nbsp;</td></tr>";
        }

        if ($orderDetails["Order"]["discount"] > $amt)
            $discamt = number_format($amt, 2, '.', '');
        else
            $discamt = number_format($orderDetails["Order"]["discount"], 2, '.', '');

        $content .= "</table></td></tr><tr><td width='50%'>";
        if ($det['prodtype'] <> "Digital") {
            $content .="<table width='100%'border='0' cellpadding='0' cellspacing='0'><tr><td><table width='90%' border='0' cellpadding='0' cellspacing='0' class='manage_table' align='center'> <tr><td width='50%'><strong>Shipping Method</strong></td><td  width='5%'>:</td><td width='45%'>" . $orderDetails['Order']['shipping_method'] . "</td></tr><tr><td><strong>Shipping Service</strong></td>
				<td>:</td><td>" . $orderDetails['Order']['shipping_service'] . " </td></tr></table></td></tr><tr><td></td></tr></table>";
        }

        $content .="</td><td width='50%'><table width='90%' border='0' cellpadding='0' cellspacing='0' class='manage_table' align='center'><tr><td><strong>Total Price</strong></td><td>:</td><td>" . $amt . "</td></tr>";

        if ($det['prodtype'] <> "Digital") {

            $content .="<tr>
				<td><strong>Shipping</strong></td><td>:</td><td> " . $orderDetails['Order']['shipping_price'] . " </td></tr>";
        }

        $content .="<tr><td><strong>Tax Name</strong></td><td>:</td><td> " . $orderDetails['Order']['tax_name'] . "</td></tr><tr><td><strong>Tax</strong></td><td>:</td><td> " . $orderDetails['Order']['tax_price'] . "</td></tr><tr><td><strong>Discount </strong></td><td>:</td><td> " . $discamt . " </td></tr><tr>			<td><strong>Promo Code Discount</strong></td><td>:</td><td> " . number_format($odr['Order']['reduced_amt'], 2, '.', '') . "</td></tr><tr><td><strong>Grand Total</strong></td><td>:</td><td><b> " . $orderDetails['Order']['total_price'] - $odr['Order']['reduced_amt'] . " </b></td></tr></table></td></tr><tr height='15'><td colspan='2' align='center'>&nbsp;</td></tr><tr>
	  <td>";

        if ($det['prodtype'] <> "Digital") {
            $content .="<table width='90%' border='0' cellpadding='0' cellspacing='0' class='manage_table' align='center'><tr><td><h3>Shipping Address</h3></td></tr><tr><td> " . $orderDetails['Order']['ship_fname'] . "&nbsp;&nbsp;  " . $orderDetails['Order']['ship_lname'] . " </td></tr><tr><td> " . $orderDetails['Order']['ship_address'] . " </td></tr><tr><td> " . $orderDetails['Order']['ship_city'] . "&nbsp;&nbsp;&nbsp;" . $orderDetails['Order']['ship_state'] . "&nbsp;&nbsp;&nbsp;" . $orderDetails['Order']['ship_zip'] . " </td></tr><tr><td> " . $orderDetails['Order']['ship_country'] . " </td></tr><tr><td>Phone &nbsp; : &nbsp; " . $orderDetails['Order']['ship_phone'] . " </td></tr><tr><td>Mobile &nbsp; : &nbsp;" . $orderDetails['Order']['ship_mobile'] . "</td></tr><tr>
		<td>Fax &nbsp; : &nbsp; " . $orderDetails['Order']['ship_fax'] . " </td></tr><tr><td>&nbsp;</td></tr></table>";
        }

        $content .=" </td><td><table width='90%' border='0' cellpadding='0' cellspacing='0' class='manage_table' align='center'><tr><td><h3> Billing Address</h3></td></tr><tr><td> " . $orderDetails['Order']['bill_fname'] . "&nbsp;&nbsp; " . $orderDetails['Order']['bill_lname'] . " </td></tr><tr><td> " . $orderDetails['Order']['bill_address'] . "</td></tr><tr><td>" . $orderDetails['Order']['bill_city'] . "&nbsp;&nbsp;&nbsp;" . $orderDetails['Order']['bill_state'] . "&nbsp;&nbsp;&nbsp;" . $orderDetails['Order']['bill_zip'] . "</td></tr><tr><td>" . $orderDetails['Order']['bill_country'] . " </td></tr><tr><td>Phone &nbsp; : &nbsp; " . $orderDetails['Order']['bill_phone'] . "</td></tr><tr><td>Mobile &nbsp; : &nbsp; " . $orderDetails['Order']['bill_mobile'] . " </td></tr><tr><td>Fax &nbsp; : &nbsp; " . $orderDetails['Order']['bill_fax'] . "</td></tr><tr><td>&nbsp;</td></tr></table></td></tr>";
        $content .="<tr><td>&nbsp;</td></tr></table></td><td>&nbsp;</td></tr></table>";
        $this->loadModel('Setting');
        $this->Setting->load();
        $cnfg = Configure::read('Neutrino');
        $subject = "Order placed at " . $cnfg["site_name"];

        $headers = "MIME-Version: 1.0\r\n";

        $headers .= "Reply-To: " . $cnfg["site_name"] . " <" . $cnfg["admin_email"] . ">" . "\r\n";

        $headers .= "Return-Path: " . $cnfg["site_name"] . " <" . $cnfg["admin_email"] . ">" . "\r\n";

        $headers .= "From: " . $cnfg["site_name"] . "<" . $cnfg["admin_email"] . ">\r\n";

        $headers .= "Organization: " . $cnfg["site_name"] . "\r\n";

        $headers .= "Content-type: text/html; charset=iso-8859-1\r\n";

        $pdt = $this->Cmspage->findByTitle('Order confirm mail');

        $path = "SiteLogo_disp.gif";

        $mcont = "<table width='90%'  border='0' cellspacing='2' cellpadding='2' align='center'>

		  <tr><td><a href='" . FULL_BASE_URL . $cnfg["sitebasefolder"] . "' target='_blank'><img src='" . FULL_BASE_URL . $cnfg["sitebasefolder"] . "/app/webroot/" . IMAGES_URL . $path . "' border='0'></a></td></tr></table>";

        $cnfg["site_name"] = "<a href='" . FULL_BASE_URL . $cnfg["sitebasefolder"] . "' target='_blank'>" . $cnfg["site_name"] . "</a>";

        //Mail for User

        $pdt = $this->Cmspage->findByTitle('Order confirm mail');

        $mailcontent = $mcont . $pdt["Cmspage"]["content"];

        $mailcontent = str_replace("[ORDER_DETAILS]", $content, $mailcontent);

        $mailcontent = str_replace("[User_Name]", $orderDetails['User']['uname'], $mailcontent);

        $mailcontent = str_replace("[SITE_NAME]", $cnfg["site_name"], $mailcontent);

        if ($orderDetails['User']['email'] != '') {

            if ($cnfg["smtpEnabled"] == "YES") {

                $mailsent = $this->Email->send($orderDetails['User']['email'], $subject, $mailcontent);
                $this->set('mail', $mailsent);
               // $this->render(false);
            } else
                $mailsent = mail($orderDetails['User']['email'], $subject, $mailcontent, $headers);
        }


        //Mail for Admin

        $pdt1 = $this->Cmspage->findByTitle('Admin order confirm mail');

        $mailcontent1 = $mcont . $pdt1["Cmspage"]["content"];

        $mailcontent1 = str_replace("[ORDER_DETAILS]", $content, $mailcontent1);

        $mailcontent1 = str_replace("[User_Name]", $orderDetails['User']['uname'], $mailcontent1);

        $mailcontent1 = str_replace("[SITE_NAME]", $cnfg["site_name"], $mailcontent1);

        if ($cnfg["admin_email"] != '') {
            if ($cnfg["smtpEnabled"] == "YES") {

                $mailsent1 = $this->Email->send($cnfg["admin_email"], $subject, $mailcontent1);
                $this->set('mail', $mailsent1);
               // $this->render(false);
            } else
                $mailsent1 = @mail($cnfg["admin_email"], $subject, $mailcontent1, $headers);
        }


        ###################################


        $this->Session->setFlash('The selected item has been ordered again. Please wait for the Administrator\'s approval.', 'default', array('class' => 'success'));
        $this->redirect(array('controller' => 'orders', 'action' => "myorder"));
        exit;
    }

    function paynow($id = 0) {

        $orderdetails = $this->Session->read('orderforpayment');
        $orderdetailsforpayment = $this->Session->read('orderdetailsforpayment');
      // echo "----from paynowfunction--->";
      //echo "<pre>";print_r($orderdetails);
        //echo "<pre>";print_r($orderdetailsforpayment);
 //exit;
        if ($orderdetails['coupon_code']) {
            // echo $orderdetails['coupon_code'];exit;
            $this->set('coupon_code', $orderdetails['coupon_code']);
        }

        $sus = $this->Session->read('Userlog');
        if (isset($sus) && empty($sus) === false) {
            $this->set('sus', $sus);
            $citem = $this->Cart->find('all', array('conditions' => array('Cart.type <>' => 'G', 'user_id' => $sus['id'])));
        } else {
            $this->set('sus', '');
            $sessid = $this->Session->id();
            $citem = $this->Cart->find('all', array('conditions' => array('Cart.type <>' => 'G', 'sess_id' => $sessid)));
        }
        $this->set('cartcount', count($citem));
        if (empty($orderdetails) && empty($orderdetailsforpayment)) {
            $this->redirect(array('controller' => 'users', 'action' => "myaccount"));
            exit;
        }
        $this->__validateLoginStatus('U');
        $this->loadModel('Setting');
        $this->Setting->load();
        $cnfg = Configure::read('Neutrino');


        $this->set('cnfg', $cnfg);
        $this->set('oid', $id);
        $user_id = $sus["id"];


        /*         * **********              ****************************** */




        $shipping_cost = $orderdetails["shipping_price"];
        $shipping_form = "<input type='hidden' name='shipping' value='$shipping_cost'>";
        $tot_price = $orderdetails["total_price"] - $orderdetails["shipping_price"];
        $totaltopay = number_format($tot_price, 2, ".", "");
        $gtotal = number_format(($tot_price + $shipping_cost), 2, ".", "");
       // echo "---------total to pay--------".$totaltopay;
        // echo "---------gtotal -- tot_price + shipping_cost--------".$totaltopay;exit;
        
        $this->set('totaltopay', $totaltopay);

        //$this->set('totaltopay', number_format($tot_price,2,".",""));	 
        $taxamt = 0;
        if ($cnfg["taxto"] == "gtotal") {
            $taxableamt = $tot_price + $shipping_cost;
        } else {
            $taxableamt = $tot_price;
        }

        if ($cnfg["tax_option"] == "notax") {

            $taxperc = 0;

            $taxname = "No Tax is applicable";
        } elseif ($cnfg["tax_option"] == "fixedtax") {

            $taxperc = $cnfg["fixedtax_rate"];

            $taxname = $cnfg["fixedtax_name"];
        } else {

            if ($cnfg["taxable_address"] == "shipping") {
                $billadd = $this->UserAddress->find("first", array("conditions" => array("UserAddress.user_id" => $user_id, "UserAddress.addr_type" => 'Shipping')));
            } else {

                 $billadd = $this->UserAddress->find("first", array("conditions" => array("UserAddress.user_id" => $user_id, "UserAddress.addr_type" => 'Billing')));
            
                 
            }
 $stdetal = $this->State->find("first", array("conditions" => array("State.country_id" => $billadd["UserAddress"]["country"], "State.code" => $billadd["UserAddress"]["state"])));
                       
          //  $stdetal = $this->State->find('State.country_id = "' . $billadd["UserAddress"]["country"] . '" AND State.code = "All"');



            if (!empty($stdetal["State"])) {

                $taxperc = $stdetal["State"]["tax_rate"];

                $taxname = $stdetal["State"]["tax_name"];
            } else {

                $stdetal = $this->State->find('State.country_id = "' . $billadd["UserAddress"]["country"] . '" AND State.code ="' . $billadd["UserAddress"]["state"] . '"');

                if (!empty($stdetal["State"])) {

                    $taxperc = $stdetal["State"]["tax_rate"];

                    $taxname = $stdetal["State"]["tax_name"];
                } else {

                    $stdetal = $this->State->find('State.country_id = "' . $billadd["UserAddress"]["country"] . '" AND State.name ="' . $billadd["UserAddress"]["state"] . '"');

                    if (!empty($stdetal["State"])) {

                        $taxperc = $stdetal["State"]["tax_rate"];

                        $taxname = $stdetal["State"]["tax_name"];
                    } else {

                        $taxperc = 0;

                        $taxname = "No Tax is applicable";
                    }
                }
            }
        }

        
        //echo $taxperc; 
        if ($tot_price > 0) {

            $taxamt = ($taxableamt * $taxperc) / 100;

            $taxamt = number_format($taxamt, 2, ".", "");

            $tot_price = $tot_price + $taxamt;
        }


        $curr = $this->Currency->findByCode($cnfg["currency"]);
        $this->set('curlogo', $curr["Currency"]["logo"]);

        ######################### End of Section to find and add tax amount......................
        $this->set('taxamnt', $taxamt);
        if ($tot_price > 0)
            $gtotal = number_format(($tot_price + $shipping_cost), 2, ".", "");
        else
            $gtotal = number_format(0.00 + $shipping_cost, 2, ".", "");
        $paymentMethod = "CC";
        $this->set('taxperc', $taxperc);
        $this->set('taxamnt', $taxamt);
        $this->set('gtotal', $gtotal);
        $this->set('userid', $user_id);
        $this->set('paymentMethod', $paymentMethod);
        $this->set('shipping_cost', $shipping_cost);


        /*         * **********              ****************************** */
    }

    function paypal($id = 0) {

        $orderdetails = $this->Session->read('orderforpayment');
        $orderdetailsforpayment = $this->Session->read('orderdetailsforpayment');
        //echo "<pre>";print_r($orderdetails);exit;
        if (empty($orderdetails) && empty($orderdetailsforpayment)) {
            $this->redirect(array('controller' => 'users', 'action' => "myaccount"));
            exit;
        }
        $orderdetails = $this->Session->read('orderforpayment');
        $orderdetailsforpayment = $this->Session->read('orderdetailsforpayment');
        $this->__validateLoginStatus('U');
        $sus = $this->Session->read('Userlog');
        //echo "<pre>";print_r($sus);		
        if (isset($sus) && empty($sus) === false) {
            $this->set('sus', $sus);
            $citem = $this->Cart->find('all', array('conditions' => array('Cart.type <>' => 'G', 'user_id' => $sus['id'])));
        } else {
            $this->set('sus', '');
            $sessid = $this->Session->id();
            $citem = $this->Cart->find('all', array('conditions' => array('Cart.type <>' => 'G', 'sess_id' => $sessid)));
        }
        $this->set('cartcount', count($citem));
        $this->loadModel('Setting');
        $this->Setting->load();
        $cnfg = Configure::read('Neutrino');


        $txtPaypalEmail = $cnfg["paypal_email"];
        $txtPaypalSandbox = $cnfg["paypal_testmode"];
        if ($txtPaypalSandbox == "Y") {
            $paypalurl = "https://www.sandbox.paypal.com/cgi-bin/webscr";
            $paypalbuttonurl = "https://www.sandbox.paypal.com/en_US/i/btn/x-click-but23.gif";
        } else {
            $paypalurl = "https://www.paypal.com/cgi-bin/webscr";
            $paypalbuttonurl = "https://www.paypal.com/en_US/i/btn/x-click-but23.gif";
        }

        $user_id = $sus["id"];
        $orderDetails = $this->Order->findById($id);

        $shipping_cost = $orderdetails["shipping_price"];
        $shipping_form = "<input type='hidden' name='shipping' value='$shipping_cost'>";
        $tot_price = $orderdetails["total_price"] - $orderdetails["shipping_price"];
        ///echo "<pre>";print_r($orderDetails);
        //echo "total price firdt appearance--->".$tot_price."---------";
        /////////// Section for Tax888888888888888
        $taxamt = 0;
        if ($cnfg["taxto"] == "gtotal") {
            $taxableamt = $tot_price + $shipping_cost;
        } else {
            $taxableamt = $tot_price;
        }

        if ($cnfg["tax_option"] == "notax") {

            $taxperc = 0;

            $taxname = "No Tax is applicable";
        } elseif ($cnfg["tax_option"] == "fixedtax") {

            $taxperc = $cnfg["fixedtax_rate"];

            $taxname = $cnfg["fixedtax_name"];
        } else {

            if ($cnfg["taxable_address"] == "shipping") {
                $billadd = $this->UserAddress->find("first", array("conditions" => array("UserAddress.user_id" => $user_id, "UserAddress.addr_type" => 'Billing')));
            } else {

                $billadd = $this->UserAddress->find('UserAddress.user_id = ' . $user_id . ' AND UserAddress.addr_type = "Billing"');
            }

            $stdetal = $this->State->find('State.country_id = "' . $billadd["UserAddress"]["country"] . '" AND State.code = "All"');

            if (!empty($stdetal["State"])) {

                $taxperc = $stdetal["State"]["tax_rate"];

                $taxname = $stdetal["State"]["tax_name"];
            } else {

                $stdetal = $this->State->find('State.country_id = "' . $billadd["UserAddress"]["country"] . '" AND State.code ="' . $billadd["UserAddress"]["state"] . '"');

                if (!empty($stdetal["State"])) {

                    $taxperc = $stdetal["State"]["tax_rate"];

                    $taxname = $stdetal["State"]["tax_name"];
                } else {

                    $stdetal = $this->State->find('State.country_id = "' . $billadd["UserAddress"]["country"] . '" AND State.name ="' . $billadd["UserAddress"]["state"] . '"');

                    if (!empty($stdetal["State"])) {

                        $taxperc = $stdetal["State"]["tax_rate"];

                        $taxname = $stdetal["State"]["tax_name"];
                    } else {

                        $taxperc = 0;

                        $taxname = "No Tax is applicable";
                    }
                }
            }
        }

        if ($tot_price > 0) {

            $taxamt = ($taxableamt * $taxperc) / 100;

            $taxamt = number_format($taxamt, 2, ".", "");

            $tot_price = $tot_price;
        }

        $this->set("taxamt", $taxamt);
        ######################### End of Section to find and add tax amount......................
        $discountamt = $orderdetails["reduced_amt"];
        $tot_price = $tot_price - $discountamt;
        //echo "tot_price-->".$tot_price."-----------";
        $totaltopay = number_format($tot_price, 2, ".", "");
        //echo "total to pay-->".$totaltopay."-----------";
        $gtotal = number_format(($tot_price + $shipping_cost), 2, ".", "");
        //echo "total final-->".$gtotal;exit;
        $this->set('totaltopay', $totaltopay);
        $this->set('oid', $id);
        $this->set('paypalurl', $paypalurl);

        $this->set('paypalbuttonurl', $paypalbuttonurl);

        $this->set('txtPaypalEmail', $txtPaypalEmail);

        $this->set('shipping_form', $shipping_form);

        $this->set('shipping_cost', $shipping_cost);



        $this->set('cnfg', $cnfg);
        $this->Session->write('Payamount', $gtotal);
    }

    function paysuccess($id) {


        $this->__validateLoginStatus('U');
        $this->loadModel('Setting');
        $this->Setting->load();
        $cnfg = Configure::read('Neutrino');

        $auth_token = $cnfg["paypal_idtoken"];

        $tx_token = '';


        //Process the tokens in the case of it returned back.

        if ($_GET['tx'] != '') {

            $tx_token = $_GET['tx'];


            $txtPaypalEmail = $cnfg["paypal_email"];

            $txtPaypalSandbox = $cnfg["paypal_testmode"];

            if ($txtPaypalSandbox == "Y") {

                $paypalurl = "www.sandbox.paypal.com";
            } else {

                $paypalurl = "www.paypal.com";
            }

            $flag_to_continue = false;

            $paypal_check = 0;

            $req = 'cmd=_notify-synch';

            $req .= "&tx=$tx_token&at=$auth_token";

            $header = "POST /cgi-bin/webscr HTTP/1.0\r\n";

            $header .= "Content-Type: application/x-www-form-urlencoded\r\n";

            $header .= "Content-Length: " . strlen($req) . "\r\n\r\n";

            $fp = fsockopen($paypalurl, 80, $errno, $errstr, 30);

            if ($txtPaypalSandbox == "Y" && ($_GET["st"] == "Pending" || $_GET["st"] == "Completed")) {
                $flag_to_continue = true;
            } else {
                if (!$fp) {

                    //echo "socket error";
                    // HTTP ERROR
                } else {

                    fputs($fp, $header . $req);

                    $res = '';

                    $headerdone = false;

                    while (!feof($fp)) {

                        $line = fgets($fp, 1024);



                        if (strcmp($line, "\r\n") == 0) {

                            // read the header

                            $headerdone = true;
                        } else if ($headerdone) {

                            // header has been read. now read the contents

                            $res .= $line;
                        }
                    }

                    // parse the data
                    $lines = explode("\n", $res);

                    $keyarray = array();
                    if (strcmp($lines[0], "SUCCESS") == 0) {
                        $flag_to_continue = true;
                    } else if (strcmp($lines[0], "FAIL") == 0) {

                        // log for manual investigation
                        //		echo("Fail in result");

                        $flag_to_continue = false;
                    } else if (strcasecmp($lines[0], "COMPLETED") == 0) {
                        $flag_to_continue = true;
                    } else if (strcasecmp($lines[0], "PENDING") == 0) {
                        $flag_to_continue = true;
                    }
                }
            }
        }

        //By Pass the paypal flag settings for  Test Servers in the tokens not received in the url settings.
        if (ENVIRONMENT == 'SYDNEY' || ENVIRONMENT == 'CLIENTSLIVE' || ENVIRONMENT == 'LOCAL') {
            $flag_to_continue = true;
        }


        if ($flag_to_continue == true) {

            //$this->redirect('/orders/myorder');
        } else {

            $this->Session->setFlash('Invalid request.Please try again later.', 'default', array('class' => 'failure'));

            $this->redirect('/orders/paynow');

            exit;
        }

        $amount_compare = number_format($_GET['amt'], 2, ".", "");

        $sessPayamt = $this->Session->read('Payamount');


        if (isset($sesspayamt) && $sesspayamt != "") {

            if ($sesspayamt != $amount_compare) {

                $paypal_check = 1;
            }
        }


        if ($paypal_check == 1) {

            $this->Session->setFlash('Order Cannot be Processed, Please contact the Administrator!', 'default', array('class' => 'failure'));

            $this->redirect('/index.php');

            exit;
        } else {
            $orderdetails = $this->Session->read('orderforpayment');
            $orderdetailsforpayment = $this->Session->read('orderdetailsforpayment');
            $id = $this->updateordetable($orderdetails, $orderdetailsforpayment);
            $this->__payorder($id, 'Pay pal', 'Through Pay pal');
            $this->redirect(array('controller' => 'orders', 'action' => 'userorderdetails/' . $id));

            exit;
        }
    }

    function payfast($id = 0) {

        $orderdetails = $this->Session->read('orderforpayment');
        $orderdetailsforpayment = $this->Session->read('orderdetailsforpayment');

        if (empty($orderdetails) && empty($orderdetailsforpayment)) {
            $this->redirect(array('controller' => 'users', 'action' => "myaccount"));
            exit;
        }
        $orderdetails = $this->Session->read('orderforpayment');
        $orderdetailsforpayment = $this->Session->read('orderdetailsforpayment');
        $this->__validateLoginStatus('U');
        $sus = $this->Session->read('Userlog');
        $this->set('sus', $sus);
        $cnfg = Configure::read('Neutrino');
        $txtPayFlowMerchantKey = $cnfg["merchant_key"];
        $txtPayFlowMerchantId = $cnfg["merchant_id"];
        $txtPayFlowSandbox = $cnfg["payfast_testmode"];
        if ($txtPayFlowSandbox == "Y") {
            $payfasturl = "https://sandbox.payfast.co.za/eng/process";
            //$paypalbuttonurl 	= 	"https://www.sandbox.paypal.com/en_US/i/btn/x-click-but23.gif" ;
        } else {
            $payfasturl = "https://www.payfast.co.za/eng/process";
            //$paypalbuttonurl 	= 	"https://www.paypal.com/en_US/i/btn/x-click-but23.gif" ;
        }

        $user_id = $sus["id"];
        $orderDetails = $this->Order->findById($id);
        $shipping_cost = $orderdetails["shipping_price"];
        $shipping_form = "<input type='hidden' name='shipping' value='$shipping_cost'>";
        $tot_price = $orderdetails["total_price"] - $orderdetails["shipping_price"];
        /////////// Section for Tax888888888888888
        $taxamt = 0;
        if ($cnfg["taxto"] == "gtotal") {
            $taxableamt = $tot_price + $shipping_cost;
        } else {
            $taxableamt = $tot_price;
        }

        if ($cnfg["tax_option"] == "notax") {

            $taxperc = 0;

            $taxname = "No Tax is applicable";
        } elseif ($cnfg["tax_option"] == "fixedtax") {

            $taxperc = $cnfg["fixedtax_rate"];

            $taxname = $cnfg["fixedtax_name"];
        } else {

            if ($cnfg["taxable_address"] == "shipping") {
                $billadd = $this->UserAddress->find("first", array("conditions" => array("UserAddress.user_id" => $user_id, "UserAddress.addr_type" => 'Billing')));
            } else {

                $billadd = $this->UserAddress->find('UserAddress.user_id = ' . $user_id . ' AND UserAddress.addr_type = "Billing"');
            }

            $stdetal = $this->State->find('State.country_id = "' . $billadd["UserAddress"]["country"] . '" AND State.code = "All"');

            if (!empty($stdetal["State"])) {

                $taxperc = $stdetal["State"]["tax_rate"];

                $taxname = $stdetal["State"]["tax_name"];
            } else {

                $stdetal = $this->State->find('State.country_id = "' . $billadd["UserAddress"]["country"] . '" AND State.code ="' . $billadd["UserAddress"]["state"] . '"');

                if (!empty($stdetal["State"])) {

                    $taxperc = $stdetal["State"]["tax_rate"];

                    $taxname = $stdetal["State"]["tax_name"];
                } else {

                    $stdetal = $this->State->find('State.country_id = "' . $billadd["UserAddress"]["country"] . '" AND State.name ="' . $billadd["UserAddress"]["state"] . '"');

                    if (!empty($stdetal["State"])) {

                        $taxperc = $stdetal["State"]["tax_rate"];

                        $taxname = $stdetal["State"]["tax_name"];
                    } else {

                        $taxperc = 0;

                        $taxname = "No Tax is applicable";
                    }
                }
            }
        }

        if ($tot_price > 0) {

            $taxamt = ($taxableamt * $taxperc) / 100;

            $taxamt = number_format($taxamt, 2, ".", "");

            $tot_price = $tot_price + $taxamt;
        }


        ######################### End of Section to find and add tax amount......................
        $discountamt = $orderdetails["reduced_amt"];
        $tot_price = $tot_price - $discountamt;
        $totaltopay = number_format($tot_price, 2, ".", "");
        $gtotal = number_format(($tot_price + $shipping_cost), 2, ".", "");

        $this->set('totaltopay', $totaltopay);
        $this->set('oid', $id);
        $this->set('payfasturl', $payfasturl);
        $txid = 'TRN' . $oid . '125E' . rand(100, 10000);
        //$this->set('paypalbuttonurl', $paypalbuttonurl);
        // $signature = md5(rand(100, 1000000).$billadd["UserAddress"]["fname"].$id);
        $signature = "";
        $this->set('txtPayFlowMerchantKey', $txtPayFlowMerchantKey);

        $this->set('txtPayFlowMerchantId', $txtPayFlowMerchantId);

        $this->set('firstname', $billadd["UserAddress"]["fname"]);

        $this->set('lastname', $billadd["UserAddress"]["lname"]);

        $this->set('emailaddress', $billadd["UserAddress"]["email"]);

        $this->set('signature', $signature);

        $this->set('shipping_form', $shipping_form);

        $this->set('shipping_cost', $shipping_cost);

        $this->set('txid', $txid);
        $this->set('gtotal', $gtotal);
        $this->set('cnfg', $cnfg);
        $this->Session->write('Payamount', $gtotal);
    }

    function payfastsuccess($id, $status) {


        $this->__validateLoginStatus('U');

        $cnfg = Configure::read('Neutrino');


        $array['status'] = $status;
        $array['amount'] = $_GET['amt'];
        $paypal_check = $this->__checkPayFastPayment($array);
        if ($paypal_check == 1) {

            $this->Session->setFlash('Invalid request.Please try again later.', 'default', array('class' => 'failure'));
            $this->redirect('/orders/paynow');
            exit;
        } else {
            $orderdetails = $this->Session->read('orderforpayment');
            $orderdetailsforpayment = $this->Session->read('orderdetailsforpayment');
            $id = $this->updateordetable($orderdetails, $orderdetailsforpayment);
            $this->__payorder($id, 'Pay Flow', 'Through Pay Flow');
            $this->redirect(array('controller' => 'orders', 'action' => 'userorderdetails/' . $id));

            exit;
        }
    }

    function __checkPayFastPayment($array) {
        $paypal_check = 1;
        if (count($array)) {
            if ($array['status'] == 'sucess') {

                $amount_compare = number_format($array['amount'], 2, ".", "");

                $sessPayamt = $this->Session->read('Payamount');
                $sessPayamt = number_format($sessPayamt, 2, ".", "");


                if ($amount_compare == $sessPayamt) {
                    $paypal_check = 0;
                }
            }
        }
        return $paypal_check;
    }

    function __payorder($id, $gtway, $txnid) {


        $sus = $this->Session->read('Userlog');

        $user_id = $sus["id"];

        $order["transaction_id"] = "Through Pay pal";


        $this->Order->payorder($id, $gtway, $txnid);

        ################################## Section to send order confirmation mail................................

        $this->Order->id = $id;

        $data = $this->Order->read();





        for ($j = 0; $j < sizeof($data["OrderDetail"]); $j++) {

            if ($data["OrderDetail"][$j]["type"] == 'P') {

                $pdet = $this->Product->findById($data["OrderDetail"][$j]["product_id"]);

                $data["OrderDetail"][$j]["Product"] = $pdet["Product"]["pname"];
            } else if ($data["OrderDetail"][$j]["type"] == 'G') {

                $gdet = $this->Giftcard->findById($data["OrderDetail"][$j]["product_id"]);

                $data["OrderDetail"][$j]["Product"] = $gdet["Giftcard"]["gift_code"] . '(Gift Card)';

                $data["OrderDetail"][$j]["product_price"] = $gdet["Giftcard"]["gift_amnt"];
            }
        }



        //$shipadd	=	$this->UserAddress->findAll("UserAddress.user_id=".$data["User"]["id"]." AND UserAddress.addr_type='Shipping'");

        $shipadd = $this->UserAddress->find("all", array("conditions" => array("UserAddress.user_id" => $data["User"]["id"], "UserAddress.addr_type" => 'Shipping')));

        //$billadd	=	$this->UserAddress->findAll("UserAddress.user_id=".$data["User"]["id"]." AND UserAddress.addr_type='Billing'");

        $billadd = $this->UserAddress->find("all", array("conditions" => array("UserAddress.user_id" => $data["User"]["id"], "UserAddress.addr_type" => 'Billing')));

        $odr = $data;

        $ship = $shipadd[0]["UserAddress"];

        $bill = $billadd[0]["UserAddress"];
        $bill_email = $billadd[0]["UserAddress"]["email"];

        $content = "<table width='90%'  border='0' cellspacing='2' cellpadding='2' align='center'><tr><td colspan='2' align='center'><h2>Order Details</h2></td></tr><tr><td colspan='2' align='center'><table width='90%' border='0' cellpadding='0' cellspacing='0' class='manage_table' align='center'><tr><td><strong>Order Number</strong></td><td><strong>Order Status</strong></td><td><strong>Order Date</strong></td><td><strong>User Name</strong></td><td><strong>Currency</strong></td> </tr><tr><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td></tr><tr><td> " . $id . "</td><td>" . $odr['OrderStatus']['name'] . "</td><td>";


        $dt = strtotime($odr['Order']['date']);

        $edt = strtotime($odr['Order']['exp_time']);

        $content .= date('m-d-Y', $dt);

        $content .= "</td><td> " . $odr['User']['uname'] . "</td><td>" . $odr["Order"]["currency_type"] . "</td></tr></table></td></tr><tr><td colspan='2' align='center'><h3>Item Details</h3></td></tr><tr><td colspan='2'><table width='90%' border='0' cellpadding='2' cellspacing='2' class='manage_table' align='center'><tr><td colspan='2'><strong>Product Name</strong></td><td><strong>Quantity</strong></td><td><strong>Unit Price</strong></td><td><strong>Extra Price</strong></td><td><strong>Discount</strong></td><td><strong>Price</strong></td></tr><tr><td colspan='3'>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td></tr>";$amt = 0;

        //print_r($odr);exit;

        foreach ($odr['OrderDetail'] as $det) {

            $price = 0;

            $combined_price = 0;

            $dis_amnt = 0;

            if ($det["discount_type"] == 'per' && $det["discount"] > 0) {

                $dis_amnt = (($det["product_price"]) * $det["discount"]) / 100;
            } else if ($det["discount_type"] == 'amnt' && $det["discount"] > 0) {

                $dis_amnt = $det["discount"];
            }

            $dis_amnt = ($dis_amnt) * ($det["quantity"]);

            $dis_amnt = number_format($dis_amnt, 2, '.', '');



            $combined_price = ($det["product_price"]);

            if (isset($det["discount_type"]) && $det["discount_type"] <> '') {

                if ($det["discount_type"] == 'per') {

                    if (isset($det["discount"]) && $det["discount"] <> '' && $det["discount"] > 0) {

                        $discounted_price = ($combined_price - (($combined_price * $det['discount']) / 100));

                        $price = ($discounted_price * $det['quantity']) + ($det["extra_price"] * $det['quantity']);

                        $amt+= $price;
                    } else
                        $amt+=($combined_price * $det['quantity']) + ($det["extra_price"] * $det['quantity']);
                }

                else if ($det["discount_type"] == 'amnt') {

                    if (isset($det["discount"]) && $det["discount"] <> '' && $det["discount"] > 0) {

                        $discounted_price = ($combined_price - $det['discount']);

                        $price = ($discounted_price * $det['quantity']) + ($det["extra_price"] * $det['quantity']);

                        $amt+= $price;
                    } else
                        $amt+=($combined_price * $det['quantity']) + ($det["extra_price"] * $det['quantity']);
                }
            }

            else {

                $price = ($combined_price * $det['quantity']) + ($det["extra_price"] * $det['quantity']);

                $amt+= $price;
            }

            $price = number_format($price, 2, ".", "");

            $amt = number_format($amt, 2, ".", "");


            /*             * ***************** to get Combination name ************ */

            $combnstr = array();
            $combinations = array();
            $combinationanme = '';
            $prod1 = $this->Productdetail->findById($det['combination_id']);




            if ($prod1) {
                $pcmbnids = $prod1["Productdetail"]["customvalue_id"];

                $pcmbnid = explode(',', $pcmbnids);

                foreach ($pcmbnid as $key => $val) {

                    if ($val != '') {
                        $combnstr[] = $this->Product->getpdctcmbn($val);

                        $combinations = implode(", ", $combnstr);


                        $combinationanme = $combinations;
                    } else {
                        $combinationanme = '';
                    }
                }
            }

            /*             * ***************** to get Combination name ************ */


            $content .= " <tr><td colspan='2'>" . $det['Product'] . ' ' . $combinationanme . "</td><td> " . $det['quantity'] . " </td><td> " . number_format($det['product_price'], 2, ".", "") . " </td><td> " . number_format($det['extra_price'] * $det['quantity'], 2, ".", "") . " </td><td> " . number_format($dis_amnt, 2, ".", "") . " </td><td>" . number_format($price, 2, ".", "") . " </td></tr><tr><td colspan='3' height='15'>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td></tr>";
        }



        if ($odr["Order"]["discount"] > 0)
            $discamt = number_format($odr["Order"]["discount"], 2, '.', '');

        // else
        // $discamt=number_format($odr["Order"]["discount"],2,'.',''); 

        $content .= "</table></td></tr><tr><td width='50%'>";

        if ($det['prodtype'] <> "Digital") {

            $content .="<table width='100%'border='0' cellpadding='0' cellspacing='0'>

		<tr><td><table width='90%' border='0' cellpadding='0' cellspacing='0' class='manage_table' align='center'><tr><td width='50%'><strong>Shipping Method</strong></td><td  width='5%'>:</td><td width='45%'>" . $odr['Order']['shipping_method'] . "</td></tr><tr><td><strong>Shipping Service</strong></td><td>:</td><td>" . $odr['Order']['shipping_service'] . " </td><tr></table></td></tr><tr><td><table width='90%' border='0' cellpadding='0' cellspacing='0' class='manage_table' align='center'><tr><td width='50%'><strong>Payment Method</strong></td><td width='5%'>:</td><td width='45%'> " . $odr['Order']['payment_method'] . "</td></tr><tr><td><strong>Transaction Id</strong></td><td>:</td><td> " . $odr['Order']['transaction_id'] . " </td></tr><tr><td><strong>Payment Date</strong></td><td>:</td><td> ";
            $pdt = strtotime($odr['Order']['pay_date']);



            $content .= date('m-d-Y', $pdt) . " </td>

			  </tr></table></td></tr></table>";
        }



        $content .="</td><td width='50%'><table width='90%' border='0' cellpadding='0' cellspacing='0' class='manage_table' align='center'><tr><td><strong>Total Price</strong></td><td>:</td><td>" . $amt . "</td></tr><tr><td><strong>Tax Name</strong></td><td>:</td><td> " . $odr['Order']['tax_name'] . "</td></tr><tr><td><strong>Tax</strong></td><td>:</td><td> " . $odr['Order']['tax_price'] . "</td></tr><tr><td><strong>Promo Code Discount</strong></td><td>:</td><td> " . number_format($odr['Order']['reduced_amt'], 2) . "</td></tr>";



        if ($det['prodtype'] <> "Digital") {

            $content .="<tr><td><strong>Shipping</strong></td><td>:</td><td> " . $odr['Order']['shipping_price'] . " </td></tr>";
        }

        $grndTot = $odr['Order']['total_price'] + $odr['Order']['tax_price'] - $odr['Order']['reduced_amt'];
        $content .="<tr><td><strong>Grand Total</strong></td><td>:</td><td><b> " . number_format($grndTot, 2) . " </b></td></tr></table></td></tr><tr height='15'><td colspan='2' align='center'>&nbsp;</td></tr><tr><td>";



        if ($det['prodtype'] <> "Digital") {

            $content .="<table width='90%' border='0' cellpadding='0' cellspacing='0' class='manage_table' align='center'><tr><td><h3>Shipping Address</h3></td></tr><tr><td> " . $odr['Order']['ship_fname'] . "&nbsp;&nbsp;  " . $odr['Order']['ship_lname'] . " </td></tr><tr><td> " . $odr['Order']['ship_address'] . " </td></tr><tr><td> " . $odr['Order']['ship_city'] . "&nbsp;&nbsp;&nbsp;" . $odr['Order']['ship_state'] . "&nbsp;&nbsp;&nbsp;" . $odr['Order']['ship_zip'] . " </td></tr><tr><td> " . $odr['Order']['ship_country'] . " </td></tr><tr><td>Phone &nbsp; : &nbsp; " . $odr['Order']['ship_phone'] . " </td></tr><tr><td>Mobile &nbsp; : &nbsp;" . $odr['Order']['ship_mobile'] . "</td></tr><tr><td>Fax &nbsp; : &nbsp; " . $odr['Order']['ship_fax'] . " </td></tr><tr><td>&nbsp;</td></tr></table>";
        }



        $content .=" </td><td><table width='90%' border='0' cellpadding='0' cellspacing='0' class='manage_table' align='center'><tr><td><h3> Billing Address</h3></td></tr><tr><td> " . $odr['Order']['bill_fname'] . "&nbsp;&nbsp; " . $odr['Order']['bill_lname'] . " </td></tr><tr><td> " . $odr['Order']['bill_address'] . "</td></tr><tr><td>" . $odr['Order']['bill_city'] . "&nbsp;&nbsp;&nbsp;" . $odr['Order']['bill_state'] . "&nbsp;&nbsp;&nbsp;" . $odr['Order']['bill_zip'] . "</td></tr><tr><td>" . $odr['Order']['bill_country'] . " </td></tr><tr><td>Phone &nbsp; : &nbsp; " . $odr['Order']['bill_phone'] . "</td></tr><tr><td>Mobile &nbsp; : &nbsp; " . $odr['Order']['bill_mobile'] . " </td></tr><tr><td>Fax &nbsp; : &nbsp; " . $odr['Order']['bill_fax'] . "</td></tr><tr><td>&nbsp;</td></tr></table></td></tr>";


        $content .="<tr><td>&nbsp;</td></tr></table></td><td>&nbsp;</td></tr></table>";
        //echo $odr['Order']['total_price']."<br>".$odr['Order']['shipping_price'];exit;
        //$content;exit;


        $cnfg = Configure::read('Neutrino');



        $subject = "Payment completed for order placed at " . $cnfg["site_name"];

        $headers = "From: " . $cnfg["site_name"] . "<" . $cnfg["admin_email"] . ">\r\n";

        $headers .= "MIME-Version: 1.0\r\n";

        $headers .= "Content-type: text/html; charset=iso-8859-1\r\n";

        $pdt = $this->Cmspage->findByTitle('Order confirm mail');

        $path = "SiteLogo_disp.gif";

        $mcont = "<table width='90%'  border='0' cellspacing='2' cellpadding='2' align='center'>
		  <tr><td><a href='http://" . $_SERVER["HTTP_HOST"] . "/" . $cnfg["sitebasefolder"] . "' target='_blank'><img src='http://" . $_SERVER["HTTP_HOST"] . "/" . $cnfg["sitebasefolder"] . "/app/webroot/" . IMAGES_URL . $path . "' border='0' width='300' ></a></td></tr></table>";

        $cnfg["site_name"] = "<a href='http://" . $_SERVER["HTTP_HOST"] . "/" . $cnfg["sitebasefolder"] . "' target='_blank'>" . $cnfg["site_name"] . "</a>";

        //Mail for User

        $pdt = $this->Cmspage->findByTitle('Order confirm mail');

        $mailcontent = $mcont . $pdt["Cmspage"]["content"];

        $mailcontent = str_replace("[ORDER_DETAILS]", $content, $mailcontent);

        $mailcontent = str_replace("[User_Name]", $odr['User']['uname'], $mailcontent);

        $mailcontent = str_replace("[SITE_NAME]", $cnfg["site_name"], $mailcontent);


        if (strcmp($bill_email, $odr['User']['email']) == 0) {
            $odr['User']['email'] = $odr['User']['email'];
             
           if ($cnfg["smtpEnabled"] == "YES") {

            $mailsent = $this->Email->send($odr['User']['email'], $subject, $mailcontent);
            $this->set('mail', $mailsent);
          //  $this->render(false);
        } else
            $mailsent = mail($odr['User']['email'], $subject, $mailcontent, $headers);


        } else {
                      
                if ($cnfg["smtpEnabled"] == "YES") {

                    $mailsent = $this->Email->send($bill_email, $subject, $mailcontent);
                    $this->set('mail', $mailsent);
                    $mailsent1 = $this->Email->send($odr['User']['email'], $subject, $mailcontent);
                    $this->set('mail', $mailsent1);

                  //  $this->render(false);
                } else
                    $mailsent = mail($bill_email, $subject, $mailcontent, $headers);
         
                    $mailsent = mail($odr['User']['email'], $subject, $mailcontent, $headers);

           
        }





        //Mail for Admin

        $pdt1 = $this->Cmspage->findByTitle('Admin order confirm mail');

        $mailcontent1 = $mcont . $pdt1["Cmspage"]["content"];

        $mailcontent1 = str_replace("[ORDER_DETAILS]", $content, $mailcontent1);

        $mailcontent1 = str_replace("[User_Name]", $odr['User']['uname'], $mailcontent1);

        $mailcontent1 = str_replace("[SITE_NAME]", $cnfg["site_name"], $mailcontent1);

        if ($cnfg["smtpEnabled"] == "YES") {

            $mailsent1 = $this->Email->send($cnfg["admin_email"], $subject, $mailcontent1);
            $this->set('mail', $mailsent1);
           // $this->render(false);
        } else
            $mailsent1 = mail($cnfg["admin_email"], $subject, $mailcontent1, $headers);



        ###################################
        $this->Session->setFlash('Your payment process completed and order has been successfully placed and an e-mail with order details has sent to your e-mail ID!', 'default', array('class' => 'success'));
        //$this->redirect('/index.php');
        //exit;
        return true;
    }

    function payfailure() {

        $this->Session->setFlash('!');
        $this->Session->setFlash('Payment Failure! <br> Your order can not be processed !<br> Try again', 'default', array('class' => 'failure'));

        $this->redirect('/index.php');

        exit;
    }

    function updateordetable($orderdetails, $orderdetailsforpayment) {

        $orderdetails['date'] = date("Y-m-d H:i:s");
        $this->Order->save($orderdetails);
        $order_id = $this->Order->id;
        $sus = $this->Session->read('Userlog');
        $user_id = $sus["id"];
        foreach ($orderdetailsforpayment as $item) {
            $this->OrderDetail->create($odet = array());
            $odet["order_id"] = $order_id;
            $odet["product_id"] = $item["Cart"]["product_id"];
            $odet["product_price"] = $item["Cart"]["product_price"];
            $odet["prodtype"] = $item["Cart"]["prodtype"];
            $odet["discount_type"] = $item["Cart"]["discount_type"];
            $odet["discount"] = $item["Cart"]["discount"];
            $odet["extra_price"] = $item["Cart"]["extra_price"];
            $odet["quantity"] = $item["Cart"]["quantity"];
            $odet["savedimages_id"] = $item["Cart"]["savedimages_id"];
            if ($item["Cart"]["option_id"] > 0 && $item["Cart"]["type"] <> 'G') {
                $odet["combination_id"] = $item["Cart"]["option_id"];
            }
            $odet["type"] = $item["Cart"]["type"];
            $odet["price_type"] = $item["Cart"]["price_type"];
            $odet["custom_information"] = $item["Cart"]["custom_information"];

            $this->OrderDetail->save($odet);
            ######## ( Code Added by Shyam)	########
            if ($item["Cart"]["option_id"] > 0) {
                $this->Product->updatecombnstock($item["Cart"]["product_id"], $item["Cart"]["option_id"], $item["Cart"]["quantity"]);
                $prodid[] = $item["Cart"]["product_id"];
            } else if ($item["Cart"]["option_id"] == 0 || $item["Cart"]["option_id"] == '') {
                $this->Product->updatestock($item["Cart"]["product_id"], $item["Cart"]["quantity"]);
            }
            if ($item["Cart"]["type"] == 'G') {
                $this->Giftcard->updateCardStock($item["Cart"]["product_id"], $item["Cart"]["quantity"]);
            }
            ######## ( Code Added by Shyam)	########
        }
        if (!empty($prodid)) {
            $prodid = array_unique($prodid);
            foreach ($prodid as $val) {
                $this->Product->updateTotalStock($val);
            }
        }
        $this->Cart->deleteAll("Cart.user_id = " . $user_id, $cascade = true);
        $this->Session->delete('orderforpayment');
        $this->Session->delete('orderdetailsforpayment');


        return $order_id;
    }

    /*     * ****************paypal express checkout********************* */

    function paypal_express($id = 0) {
        $this->loadModel('Setting');
        $this->Setting->load();
        $orderdetails = $this->Session->read('orderforpayment');
        $orderdetailsforpayment = $this->Session->read('orderdetailsforpayment');

        if (empty($orderdetails) && empty($orderdetailsforpayment)) {
            $this->redirect(array('controller' => 'users', 'action' => "myaccount"));
            exit;
        }
        $orderdetails = $this->Session->read('orderforpayment');
        $orderdetailsforpayment = $this->Session->read('orderdetailsforpayment');
        //  echo "----orderdetails--->";echo"<pre>";print_r($orderdetails);

        $this->__validateLoginStatus('U');
        $sus = $this->Session->read('Userlog');
        $sus = $this->Session->read('Userlog');


        if (isset($sus) && empty($sus) === false) {
            $this->set('sus', $sus);
            $citem = $this->Cart->find('all', array('conditions' => array('Cart.type <>' => 'G', 'user_id' => $sus['id'])));
        } else {
            $this->set('sus', '');
            $sessid = $this->Session->id();
            $citem = $this->Cart->find('all', array('conditions' => array('Cart.type <>' => 'G', 'sess_id' => $sessid)));
        }
        $this->set('cartcount', count($citem));
        $cnfg = Configure::read('Neutrino');
        $user_id = $sus["id"];
        //  echo "----config array--->";echo"<pre>";print_r($cnfg);
        //$orderDetails = $this->Order->findById($id);
        $shipping_cost = $orderdetails["shipping_price"];
        $shipping_form = "<input type='hidden' name='shipping' value='$shipping_cost'>";
        $tot_price = $orderdetails["total_price"] - $orderdetails["shipping_price"];
        $totaltopay = number_format($tot_price, 2, ".", "");
        $gtotal = number_format(($tot_price + $shipping_cost), 2, ".", "");

        //echo "----total without shiping--->";echo"<pre>";print_r($totaltopay);
        // echo "----total with shiping--->";echo"<pre>";print_r($gtotal);

        $coupon_reduced_amt = $this->Session->read('orderforpayment');
        $this->set('totaltopay', $totaltopay);
        $this->set('oid', $id);
        //$this->set('totaltopay', number_format($tot_price,2,".",""));	 
        $taxamt = 0;
        if ($cnfg["taxto"] == "gtotal") {
            $taxableamt = $tot_price + $shipping_cost;
        } else {
            $taxableamt = $tot_price;
        }

        if ($cnfg["tax_option"] == "notax") {

            $taxperc = 0;

            $taxname = "No Tax is applicable";
        } elseif ($cnfg["tax_option"] == "fixedtax") {

            $taxperc = $cnfg["fixedtax_rate"];

            $taxname = $cnfg["fixedtax_name"];
        } else {

            if ($cnfg["taxable_address"] == "shipping") {
                $billadd = $this->UserAddress->find("first", array("conditions" => array("UserAddress.user_id" => $user_id, "UserAddress.addr_type" => 'Shipping')));
            } else {

                $billadd = $this->UserAddress->find("first", array("conditions" => array("UserAddress.user_id" => $user_id, "UserAddress.addr_type" => 'Billing')));
            }

            $stdetal = $this->State->find('State.country_id = "' . $billadd["UserAddress"]["country"] . '" AND State.code = "All"');

            if (!empty($stdetal["State"])) {

                $taxperc = $stdetal["State"]["tax_rate"];

                $taxname = $stdetal["State"]["tax_name"];
            } else {

                $stdetal = $this->State->find('State.country_id = "' . $billadd["UserAddress"]["country"] . '" AND State.code ="' . $billadd["UserAddress"]["state"] . '"');

                if (!empty($stdetal["State"])) {

                    $taxperc = $stdetal["State"]["tax_rate"];

                    $taxname = $stdetal["State"]["tax_name"];
                } else {

                    $stdetal = $this->State->find('State.country_id = "' . $billadd["UserAddress"]["country"] . '" AND State.name ="' . $billadd["UserAddress"]["state"] . '"');

                    if (!empty($stdetal["State"])) {

                        $taxperc = $stdetal["State"]["tax_rate"];

                        $taxname = $stdetal["State"]["tax_name"];
                    } else {

                        $taxperc = 0;

                        $taxname = "No Tax is applicable";
                    }
                }
            }
        }

        if ($tot_price > 0) {

            $taxamt = ($taxableamt * $taxperc) / 100;

            $taxamt = number_format($taxamt, 2, ".", "");

            $tot_price = $tot_price + $taxamt;
        }


        ######################### End of Section to find and add tax amount......................

        $this->set('taxamnt', $taxamt);
        if ($tot_price > 0)
            $gtotal = number_format(($tot_price + $shipping_cost), 2, ".", "");
        else
            $gtotal = number_format(0.00 + $shipping_cost, 2, ".", "");
        $paymentMethod = "CC";
        $this->set('taxamnt', $taxamt);
        $this->set('gtotal', $gtotal - $coupon_reduced_amt['reduced_amt']);
        $this->set('userid', $user_id);
        $this->set('paymentMethod', $paymentMethod);
        $this->set('shipping_cost', $shipping_cost);
        /* $billadd	=	$this->UserAddress->find("UserAddress.user_id =".$user_id." AND UserAddress.addr_type ='Billing'"); */
        $billadd = $this->UserAddress->find("first", array("conditions" => array("UserAddress.user_id" => $user_id, "UserAddress.addr_type" => 'Billing')));
        $txtAuthorizeEmail = $cnfg["authorize_email"];
        $txtAuthorizeTestMode = $cnfg["authorize_testmode"];
        $txtAuthorizeLoginId = $cnfg["authorize_loginid"];
        $txtAuthorizeTransKey = $cnfg["authorize_transactionkey"];
        $Company = "-NA-";
        $newinvid = $this->Order->getNewinvid();
        $txtEmail = $sus["email"];
        $curr = $this->Currency->findByCode($cnfg["currency"]);
        $this->set('curlogo', $curr["Currency"]["logo"]);
        if ($_SERVER['REQUEST_METHOD'] == 'POST' && !empty($orderdetails) && !empty($orderdetailsforpayment)) {
            $firstName = urlencode($billadd['UserAddress']['fname']);
            $lastName = urlencode($billadd['UserAddress']['lname']);
            $creditCardType = 'visa';
            $creditCardNumber = $this->request->data['txtCCNumber'];
            $expDateMonth = $this->request->data['txtMM'];
            $padDateMonth = str_pad($expDateMonth, 2, '0', STR_PAD_LEFT);
            $expDateYear = $this->request->data['txtYY'];
            $cvv2Number = $this->request->data['txtCVV2'];
            $amount = $this->request->data['cart_total'];
            $nvp = '&PAYMENTACTION=Sale';
            $nvp .= '&AMT=' . $amount;
            $nvp .= '&CREDITCARDTYPE=' . trim($creditCardType);
            $nvp .= '&ACCT=' . trim($creditCardNumber);
            $nvp .= '&CVV2=' . trim($cvv2Number);
            $nvp .= '&EXPDATE=' . $padDateMonth . $expDateYear;
            $nvp .= '&FIRSTNAME=' . $firstName;
            $nvp .= '&LASTNAME=' . $lastName;
            $nvp .= '&COUNTRYCODE=' . trim($cnfg["shipping_origin_country"]) . '&CURRENCYCODE=' . trim($cnfg["currency"]);
            $response = $this->PaypalWPP->wpp_hash('DoDirectPayment', $nvp);
            
            if ($response['ACK'] == 'Success') {
                $trans_id = $response["TRANSACTIONID"];
                $id = $this->updateordetable($orderdetails, $orderdetailsforpayment);
                $this->__payorder($id, 'PaypalPro', $trans_id);
                $this->Session->setFlash('Your order has been successfully placed and an e-mail with order details has sent to your e-mail ID!', 'default', array('class' => 'success'));
                $this->redirect(array('controller' => 'orders', 'action' => 'userorderdetails/' . $id));
                exit;
            } else {
                $this->Session->setFlash($response['L_LONGMESSAGE0']);
            }
        }
    }

    /*     * ************************************************************ */

    /*     * ***************** Stripe payment ********************************* */

    function stripe_pay($id = 0) {

        $this->loadModel('Setting');
        $this->Setting->load();
        $orderdetails = $this->Session->read('orderforpayment');
        $orderdetailsforpayment = $this->Session->read('orderdetailsforpayment');

        if (empty($orderdetails) && empty($orderdetailsforpayment)) {
            $this->redirect(array('controller' => 'users', 'action' => "myaccount"));
            exit;
        }
        $orderdetails = $this->Session->read('orderforpayment');
        $orderdetailsforpayment = $this->Session->read('orderdetailsforpayment');


        $this->__validateLoginStatus('U');
        $sus = $this->Session->read('Userlog');
        $sus = $this->Session->read('Userlog');


        if (isset($sus) && empty($sus) === false) {
            $this->set('sus', $sus);
            $citem = $this->Cart->find('all', array('conditions' => array('Cart.type <>' => 'G', 'user_id' => $sus['id'])));
        } else {
            $this->set('sus', '');
            $sessid = $this->Session->id();
            $citem = $this->Cart->find('all', array('conditions' => array('Cart.type <>' => 'G', 'sess_id' => $sessid)));
        }
        $this->set('cartcount', count($citem));
        $cnfg = Configure::read('Neutrino');
        $user_id = $sus["id"];

        //$orderDetails = $this->Order->findById($id);
        $shipping_cost = $orderdetails["shipping_price"];
        $shipping_form = "<input type='hidden' name='shipping' value='$shipping_cost'>";
        $tot_price = $orderdetails["total_price"] - $orderdetails["shipping_price"];
        $totaltopay = number_format($tot_price, 2, ".", "");
        $gtotal = number_format(($tot_price + $shipping_cost), 2, ".", "");
        $coupon_reduced_amt = $this->Session->read('orderforpayment');
        $this->set('totaltopay', $totaltopay);
        $this->set('oid', $id);
        //$this->set('totaltopay', number_format($tot_price,2,".",""));	 
        $taxamt = 0;
        if ($cnfg["taxto"] == "gtotal") {
            $taxableamt = $tot_price + $shipping_cost;
        } else {
            $taxableamt = $tot_price;
        }

        if ($cnfg["tax_option"] == "notax") {

            $taxperc = 0;

            $taxname = "No Tax is applicable";
        } elseif ($cnfg["tax_option"] == "fixedtax") {

            $taxperc = $cnfg["fixedtax_rate"];

            $taxname = $cnfg["fixedtax_name"];
        } else {

            if ($cnfg["taxable_address"] == "shipping") {
                $billadd = $this->UserAddress->find("first", array("conditions" => array("UserAddress.user_id" => $user_id, "UserAddress.addr_type" => 'Shipping')));
            } else {

                $billadd = $this->UserAddress->find("first", array("conditions" => array("UserAddress.user_id" => $user_id, "UserAddress.addr_type" => 'Billing')));
            }

            $stdetal = $this->State->find('State.country_id = "' . $billadd["UserAddress"]["country"] . '" AND State.code = "All"');

            if (!empty($stdetal["State"])) {

                $taxperc = $stdetal["State"]["tax_rate"];

                $taxname = $stdetal["State"]["tax_name"];
            } else {

                $stdetal = $this->State->find('State.country_id = "' . $billadd["UserAddress"]["country"] . '" AND State.code ="' . $billadd["UserAddress"]["state"] . '"');

                if (!empty($stdetal["State"])) {

                    $taxperc = $stdetal["State"]["tax_rate"];

                    $taxname = $stdetal["State"]["tax_name"];
                } else {

                    $stdetal = $this->State->find('State.country_id = "' . $billadd["UserAddress"]["country"] . '" AND State.name ="' . $billadd["UserAddress"]["state"] . '"');

                    if (!empty($stdetal["State"])) {

                        $taxperc = $stdetal["State"]["tax_rate"];

                        $taxname = $stdetal["State"]["tax_name"];
                    } else {

                        $taxperc = 0;

                        $taxname = "No Tax is applicable";
                    }
                }
            }
        }

        if ($tot_price > 0) {

            $taxamt = ($taxableamt * $taxperc) / 100;

            $taxamt = number_format($taxamt, 2, ".", "");

            $tot_price = $tot_price + $taxamt;
        }


        ######################### End of Section to find and add tax amount......................

        $this->set('taxamnt', $taxamt);
        if ($tot_price > 0)
            $gtotal = number_format(($tot_price + $shipping_cost), 2, ".", "");
        else
            $gtotal = number_format(0.00 + $shipping_cost, 2, ".", "");
        $paymentMethod = "CC";
        $this->set('taxamnt', $taxamt);
        $this->set('gtotal', $gtotal - $coupon_reduced_amt['reduced_amt']);
        $this->set('userid', $user_id);
        $this->set('paymentMethod', $paymentMethod);
        $this->set('shipping_cost', $shipping_cost);
        $stripe_public_key = Configure::read('Stripe.public_key');
        $this->set('stripe_public_key', $stripe_public_key);
        /* $billadd	=	$this->UserAddress->find("UserAddress.user_id =".$user_id." AND UserAddress.addr_type ='Billing'"); */
        $billadd = $this->UserAddress->find("first", array("conditions" => array("UserAddress.user_id" => $user_id, "UserAddress.addr_type" => 'Billing')));
        $txtAuthorizeEmail = $cnfg["authorize_email"];
        $txtAuthorizeTestMode = $cnfg["authorize_testmode"];
        $txtAuthorizeLoginId = $cnfg["authorize_loginid"];
        $txtAuthorizeTransKey = $cnfg["authorize_transactionkey"];
        $Company = "-NA-";
        $newinvid = $this->Order->getNewinvid();
        $txtEmail = $sus["email"];
        $curr = $this->Currency->findByCode($cnfg["currency"]);
        $this->set('curlogo', $curr["Currency"]["logo"]);
        if ($_SERVER['REQUEST_METHOD'] == 'POST' && !empty($orderdetails) && !empty($orderdetailsforpayment)) {
            $firstName = urlencode($billadd['UserAddress']['fname']);
            $lastName = urlencode($billadd['UserAddress']['lname']);
            $email = urlencode($billadd['UserAddress']['email']);
            $amount = $this->request->data['cart_total'];
            $data = array(
                'amount' => $amount,
                'stripeToken' => $this->request->data['stripeToken'],
                'description' => "$firstName $lastName - $email"
            );
            $response = $this->Stripe->charge($data);
            //echo "<pre>";print_r($response);exit;
            if (isset($response['stripe_id'])) {
                $trans_id = $response["stripe_id"];
                $id = $this->updateordetable($orderdetails, $orderdetailsforpayment);
                $this->__payorder($id, 'Stripe', $trans_id);
                $this->Session->setFlash('Your order has been successfully placed and an e-mail with order details has sent to your e-mail ID!', 'default', array('class' => 'success'));
                $this->redirect(array('controller' => 'orders', 'action' => 'userorderdetails/' . $id));
                exit;
            } else {
                $this->Session->setFlash("Payment Failure! Your order can not be processed ! Try again", 'default', array('class' => 'failure'));
            }
        }
    }

    /*     * ************************************************************ */

    //function ordersavebeforepayment

    function ccard($id = 0) {
       // Configure::write('debug', 2);
        $orderdetails = $this->Session->read('orderforpayment');
        $orderdetailsforpayment = $this->Session->read('orderdetailsforpayment');

        if (empty($orderdetails) && empty($orderdetailsforpayment)) {
            $this->redirect(array('controller' => 'users', 'action' => "myaccount"));
            exit;
        }
        $orderdetails = $this->Session->read('orderforpayment');
        $orderdetailsforpayment = $this->Session->read('orderdetailsforpayment');


        $this->__validateLoginStatus('U');
        $sus = $this->Session->read('Userlog');
        $sus = $this->Session->read('Userlog');


        if (isset($sus) && empty($sus) === false) {
            $this->set('sus', $sus);
            $citem = $this->Cart->find('all', array('conditions' => array('Cart.type <>' => 'G', 'user_id' => $sus['id'])));
        } else {
            $this->set('sus', '');
            $sessid = $this->Session->id();
            $citem = $this->Cart->find('all', array('conditions' => array('Cart.type <>' => 'G', 'sess_id' => $sessid)));
        }
        $this->set('cartcount', count($citem));
        $cnfg = Configure::read('Neutrino');
        $user_id = $sus["id"];

        //$orderDetails = $this->Order->findById($id);
        $shipping_cost = $orderdetails["shipping_price"];
        $shipping_form = "<input type='hidden' name='shipping' value='$shipping_cost'>";
        $tot_price = $orderdetails["total_price"] - $orderdetails["shipping_price"];
        $totaltopay = number_format($tot_price, 2, ".", "");
        $gtotal = number_format(($tot_price + $shipping_cost), 2, ".", "");
        $coupon_reduced_amt = $this->Session->read('orderforpayment');
        $this->set('totaltopay', $totaltopay);
        $this->set('oid', $id);
        //$this->set('totaltopay', number_format($tot_price,2,".",""));	 
        $taxamt = 0;
        if ($cnfg["taxto"] == "gtotal") {
            $taxableamt = $tot_price + $shipping_cost;
        } else {
            $taxableamt = $tot_price;
        }

        if ($cnfg["tax_option"] == "notax") {

            $taxperc = 0;

            $taxname = "No Tax is applicable";
        } elseif ($cnfg["tax_option"] == "fixedtax") {

            $taxperc = $cnfg["fixedtax_rate"];

            $taxname = $cnfg["fixedtax_name"];
        } else {

            if ($cnfg["taxable_address"] == "shipping") {
                $billadd = $this->UserAddress->find("first", array("conditions" => array("UserAddress.user_id" => $user_id, "UserAddress.addr_type" => 'Shipping')));
            } else {

                $billadd = $this->UserAddress->find("first", array("conditions" => array("UserAddress.user_id" => $user_id, "UserAddress.addr_type" => 'Billing')));
            }

            $stdetal = $this->State->find('State.country_id = "' . $billadd["UserAddress"]["country"] . '" AND State.code = "All"');

            if (!empty($stdetal["State"])) {

                $taxperc = $stdetal["State"]["tax_rate"];

                $taxname = $stdetal["State"]["tax_name"];
            } else {

                $stdetal = $this->State->find('State.country_id = "' . $billadd["UserAddress"]["country"] . '" AND State.code ="' . $billadd["UserAddress"]["state"] . '"');

                if (!empty($stdetal["State"])) {

                    $taxperc = $stdetal["State"]["tax_rate"];

                    $taxname = $stdetal["State"]["tax_name"];
                } else {

                    $stdetal = $this->State->find('State.country_id = "' . $billadd["UserAddress"]["country"] . '" AND State.name ="' . $billadd["UserAddress"]["state"] . '"');

                    if (!empty($stdetal["State"])) {

                        $taxperc = $stdetal["State"]["tax_rate"];

                        $taxname = $stdetal["State"]["tax_name"];
                    } else {

                        $taxperc = 0;

                        $taxname = "No Tax is applicable";
                    }
                }
            }
        }

        if ($tot_price > 0) {

            $taxamt = ($taxableamt * $taxperc) / 100;

            $taxamt = number_format($taxamt, 2, ".", "");

            $tot_price = $tot_price + $taxamt;
        }


        ######################### End of Section to find and add tax amount......................

        $this->set('taxamnt', $taxamt);
        if ($tot_price > 0)
            $gtotal = number_format(($tot_price + $shipping_cost), 2, ".", "");
        else
            $gtotal = number_format(0.00 + $shipping_cost, 2, ".", "");
        $paymentMethod = "CC";
        $this->set('taxamnt', $taxamt);
        $this->set('gtotal', $gtotal - $coupon_reduced_amt['reduced_amt']);
        $this->set('userid', $user_id);
        $this->set('paymentMethod', $paymentMethod);
        $this->set('shipping_cost', $shipping_cost);
        /* $billadd	=	$this->UserAddress->find("UserAddress.user_id =".$user_id." AND UserAddress.addr_type ='Billing'"); */
        $billadd = $this->UserAddress->find("first", array("conditions" => array("UserAddress.user_id" => $user_id, "UserAddress.addr_type" => 'Billing')));
        $txtAuthorizeEmail = $cnfg["authorize_email"];
        $txtAuthorizeTestMode = $cnfg["authorize_testmode"];
        $txtAuthorizeLoginId = $cnfg["authorize_loginid"];
        $txtAuthorizeTransKey = $cnfg["authorize_transactionkey"];
        $Company = "-NA-";
        $newinvid = $this->Order->getNewinvid();
        $txtEmail = $sus["email"];
        $curr = $this->Currency->findByCode($cnfg["currency"]);
        $this->set('curlogo', $curr["Currency"]["logo"]);
        if ($_SERVER['REQUEST_METHOD'] == 'POST' && !empty($orderdetails) && !empty($orderdetailsforpayment)) {
            $res = $this->Authorizepayment->authpay($billadd["UserAddress"], $txtEmail, $_POST["txtCCNumber"], $_POST["txtCVV2"], $_POST["txtMM"], $_POST["txtYY"], $txtAuthorizeLoginId, $txtAuthorizeTransKey, $cnfg["currency"], $_POST["cart_total"], $txtAuthorizeEmail, $Company, $user_id, $newinvid, $cnfg["site_name"], $txtAuthorizeTestMode);
            if ($res["status"] == 1) {
                $trans_id = $res["msg"];
                $id = $this->updateordetable($orderdetails, $orderdetailsforpayment);
                $this->__payorder($id, 'CC', $trans_id);
                $this->Session->setFlash('Your order has been successfully placed and an e-mail with order details has sent to your e-mail ID!', 'default', array('class' => 'success'));
                $this->redirect(array('controller' => 'orders', 'action' => 'userorderdetails/' . $id));
                exit;
            } else {
                $this->Session->setFlash($res["msg"]);
            }
        }
    }

    /*     * *********** Function to pay using bluepay************************************* */

    function bluepay($id = 0) {

        $orderdetails = $this->Session->read('orderforpayment');
        $orderdetailsforpayment = $this->Session->read('orderdetailsforpayment');

        if (empty($orderdetails) && empty($orderdetailsforpayment)) {
            $this->redirect(array('controller' => 'users', 'action' => "myaccount"));
            exit;
        }
        $this->__validateLoginStatus('U');
        $sus = $this->Session->read('Userlog');
        $this->set('sus', $sus);
        $cnfg = Configure::read('Neutrino');
        $user_id = $sus["id"];
        $orderDetails = $this->Order->findById($id);
        $shipping_cost = $orderdetails["shipping_price"];
        $shipping_form = "<input type='hidden' name='shipping' value='$shipping_cost'>";
        $tot_price = $orderdetails["total_price"] - $orderdetails["shipping_price"];
        $totaltopay = number_format($tot_price, 2, ".", "");
        $gtotal = number_format(($tot_price + $shipping_cost), 2, ".", "");
        $this->set('totaltopay', $totaltopay);
        $this->set('oid', $id);
        $this->set('totaltopay', number_format($tot_price, 2, ".", ""));
        $taxamt = 0;
        if ($cnfg["taxto"] == "gtotal") {
            $taxableamt = $tot_price + $shipping_cost;
        } else {
            $taxableamt = $tot_price;
        }

        if ($cnfg["tax_option"] == "notax") {

            $taxperc = 0;

            $taxname = "No Tax is applicable";
        } elseif ($cnfg["tax_option"] == "fixedtax") {

            $taxperc = $cnfg["fixedtax_rate"];

            $taxname = $cnfg["fixedtax_name"];
        } else {

            if ($cnfg["taxable_address"] == "shipping") {
                $billadd = $this->UserAddress->find("first", array("conditions" => array("UserAddress.user_id" => $user_id, "UserAddress.addr_type" => 'Billing')));
            } else {

                $billadd = $this->UserAddress->find('UserAddress.user_id = ' . $user_id . ' AND UserAddress.addr_type = "Billing"');
            }

            $stdetal = $this->State->find('State.country_id = "' . $billadd["UserAddress"]["country"] . '" AND State.code = "All"');

            if (!empty($stdetal["State"])) {

                $taxperc = $stdetal["State"]["tax_rate"];

                $taxname = $stdetal["State"]["tax_name"];
            } else {

                $stdetal = $this->State->find('State.country_id = "' . $billadd["UserAddress"]["country"] . '" AND State.code ="' . $billadd["UserAddress"]["state"] . '"');

                if (!empty($stdetal["State"])) {

                    $taxperc = $stdetal["State"]["tax_rate"];

                    $taxname = $stdetal["State"]["tax_name"];
                } else {

                    $stdetal = $this->State->find('State.country_id = "' . $billadd["UserAddress"]["country"] . '" AND State.name ="' . $billadd["UserAddress"]["state"] . '"');

                    if (!empty($stdetal["State"])) {

                        $taxperc = $stdetal["State"]["tax_rate"];

                        $taxname = $stdetal["State"]["tax_name"];
                    } else {

                        $taxperc = 0;

                        $taxname = "No Tax is applicable";
                    }
                }
            }
        }

        if ($tot_price > 0) {

            $taxamt = ($taxableamt * $taxperc) / 100;

            $taxamt = number_format($taxamt, 2, ".", "");

            $tot_price = $tot_price + $taxamt;
        }
//echo $tot_price;exit;
        ######################### End of Section to find and add tax amount......................
        $discountamt = $orderdetails["reduced_amt"];
        $tot_price = $tot_price - $discountamt;
        $this->set('taxamnt', $taxamt);
        if ($tot_price > 0)
            $gtotal = number_format(($tot_price + $shipping_cost), 2, ".", "");
        else
            $gtotal = number_format(0.00 + $shipping_cost, 2, ".", "");
        /////////////////////////////////////////////////////////////
        $paymentMethod = "CC";

        $this->set('totaltopay', $tot_price);

        $this->set('userid', $user_id);

        $this->set('paymentMethod', $paymentMethod);

        $this->set('shipping_cost', $shipping_cost);

        $billadd = $this->UserAddress->find("UserAddress.user_id =" . $user_id . " AND UserAddress.addr_type ='Billing'");

        #$txtUrPayDemo	=	"YES";

        $bp_testmode = $cnfg["bp_testmode"];
        if ($bp_testmode == "Y") {
            $bp_testmode = "TEST";
        } else {
            $bp_testmode = "LIVE";
        }

        $bp_secret = $cnfg["bp_secret"];

        $bp_account = $cnfg["bp_account"];




        # BILLING INFO 4111111111111111

        $bad = $billadd["UserAddress"];

        $txtEmail = $sus["email"];


        ############################################

        $Company = "-NA-";
//echo $_POST["cart_total"];exit;
        //$newinvid					=	$this->Order->getNewinvid();

        $curr = $this->Currency->findByCode($cnfg["currency"]);

        $this->set('curlogo', $curr["Currency"]["logo"]);

        if ($_SERVER['REQUEST_METHOD'] == 'POST') {

            $cardNumber = urlencode($_POST["txtCCNumber"]);

            $myorder["cardexpmonth"] = $_POST["txtMM"];


            $expireMonthYear = $_POST["txtMM"] . substr($_POST["txtYY"], -2);
            $cardExpire = $expireMonthYear;
            //echo $cardExpire;exit;
            $myorder["chargetotal"] = urlencode($_POST["cart_total"]);
            /*             * ******* Section to post data into bluepay*********************************** */
            $this->Bluepay->setValue("ACCOUNT_ID", $bp_account);       # Johns account id -> 100036521127
            $this->Bluepay->setValue("SECRET_KEY", $bp_secret);  # Johns Secret key -> ROQYX69Y6CYPXXZ2DRFOCAF.EGCS0CDK 
            $this->Bluepay->setValue("TRANS_TYPE", 'SALE');
            $this->Bluepay->setValue("MODE", $bp_testmode);         # Default is TEST --> Set to LIVE for live tx
            $this->Bluepay->setValue("AMOUNT", $_POST["cart_total"]);          # ODD returns Approved, EVEN returns Declined in TEST mode
            $this->Bluepay->setValue("PAYMENT_ACCOUNT", $cardNumber);      # VISA Test Card
            $this->Bluepay->setValue("CARD_EXPIRE", $cardExpire);
            $this->Bluepay->setValue("NAME1", $bad["fname"]);
            $this->Bluepay->setValue("NAME2", $bad["lname"]);
            $this->Bluepay->setValue("PHONE", $bad["phone"]);
            $this->Bluepay->setValue("EMAIL", $sus["email"]);
            $this->Bluepay->setValue("COMPANY_NAME", 'NA');
            $tamperProofSeal = md5($bp_secret . $bp_account . $_POST["cart_total"] . $bp_testmode);
            $this->Bluepay->setValue("TAMPER_PROOF_SEAL", $tamperProofSeal);
            $this->Bluepay->setValue("ADDR1", $bad["address"]);
            $this->Bluepay->setValue("CITY", $bad["city"]);
            $this->Bluepay->setValue("STATE", $bad["state"]);
            $this->Bluepay->setValue("ZIP", $bad["zip"]);
            $this->Bluepay->setValue("COUNTRY", $bad["country"]);
            /*
              // Rebilling Section [ Start ]
              $bp->setValue("DO_REBILL",'1');  					# value 1 for rebilling 0 or not set for no-rebilling
              $bp->setValue("REB_FIRST_DATE",'2010-07-23');		# Date and time of first rebilling to run, in ISO format (YYYY-MM-DD HH:MM:SS),Time portion is optional.will default to midnight of the date specified
              $bp->setValue("REB_EXPR",'1 MONTH');				# How often to run rebilling eg :"1 MONTH" to run monthly
              $bp->setValue("REB_AMOUNT",'201.00');				# Optional.  How much to charge when rebillings are run. Defaults to amount of transaction being run.
              // Rebilling Section [ END ]
             */
            $this->Bluepay->bp20post($bp_testmode);

            /*             * ******* Section to post data into bluepay*********************************** */
            /*             * ********** Section to return the result************** */
            $status = $this->Bluepay->getValue("STATUS");
            $message = $this->Bluepay->getValue("MESSAGE");

            //echo $status."<br>".$avs."<br>".$cvv2."<br>".$authcode."<br>".$message."<br>".$rebid;exit();
            /*             * ********** Section to return the result************** */

            if ($status == "E") {

                $paymentsuccessful = false;

                $paymenterror = "Error";

                $paymenterror = $message;
                $this->Session->setFlash($paymenterror, 'default', array('class' => 'failure'));
            } else {

                $transactionid = $this->Bluepay->getValue("TRANS_ID");
                $avs = $this->Bluepay->getValue("AVS");
                $cvv2 = $this->Bluepay->getValue("CVV2");
                $authcode = $this->Bluepay->getValue("AUTH_CODE");
                $rebid = $this->Bluepay->getValue("REBID");

                if ($status <> 1) { // transaction failed, print the reason

                    $paymentsuccessful = false;

                    $paymenterror = "Error";


                    $paymenterror = $message;

                    $this->Session->setFlash($paymenterror, 'default', array('class' => 'failure'));
                } else { // success
                    $paymentsuccessful = true;

                    $transactionid = $transactionid;
                    $id = $this->updateordetable($orderdetails, $orderdetailsforpayment);
                    $this->__payorder($id, 'Blue Pay', $trans_id);
                    $this->Session->setFlash('Your order has been successfully placed and an e-mail with order details has sent to your e-mail ID!', 'default', array('class' => 'success'));
                    $this->redirect(array('controller' => 'orders', 'action' => 'userorderdetails/' . $id));
                    exit;
                }
            }
        }
        ////////////////////////////////////////////////////////////
    }

    /*     * *********** Function to pay using Yourpay************************************* */

    function yourpay($id = 0) {
        $orderdetails = $this->Session->read('orderforpayment');
        $orderdetailsforpayment = $this->Session->read('orderdetailsforpayment');

        if (empty($orderdetails) && empty($orderdetailsforpayment)) {
            $this->redirect(array('controller' => 'users', 'action' => "myaccount"));
            exit;
        }
        $this->__validateLoginStatus('U');
        $sus = $this->Session->read('Userlog');
        $this->set('sus', $sus);
        $cnfg = Configure::read('Neutrino');
        $user_id = $sus["id"];

        $shipping_cost = $orderdetails["shipping_price"];
        $shipping_form = "<input type='hidden' name='shipping' value='$shipping_cost'>";
        $tot_price = $orderdetails["total_price"] - $orderdetails["shipping_price"];
        $totaltopay = number_format($tot_price, 2, ".", "");
        $gtotal = number_format(($tot_price + $shipping_cost), 2, ".", "");
        $this->set('totaltopay', $totaltopay);
        $this->set('oid', $id);
        $this->set('totaltopay', number_format($tot_price, 2, ".", ""));
        $taxamt = 0;
        if ($cnfg["taxto"] == "gtotal") {
            $taxableamt = $tot_price + $shipping_cost;
        } else {
            $taxableamt = $tot_price;
        }

        if ($cnfg["tax_option"] == "notax") {

            $taxperc = 0;

            $taxname = "No Tax is applicable";
        } elseif ($cnfg["tax_option"] == "fixedtax") {

            $taxperc = $cnfg["fixedtax_rate"];

            $taxname = $cnfg["fixedtax_name"];
        } else {

            if ($cnfg["taxable_address"] == "shipping") {
                $billadd = $this->UserAddress->find("first", array("conditions" => array("UserAddress.user_id" => $user_id, "UserAddress.addr_type" => 'Billing')));
            } else {

                $billadd = $this->UserAddress->find('UserAddress.user_id = ' . $user_id . ' AND UserAddress.addr_type = "Billing"');
            }

            $stdetal = $this->State->find('State.country_id = "' . $billadd["UserAddress"]["country"] . '" AND State.code = "All"');

            if (!empty($stdetal["State"])) {

                $taxperc = $stdetal["State"]["tax_rate"];

                $taxname = $stdetal["State"]["tax_name"];
            } else {

                $stdetal = $this->State->find('State.country_id = "' . $billadd["UserAddress"]["country"] . '" AND State.code ="' . $billadd["UserAddress"]["state"] . '"');

                if (!empty($stdetal["State"])) {

                    $taxperc = $stdetal["State"]["tax_rate"];

                    $taxname = $stdetal["State"]["tax_name"];
                } else {

                    $stdetal = $this->State->find('State.country_id = "' . $billadd["UserAddress"]["country"] . '" AND State.name ="' . $billadd["UserAddress"]["state"] . '"');

                    if (!empty($stdetal["State"])) {

                        $taxperc = $stdetal["State"]["tax_rate"];

                        $taxname = $stdetal["State"]["tax_name"];
                    } else {

                        $taxperc = 0;

                        $taxname = "No Tax is applicable";
                    }
                }
            }
        }

        if ($tot_price > 0) {

            $taxamt = ($taxableamt * $taxperc) / 100;

            $taxamt = number_format($taxamt, 2, ".", "");

            $tot_price = $tot_price + $taxamt;
        }
//echo $tot_price;exit;
        ######################### End of Section to find and add tax amount......................

        $this->set('taxamnt', $taxamt);
        if ($tot_price > 0)
            $gtotal = number_format(($tot_price + $shipping_cost), 2, ".", "");
        else
            $gtotal = number_format(0.00 + $shipping_cost, 2, ".", "");
        /////////////////////////////////////////////////////////////
        $totaltopay = number_format($tot_price, 2, ".", "");

        $gtotal = number_format(($tot_price + $shipping_cost), 2, ".", "");

        $paymentMethod = "CC";

        $this->set('totaltopay', $totaltopay);

        $this->set('userid', $user_id);

        $this->set('paymentMethod', $paymentMethod);

        $this->set('shipping_cost', $shipping_cost);

        $billadd = $this->UserAddress->find("UserAddress.user_id =" . $user_id . " AND UserAddress.addr_type ='Billing'");

        #$txtUrPayDemo	=	"YES";

        $txtUrPayDemo = $cnfg["yourpay_testmod"];

        $txtYourpayStoreId = $cnfg["yourpay_storeid"];

        #$txtYourpayStoreId     = "123" ;

        $pemfolder = $cnfg["yourpay_certificate_file"];

        //$myorder["host"]       	= "secure.linkpt.net";

        $myorder["port"] = "1129";

        $myorder["keyfile"] = IMAGES . $pemfolder;

        #$myorder["keyfile"]    = IMAGES."1211447989_1001168167.pem"; # Change this to the name and location of your certificate file

        $myorder["configfile"] = urlencode($txtYourpayStoreId);        # Change this to your store number

        $myorder["ordertype"] = "SALE";

        if ($txtUrPayDemo == "YES") {
            $myorder["host"] = "staging.linkpt.net";
            $myorder["result"] = "GOOD"; # For a test, set result to GOOD, DECLINE, or DUPLICATE
        } else {
            $myorder["host"] = "secure.linkpt.net";
            $myorder["result"] = "LIVE";
        }





        # BILLING INFO 4111111111111111

        $bad = $billadd["UserAddress"];

        $txtEmail = $sus["email"];

        $myorder["name"] = urlencode($bad["fname"]) . " " . urlencode($bad["lname"]);

        $myorder["company"] = "-NA-";

        $myorder["address1"] = urlencode($bad["address"]);

        $myorder["city"] = urlencode($bad["city"]);

        $myorder["state"] = urlencode($bad["state"]);

        $myorder["country"] = urlencode($bad["zip"]);

        $myorder["phone"] = urlencode($bad["country"]);

        $myorder["email"] = urlencode($txtEmail);
        $myorder["addrnum"] = "125";   # Required for AVS. The numeric portion of the street address If not provided, transactions will downgrade.
        ############################################

        $Company = "-NA-";

        $newinvid = $this->Order->getNewinvid();

        $curr = $this->Currency->findByCode($cnfg["currency"]);

        $this->set('curlogo', $curr["Currency"]["logo"]);
////////////////////////////////////////////////////////////////////
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {

            $myorder["cardnumber"] = urlencode($_POST["txtCCNumber"]);

            $myorder["cardexpmonth"] = $_POST["txtMM"];

            $myorder["cardexpyear"] = $_POST["txtYY"];

            $myorder["chargetotal"] = urlencode($_POST["cart_total"]);

            $result = $this->Yourpay->curl_process($myorder);  # use curl methods
            ///////////////////
            if ($result["r_approved"] != "APPROVED") { // transaction failed, print the reason
                $paymentsuccessful = false;
                $paymenterror = "Error: " . $result["r_error"];
                $this->Session->setFlash($paymenterror, 'default', array('class' => 'failure'));
            } else { // success
                $paymentsuccessful = true;
                $transactionid = $result["r_ordernum"];
                $transactionid = $transactionid;
                $id = $this->updateordetable($orderdetails, $orderdetailsforpayment);
                $this->__payorder($id, 'YourPay', $transactionid);
                $this->Session->setFlash('Your order has been successfully placed and an e-mail with order details has sent to your e-mail ID!', 'default', array('class' => 'success'));
                $this->redirect(array('controller' => 'orders', 'action' => 'userorderdetails/' . $id));
                exit;
            }
            /////////////////
        }
//////////////////////////////////////////////////////////////////////
    }

    //////////// Function for World Pay....................................
    function worldpay($id = 0) {
        $orderdetails = $this->Session->read('orderforpayment');
        $orderdetailsforpayment = $this->Session->read('orderdetailsforpayment');

        if (empty($orderdetails) && empty($orderdetailsforpayment)) {
            $this->redirect(array('controller' => 'users', 'action' => "myaccount"));
            exit;
        }
        $this->__validateLoginStatus('U');
        $sus = $this->Session->read('Userlog');
        $this->set('sus', $sus);
        $cnfg = Configure::read('Neutrino');
        $worldpaytestmode = $cnfg["worldpay_testmode"];

        $Instid = $cnfg["worldpay_inst_Id"];

        $worldpayEmail = $cnfg["worldpay_email"];

        $worldauthmode = $cnfg["worldpay_transact_method"];



        switch ($worldpaytestmode) {

            case "100":

                $worldpayserver = "https://select-test.worldpay.com/wcc/purchase";

                break;



            case "0":

                $worldpayserver = "https://select.worldpay.com/wcc/purchase";

                break;



            default:

                $worldpayserver = "https://select.worldpay.com/wcc/purchase";

                break;
        }

        //$referrer 	`			=  	$_SERVER["HTTP_REFERER"];




        $user_id = $sus["id"];
        $umail = $sus["email"];
        $orderDetails = $this->Order->findById($id);
        $shippingMethod = $orderdetails["shipping_method"];
        $shippingServ = $orderdetails["shipping_service"];
        $shipping_cost = $orderdetails["shipping_price"];
        $shipping_form = "<input type='hidden' name='shipping' value='$shipping_cost'>";
        $tot_price = $orderdetails["total_price"] - $orderdetails["shipping_price"];
        /////////// Section for Tax888888888888888
        $taxamt = 0;
        if ($cnfg["taxto"] == "gtotal") {
            $taxableamt = $tot_price + $shipping_cost;
        } else {
            $taxableamt = $tot_price;
        }
        $billaddsu = $this->UserAddress->find('UserAddress.user_id = ' . $user_id . ' AND UserAddress.addr_type = "Billing"');
        if ($cnfg["tax_option"] == "notax") {

            $taxperc = 0;

            $taxname = "No Tax is applicable";
        } elseif ($cnfg["tax_option"] == "fixedtax") {

            $taxperc = $cnfg["fixedtax_rate"];

            $taxname = $cnfg["fixedtax_name"];
        } else {

            if ($cnfg["taxable_address"] == "shipping") {
                $billadd = $this->UserAddress->find("first", array("conditions" => array("UserAddress.user_id" => $user_id, "UserAddress.addr_type" => 'Billing')));
            } else {

                $billadd = $this->UserAddress->find('UserAddress.user_id = ' . $user_id . ' AND UserAddress.addr_type = "Billing"');
            }

            $stdetal = $this->State->find('State.country_id = "' . $billadd["UserAddress"]["country"] . '" AND State.code = "All"');

            if (!empty($stdetal["State"])) {

                $taxperc = $stdetal["State"]["tax_rate"];

                $taxname = $stdetal["State"]["tax_name"];
            } else {

                $stdetal = $this->State->find('State.country_id = "' . $billadd["UserAddress"]["country"] . '" AND State.code ="' . $billadd["UserAddress"]["state"] . '"');

                if (!empty($stdetal["State"])) {

                    $taxperc = $stdetal["State"]["tax_rate"];

                    $taxname = $stdetal["State"]["tax_name"];
                } else {

                    $stdetal = $this->State->find('State.country_id = "' . $billadd["UserAddress"]["country"] . '" AND State.name ="' . $billadd["UserAddress"]["state"] . '"');

                    if (!empty($stdetal["State"])) {

                        $taxperc = $stdetal["State"]["tax_rate"];

                        $taxname = $stdetal["State"]["tax_name"];
                    } else {

                        $taxperc = 0;

                        $taxname = "No Tax is applicable";
                    }
                }
            }
        }

        if ($tot_price > 0) {

            $taxamt = ($taxableamt * $taxperc) / 100;

            $taxamt = number_format($taxamt, 2, ".", "");

            $tot_price = $tot_price + $taxamt;
        }


        ######################### End of Section to find and add tax amount......................
        $totaltopay = number_format($tot_price, 2, ".", "");
        $gtotal = number_format(($tot_price + $shipping_cost), 2, ".", "");

        ///////////////////////////////////////////////////
        //print_r($billaddsu);exit;
        $this->set('taxamt', $taxamt);

        $this->set('taxname', $taxname);

        $this->set('address', $billaddsu["UserAddress"]);

        $this->set('cartAmount', $totaltopay);

        $this->set('Shipmethod', $shippingMethod);

        $this->set('Shipcost', $shipping_cost);

        $this->set('Shipservice', $shippingServ);

        $this->set('worldpayserver', $worldpayserver);

        $this->set('worldpaytestmode', $worldpaytestmode);

        $this->set('shipping_form', $shipping_form);

        $this->set('shipping_cost', $shipping_cost);

        $this->set('umail', $umail);

        $this->set('user_id', $user_id);

        $this->set('Instid', $Instid);

        $this->set('cnfg', $cnfg);
        $this->set('oid', $id);
    }

    function worldpayback($id = 0) {

        if ($_REQUEST["transStatus"] == "Y") {

            $user_id = $_REQUEST["cartId"];

            $usr = $this->User->findById($user_id);
            $transactionid = $_REQUEST["transactionId"];
            $id = $this->updateordetable($orderdetails, $orderdetailsforpayment);
            $this->__payorder($id, 'WorldPay', $transactionid);
            $this->Session->setFlash('<font color=#009900>Your order has been successfully placed and an e-mail with order details has sent to your e-mail ID!!</font>');
            $this->Session->setFlash('Your order has been successfully placed and an e-mail with order details has sent to your e-mail ID!', 'default', array('class' => 'success'));
            $this->redirect(array('controller' => 'orders', 'action' => 'userorderdetails/' . $id));
            exit;
        } else {

            $this->Session->setFlash('Payment Failure! <br> Your order can not be processed !<br> Try again!', 'default', array('class' => 'failure'));
            $this->redirect('/index.php');

            exit;
        }
    }

    function payreports() {
        $this->__validateLoginStatus();
        $admsess = $this->Session->read('Admin');
        if ($admsess["orders"] <> 1) {
            $this->redirect(array('controller' => 'admins', 'action' => 'index'));
            exit();
        }

        $sales_min_date = explode(" ", $this->Order->getSalesDates("min"));
        $sales_max_date = explode(" ", $this->Order->getSalesDates("max"));
        $this->set('dflt_mindate', $sales_min_date[0]); //Setting the max date for the calendar...
        $this->set('dflt_maxdate', $sales_max_date[0]); //Setting the max date for the calendar...

        if (isset($_POST["sales_fdate"]) && isset($_POST["sales_fdate"]) && $_POST["sales_tdate"] <> '' && $_POST["sales_tdate"] <> '') {
            $frmdate = $_POST["sales_fdate"];
            $todate = $_POST["sales_tdate"];
        } else if (isset($this->passedArgs["frmdate"]) && isset($this->passedArgs["todate"]) &&
                $this->passedArgs["frmdate"] <> '' && $this->passedArgs["todate"] <> '') {
            $frmdate = $this->passedArgs["frmdate"];
            $todate = $this->passedArgs["todate"];
        } else if ($sales_min_date[0] <> '' && $sales_max_date[0] <> '') {
            $frmdate = $sales_min_date[0];
            $todate = $sales_max_date[0];
        } else {
            $frmdate = date("m-d-Y", strtotime("-1 month", time()));
            $todate = date("m-d-Y");
        }
        //$cttbl=$this->Report->getTableName("users");
        $reportdet = array();


        $sdate = explode('-', $frmdate);
        $srch_fdate = $sdate[2] . '-' . $sdate[0] . '-' . $sdate[1];
        $tdate = explode('-', $todate);
        $srch_tdate = $tdate[2] . '-' . $tdate[0] . '-' . $tdate[1];

        //getting table names...

        $ordtbl = $this->Order->getTableName("orders");
        $usrtbl = $this->Order->getTableName("users");

        //getting table names...		

        $this->paginate = array(
            'conditions' => array("DATE_FORMAT(Order.pay_date,'%Y-%m-%d')>= '" . $srch_fdate . "' AND  DATE_FORMAT(Order.pay_date,'%Y-%m-%d') <= '" . $srch_tdate . "' AND Order.order_status_id >= 6 AND Order.pay_date != '0000-00-00' "),
            'fields' => array("Order.id,Order.date,User.uname,Order.total_price, Order.payment_method, DATE_FORMAT(Order.pay_date,'%Y-%m-%d'), Order.transaction_id"),
            'order' => 'Order.pay_date DESC',
            'limit' => $this->paginate["limit"],
            'group' => '',
            'passit' => $this->passedArgs
        );


        $reportdet = $this->paginate('Order');
        $this->set('reportdet', $reportdet);
        $this->set('mindate', $frmdate);
        $this->set('maxdate', $todate);
        $this->passedArgs['limit'] = $this->paginate["limit"];
        $this->set('passedarg', $this->passedArgs);
        $this->layout = 'adm';
    }

    function paysalesxls($frmdate = '', $todate = '') {
        //getting table names...
        $ordtbl = $this->Order->getTableName("orders");
        $usrtbl = $this->Order->getTableName("users");
        //getting table names...		

        $sdate = explode('-', $frmdate);
        $srch_fdate = $sdate[2] . '-' . $sdate[0] . '-' . $sdate[1];
        $tdate = explode('-', $todate);
        $srch_tdate = $tdate[2] . '-' . $tdate[0] . '-' . $tdate[1];

        $this->paginate = array(
            'conditions' => array("Order.order_status_id >= 6 AND DATE_FORMAT(Order.date,'%Y-%m-%d')>= '" . $srch_fdate . "' AND  
			DATE_FORMAT(Order.date,'%Y-%m-%d') <= '" . $srch_tdate . "' AND Order.order_status_id >= 6 AND Order.pay_date != '0000-00-00' "),
            'fields' => array("Order.id,Order.date,User.uname,Order.total_price, Order.payment_method, DATE_FORMAT(Order.pay_date,'%Y-%m-%d') AS paydate, Order.transaction_id"),
            'order' => 'Order.pay_date DESC',
            'limit' => 10000,
            'group' => ''
        );

        $reportdet = $this->paginate('Order');
        $tot_cnt = count($reportdet);
        //echopre1($reportdet);
        $this->set('data', $reportdet);
        $this->layout = 'csvexp';
    }

    function paysalescsv($frmdate = '', $todate = '') {
        //getting table names...
         $ordtbl = $this->Order->getTableName("orders");
        $usrtbl = $this->Order->getTableName("users");
        //getting table names...		

        $sdate = explode('-', $frmdate);
        $srch_fdate = $sdate[2] . '-' . $sdate[0] . '-' . $sdate[1];
        $tdate = explode('-', $todate);
        $srch_tdate = $tdate[2] . '-' . $tdate[0] . '-' . $tdate[1];

        $this->paginate = array(
            'conditions' => array("Order.order_status_id >= 6 AND DATE_FORMAT(Order.date,'%Y-%m-%d')>= '" . $srch_fdate . "' AND  
			DATE_FORMAT(Order.date,'%Y-%m-%d') <= '" . $srch_tdate . "' AND Order.order_status_id >= 6 AND Order.pay_date != '0000-00-00' "),
            'fields' => array("Order.id,Order.date,User.uname,Order.total_price, Order.payment_method, DATE_FORMAT(Order.pay_date,'%Y-%m-%d') AS paydate, Order.transaction_id"),
            'order' => 'Order.pay_date DESC',
            'limit' => 10000,
            'group' => ''
        );

        $reportdet = $this->paginate('Order');
        $tot_cnt = count($reportdet);
        $this->set('data', $reportdet);
        $this->layout = 'csvexp';
    }

    //--------------------------Print Image-------------------------------//
    function printimages($savID, $orderId) {
        Configure::write('debug', 0);
        $imgArr       = $this->Savedimage->findById($savID);
        $orderdetails = $this->Order->findById($orderId);

        //echopre1($orderdetails);

        $order_status = $orderdetails['OrderStatus']['name'];
        
        $this->set('order_status',$order_status);

        $customInfo = $this->OrderDetail->findCustomInfo($savID);

        $images = $this->Savedimage->findAllByRefName($imgArr['Savedimage']['ref_name']);
        $productetails = $imgArr['Savedimage'];
        $productDetId = $productetails['productdetails_id'];
        $prodArr = $this->Productdetail->findById($productDetId);

        // print_r($prodArr);
        $this->set('prodArr', $prodArr);
        //-----------fix to fill front/rear images in only 1 is present-------------//
        $this->Customimage->resetTable($images[0]['Savedimage']['users_id'], $productDetId);

        //-------------------------------------------------------------------------//
        $admsess = $this->Session->read('Admin');
        if ($admsess["orders"] == 1)
            $this->set('isAdmin', 1);
        else
            $this->set('isAdmin', 0);
        //-------------generate image for unsaved sides of images--------------//
        $imageArray = $this->Customimage->removeTemp($images[0]['Savedimage']['users_id']);
        if ($imageArray != '') {
            $temp = explode("@@", $imageArray);
            foreach ($temp as $tempval) {
                if ($tempval != '') {
                    $temp2 = explode("<>", $tempval);
                    $editedImg = $this->Customize->index($temp2[2]);
                    $this->Customize->addText($temp2[0]);
                    $this->Customize->addImage($temp2[1]);

                    //--------------------foreground image-----------------//
                    $editedImg_blank = $this->Customize->index("blank.png", true);
                    $this->Customize->addText($temp2[0]);
                    $this->Customize->addImage($temp2[1]);

                    if ($temp2[0] == ' ' && $temp2[1] == ' ') {
                        copy(WWW_ROOT . IMAGES_URL . $temp2[2], WWW_ROOT . IMAGES_URL . $editedImg);
                        copy(WWW_ROOT . IMAGES_URL . "blank.png", WWW_ROOT . IMAGES_URL . $editedImg_blank);
                    }

                    $this->Customimage->updateSaveImage($editedImg, $editedImg_blank, $temp2[3]);
                    unset($editedImg, $editedImg_blank, $temp2);
                }
            }
        }

        $images_new = $this->Savedimage->findAllByRefName($imgArr['Savedimage']['ref_name']);

        //echopre1($images_new);
        $prdoDetId = $images_new[0]['Savedimage']['productdetails_id'];
        // $sideType = $this->Order->FindSideType($productDetId); 
        //print_r($sideType);

        foreach ($images_new as $key => $val) {

            $img[$val['Savedimage']['type']]['img'] = $val['Savedimage']['image'];
            $img[$val['Savedimage']['type']]['fore'] = $val['Savedimage']['foreground_image'];
        }

        if ($prodArr['Productdetail']['doublesided'] == 'N') {
            unset($img['Rear']);
        }

        //  $img['doublesided'] = $prodArr['Productdetail']['doublesided'];
        //  print_r($img);
        $this->set('images', $img);
        $this->set('savID', $savID);
        $this->set('orderId', $orderId);
        $this->set('imagesRef', $imgArr['Savedimage']['ref_name']);
        $this->set('customInfo', json_decode($customInfo['custom_information']));
        $this->layout = 'ajax';
    }

    function downloadimages($imagePath) {
        $imagePath = str_replace("@$@$", "/", $imagePath);

        $fileinfo = pathinfo($imagePath);
        if (!file_exists(WWW_ROOT . IMAGES_URL . "TIFF/" . $fileinfo['filename'] . ".tif")) {
            //----------shell command for imagemagick---------------------//
            $exec = "convert -resize 1024x1024 " . WWW_ROOT . IMAGES_URL . $imagePath . " " . WWW_ROOT . IMAGES_URL . "TIFF/" . $fileinfo['filename'] . ".tif";
            system($exec, $err);
        }

        $tifPath = IMAGES_URL . "TIFF/" . $fileinfo['filename'] . ".tif";
        $this->Download->downloadFile($tifPath);
        exit;
    }

    function downloadforeground($imagePath, $type, $imagesRef, $orderId) {
        $cnfg = Configure::read('Neutrino');

        $imagePath = str_replace("@$@$", "/", $imagePath);
        $imagesArray = $this->Savedimage->findAllByRefName($imagesRef);
        //$fileinfo    = pathinfo($imagePath); 
        if (!file_exists(WWW_ROOT . IMAGES_URL . "customized_tshirts_foreground/" . $fileinfo['basename'])) {
            echo "No customizations to download!";
            exit;
        }

        $tifPath = array();
        if (count($imagesArray) > 0) {
            foreach ($imagesArray as $imageData) {

                $fileinfo = pathinfo($imageData['Savedimage']['foreground_image']);
                $imageToConvert = IMAGES_URL . "TIFF/design_" . $imageData['Savedimage']['id'] . "_" . $imageData['Savedimage']['type'];

                if ($type == "tiff") {
                    @unlink(WWW_ROOT . $imageToConvert . ".tif");
                    if (!file_exists(WWW_ROOT . $imageToConvert . ".tif")) {

                        $jpeganme = time() . rand(1000, 100000) . '.jpg';

                        $exec = "convert -resample 300 " . WWW_ROOT . IMAGES_URL . "customized_tshirts_foreground/" . $fileinfo['basename'] . " -background white -flatten " . WWW_ROOT . IMAGES_URL . 'TIFF/' . $jpeganme;
                        system($exec, $err);


                        //----------shell command for imagemagick---------------------//
                        $exec = "convert -resample 300 " . WWW_ROOT . IMAGES_URL . 'TIFF/' . $jpeganme . " -background white -flatten " . WWW_ROOT . $imageToConvert . ".tif";
                        system($exec, $err);
                        $exec = "convert -resize 1024x1024 " . WWW_ROOT . $imageToConvert . ".tif " . WWW_ROOT . $imageToConvert . ".tif";
                        system($exec, $err);

                        $exec = "convert  " . WWW_ROOT . $imageToConvert . ".tif -set units PixelsPerInch -density 300 " . WWW_ROOT . $imageToConvert . ".tif";
                        system($exec, $err);

                        @unlink(WWW_ROOT . IMAGES_URL . 'TIFF/' . $jpeganme);
                    }
                    $tifPath[] = $imageToConvert . ".tif";
                } elseif ($type == "pdf") {
                    if (!file_exists(WWW_ROOT . $imageToConvert . ".pdf")) {
                        //----------shell command for imagemagick---------------------//
                        $exec = "convert -resample 300 " . WWW_ROOT . IMAGES_URL . "customized_tshirts_foreground/" . $fileinfo['basename'] . " " . WWW_ROOT . $imageToConvert . ".pdf";
                        system($exec, $err);
                        $exec = "convert -resize 1024x1024 " . WWW_ROOT . $imageToConvert . ".pdf " . WWW_ROOT . $imageToConvert . ".pdf";
                        system($exec, $err);
                    }
                    $tifPath[] = $imageToConvert . ".pdf";
                } elseif ($type == "eps") {
                    if (file_exists(WWW_ROOT . $imageToConvert . ".eps")) {
                        unlink(WWW_ROOT . $imageToConvert . ".eps");
                    }
                    if (!file_exists(WWW_ROOT . $imageToConvert . ".eps")) {

                        $exec = "convert " . WWW_ROOT . IMAGES_URL . "customized_tshirts_foreground/" . $fileinfo['basename'] . " -resize 1024x1024 -density 500 -units pixelsperinch -quality 100 -compress none -alpha set -colorspace rgb -fuzz 10% -transparent white -flatten -background none -depth 8 eps3:" . WWW_ROOT . $imageToConvert . ".eps";

                        system($exec, $err);
                    }

                    $tifPath[] = $imageToConvert . ".eps";
                } elseif ($type == "png") {
                    if (!file_exists(WWW_ROOT . $imageToConvert . ".png")) {
                        //----------shell command for imagemagick---------------------//
                        $exec = "convert -resample 300 " . WWW_ROOT . IMAGES_URL . "customized_tshirts_foreground/" . $fileinfo['basename'] . " " . WWW_ROOT . $imageToConvert . ".png";
                        system($exec, $err);
                        $exec = "convert -resize 1024x1024 " . WWW_ROOT . $imageToConvert . ".png " . WWW_ROOT . $imageToConvert . ".png";
                        system($exec, $err);
                    }
                    $tifPath[] = $imageToConvert . ".png";
                } elseif ($type == "jpg") {
                    if (!file_exists(WWW_ROOT . $imageToConvert . ".jpg")) {
                        //----------shell command for imagemagick---------------------//
                        $exec = "convert -resample 300 " . WWW_ROOT . IMAGES_URL . "customized_tshirts_foreground/" . $fileinfo['basename'] . " -background white -flatten " . WWW_ROOT . $imageToConvert . ".jpg";
                        system($exec, $err);
                        $exec = "convert -resize 1024x1024 " . WWW_ROOT . $imageToConvert . ".jpg " . WWW_ROOT . $imageToConvert . ".jpg";
                        system($exec, $err);
                    }
                    $tifPath[] = $imageToConvert . ".jpg";
                } elseif ($type == "svg") {
                    /*                     * * for backword Svg Download if Autotracing not worked out well ***** */
                    if (file_exists(WWW_ROOT . $imageToConvert . ".svg")) {
                        unlink(WWW_ROOT . $imageToConvert . ".svg");
                    }
                    /*                     * * for backword Svg Download if Autotracing not worked out well ***** */
                    if (!file_exists(WWW_ROOT . $imageToConvert . ".svg")) {

                        if ($cnfg['autotracing'] == "YES") {
                            $exec = "convert -resample 300 " . WWW_ROOT . IMAGES_URL . "customized_tshirts_foreground/" . $fileinfo['basename'] . " " . WWW_ROOT . $imageToConvert . ".png";
                            system($exec, $err);
                            $exec = "convert -resize 1024x1024 " . WWW_ROOT . $imageToConvert . ".png " . WWW_ROOT . $imageToConvert . ".png";
                            system($exec, $err);
                            system("/usr/bin/autotrace --input-format=png --output-file=" . WWW_ROOT . $imageToConvert . ".svg --dpi=300 --color-count=16 --despeckle-level=10 --despeckle-tightness=5 --corner-always-threshold=60 --line-threshold=0.1 --width-weight-factor=0.1 --line-reversion-threshold=0.1 --preserve-width --remove-adjacent-corners " . WWW_ROOT . $imageToConvert . ".png");
                        } else {

                            if (!file_exists($src = WWW_ROOT . IMAGES_URL . "customized_tshirts_foreground/" . $fileinfo['filename'] . ".svg")) {
                                $exec = "convert " . WWW_ROOT . IMAGES_URL . "customized_tshirts_foreground/" . $fileinfo['basename'] . " " . WWW_ROOT . $imageToConvert . ".svg";
                                system($exec, $err);
                            } else {
                                @copy($src, WWW_ROOT . $imageToConvert . ".svg");
                            }
                        }
                    }
                    $tifPath[] = $imageToConvert . ".svg";
                }
            }
            //echopre1($tifPath);
            $zipfilename = "order_" . $orderId . "_design_" . $type;
            $zipObject = new ZipdirectoryclassComponent();

            foreach ($tifPath as $key => $value) {
                $filelocation = str_replace("img/TIFF/", $zipfilename . "/", $value);
                $zipObject->add_file($value, $filelocation);
            }
            header("Content-type: application/octet-stream");
            header("Content-disposition: attachment; filename=$zipfilename.zip");
            echo $zipObject->file();
        }
        //$this->Download->downloadFile($tifPath);
        exit;
    }

    function downloadforeground_single($imagePath, $type) {
        $cnfg = Configure::read('Neutrino');
        $imagePath = str_replace("@$@$", "/", $imagePath);

        $fileinfo = pathinfo($imagePath);
        if (!file_exists(WWW_ROOT . IMAGES_URL . "customized_tshirts_foreground/" . $fileinfo['basename'])) {
            echo "No customizations to download!";
            exit;
        }
        if ($type == "tiff") {
            @unlink(WWW_ROOT . IMAGES_URL . "TIFF/fore_" . $fileinfo['filename'] . ".tif");
            if (!file_exists(WWW_ROOT . IMAGES_URL . "TIFF/fore_" . $fileinfo['filename'] . ".tif")) {
                //----------shell command for imagemagick---------------------//

                $jpeganme = time() . rand(1000, 100000) . '.jpg';
                //  echo WWW_ROOT.IMAGES_URL."customized_tshirts_foreground/".$fileinfo['basename']; exit;
                $exec = "convert -resample 300 " . WWW_ROOT . IMAGES_URL . "customized_tshirts_foreground/" . $fileinfo['basename'] . " -background white -flatten " . WWW_ROOT . IMAGES_URL . "TIFF/" . $jpeganme;
                system($exec, $err);


                $exec = "convert -resample 300 " . WWW_ROOT . IMAGES_URL . "TIFF/" . $jpeganme . " " . WWW_ROOT . IMAGES_URL . "TIFF/fore_" . $fileinfo['filename'] . ".tif";
                system($exec, $err);
                $exec = "convert -resize 1024x1024 " . WWW_ROOT . IMAGES_URL . "TIFF/fore_" . $fileinfo['filename'] . ".tif " . WWW_ROOT . IMAGES_URL . "TIFF/fore_" . $fileinfo['filename'] . ".tif";
                system($exec, $err);
                $exec = "convert  " . WWW_ROOT . IMAGES_URL . "TIFF/fore_" . $fileinfo['filename'] . ".tif -set units PixelsPerInch -density 300 " . WWW_ROOT . IMAGES_URL . "TIFF/fore_" . $fileinfo['filename'] . ".tif";
                system($exec, $err);




                @unlink(WWW_ROOT . IMAGES_URL . "TIFF/" . $jpeganme);
            }
            $tifPath = IMAGES_URL . "TIFF/fore_" . $fileinfo['filename'] . ".tif";
        } elseif ($type == "pdf") {
            if (!file_exists(WWW_ROOT . IMAGES_URL . "TIFF/fore_" . $fileinfo['filename'] . ".pdf")) {
                //----------shell command for imagemagick---------------------//
                $exec = "convert -resample 300 " . WWW_ROOT . IMAGES_URL . "customized_tshirts_foreground/" . $fileinfo['basename'] . " " . WWW_ROOT . IMAGES_URL . "TIFF/fore_" . $fileinfo['filename'] . ".pdf";
                system($exec, $err);
                $exec = "convert -resize 1024x1024 " . WWW_ROOT . IMAGES_URL . "TIFF/fore_" . $fileinfo['filename'] . ".pdf " . WWW_ROOT . IMAGES_URL . "TIFF/fore_" . $fileinfo['filename'] . ".pdf";
                system($exec, $err);
            }
            $tifPath = IMAGES_URL . "TIFF/fore_" . $fileinfo['filename'] . ".pdf";
        } elseif ($type == "eps") {
            if (!file_exists(WWW_ROOT . IMAGES_URL . "TIFF/fore_" . $fileinfo['filename'] . ".eps")) {
                //----------shell command for imagemagick---------------------//
                $exec = "convert " . WWW_ROOT . IMAGES_URL . "customized_tshirts_foreground/" . $fileinfo['basename'] . " -resize 1024x1024 -density 500 -units pixelsperinch -quality 100 -compress none -alpha set -colorspace rgb -fuzz 10% -transparent white -flatten -background none -depth 8 eps3:" . WWW_ROOT . IMAGES_URL . "TIFF/fore_" . $fileinfo['filename'] . ".eps";
                system($exec, $err);
            }
            $tifPath = IMAGES_URL . "TIFF/fore_" . $fileinfo['filename'] . ".eps";
        } elseif ($type == "png") {
            if (!file_exists(WWW_ROOT . IMAGES_URL . "TIFF/fore_" . $fileinfo['filename'] . ".png")) {

                //----------shell command for imagemagick---------------------//
                list($height, $width) = getimagesize(WWW_ROOT . IMAGES_URL . "customized_tshirts_foreground/" . $fileinfo['basename']);

                if ($height == 1024 && $width == 1024) {

                    $exec = "convert " . WWW_ROOT . IMAGES_URL . "customized_tshirts_foreground/" . $fileinfo['basename'] . " " . WWW_ROOT . IMAGES_URL . "TIFF/fore_" . $fileinfo['filename'] . ".png";
                    system($exec, $err);
                } else {

                    $exec = "convert -resample 300 " . WWW_ROOT . IMAGES_URL . "customized_tshirts_foreground/" . $fileinfo['basename'] . " " . WWW_ROOT . IMAGES_URL . "TIFF/fore_" . $fileinfo['filename'] . ".png";
                    system($exec, $err);
                    $exec = "convert -resize 1024x1024 " . WWW_ROOT . IMAGES_URL . "TIFF/fore_" . $fileinfo['filename'] . ".png " . WWW_ROOT . IMAGES_URL . "TIFF/fore_" . $fileinfo['filename'] . ".png";
                    system($exec, $err);
                }
            }
            $tifPath = IMAGES_URL . "TIFF/fore_" . $fileinfo['filename'] . ".png";
        } elseif ($type == "jpg") {
            if (!file_exists(WWW_ROOT . IMAGES_URL . "TIFF/fore_" . $fileinfo['filename'] . ".jpg")) {
                //----------shell command for imagemagick---------------------//

                list($height, $width) = getimagesize(WWW_ROOT . IMAGES_URL . "customized_tshirts_foreground/" . $fileinfo['basename']);

                if ($height == 1024 && $width == 1024) {

                    $exec = "convert " . WWW_ROOT . IMAGES_URL . "customized_tshirts_foreground/" . $fileinfo['basename'] . " -background white -flatten " . WWW_ROOT . IMAGES_URL . "TIFF/fore_" . $fileinfo['filename'] . ".jpg";
                    system($exec, $err);
                } else {

                    $exec = "convert -resample 300 " . WWW_ROOT . IMAGES_URL . "customized_tshirts_foreground/" . $fileinfo['basename'] . " -background white -flatten " . WWW_ROOT . IMAGES_URL . "TIFF/fore_" . $fileinfo['filename'] . ".jpg";
                    system($exec, $err);
                    $exec = "convert -resize 1024x1024 " . WWW_ROOT . IMAGES_URL . "TIFF/fore_" . $fileinfo['filename'] . ".jpg " . WWW_ROOT . IMAGES_URL . "TIFF/fore_" . $fileinfo['filename'] . ".jpg";
                    system($exec, $err);
                }
            }
            $tifPath = IMAGES_URL . "TIFF/fore_" . $fileinfo['filename'] . ".jpg";
        } elseif ($type == "svg") {
            $imageToConvert = IMAGES_URL . "TIFF/fore_" . $fileinfo['filename'];
            /*             * * for backword Svg Download if Autotracing not worked out well ***** */
            if (file_exists(IMAGES_URL . "TIFF/fore_" . $fileinfo['filename'] . ".svg")) {
                unlink(IMAGES_URL . "TIFF/fore_" . $fileinfo['filename'] . ".svg");
            }
            /*             * * for backword Svg Download if Autotracing not worked out well ***** */
            if ($cnfg['autotracing'] == "YES") {
                $exec = "convert -resample 300 " . WWW_ROOT . IMAGES_URL . "customized_tshirts_foreground/" . $fileinfo['basename'] . " " . WWW_ROOT . $imageToConvert . ".png";
                system($exec, $err);
                $exec = "convert -resize 1024x1024 " . WWW_ROOT . $imageToConvert . ".png " . WWW_ROOT . $imageToConvert . ".png";
                system($exec, $err);
                system("/usr/bin/autotrace  --input-format=png --output-file=" . WWW_ROOT . $imageToConvert . ".svg --dpi=300 --color-count=16 --despeckle-level=10 --despeckle-tightness=5 --corner-always-threshold=60 --line-threshold=0.1 --width-weight-factor=0.1 --line-reversion-threshold=0.1 --preserve-width --remove-adjacent-corners " . WWW_ROOT . $imageToConvert . ".png");
            } else {
                if (!file_exists($src = WWW_ROOT . IMAGES_URL . "customized_tshirts_foreground/" . $fileinfo['filename'] . ".svg")) {
                    $exec = "convert " . WWW_ROOT . IMAGES_URL . "customized_tshirts_foreground/" . $fileinfo['basename'] . " " . WWW_ROOT . $imageToConvert . ".svg";
                    system($exec, $err);
                } else {
                    @copy($src, IMAGES_URL . "TIFF/fore_" . $fileinfo['filename'] . ".svg");
                }
            }
            $tifPath = IMAGES_URL . "TIFF/fore_" . $fileinfo['filename'] . ".svg";
        }

        $this->Download->downloadFile($tifPath);
        exit;
    }

    function downloadinstructions($savID) {

        $customInfoData = $this->OrderDetail->findCustomInfo($savID);
        $customInfo = json_decode($customInfoData['custom_information']);
        $fileName = "instructions.doc";
        $customInfoContent = '';

        $customInfoContent .= '<div class="show_info" style=" width: 620px;padding: 5px;"><table width="100%"  border="0" cellspacing="0" cellpadding="0" id="items_display_area_admin_table">
                                  <tr>
                                    <td align="left" valign="top">
                                        <table width="100%"  border="0" cellspacing="0" cellpadding="5">
                                      <tr>
                                        <td class="boxtopheader">Custom Information </td>
                                      </tr>
                                    </table>
                                    <table width="100%"  border="0" cellspacing="1" cellpadding="6" class="admin-table-list">
                                      <tr align="left" valign="middle" id="list_admin_top">
                                        <td width="5%">No.</td>
                                                <td >Details</td></tr>';
        if ($customInfo) {
            foreach ($customInfo as $k => $v) {
                $customInfoContent .= '<tr id="list_admin"><td>' . ($k + 1) . '</td> <td>' . $v . '</td></tr>';
            }
        }
        $customInfoContent .='</table></td></tr></table></div>';



        //header('Content-Type: application/pdf');
        header("Content-Type: application/octet-stream");
        header("Content-Transfer-Encoding: Binary");
        header("Content-disposition: attachment; filename=" . $fileName);
        echo $customInfoContent;
        exit;
    }

    function fedexlabelgen($orderid = '') {
        //$shipping_state = $this->Setting->findByFieldname('shipping_origin_state');
        //$shipping_country = $this->Setting->findByFieldname('shipping_origin_country');
        //$shipping_zip = $this->Setting->findByFieldname('shipping_origin_zip');

        $fedexmeterno = $this->Setting->findByFieldname('fedexmeterno');
        $fedexshipaccno = $this->Setting->findByFieldname('fedexshipaccno');

        $ord_res = $this->Order->findById($orderid);
        $user_id = $ord_res["User"]["id"];
        //echo "<pre>";print_r($ord_res);exit;
        include(WWW_ROOT . "Fedex/fedex-common.php");
        $path_to_wsdl = WWW_ROOT . 'Fedex/ShipService_v8.wsdl';
        $array_ReplaceWith = array("EUROPE_FIRST_INTERNATIONAL_PRIORITY",
            "FEDEX_1_DAY_FREIGHT",
            "FEDEX_2_DAY",
            "FEDEX_2_DAY_FREIGHT",
            "FEDEX_3_DAY_FREIGHT",
            "FEDEX_EXPRESS_SAVER",
            "FEDEX_GROUND",
            "FIRST_OVERNIGHT",
            "GROUND_HOME_DELIVERY",
            "INTERNATIONAL_ECONOMY",
            "INTERNATIONAL_ECONOMY_FREIGHT",
            "INTERNATIONAL_FIRST",
            "INTERNATIONAL_PRIORITY",
            "INTERNATIONAL_PRIORITY_FREIGHT",
            "PRIORITY_OVERNIGHT",
            "STANDARD_OVERNIGHT");

        $array_Replace = array("EUROPE_FIRST_INTERNATIONAL_PRIORITY",
            "FedEx Overnight Freight",
            "FedEx 2 Day",
            "FedEx 2 day Freight",
            "FedEx 3 day Freight",
            "FedEx Express Saver",
            "FedEx Ground",
            "FedEx First Overnight",
            "FedEx Home Delivery",
            "FedEx International Economy",
            "INTERNATIONAL_ECONOMY_FREIGHT",
            "FedEx International First",
            "FedEx International Priority",
            "INTERNATIONAL_PRIORITY_FREIGHT",
            "FedEx Priority Overnight",
            "FedEx Standard Overnight");

        $vshipping_name = $ord_res["Order"]["shipping_service"];
        //$vshipping_name= "STANDARD_OVERNIGHT";
        //Replace shipping service with proper naming
        $vshipping_name = str_replace($array_Replace, $array_ReplaceWith, $vshipping_name);
        $recipient_name = $ord_res["Order"]["ship_fname"] . " " . $ord_res["Order"]["ship_lname"];
        $recipient_company = '';
        $recipient_phone = $ord_res["Order"]["ship_phone"];
        $recipient_address = $ord_res["Order"]["ship_address"];
        $recipient_city = $ord_res["Order"]["ship_city"];
        //$recipient_state   			= $pck_res["Packet"]["ship_state"];
        //$statedet					=	$this->State->findByName($pck_res["Packet"]["ship_state"]);
        $recipient_state = $ord_res["Order"]["ship_state"];
        //$recipient_state 	        =	'CA';

        $recipient_postcode = $ord_res["Order"]["ship_zip"];
        //$recipient_postcode  		=   '90001';
        //$recipient_country   		= $pck_res["Packet"]["ship_country"];
        $cntdet = $this->Country->findByCountryName($ord_res["Order"]["ship_country"]);
        $recipient_country = $cntdet["Country"]["country_iso_code_2"];
        $delivery_place_residential = 'false';

        //Shipper Address Details
        $shipper_name = 'Shipper Name';
        $shipper_company = 'Shipper Company';
        $shipper_phone = '713-932-6901';
        //$shipper_phone   		= '404-299-0842'; //Original phone
        $shipper_address = '1325 Remington Rd, Suite R';
        $shipper_city = 'Schaumburg';
        $shipper_state = 'IL';
        $shipper_postcode = '60173';
        $shipper_pick_up_zip = '60173';
        $shipper_country = 'US';
        //Shipper Address Details
        /* Working FEDEX Credentials
          $key='VH9gpVObdc0EvOIQ';
          $password='wQYp3s0PqmZYSM9piA7EdvWhJ';
          $shipAccount='510088000';
          $meter='100022250';
          $billAccount='510088000';
          $dutyAccount='';
          Working FEDEX Credentials */

        // Working FEDEX Credentials
        /* $width = '20';
          $height = '10';
          $length = '20';
          $units = '10';
          $weight = '50'; */
        //Working FEDEX Credentials 

        $cnfg = Configure::read('Neutrino');
        $key = $cnfg["fedexkey"];
        $password = $cnfg["fedexpaswd"];
        $shipAccount = $cnfg["fedexshipaccno"];
        $meter = $cnfg["fedexmeterno"];
        $billAccount = $cnfg["fedexbillaccno"];
        $dutyAccount = '';

        $width = $_POST["fed_width"];
        $height = $_POST["fed_height"];
        $length = $_POST["fed_length"];
        $units = $_POST["fed_units"];
        $weight = $_POST["fed_weight"];


        ini_set("soap.wsdl_cache_enabled", "0");
        $client = new SoapClient($path_to_wsdl, array('trace' => true)); // Refer to http://us3.php.net/manual/en/ref.soap.php for more information
        $request['WebAuthenticationDetail'] = array('UserCredential' =>
            array('Key' => $key, 'Password' => $password));
        $request['ClientDetail'] = array('AccountNumber' => $shipAccount, 'MeterNumber' => $meter);
        $request['TransactionDetail'] = array('CustomerTransactionId' => '*** Express Domestic Shipping Request v8 using PHP ***');
        $request['Version'] = array('ServiceId' => 'ship', 'Major' => '8', 'Intermediate' => '0', 'Minor' => '0');

        $request['RequestedShipment'] = array('ShipTimestamp' => date('c'),
            'DropoffType' => 'REGULAR_PICKUP', // valid values REGULAR_PICKUP, REQUEST_COURIER, DROP_BOX, BUSINESS_SERVICE_CENTER and STATION
            /* 				'ServiceType' => strtoupper(str_replace(' ','_',$vshipping_name)),// valid values STANDARD_OVERNIGHT, PRIORITY_OVERNIGHT, FEDEX_GROUND, ... */
            'ServiceType' => strtoupper($vshipping_name), // valid values STANDARD_OVERNIGHT, PRIORITY_OVERNIGHT, FEDEX_GROUND, ...
            'PackagingType' => 'YOUR_PACKAGING', // valid values FEDEX_BOX, FEDEX_PAK, FEDEX_TUBE, YOUR_PACKAGING, ...
            'TotalWeight' => array('Value' => $weight, 'Units' => 'LB'), // valid values LB and KG
            'Shipper' => array('Contact' => array('PersonName' => $shipper_name,
                    'CompanyName' => $shipper_company,
                    'PhoneNumber' => $shipper_phone),
                'Address' => array('StreetLines' => array($shipper_address),
                    'City' => $shipper_city,
                    'StateOrProvinceCode' => $shipper_state,
                    'PostalCode' => $shipper_postcode,
                    'CountryCode' => $shipper_country)),
            'Recipient' => array('Contact' => array('PersonName' => $recipient_name,
                    'CompanyName' => $recipient_company,
                    'PhoneNumber' => $recipient_phone),
                'Address' => array('StreetLines' => array($recipient_address),
                    'City' => $recipient_city,
                    'StateOrProvinceCode' => $recipient_state,
                    'PostalCode' => $recipient_postcode,
                    'CountryCode' => $recipient_country),
                'Residential' => $delivery_place_residential),
            'ShippingChargesPayment' => array('PaymentType' => 'SENDER', // valid values RECIPIENT, SENDER and THIRD_PARTY
                'Payor' => array('AccountNumber' => $billAccount,
                    'CountryCode' => 'US')),
            'SpecialServicesRequested' => array(),
            'LabelSpecification' => array('LabelFormatType' => 'COMMON2D', // valid values COMMON2D, LABEL_DATA_ONLY
                'ImageType' => 'PDF', // valid values DPL, EPL2, PDF, ZPLII and PNG
                'LabelStockType' => 'PAPER_7X4.75'),
            'RateRequestTypes' => array('ACCOUNT'), // valid values ACCOUNT and LIST
            'PackageCount' => 1,
            'PackageDetail' => 'INDIVIDUAL_PACKAGES',
            'RequestedPackageLineItems' => array('0' => array('Weight' => array('Value' => $weight,
                        'Units' => 'LB'))));

        /* echo "<pre>";
          print_r($request);
          exit(); */


        try {
            $response = $client->processShipment($request);  // FedEx web service invocation
            echo "<pre>";
            print_r($response);
            exit;
            if ($response->HighestSeverity != 'FAILURE' && $response->HighestSeverity != 'ERROR') {
                $tracking_no = $response->CompletedShipmentDetail->CompletedPackageDetails->AstraLabelElements[5]->Content;
                $pdftrackno = str_replace(" ", "", $tracking_no);
                /*
                  if(is_object($response->CompletedShipmentDetail->CodReturnDetail)) {
                  $fp = fopen(WWW_ROOT.'Fedex/shipping_label/'.SHIP_CODLABEL, 'w+');
                  fwrite($fp, $response->CompletedShipmentDetail->CodReturnDetail->Label->Parts->Image); //Create COD Return PNG or PDF file
                  fclose($fp);
                  }
                 */

                define('SHIP_LABEL', $pdftrackno . '_label.pdf');  // PNG label file. Change to file-extension .pdf for creating a PDF label (e.g. shiplabel.pdf)
                // Inserting the Trackinh number and PDF path
                $this->Order->id = $ord_res["Order"]["id"];
                $this->Order->saveField('tracking_no', $tracking_no);
                $this->Order->saveField('label_pdf', SHIP_LABEL);
                //define('SHIP_CODLABEL',$pckid.'_returnlabel.pdf');  // PNG label file. Change to file-extension .pdf for creating a PDF label (e.g. CODexpressreturnlabel.pdf)
                //working code ,saved to Fedex/shipping_label folder in root 
                $fp = fopen(WWW_ROOT . 'Fedex/shipping_label/' . SHIP_LABEL, 'w+');
                //Create PNG or PDF file
                fwrite($fp, $response->CompletedShipmentDetail->CompletedPackageDetails->Label->Parts->Image); //Create PNG or PDF file
                fclose($fp);
                // Inserting the Trackinh number and PDF path
                $this->Order->id = $ord_res["Order"]["id"];
                $this->Order->saveField('tracking_no', $tracking_no);
                $this->Order->saveField('label_pdf', SHIP_LABEL);

                /* ob_start();            
                  header('Content-type: application/pdf');
                  header('Content-Disposition: attachment; filename='.SHIP_LABEL);
                  echo($response->CompletedShipmentDetail->CompletedPackageDetails->Label->Parts->Image);
                  exit; */
            } else {
                $res = printError($client, $response);
                //print_r($res);exit;
                $cnt = count($res);
                $errMSGFromFedex = "";
                if ($cnt > 1) {
                    $errMSGFromFedex = "The following error(s) has been returned from FedEx server<hr width='75%' align='left'><br>";
                    for ($counter = 0; $counter <= $cnt - 1; $counter += 1) {
                        $errMSGFromFedex.= $res[$counter]->LocalizedMessage . "<br>";
                    }
                } elseif ($cnt == 1) {
                    $errMSGFromFedex = "The following error(s) has been returned from FedEx server<hr width='75%' align='left'><br>";
                    $errMSGFromFedex.= $res->LocalizedMessage . "<br>";
                } else {
                    $errMSGFromFedex = "The following error(s) has been returned from FedEx server<hr width='75%' align='left'><br>";
                    $errMSGFromFedex.= $res . "<br>";
                }

                if ($errMSGFromFedex <> "") {
                    $errMSGFromFedex = $errMSGFromFedex . 'Shipping label can\'t be created.';
                } else {
                    $errMSGFromFedex = 'Shipping Label Cannot be Created.';
                }

                $this->Session->setFlash(__($errMSGFromFedex, true));
                $this->redirect(array('controller' => 'orders', 'action' => 'details/' . $orderid));
            }

            //writeToLog($client);    // Write to log file
        } catch (SoapFault $exception) {
            printFault($exception, $client);
        }

        /* Generate Labels */
        $this->Session->setFlash(__('Shipping Label Created Successfully.', true));
        $this->redirect(array('controller' => 'orders', 'action' => 'details/' . $orderid));
        exit();
    }

    function __customaddslashes($param) {
        /* if($this->getMagicQuotes()) return $param;
          else */ return addslashes($param);
    }

    function ajaxCheckCoupons() {
        extract($_POST);
        $code = $_POST['coupon_code'];
        $total = $_POST['total'];
        $tax = $_POST['tax'];
        $shipamnt = $_POST['shipamt'];
        $tax_perc = $_POST['taxperc'];
        $ship = $shipamnt;
        $this->Session->write('orderforpayment.coupon_code', Null);
        $this->Session->write('orderforpayment.reduced_amt', Null);
        $dups = $this->Coupon->checkCouponExists(trim($code));
        //	print_r($dups);
        global $currency;

        $curr = $this->Currency->findByCode($currency);

        if (isset($dups) && $dups > 0) {
            $message = 1;

            if ($total >= $dups['minamt']) {
                if ($dups['type'] == "Perc") {
                    $reducedamt = $total * $dups['giftvalue'] / 100;
                    //$newTotal	= $total-($total*$dups['giftvalue']/100);
                } elseif ($dups['type'] == "Amt") {
                    $reducedamt = $dups['giftvalue'];
                } elseif ($dups['type'] == "Free") {
                    // $reducedamt = $shipamnt;
                    $shipamnt = 0;
                    $message = 4;
                }

                /* if($dups['type']== "Free"){

                  $newTotal	= $total-$reducedamt;
                  $TOTPAY     = $total-$reducedamt;
                  $newTotal   = $tax+$newTotal;
                  $newTotal   = number_format($newTotal,2,".","");

                  }
                  else{ */

                $newTotal = $total - $reducedamt;
                $TOTPAY = $total - $reducedamt;

                if ($dups['type'] == "Free") {

                    $taxamt = ($newTotal * $tax_perc) / 100;

                    $tax = number_format($taxamt, 2, ".", "");
                }

                $newTotal = $tax + $shipamnt + $newTotal;
                $newTotal = number_format($newTotal, 2, ".", "");

                //}

                if ($newTotal <= 0 || $TOTPAY <= 0 || $total <= $reducedamt ) {
                    $message = 3;
                    $total_t = $total + $tax + $shipamnt;
                    $newTotal = number_format($total_t, 2, ".", "");

                  //  echo "---newTotal--->".$newTotal;exit;
                } else {
                    $this->Session->write('orderforpayment.coupon_code', $code);
                    $this->Session->write('orderforpayment.reduced_amt', $reducedamt);

                    if ($dups['type'] == "Free") {

                        $this->Session->write('orderforpayment.discount_type', 'Free_Shipping');
                        $this->Session->write('orderforpayment.shipping_price', $shipamnt);

                        $this->Session->write('orderforpayment.total_price', $TOTPAY);
                        $this->Session->write('orderforpayment.tax_price', $tax);
                    }
                }
            } else {
                $message = 2;
                $newTotal = $tax + $shipamnt + $total;
            }
        } else {
            $message = 0;
            $newTotal = $tax + $shipamnt + $total;
        }
        $this->set('gtotal', $newTotal);
        if ($message == 0) {
            $msg = "No such coupon code exists";
            $class = "failure";
        } else if ($message == 2) {
            $msg = "You need to purchase for a minimum amount " . $curr["Currency"]["logo"] . $dups['minamt'] . " to apply this coupon code.";
            $class = "failure";
        } else if ($message == 3) {
            $msg = "You can only apply a coupon code amount which is less than the Grand total/Total to pay amount.";
            $class = "failure";
        } else if ($message == 4) {
            $msg = $curr["Currency"]["logo"] . $ship . " shipping cost has been deducted from total amount";
            $class = "success";
        } else {
            $msg = $curr["Currency"]["logo"] . $reducedamt . " has been deducted from total amount";
            $class = "success";
        }
        $returnArr = array('amount' => $newTotal,
            'tax' => $tax,
            'message' => $msg,
            'class' => $class
        );

        //	echo "here".$gtotal;
        Configure::write('debug', 0);
        $this->autoRender = false;
        echo json_encode($returnArr);

        exit;
    }

}

?>