<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: 			*/
// +----------------------------------------------------------------------+
// | PHP version 4/5                                                      |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004-2011 ARMIA INC                                    |
// +----------------------------------------------------------------------+
// | This source file is a part of iScripts PrintLogic                    |
// +----------------------------------------------------------------------+
// | Authors: Jipson<jipson.thomas@armiasystems.com>             		  |
// +----------------------------------------------------------------------+
App::uses('Controller', 'Controller'); 
App::uses('Component/Paginator', 'Controller');
App::uses('Sanitize', 'Utility');
App::uses('Customimages', 'Controller');
App::uses('Xml', 'Utility');
class ProductsController extends AppController {

    var $name = "Product";
    //var $helpers = array('Html', 'Form','Pagination','Javascript','Ajax','Csv','xls','Tree');
    var $helpers = array('Html', 'Form','Paginator','Js','Flash','Tree','Csv','Xls');
    var $components = array ('RequestHandler','Paginator','Catmenu','Pclzip','Resize','Customize','Imagehandle','Email'); // Added
    var $uses = array('Product','Cart','Category','User','Rating','Currency','Customfield','Customfieldvalue','Customcombination','Productcustomfield','Productdetail','Productimages','Setting','Cmspage','Customimage','Font','Palette','Order','OrderDetail','Customimagetypes','Customimage','Coordinate','Imageregion','Savedimage','Itemcoordinate','Productpricetier','Ruler','Dynamicpage','Template','Productdimension','Brand','Productexternal','Productexternalsdetail');

    var $paginate = array('limit' => 25,'order' => array('Product.pname' => 'asc'));


    function index() {

       $cnfg            =   Configure::read('Neutrino');
       $this->Paginator->settings['limit'] = $cnfg["items_perpage"];

     

        $this->__validateLoginStatus();
        $admsess	=	$this->Session->read('Admin');
        if($admsess["products"] <> 1) {
            $this->redirect(array('controller' => 'admins', 'action' => 'index'));
              exit();
        }

        //for deleting null rows from products table.

        $res=$this->Product->delNullrows();

        global $currency;
        $curr		=	$this->Currency->findByCode($currency);
        $this->set('curlogo',$curr["Currency"]["logo"]);
        $criteria="Product.status = 'A'";
        $cmbSearchType	=	"";
        $txtSearch		=	"";
        if(isset($_GET["cmbSearchType"]) && isset($_GET["txtSearch"])) {
            $cmbSearchType	=	$_GET["cmbSearchType"];
            $txtSearch		=	$_GET["txtSearch"];
            if($cmbSearchType == "name") {
                $data = $this->paginate('Product', array('Product.pname  LIKE ' => "%".addslashes($txtSearch)."%",'Product.status  = ' => "A"));
            }elseif($cmbSearchType == "category") {
                $data = $this->paginate('Product', array('Category.cname  LIKE ' => "%".addslashes($txtSearch)."%",'Product.status  = ' => "A"));
            }else {
                $data = $this->paginate('Product', array('Product.status  = ' => "A"));
            }
        }
        else if(isset($this->passedArgs["cmbSearchType"]) && isset($this->passedArgs["txtSearch"]) &&
                $this->passedArgs["txtSearch"] <> '') {
            $cmbSearchType	=	$this->passedArgs["cmbSearchType"];
            $txtSearch		=	$this->passedArgs["txtSearch"];
            if($cmbSearchType == "name") {
                $data = $this->paginate('Product', array('Product.pname  LIKE ' => "%".addslashes($txtSearch)."%"));
            }elseif($cmbSearchType == "category") {
                $data = $this->paginate('Product', array('Category.cname  LIKE ' => "%".addslashes($txtSearch)."%"));
            }else {
                $data = $this->paginate('Product', array('Product.status  = ' => "A"));
            }
        }
        else {
            $data = $this->paginate('Product', array('Product.status  = ' => "A"));
        }

        
        for($c=0; $c < sizeof($data); $c++) {
            $data[$c]["Product"]["id"];

            $productDetails = $this->Productdetail->findByProductId($data[$c]["Product"]['id']);
            $data[$c]["Product"]['productDetail_id'] = $productDetails['Productdetail']['id'];
            // print_r($productDetailId);
            if(isset($data[$c]["Productimages"][0]["imagename"])) {
                $defimg	=	$data[$c]["Productimages"][0]["imagename"];
                for($m=0; $m < sizeof($data[$c]["Productimages"]); $m++) {
                    if($data[$c]["Productimages"][$m]["default_img"] == "Y") {
                        $defimg	=	$data[$c]["Productimages"][$m]["imagename"];
                    }
                }
                $data[$c]["Productimages"]	=	$defimg;
            }
            else {
                $data[$c]["Productimages"]	= '';
            }
        }

        $this->set('cmbSearchType', $cmbSearchType);
        $this->set('txtSearch', $txtSearch);
        $this->passedArgs['limit']=$this->paginate["limit"];
        $this->set('passedarg',$this->passedArgs);
        $this->set('product', $data);
        $this->layout = 'adm';
    }

    function templates() {

        $this->__validateLoginStatus();
        $admsess	=	$this->Session->read('Admin');
        $uid = $admsess['id'];
        if($admsess["products"] <> 1) {
            $this->redirect(array('controller' => 'admins', 'action' => 'index'));
            exit();
        }


        $this->Session->write('tempUser',$uid);
        $this->Session->write('templateName','');
        $this->Session->write('templateCombId', '');
        $this->Customimage->resetTable($uid);

        //-------------generate image for unsaved sides of images--------------//
        $imageArray = $this->Customimage->removeTemp($uid);


        if(is_array($imageArray)) {

            foreach($imageArray as $images) {

                if(!empty($images['design_items'])) {
                    //------------------background image--------------------//
                    $editedImg = $this->Customize->index($images['image_path']);
                    foreach($images['design_items'] as $designs) {

                        $designs['type'] == 'text' ? $this->Customize->addText($designs) : $this->Customize->addImage($designs);

                    }

                    //--------------------foreground image-----------------//
                    $editedImg_blank = $this->Customize->index("blank.png", true);

                    foreach($images['design_items'] as $designs) {

                        $designs['type'] == 'text' ? $this->Customize->addText($designs) : $this->Customize->addImage($designs);

                    }
                }
                else {
                    $editedImg = $this->Customize->index($images['image_path']);
                    $editedImg_blank = $this->Customize->index("blank.png", true);

                    copy(WWW_ROOT.IMAGES_URL.$images['image_path'], WWW_ROOT.IMAGES_URL.$editedImg);
                    copy(WWW_ROOT.IMAGES_URL."blank.png", WWW_ROOT.IMAGES_URL.$editedImg_blank);
                }

                $this->Customimage->updateSaveImage($editedImg, $editedImg_blank, $images['id']);

            }

        }

        if($redirect == 1) {
            $this->redirect(array('controller' => 'carts', 'action' => "show"));
            exit;
        }elseif($redirect == 2) {
            $this->redirect(array('controller' => 'orders', 'action' => "myorder/sendtoadmin/sucess"));
            exit;
        }

        $perPage = 10;
        isset($_GET['page']) ? $cur = $_GET['page'] - 1 : $cur = 0;
        $totalRecs = $this->Customimage->adminuserImagesCount($uid);
        $max = ceil($totalRecs/$perPage);
        $pagingArray = array('cur' => $cur, 'max' => $max);
        $this->set("pagingArray", $pagingArray);
        $designOrder = array();
        $imgList = $this->Customimage->adminuserImages($uid, $perPage, $cur);
        $uneditableList = $this->Customimage->pendingorders($uid);
        if($uneditableList) {
            foreach($uneditableList as $val) $uneditableArray[] = $val['SAV']['id'];
        }
        else $uneditableArray[0] = 0;

        $cartimageList = $this->Customimage->designsincart($uid);

        if($cartimageList) {
            foreach($cartimageList as $val) $cartimageArray[] = $val ['PrintLogic_carts']['savedimages_id'];
        }
        else $cartimageArray[0] = 0;
        $designOrderList = $this->Customimage->designOrder($uid);
        if($designOrderList) {
            foreach($designOrderList as $val) $designOrder[] = $val ['odt']['savedimages_id'];
        }else $designOrder[0] = 0;
        //print_r($cartimageArray);exit;
        $this->set("imgList", $imgList);
        $this->set("uneditableArray", $uneditableArray);
        $this->set("cartimageArray", $cartimageArray);
        $this->set("designOrder", $designOrder);
        $this->layout = 'adm';
    }

/*********** Function to add/edit price rates  ************/
    function addpricerates($productid,$rateid=0){


        $this->__validateLoginStatus();
        $pdctdetails = $this->Product->findById($productid);
        //echo "<pre>";print_r($pdctdetails);exit;
        $priceRates= $pdctdetails['Productpricetier'];
        $this->set('productid', $productid);
        if($rateid != 0 ) {
            $ratedetails = $this->Productpricetier->findById($rateid);
            $ratedetails = $ratedetails['Productpricetier'];
            $this->set('ratedetails', $ratedetails);
        }
        if(isset($_POST)&& $_POST['savBtn']=='Add'){
         //
            //Null Check
            if($this->data['rate']==NULL)
            {
                $this->Session->setFlash('Please enter rate.', 'default',array('class'=> 'failure'));
                $this->redirect(array('controller' => 'products','action'=>'addpricerates/'.$this->data['product_id']));
            }
            //
            if($this->data['type']=="Between"){ // validation
                $post_data = $this->data;
                $post_data['quantity']= $this->data['quantity'].",".$this->data['quantity2'];
                $this->data =  $post_data;
                $addedprices = $this->Productpricetier->select_ByproductID($this->data['product_id']);
                if($addedprices!=NULL){
                foreach ($addedprices as $key => $value) {
                    if($value['priceTiers']['type']=='Above')
                    {
                        $betweenRange = range($this->data['quantity'],$this->data['quantity2']);
                        if(in_array($value['priceTiers']['quantity'], $betweenRange))
                        {
                            $this->Session->setFlash('Invalid range, conflict with range "Above" entered.', 'default',array('class'=> 'failure'));
                            $this->redirect(array('controller' => 'products','action'=>'addpricerates/'.$this->data['product_id']));
                        }
                        if($this->data['quantity']>$value['priceTiers']['quantity'])
                        {
                            $this->Session->setFlash('Invalid range, conflict with range "Above" entered.', 'default',array('class'=> 'failure'));
                            $this->redirect(array('controller' => 'products','action'=>'addpricerates/'.$this->data['product_id']));
                        }
                        if($this->data['quantity2']>$value['priceTiers']['quantity'])
                        {
                            $this->Session->setFlash('Invalid range, conflict with range "Above" entered.', 'default',array('class'=> 'failure'));
                            $this->redirect(array('controller' => 'products','action'=>'addpricerates/'.$this->data['product_id']));
                        }
                    }
                    if($value['priceTiers']['type']=='Between')
                        {
                            $arrqty       = explode(",", $value['priceTiers']['quantity']);
                            $betweenRange = range($arrqty[0],$arrqty[1]);
                            if(in_array($this->data['quantity'], $betweenRange))
                            {
                                $this->Session->setFlash('Invalid range, conflict with "Between" range entered.', 'default',array('class'=> 'failure'));
                                $this->redirect(array('controller' => 'products','action'=>'addpricerates/'.$this->data['product_id']));
                            }
                            if(in_array($this->data['quantity2'], $betweenRange))
                            {
                                $this->Session->setFlash('Invalid range, conflict with "Between" range entered.', 'default',array('class'=> 'failure'));
                                $this->redirect(array('controller' => 'products','action'=>'addpricerates/'.$this->data['product_id']));
                            }
                            $betweenRange = range($this->data['quantity'],$this->data['quantity2']);
                            if(in_array($arrqty[0], $betweenRange))
                            {
                                $this->Session->setFlash('Invalid range, conflict with "Between" range entered.', 'default',array('class'=> 'failure'));
                                $this->redirect(array('controller' => 'products','action'=>'addpricerates/'.$this->data['product_id']));
                            }
                            if(in_array($arrqty[1], $betweenRange))
                            {
                                $this->Session->setFlash('Invalid range, conflict with "Between" range entered.', 'default',array('class'=> 'failure'));
                                $this->redirect(array('controller' => 'products','action'=>'addpricerates/'.$this->data['product_id']));
                            }
                        }
                }
            }
            }
            if($this->data['type']=="Above"){ //validation
                 $addedprices = $this->Productpricetier->select_ByproductID($this->data['product_id']);
                    if($addedprices!=NULL){
                    foreach ($addedprices as $key => $value) {
                        if($value['priceTiers']['type']=='Between')
                        {
                            $arrqty       = explode(",", $value['priceTiers']['quantity']);
                            $betweenRange = range($arrqty[0],$arrqty[1]-1);
                            if(in_array($this->data['quantity'], $betweenRange))
                            {
                                $this->Session->setFlash('Invalid range, conflict with "Between" range entered.', 'default',array('class'=> 'failure'));
                                $this->redirect(array('controller' => 'products','action'=>'addpricerates/'.$this->data['product_id']));
                            }
                            if($this->data['quantity'] < $arrqty[1])
                            {
                                $this->Session->setFlash('Invalid range, conflict with "Between*" range entered.', 'default',array('class'=> 'failure'));
                                $this->redirect(array('controller' => 'products','action'=>'addpricerates/'.$this->data['product_id']));
                            }
                        }
                        if($value['priceTiers']['type']=='Above'){

                            $this->Session->setFlash('Range "Above" already entered.', 'default',array('class'=> 'failure'));
                            $this->redirect(array('controller' => 'products','action'=>'addpricerates/'.$this->data['product_id']));
                        }
                    }
                }
             }
            // print_r($this->data);exit;
            $this->Productpricetier->save($this->data);
            $pdctdetails = $this->Product->findById($this->data['product_id']);

            $priceRates= $pdctdetails['Productpricetier'];
            $this->redirect(array('controller' => 'products','action'=>'addpricerates/'.$this->data['product_id']));
        }
        if(isset($_POST)&& $_POST['savBtn']=='Update'){
            if($this->data['type']=="Between")
               {
                $post_data = $this->data;
                $post_data['quantity']= $this->data['quantity'].",".$this->data['quantity2'];
                $this->data =  $post_data;
               }
            $arrPricerate = $this->Productpricetier->findById($this->data['id']);
            if($arrPricerate['Productpricetier']['quantity']!=$this->data['quantity']){
            /**********************************/

            if($this->data['type']=="Between"){ // validation
                //$this->data['quantity']= $this->data['quantity'].",".$this->data['quantity2'];
                $addedprices = $this->Productpricetier->select_ByproductID($this->data['product_id']);
                if($addedprices!=NULL){
                foreach ($addedprices as $key => $value) {
                    if($value['priceTiers']['id']!=$this->data['id']){ // same pricetier Id check
                    if($value['priceTiers']['type']=='Above')
                    {
                        $betweenRange = range($this->data['quantity'],$this->data['quantity2']);
                        if(in_array($value['priceTiers']['quantity'], $betweenRange))
                        {
                            $this->Session->setFlash('Invalid range, conflict with range "Above" entered.', 'default',array('class'=> 'failure'));
                            $this->redirect(array('controller' => 'products','action'=>'addpricerates/'.$this->data['product_id']));
                        }
                        if($this->data['quantity']>$value['priceTiers']['quantity'])
                        {
                            $this->Session->setFlash('Invalid range, conflict with range "Above" entered.', 'default',array('class'=> 'failure'));
                            $this->redirect(array('controller' => 'products','action'=>'addpricerates/'.$this->data['product_id']));
                        }
                        if($this->data['quantity2']>$value['priceTiers']['quantity'])
                        {
                            $this->Session->setFlash('Invalid range, conflict with range "Above" entered.', 'default',array('class'=> 'failure'));
                            $this->redirect(array('controller' => 'products','action'=>'addpricerates/'.$this->data['product_id']));
                        }
                    }
                    if($value['priceTiers']['type']=='Between')
                        {
                            $arrqty       = explode(",", $value['priceTiers']['quantity']);
                            $betweenRange = range($arrqty[0],$arrqty[1]);
                            if(in_array($this->data['quantity'], $betweenRange))
                            {
                                $this->Session->setFlash('Invalid range, conflict with "Between" range entered.', 'default',array('class'=> 'failure'));
                                $this->redirect(array('controller' => 'products','action'=>'addpricerates/'.$this->data['product_id']));
                            }
                            if(in_array($this->data['quantity2'], $betweenRange))
                            {
                                $this->Session->setFlash('Invalid range, conflict with "Between" range entered.', 'default',array('class'=> 'failure'));
                                $this->redirect(array('controller' => 'products','action'=>'addpricerates/'.$this->data['product_id']));
                            }

                            $betweenRange = range($this->data['quantity'],$this->data['quantity2']);
                            if(in_array($arrqty[0], $betweenRange))
                            {
                                $this->Session->setFlash('Invalid range, conflict with "Between" range entered.', 'default',array('class'=> 'failure'));
                                $this->redirect(array('controller' => 'products','action'=>'addpricerates/'.$this->data['product_id']));
                            }
                            if(in_array($arrqty[1], $betweenRange))
                            {
                                $this->Session->setFlash('Invalid range, conflict with "Between" range entered.', 'default',array('class'=> 'failure'));
                                $this->redirect(array('controller' => 'products','action'=>'addpricerates/'.$this->data['product_id']));
                            }

                        }
                 }
                }// same pricetier Id check
            }
            }
            if($this->data['type']=="Above"){ //validation
                 $addedprices = $this->Productpricetier->select_ByproductID($this->data['product_id']);
                    if($addedprices!=NULL){
                    foreach ($addedprices as $key => $value) {
                        if($value['priceTiers']['id']!=$this->data['id']){ // same pricetier Id check
                        if($value['priceTiers']['type']=='Between')
                        {
                            $arrqty       = explode(",", $value['priceTiers']['quantity']);
                            $betweenRange = range($arrqty[0],$arrqty[1]-1);
                            if(in_array($this->data['quantity'], $betweenRange))
                            {
                                $this->Session->setFlash('Invalid range, conflict with "Between" range entered.', 'default',array('class'=> 'failure'));
                                $this->redirect(array('controller' => 'products','action'=>'addpricerates/'.$this->data['product_id']));
                            }
                            if($this->data['quantity'] < $arrqty[1])
                            {
                                $this->Session->setFlash('Invalid range, conflict with "Between*" range entered.', 'default',array('class'=> 'failure'));
                                $this->redirect(array('controller' => 'products','action'=>'addpricerates/'.$this->data['product_id']));
                            }
                        }
                        if($value['priceTiers']['type']=='Above'){

                            $this->Session->setFlash('Range "Above" already entered.', 'default',array('class'=> 'failure'));
                            $this->redirect(array('controller' => 'products','action'=>'addpricerates/'.$this->data['product_id']));
                        }
                    }
                   }// check same Id
                }
             }
            /**********************************/
            }
             //$this->Productpricetier->updatePricerate($this->data);
             $this->Productpricetier->save($this->data);
             $this->Session->setFlash('Rate details updated.', 'default',array('class'=> 'success'));
             //$this->Session->setFlash(__('Rate details updated.',true));
             $this->redirect(array('controller' => 'products','action'=>'addpricerates/'.$this->data['product_id'].'/'.$this->data['id']));
        }
        global $currency;
    $curr       =   $this->Currency->findByCode($currency);

    $this->set('curlogo',$curr["Currency"]["logo"]);
        $this->set('productdetails', $pdctdetails);
        //echo "<pre>";print_r($priceRates);exit;
        $this->set('priceRates', $priceRates);
        $this->layout = 'ajax';
    }


public function add_dimensions($productid,$dimid=0){

        $this->__validateLoginStatus();  
        $pdctdetails       = $this->Product->findById($productid); 
       // echo "<pre>";print_r($pdctdetails);exit;
        $dimensions        = $pdctdetails['productdimensions'];  
        $dimdetails        = $pdctdetails['productdimensions'];  
        $this->set('productid', $productid);
        
        if($dimid != 0 ) {
            $pdctdetails   = $this->Product->findById($productid); 
            $dimdetails    = $pdctdetails['productdimensions']; 
            $dimensions    = unserialize($dimdetails[0]['size']); 

        } 
           


        if(isset($_POST)&& $_POST['savBtn']=='Save'){        
           //print_r($_POST['data']);exit;
            $data                        =     $_POST['data'];
            $data                        =     serialize($data);
            $data1                       =     unserialize($data);
        // echo "<pre>";print_r($data1);exit;
            $postArray                   =     $this->data;
            $postArray['size']           =     $data;
            $postArray['inches']         =    '38-42';
            $postArray['centimeter']     =    '80-86';
            $postArray['product_id']     =     $_POST['data']['product_id'];
            $this->data                  =     $postArray; 
            $this->Productdimension->save($this->data);    
            $ProductDimension            =     $this->Productdimension->id; 
          //  echo $ProductDimension; 

            $pdctdetails                 = $this->Product->findById($this->data['product_id']); 
            $dimdetails                  = $pdctdetails['productdimensions']; 
            $dimensions                  = unserialize($dimdetails[0]['size']); 
            
         // echo "<pre>";print_r($dimdetails);exit;       
                
               
           // $priceRates= $pdctdetails['Product_dimensions'];      
            $this->redirect(array('controller' => 'products','action'=>'add_dimensions/'.$this->data['product_id'])); 


        }
        if(isset($_POST)&& $_POST['savBtn']=='Update'){ 
          
              $data                         =  $_POST['data'];
              $data                         =  serialize($data);
              $data1                        =  unserialize($data);
              $postArray                    =  $this->data;
              $postArray['size']            =  $data;
              $postArray['inches']          =  '38-42';
              $postArray['centimeter']      =  '80-86';
              $postArray['product_id']      =  $_POST['data']['product_id'];
              $postArray['id']              =  $_POST['data']['id'];
              $this->data                   =  $postArray; 
                 //$this->Productpricetier->updatePricerate($this->data);
              $this->Productdimension->save($this->data);     
              $this->Session->setFlash('Dimensions updated.', 'default',array('class'=> 'success'));    
                 //$this->Session->setFlash(__('Rate details updated.',true));
              $this->redirect(array('controller' => 'products','action'=>'add_dimensions/'.$postArray['product_id'].'/'.$postArray['id'])); 
        }      
        global $currency;
        $curr       =   $this->Currency->findByCode($currency);
        $this->set('curlogo',$curr["Currency"]["logo"]);
        $this->set('productdetails', $pdctdetails);
        //echo "<pre>";print_r($priceRates);exit;
        if($dimid == 0 ) {
        $dimensions = unserialize($dimensions[0]['size']); 
       }
        $this->set('dimdetails', $dimdetails);      
        $this->set('dimensions', $dimensions);  
        $this->layout = 'ajax'; 
}



 /*********** Function to delete price rates  ************/
    function deletepricerates($rateid=0,$productid){
    $this->__validateLoginStatus();
    if($rateid == 0 ) {
            $this->Session->setFlash(__('Can not find the rate.',true));
            $this->redirect(array('controller'=>'products','action'=>'addpricerates'));
        }
    $this->Productpricetier->delete_Productpricetier($rateid);
    $this->Session->setFlash('Rate successfully deleted.', 'default',array('class'=> 'success'));
    $this->redirect(array('controller' => 'products','action'=>'addpricerates/'.$productid));
    }

     function deletedimensions($dimid=0,$productid){

        //echo "JJJJJJJJJJJJJ";exit;
    $this->__validateLoginStatus();
    if($dimid == 0 ) {
            $this->Session->setFlash(__('Can not find the rate.',true));
            $this->redirect(array('controller'=>'products','action'=>'add_dimensions'));
        }
    $this->Productpricetier->delete_Productdimension($dimid);
    $this->Session->setFlash('Rate successfully deleted.', 'default',array('class'=> 'success'));
    $this->redirect(array('controller' => 'products','action'=>'add_dimensions/'.$productid));
    }



function files($path,&$files = array())
{
    $dir = opendir($path."/.");
    while($item = readdir($dir))
        if(is_file($sub = $path."/".$item))
            $files[] = $item;else
            if($item != "." and $item != "..")
                $this->files($sub,$files);
    return($files);
}
    function calculateAmt($custID) {
        $addtionalCost = 0;
        if($custID == '') {
            return 0;
            exit;
        }

        // STEP 1: Find the front & read id's of the saved image
        $imgArr = $this->Savedimage->findById($custID);
        $images = $this->Savedimage->findAllByRefName($imgArr['Savedimage']['ref_name']);
        foreach($images as $val) {
            $img[] = $val['Savedimage']['id'];
        }

        // STEP 2: Get the entries from the settings table
        $first_imagecost = $this->Setting->findByFieldname('first_image');
        $addn_imagecost = $this->Setting->findByFieldname('addn_image');
        $first_textcost = $this->Setting->findByFieldname('first_text');
        $addn_textcost = $this->Setting->findByFieldname('addn_text');

        // STEP 3: Find the entries in coordinates tbl for each id
        $imgCount = $txtCount = 0;
        foreach($img as $imgkey => $imgval) {
            $coords = $this->Itemcoordinate->findAllBySavedimagesId($imgval);
            if($coords) {
                foreach($coords as $cval) {
                    switch($cval['Itemcoordinate']['content_type']) {
                        case "Image":
                            $customArray[$imgkey]['Image'][] = $cval['Itemcoordinate']['content'];
                            break;
                        case "Text":
                            $customArray[$imgkey]['Text'][] = $cval['Itemcoordinate']['font_color'];
                            break;
                    }
                }
            }
            if(!empty($customArray[$imgkey]['Text'])) {
                $chkArray = array('Default');
                foreach($customArray[$imgkey]['Text'] as $tk => $tv) {
                    if(!in_array($tv, $chkArray)) {
                        array_push($chkArray, $tv);
                        if($txtCount == 0) $addtionalCost += intval($first_textcost['Setting']['value']);
                        else $addtionalCost += intval($addn_textcost['Setting']['value']);
                        $txtCount++;
                    }
                }
            }

            if(!empty($customArray[$imgkey]['Image'])) {
                $sus = $this->Session->read('Userlog');
                foreach($customArray[$imgkey]['Image'] as $ik => $iv) {
                    $imgPath = explode('/', $iv);
                    $imgNamepatr = explode('_',$imgPath[1]);
                    $imgpatr = explode('.', $imgNamepatr[1]);

                    $image_file_user_path = WWW_ROOT.IMAGES_URL.'editorimages/'.$sus['uname'].'/';
                    $files = implode('-',$this->files($image_file_user_path));

                    $image_file_admin_path = WWW_ROOT.IMAGES_URL.'editorimages/admin/';
                    $admin_files = implode('-',$this->files($image_file_admin_path));

                    $image_file_temp_path = WWW_ROOT.IMAGES_URL.'editorimages/temp/';
                    $temp_files = implode('-',$this->files($image_file_temp_path));

                    if(!stristr($iv, $sus['uname']) && !stristr($files,$imgpatr[0]) && !stristr($admin_files,$imgpatr[0]) && !stristr($temp_files,$imgpatr[0]) && !stristr($iv, 'temp')) {

                    }
                    else {
                        if($imgCount == 0) $addtionalCost += intval($first_imagecost['Setting']['value']);
                        else $addtionalCost += intval($addn_imagecost['Setting']['value']);
                        $imgCount++;
                    }
                }
            }

        }

        return $addtionalCost;
        exit;
    }


    function productexport($datas)
    {
    	$i=0;
    	foreach ($datas as $data )
    	{
    		set_time_limit(30);
    		$mportdata['pname']=$data['Product']['pname'];
    		$mportdata['descr']=$data['Product']['descr'];
    		$mportdata['price']=$data['Product']['price'];
    		$mportdata['weight']=$data['Product']['weight'];
    		if($data['Product']['featured']==1)
    		{
    			$mportdata['featured']="YES";
    		}
    		else
    		{
    			$mportdata['featured']="NO";
    		}
    		if($data['Product']['discount_type']=="amnt")
    		{
    			$mportdata['discount']=$data['Product']['discount'];
    		}
    		elseif ($data['Product']['discount_type']=="per")
    		{
    			$mportdata['discount']=$data['Product']['discount']."%";
    		}
    		else
    		{
    			$mportdata['discount']="Nil";
    		}
    		$mportdata['cname']=$data['Category']['cname'];
    		while($data['Category']['parent_id']!=1 && !empty($data['Category']['parent_id']))
    		{
    			$parentcat=$this->Category->findAllByid($data['Category']['parent_id']);
    			$mportdata['cname']=$parentcat[0]['Category']['cname']."/".$mportdata['cname'];
    			$data['Category']['parent_id']=$parentcat[0]['Category']['parent_id'];
    			//echopre()
    		}
    		$productcomps=$this->Productdetail->findAllByproduct_id($data['Product']['id']);

    		foreach ($productcomps as $productcomp)
    		{

    			$impdata[$i]['pname']=$mportdata['pname'];
    			$impdata[$i]['descr']=$mportdata['descr'];
    			$impdata[$i]['price']=$mportdata['price'];
    			$impdata[$i]['weight']=$mportdata['weight'];
    			$impdata[$i]['featured']=$mportdata['featured'];
    			$impdata[$i]['discount']=$mportdata['discount'];
    			$impdata[$i]['cname']=$mportdata['cname'];
    			$impdata[$i]['stock']=$productcomp['Productdetail']['stock'];
    			$impdata[$i]['reorderlevel']=$productcomp['Productdetail']['reorderlevel'];
    			$impdata[$i]['skuno']=$productcomp['Productdetail']['skuno'];
    			$impdata[$i]['extraprice']=$productcomp['Productdetail']['extraprice'];
    			//echopre($productcomp);
    			//customfieldvalues
    			$values=explode(',',$productcomp['Productdetail']['customvalue_id']);


    			foreach ($values as $value)
    			{
    				$customfiledvalues=$this->Customfieldvalue->findAllByid($value);


    				if(!empty($customfiledvalues))
    				{
    					$impdata[$i]['productcombination']=$impdata[$i]['productcombination'].$customfiledvalues[0]['Customfield']['custom_name'].":".$customfiledvalues[0]['Customfieldvalue']['custom_value'].",";
    				}
    			}
    			$impdata[$i]['productcombination']=rtrim($impdata[$i]['productcombination'],",");
    			//echopre($productcomp['Productdetail']['customvalue_id']);
    			//$customfiledvalues=$this->Customfieldvalue->findAllByid();
    			//echopre($customfiledvalues);
    			$i=$i+1;
    		}


    	}


    	return $impdata;
    }

    /*function getcsv_brands($cmbSearchType = '',$txtSearch='') {
        $this->__validateLoginStatus();
        $admsess	=	$this->Session->read('Admin');
        if($admsess["products"] <> 1) {
            $this->redirect(array('controller' => 'admins', 'action' => 'index'));
            exit();
        }

         if($cmbSearchType == "name") {
                $datas = $this->Product->find('all',array('conditions'=>array('Brand.brandname  LIKE ' => "%".addslashes($txtSearch)."%",'Brand.status  = ' => "A")));
            }else {
                $datas = $this->Product->find('all',array('conditions'=>array('Brand.status  = ' => "A")));
            }


       // $datas	=	$this->Product->findAllByStatus('A');
        $data=$this->brandexport($datas);
        $this->set('data',$data);
        $this->layout	=	'csvexp';
    }

    function brandexport($datas)
    {
    	$i=0;
    	foreach ($datas as $data){
    		set_time_limit(30);
    		$mportdata['pname']=$data['Brand']['brandname'];
    		$mportdata['descr']=$data['Brand']['descr'];
    			//echopre($productcomp['Productdetail']['customvalue_id']);
    			//$customfiledvalues=$this->Customfieldvalue->findAllByid();
    			//echopre($customfiledvalues);
    			$i=$i+1;
    		}
    	}
    	return $impdata;
    }  */

    function getcsv($cmbSearchType = '',$txtSearch='') {
        $this->__validateLoginStatus();
        $admsess	=	$this->Session->read('Admin');
        if($admsess["products"] <> 1) {
            $this->redirect(array('controller' => 'admins', 'action' => 'index'));
            exit();
        }

         if($cmbSearchType == "name") {
                $datas = $this->Product->find('all',array('conditions'=>array('Product.pname  LIKE ' => "%".addslashes($txtSearch)."%",'Product.status  = ' => "A")));
            }elseif($cmbSearchType == "category") {
                $datas = $this->Product->find('all',array('conditions'=>array('Category.cname  LIKE ' => "%".addslashes($txtSearch)."%",'Product.status  = ' => "A")));
            }else {
                $datas = $this->Product->find('all',array('conditions'=>array('Product.status  = ' => "A")));
            }


       // $datas	=	$this->Product->findAllByStatus('A');
        $data=$this->productexport($datas);

        $this->set('data',$data);



        $this->layout	=	'csvexp';
    }

    function getxls($cmbSearchType = '',$txtSearch='') {

        $this->__validateLoginStatus();

        $admsess	=	$this->Session->read('Admin');

        if($admsess["products"] <> 1) {

            $this->redirect(array('controller' => 'admins', 'action' => 'index'));

            exit();

        }
          if($cmbSearchType == "name") {
                $datas = $this->Product->find('all',array('conditions'=>array('Product.pname  LIKE ' => "%".addslashes($txtSearch)."%",'Product.status  = ' => "A")));
            }elseif($cmbSearchType == "category") {
                $datas = $this->Product->find('all',array('conditions'=>array('Category.cname  LIKE ' => "%".addslashes($txtSearch)."%",'Product.status  = ' => "A")));
            }else {
                $datas = $this->Product->find('all',array('conditions'=>array('Product.status  = ' => "A")));
            }
      //  $datas	=	$this->Product->findAllByStatus('A');
        $data=$this->productexport($datas);

        $this->set('data',$data);


        $this->layout	=	'csvexp';

    }

    function beforeFilter() {
       /* if (isset($this->Setting) && !empty($this->Setting->table)) {
            $this->Setting->load();
        }*/
        $this->loadModel('Setting');
        $this->Setting->load();
        global $sitefolder;
        global $meta_description;
        global $meta_keywords;
        global $page_title;
        global $currency;
        $cnfg 				=	Configure::read('Neutrino');
        $currency			=	$cnfg["currency"];
        $sitefolder			=	$cnfg["sitebasefolder"];
        $meta_description	=	$cnfg["meta_description"];
        $meta_keywords		=	$cnfg["meta_keywords"];
        $page_title			=	$cnfg["page_title"];
        global $style;
        $style				=	$cnfg["style"];
        $this->set('style', $style);
        $this->set('meta_description', $meta_description);
        $this->set('meta_keywords', $meta_keywords);
        $this->pageTitle = $page_title	;
        $this->set('cnfg',$cnfg);
        $this->paginate["limit"]=$cnfg["items_perpage"]; //Setting pagination limit per page.
        $this->set('sitefolder', $sitefolder);
        $httpHost	=	$_SERVER['HTTP_HOST'];
        $this->set('sitebase',FULL_BASE_URL);
        
        $facebook_key = $this->Setting->find('list',array('fields'=>array('Setting.fieldname', 'Setting.value'),'conditions'=>array('OR'=>array('Setting.fieldname'=>'facebook_app_id',' Setting.fieldname'=>'facebook_app_secret'))));   
//print_r($facebook_key);
$this->set('facebookKey', $facebook_key);    
         
                $twitterKeys = $this->Setting->find('list',array('fields'=>array('Setting.fieldname', 'Setting.value'),'conditions'=>array("Setting.fieldname IN('tweet_status','twitter_consumer_key','twitter_consumer_secret')")));

                $this->set('twitterKey', $twitterKeys); 

    }

    function beforeRender() {
        $lst	=	$this->Category->find('all',array('order' => array('position' => 'ASC')));
        if(empty($lst)===false) {
            foreach($lst as $det)
                $menu_array[$det["Category"]["id"]] = array('name' => $det["Category"]["cname"],'parent' => $det["Category"]["parent_id"], 'position' => $det["Category"]["position"]);
            $this->set('menu_array', $menu_array);
        }
        $footer_links = $this->Cmspage->find('list',array('conditions' => array('Cmspage.type' => 'content','Cmspage.status' => 'Y')));
        $this->set('footerlinks', $footer_links);
        $pages =    $this->Dynamicpage->getpages();
        //echo "hello<pre>";print_r($pages);
        $this->set('pagesdynamic', $pages);
    }

    function __validateLoginStatus() {
        if($this->Session->check('Admin') == false) {
            //$this->Session->setFlash('The URL you\'ve followed requires you login', 'default',array('class'=> 'success'));
            $this->Session->setFlash('The URL you have followed requires you login', 'default',array('class'=> 'failure'));
            $this->redirect(array('controller' => 'admins', 'action' => 'login'));
        }
    }

    function add() {
    Configure::write('debug', 0);

    //echopre($_POST);
        $this->__validateLoginStatus(); 

        $admsess	=	$this->Session->read('Admin');
        if($admsess["products"] <> 1) {
            $this->redirect(array('controller' => 'admins', 'action' => 'index'));
            exit();
        }
        global $currency;

         $curr		=	$this->Currency->findByCode($currency);

        //print_r($curr);

        $rulers = $this->Ruler->find('all');


        $this->set('rulers',$rulers);
        $this->set('curcode',$curr["Currency"]["name"]);
        $cat_cnt = $this->Category->find('count', array('fields' => 'COUNT(Category.id) as count','conditions' => array('Category.id !=' => 1)));
        if($cat_cnt == 0) {
            $this->Session->setFlash('Please add a product category before adding a product.', 'default',array('class'=> 'failure'));
            $this->redirect(array('controller' => 'categories','action'=>'index'));
            exit();
        }



        //$xfile  = "../webroot/configxml.xml";
         



        global $currency;
        $curr		=	$this->Currency->findByCode($currency);
        $this->set('curlogo',$curr["Currency"]["logo"]);
        //App::import('Xml');
        // your XML file's location
        $file = "configxml.xml";
        // now parse it
        //$parsed_xml =new XML($file);
        $parsed_xml = Xml::build($file);
        $parsed_xml = Set::reverse($parsed_xml); // this is what i call magic
        $maxnum = $parsed_xml["Configuration"] ["pno"];
        //$maxnum = 20;
        $maxnum = (int)$maxnum ;
        $curnum	=	$this->Product->getCntPdct();
     /*   if($curnum >= $maxnum) {
            $this->Session->setFlash('The Maximum Product limit exceeded!', 'default',array('class'=> 'failure'));
            $this->redirect(array('action'=>'index'));
            exit;
        }*/

        /*
        // Insert dummy prodcut entry
        $productid = $this->Session->read('tempProductId');
        //$productid = '78';
        if(!$productid){
            $this->data["Product"]["status"] = 'T';
            $this->Product->save($this->data);
            $productid = $this->Product->id;
            if ($productid > 0) $productDetailId = $this->Product->insertProductDetailData($productid);

            $this->Session->write('tempProductId', $productid);
        }

        if(!$productDetailId)
            $productDetailData = $this->Product->getProductDetailData($productid);

        $this->set('productDetailId',$productDetailId);
        $this->set('productid',$productid);
        unset($this->data);
        // Insert dummy product entry
        */


        if (!empty($this->data)) {
            $params_data = $this->data;



            //Setting 0.0 as prices if the whole sale or retail prices are not entered
            if(isset($this->data["Product"]["Set as Featured Item"]))
                $params_data["Product"]["featured"] = $this->data["Product"]["Set as Featured Item"];
            if(isset($this->data["Product"]["wholesale_price"]) && $this->data["Product"]["wholesale_price"] == '')
                $params_data["Product"]["wholesale_price"] = $this->data["Product"]["price"];
            if(isset($this->data["Product"]["price"]) && $this->data["Product"]["price"] == '')
                $params_data["Product"]["price"] = 0.0;
            if(isset($this->data["Product"]["discount_type"]) && $this->data["Product"]["discount_type"] == '')
                $params_data["Product"]["discount"] = 0.0;
            if(isset($this->data["Product"]["weight"]) && $this->data["Product"]["weight"] == '')
                $params_data["Product"]["weight"] = 0.0;

    //Product Main Image Upload Starts.
        $pdctMainImageName='';
        $i = 0;
        //if($i==$this->data["Product"]["defaultimg"])  $dfltimg='Y'; else  $dfltimg='N';

        if(!empty($this->data["Product"]["pdctfileImage"]["tmp_name"])) {
            list($width,$height,$type) = @getimagesize($this->data["Product"]["pdctfileImage"]["tmp_name"]);
            if($width >= 25 && $height >= 25) {
                $pdctfileImageFile = $this->Product->generateUniqueFilename($this->data["Product"]["pdctfileImage"]["name"]);

                $error = $this->Product->handleFileUpload($this->data["Product"]["pdctfileImage"], $pdctfileImageFile);

                if(empty($error)) {
                    if(!empty($pdctfileImageFile)) {
                        $pdctMainImageName = $pdctfileImageFile;
                        //$resObj = $this->Product->addProductImages($productid,$pdctMainImageName,$dfltimg);
                        $params_data['Product']['image1'] = $pdctMainImageName;
                    }
                        $pdctfileImageFile='';
                        $error=false;
                } else
                    $size_err.="<br />".$error;
            }
            else {
                $size_err.="<br />Please Upload Image of size greater than 25x25 pixels for product";
            }
        }
        //Product Main Image Upload Ends.

            $params_data["Product"]["max_quantity"] = $this->data["Product"]["max_quantity"];
            $params_data["Product"]["min_quantity"] = $this->data["Product"]["min_quantity"];

             $params_data["Product"]["brand_id"]      = $this->data["brand"];
//echopre1($params_data);
      

            $params_data["Product"]["id"] = $this->data["Product"]["productid"];
            $product_dimensions[]=($this->data["Product"]["length"]!=NULL)?$this->data["Product"]["length"]:0;
            $product_dimensions[]=($this->data["Product"]["width"]!=NULL)?$this->data["Product"]["width"]:0;
            $product_dimensions[]=($this->data["Product"]["heigth"]!=NULL)?$this->data["Product"]["heigth"]:0;
            $product_dimensions[]=($this->data["Product"]["grith"]!=NULL)?$this->data["Product"]["grith"]:0;

            $params_data["Product"]["prod_dimensions"] = implode(",", $product_dimensions);

            // Insert/Update product multiple categories
            $deletePMultiCategory = $this->Product->deleteProductMultiCategoryValues($this->data["Product"]["productid"]);
            $savePMultiCategory = $this->Product->saveProductMultiCategoryValues($this->data["Product"]["productid"],$this->data["Product"]['additional_category_id']);
            // Insert/Update product multiple categories

            $check_combn = $this->Category->findById($this->data["Product"]["category_id"]);

            if($check_combn["Category"]["custom_combination"]=='') {

                //Uplaoding image for digital product
                $err = false;
                if(!empty($this->data['Product']['pdctfile']['tmp_name'])) {
                    $pdctfile1 = $this->Product->generateUniqueFilename($this->data['Product']['pdctfile']['name']);
                    $error = $this->Product->handleFileUpload($this->data['Product']['pdctfile'], $pdctfile1);
                }

                if(empty($error)) {
                    if(!empty($pdctfile1)){
                        $params_data['Product']['pdctfile'] = $pdctfile1;
                    }
                    else{

                            unset($params_data['Product']['pdctfile']);
                            $this->data = $params_data;
                            //unset($this->data['Product']['pdctfile']);
                    }
                }



                $this->data = $params_data;
                //Uplaoding image for digital product
                if ($this->Product->save($this->data)) {
                    $productid = $this->Product->id;
                    $this->_uploadProductImages($productid);
                }
                $this->Session->setFlash('The Product has been saved!', 'default',array('class'=> 'success'));
                $this->redirect(array('controller' => 'products','action'=>'index'));
            }

            else if($check_combn["Category"]["custom_combination"]<>'') {

                //Uploading image for digital product
                $err = false;
                if(!empty($this->data['Product']['pdctfile']['tmp_name'])) {
                    $pdctfile1 = $this->Product->generateUniqueFilename($this->data['Product']['pdctfile']['name']);
                    $error = $this->Product->handleFileUpload($this->data['Product']['pdctfile'], $pdctfile1);
                }
                if(empty($error)) {
                    if(!empty($pdctfile1)){
                        $params_data['Product']['pdctfile'] = $pdctfile1;
                    }
                    else{

                        unset($params_data['Product']['pdctfile']);
                        $this->data = $params_data;
                        //unset($this->data['Product']['pdctfile']);
                    }
                }
                //Uploading image for digital product
                //echo '<pre>';print_r($this->data);die;

                //echopre($this->data);

                $this->data = $params_data;
                if ($this->Product->save($this->data)) {
                    $productid = $this->Product->id;
                    global $size_err;
                    $this->_uploadProductImages($productid);

                    #################  Function to Add product details starts here(Added by Shyam)	#################
                    if(isset($this->data['Product']['combn_cnt'])) {
                        //getting the last insert id.
                        $categoryid=$this->data['Product']['category_id'];
                        $pdctimage='';
                        $c=0;
                        foreach($this->data['Product']['combn_cnt'] as $k => $v) {
                            $c++;
                            foreach($this->data["Product"]["attributes$v"] as $attribval) {
                                if($attribval!='') $attrib_array[]=$attribval;
                            }
                            if(isset($attrib_array))   $attributes=implode(',',$attrib_array); else  $attributes='';
                            $stock          = $this->data["Product"]["stock$v"];

                           if($this->data["Product"]["reorderlevel$v"]!='') {
                            $reorderlevel   = $this->data["Product"]["reorderlevel$v"];
                            }else{
                            $reorderlevel = 0;
                            }

                            if($this->data["Product"]["extraprice$v"]!='')
                            {
                                $extraprice     = $this->data["Product"]["extraprice$v"];
                            }else{
                                $extraprice  = 0;
                            }




                            $skuno          = $this->data["Product"]["skuno$v"];
                            
                            

                            $productdetailid = $this->data["Product"]["pdctdetailid$v"];

                            $productImageUrl = $this->data["Product"]["prodcutimageurlfront$v"];
                            $pdctimageVal    = explode("tshirts/",$productImageUrl);
                            $pdctimage       =  $pdctimageVal[1];


                            /*
                            //Uploading Image Starts here .
                            if(!empty($this->data["Product"]["pdctfile$v"]["tmp_name"])) {
                                list($width,$height,$type) = @getimagesize($this->data["Product"]["pdctfile$v"]["tmp_name"]);
                                if($width >= 25 && $height >= 25) {
                                    $pdctfile = $this->Product->generateUniqueFilename($this->data["Product"]["pdctfile$v"]["name"]);
                                    $error = $this->Product->handleFileUpload($this->data["Product"]["pdctfile$v"], $pdctfile);
                                    if(empty($error)) {
                                        if(!empty($pdctfile))
                                            $pdctimage = $pdctfile;
                                    }
                                    else
                                        $size_err.="<br />".$error;
                                }
                                else {
                                    $size_err.="<br />Please Upload Image of size greater than 25x25 pixels for product combination".$c.".";
                                }
                            }
                            //Uploading Image Ends here ..
                            */

                            $productDetailId = $this->Product->updateProductCombinations($categoryid,$productid,$attributes,$stock,$reorderlevel,$skuno,$extraprice,$pdctimage,$productdetailid);

                            if(isset($attrib_array)) unset($attrib_array);
                            $pdctimage='';
                            $pdctfile='';
                            $error=false;
                        }
                        $this->Product->updateTotalStock($productid);
                    }

                    ################# Function to Add product details Ends here(Added by Shyam)	#################

                    if(isset($size_err) && !empty($size_err))
                        $this->Session->setFlash('The Product has been saved.'.$size_err, 'default',array('class'=> 'success'));
                    else
                        $this->Session->setFlash('The Product has been saved', 'default',array('class'=> 'success'));
                   $this->redirect(array('controller' => 'products','action'=>'edit/'.$productid.'/'.$categoryid));
                    //$this->redirect(array('controller' => 'products','action'=>'index'));
                    //$this->redirect(array('controller' => 'products'));
                    exit();
                }
            }
            //newly added for category tree listing
            $ppcat = $this->Category->find('threaded', array('order' => array('Category.position' => 'ASC')));
            $this->set('categoriesList', $ppcat);

            // $ppbrands = $this->Brand->find('list', array('conditions' =>'Brand.status = "A"','order' => array('Brand.brandname' => 'ASC')));
            $ppbrands = $this->Brand->find('all');
            $ppbrands = $this->Brand->find('list');

            $this->set('brandsList', $ppbrands);

            $this->layout = 'adm';
            $this->render();
        }
        else {
            // Insert dummy product entry
            $params_data["Product"]["status"] = 'T';
            $this->data = $params_data;
            $this->Product->save($this->data);
            $productid = $this->Product->id;


            // Insert dummy product detail entry
            if ($productid > 0) $productDetailId = $this->Product->insertProductDetailData($productid);

            // Product Multicategory
            $productMultiCateValues = $this->Product->getProductMultiCategoryValues($productid);
            $this->set('productMultiCateValues', $productMultiCateValues);

            $this->set('productDetailId',$productDetailId);
            $this->set('productid',$productid);
            // Insert dummy product entry


            $ppcat = $this->Category->find('threaded', array('order' => array('Category.position' => 'ASC')));

           // echopre($ppcat);

            $this->set('categoriesList', $ppcat);
            $catlist = $this->Category->catlist();
           // echopre1($catlist);
            $this->set('catlist', $catlist);


            //$ppbrands = $this->Brand->find('list', array('conditions' =>'Brand.status = "A"','order' => array('Brand.brandname' => 'ASC')));
            $ppbrands = $this->Brand->find('all');
            //echo "<pre>"; print_r($ppbrands); echo "</pre>";
            $this->set('brandsList', $ppbrands);

            $this->layout = 'adm';
        }
    }


    #################  Function to Add product Images starts here(Added by Shyam)	#################

    function _uploadProductImages($productid) {

        global $size_err;

        for($i=0;$i<=$this->data["Product"]["totalimg"];$i++) {

            if($i==$this->data["Product"]["defaultimg"])  $dfltimg='Y'; else  $dfltimg='N';

            $pdctimage='';

            if(!empty($this->data["Product"]["pdctimg$i"]["tmp_name"])) {

                list($width,$height,$type) = @getimagesize($this->data["Product"]["pdctimg$i"]["tmp_name"]);

                if($width >= 25 && $height >= 25) {

                    $pdctimgfile = $this->Product->generateUniqueFilename($this->data["Product"]["pdctimg$i"]["name"]);

                    $error = $this->Product->handleFileUpload($this->data["Product"]["pdctimg$i"], $pdctimgfile);

                    if(empty($error)) {

                        if(!empty($pdctimgfile))

                            $pdctimage = $pdctimgfile;

                        $this->Product->addProductImages($productid,$pdctimage,$dfltimg);

                        $pdctimgfile='';
                        $error=false;

                    }

                    else

                        $size_err.="<br />".$error;

                }

                else {

                    $size_err="<br />Please Upload Images of size greater than 25x25 pixels for product images.";

                }

            }

        }

    }

    #################  Function to Add product Images ends here(Added by Shyam)	#################



    ################# Ajax Function to show Custom fields starts here(Added by Shyam)	#################

    function showcustomfields($catid,$index,$productid,$productDetailId) {

        $this->layout = null;
        global $currency;

        $curr		=	$this->Currency->findByCode($currency);

        $this->set('curlogo',$curr["Currency"]["logo"]);


        // Get Prodcut Sides
        $pSides = $this->Customimage->getCustomImagesType($productid);

        if($productDetailId==0)
            if ($productid > 0) $productDetailId = $this->Product->insertProductDetailData($productid);

        $this->set('pSides',$pSides);
        $this->set('productid',$productid);
        $this->set('productDetailId',$productDetailId);



        $combinations=$this->Category->findById($catid);

        if($combinations['Category']['custom_combination']!='') {

            $combination=$combinations['Category']['custom_combination'];

            $split_combination=explode(',',$combination);

            foreach($split_combination as $combn) {

                $cparent=$this->Customfieldvalue->findById($combn);

                $cparents[$combn]=$cparent['Customfieldvalue']['customfield_id'];

            }

            $selected_cfields=array_unique(array_values($cparents));

            $selected_cvalues=array_keys($cparents);

            $sel_cids=array();
            $sel_cids=implode(',',$selected_cvalues);


            foreach($selected_cfields as $fieldid) {

                $temp_array= $this->Customfield->findById($fieldid);

                $selected_cfieldnames[]=$temp_array['Customfield']['custom_name'];
                $selected_cfieldId[]=$temp_array['Customfield']['id'];

            }

            unset($temp_array);
            unset($fieldid);

            //echopre($selected_cfields);
            foreach($selected_cfields as $fieldid) {

                // $temp_array= $this->Customfieldvalue->find('list',array('fields'=>array('Customfieldvalue.id', 'Customfieldvalue.custom_value'),'conditions' =>'Customfieldvalue.customfield_id  IN ('.$fieldid.')'));



              if($fieldid!='')  {

                $temp_array= $this->Customfieldvalue->find('list',array('fields'=>array('Customfieldvalue.id', 'Customfieldvalue.custom_value'),'conditions' =>'Customfieldvalue.customfield_id  IN ('.$fieldid.') AND Customfieldvalue.id IN ('.$sel_cids.')'));

                $selected_cfieldvalues[$fieldid]=$temp_array;
            }

            }



            $this->set('index', $index);

            $this->set('selected_cfieldvalues', $selected_cfieldvalues);

            $this->set('selected_cfieldnames', $selected_cfieldnames);
            $this->set('selected_cfieldId', $selected_cfieldId);

        }

        else {

            echo '';

            exit();

        }

    }

    ################# Ajax Function to show Custom fields ends here(Added by Shyam)	#################


    //------------------------Show select box for default combination-------------------------//
    function availablecombinations($catid) {
        $combinations=$this->Category->findById($catid);

        $combination=$combinations['Category']['custom_combination'];

        $split_combination=explode(',',$combination);

        foreach($split_combination as $combn) {
            $cparent=$this->Customfieldvalue->findById($combn);

            $cparents[$combn]=$cparent['Customfieldvalue']['customfield_id'];
        }

        $selected_cfields=array_unique(array_values($cparents));

        $selected_cvalues=array_keys($cparents);

        $sel_cids=array();
        $sel_cids=implode(',',$selected_cvalues);


        foreach($selected_cfields as $fieldid) {
            $temp_array= $this->Customfield->findById($fieldid);

            $selected_cfieldnames[$fieldid]=$temp_array['Customfield']['custom_name'];
            $selected_cfieldId[]=$temp_array['Customfield']['id'];
        }

        $this->set('selected_cfieldnames', $selected_cfieldnames);
        $this->set('selected_cfieldId', $selected_cfieldId);
        $this->layout = 'ajax';
    }


################# Ajax Function to show product combination image and skuno starts here(Added by Shyam)	#################

    function showcombnimage($cmbnid='',$price='',$distype='',$discnt='',$type='Front') {

                $this->layout = null;
        $cnfg 				=	Configure::read('Neutrino');
        $tieredprice	=	$cnfg['tiered_price'];
        $this->set('allowtieredprice', $tieredprice);
        $sus	=	$this->Session->read('Userlog');
        if(isset($sus) && empty($sus)===false) {

            $this->set('sus', $sus);

        }


        global $currency;

        $curr		=	$this->Currency->findByCode($currency);

        $this->set('curlogo',$curr["Currency"]["logo"]);

        $cmbn_det=$this->Productdetail->findById($cmbnid);
        $this->set('cmbn_det', $cmbn_det);


        $imageBackFront = $this->Customimage->getImages($cmbnid,$type);



        if(isset($cmbn_det["Productdetail"]["product_id"]) && $cmbn_det["Productdetail"]["product_id"] <> '') {

            $pid=$cmbn_det["Productdetail"]["product_id"];

            $prod_det=$this->Product->findById($pid);

            $this->set('prod_det', $prod_det);

            //echopre($prod_det);

        }
//echopre($cmbn_det);
        //$this->set('tieredPriceRates', '');

        if(!empty($prod_det['Productpricetier'])){
        	$priceRates = $prod_det['Productpricetier'];
        	//echo "enter0";print_r($priceRates);
        	$this->set('tieredPriceRates', $priceRates);

        }

      //  echo "enter";print_r($tieredPriceRates);
        $this->set('prod_price', $price);

        $this->set('prod_distype', $distype);

        $this->set('prod_discnt', $discnt);
        $this->set('imageBackFront', $imageBackFront);



    }

################# Ajax Function to show product combination image and skuno ends here(Added by Shyam)	#################





    function edit($id=0,$catid=0,$tab='') {
          //  Configure::write('debug', 2);


        if($id == 0) {
            $this->redirect(array('controller' => 'products','action'=>'index'));
            exit();
        }

        $this->__validateLoginStatus();
        $admsess	=	$this->Session->read('Admin');

        if($admsess["products"] <> 1) {
            $this->redirect(array('controller' => 'admins', 'action' => 'index'));
            exit();
        }
        $this->Product->id = $id;

        global $currency;

        //$this->set('tab', $tab);
            $ppbrands = $this->Brand->find('all');
            $this->set('brandsList', $ppbrands);
            $brand =  $this->Product->findById($id);
            //echopre1($brand);
            $brandid=$brand['Product']['brand_id'];

            $branddet =  $this->Brand->findById($brandid);
             
            $brandname=$brand['Brand']['brandname'];
            $this->set('brandid',$brandid);
            $this->set('brandname',$brandname);






        $curr		=	$this->Currency->findByCode($currency);
        $this->set('curlogo',$curr["Currency"]["logo"]);
        $this->set('catid',$catid);


        $this->set('curcode',$curr["Currency"]["name"]);
        $rulers = $this->Ruler->find('all');
        $this->set('rulers',$rulers);
        /*
        // Get Product Custom Side Data
        $pSides = $this->Customimage->getCustomImagesType($id);
        $this->set('pSides',$pSides);
        // Get Product Categories
        $pCategories = $this->Category->find('all',array('conditions' => array('id!=1 order by cname ASC')));
        foreach($pCategories as $pCategory){
            $pCategoryArray[] = $pCategory['Category'];
        }
        $this->set('pCategoryArray',$pCategoryArray);
        */

        $pCustomSides = $this->populateCustomSideValue($id);
        $this->set('pCustomSides',$pCustomSides);

        // Get Product Custom Side Data

        if (!empty($this->data)) { //echopre1($this->data);
             $params_data = $this->data;
            //Setting 0.0 as prices if the whole sale or retail prices are not entered
          //  if(isset($this->data["Product"]["Set as Featured Item"]))
                //$params_data["Product"]["featured"] = $this->data["Product"]["featured"];
            if(isset($this->data["Product"]["wholesale_price"]) && $this->data["Product"]["wholesale_price"] == '')
                $params_data["Product"]["wholesale_price"] = 0.0;
            if(isset($this->data["Product"]["price"]) && $this->data["Product"]["price"] == '')
                $params_data["Product"]["price"] = 0.0;
            if(isset($this->data["Product"]["discount_type"]) && $this->data["Product"]["discount_type"] == '')
                $params_data["Product"]["discount"] = 0.0;
            if(isset($this->data["Product"]["weight"]) && $this->data["Product"]["weight"] == '')
                $params_data["Product"]["weight"] = 0.0;
              // echopre1($this->data);
                
                $params_data["Product"]["brand_id"] = $this->data["brand"];
                $brandid = $this->data["brand"];
              
                
                   


              


        //Product Main Image Upload Starts.
        $pdctMainImageName='';
        $i = 0;
        //if($i==$this->data["Product"]["defaultimg"])  $dfltimg='Y'; else  $dfltimg='N';

        if(!empty($this->data["Product"]["pdctfileImage"]["tmp_name"])) {
            list($width,$height,$type) = @getimagesize($this->data["Product"]["pdctfileImage"]["tmp_name"]);
            if($width >= 25 && $height >= 25) {
                $pdctfileImageFile = $this->Product->generateUniqueFilename($this->data["Product"]["pdctfileImage"]["name"]);

                $error = $this->Product->handleFileUpload($this->data["Product"]["pdctfileImage"], $pdctfileImageFile);

                if(empty($error)) {
                    if(!empty($pdctfileImageFile)) {
                        $pdctMainImageName = $pdctfileImageFile;
                        $params_data['Product']['image1'] = $pdctMainImageName;
                        //unlink old product image start
                        $cnfg     = Configure::read('Neutrino');
                        $pimagePathMainProImage = WWW_ROOT.IMAGES_URL.'products/';

                        $mainProimage = $this->data["rmpdctfileImage"];
                        $mainProimageEx = explode(".",$mainProimage);
                        $mainProimageOrigin = $mainProimageEx[0];
                        $mainProimageExtension = $mainProimageEx[1];
                        $mainProimageOrigin_thumb = $mainProimageOrigin.'_thumb.'.$mainProimageExtension;
                        $mainProimageOrigin_disp = $mainProimageOrigin.'_disp.'.$mainProimageExtension;

                        $mainProimagePath = $pimagePathMainProImage.$mainProimage;
                        $mainProimagePath_thumb = $pimagePathMainProImage.$mainProimageOrigin_thumb;
                        $mainProimagePath_disp = $pimagePathMainProImage.$mainProimageOrigin_disp;

                        if(file_exists($mainProimagePath)) {
                            unlink($mainProimagePath);
                        }

                        if(file_exists($mainProimagePath_thumb)) {
                            unlink($mainProimagePath_thumb);
                        }

                        if(file_exists($mainProimagePath_disp)) {
                            unlink($mainProimagePath_disp);
                        }
                        //unlink old product image ends
                    }
                        $pdctfileImageFile='';
                        $error=false;
                } else
                    $size_err.="<br />".$error;
            }
            else {
                $size_err.="<br />Please Upload Image of size greater than 25x25 pixels for product";
            }
        }
        //Product Main Image Upload Ends.

            $product_dimensions[]=($this->data["Product"]["length"]!=NULL)?$this->data["Product"]["length"]:0;
            $product_dimensions[]=($this->data["Product"]["width"]!=NULL)?$this->data["Product"]["width"]:0;
            $product_dimensions[]=($this->data["Product"]["heigth"]!=NULL)?$this->data["Product"]["heigth"]:0;
            $product_dimensions[]=($this->data["Product"]["grith"]!=NULL)?$this->data["Product"]["grith"]:0;
            $params_data["Product"]["prod_dimensions"] = implode(",", $product_dimensions);

            $productid=$id;
            //Code to change category of the product if a new category is selected starts here...

            if($this->data["Product"]["hidcatid"] <> $this->data["Product"]["category_id"]) {

                $new_comb_det		=	$this->Category->findById($this->data["Product"]["category_id"]);
                $old_comb_det		=	$this->Category->findById($this->data["Product"]["hidcatid"]);

                if($new_comb_det["Category"]["custom_combination"] <> $old_comb_det["Category"]["custom_combination"]) {
                    $this->Session->setFlash('Product Attributes doesn\'t match for the selected category!', 'default',array('class'=> 'failure'));
                    $this->redirect(array('controller' => 'products','action'=>'index/'));
                    exit();
                }

                else {

                    $this->Product->updateCategory($productid,$this->data["Product"]["category_id"]);
                    $categoryid=$this->data["Product"]["category_id"];
                }

            }

            else {
                $categoryid=$this->data["Product"]["hidcatid"];
            }

            //Uplaoding image for digital product
            $err = false;
            if(!empty($this->data['Product']['pdctfile']['tmp_name'])) {
                $pdctfile1 = $this->Product->generateUniqueFilename($this->data['Product']['pdctfile']['name']);
                $error = $this->Product->handleFileUpload($this->data['Product']['pdctfile'], $pdctfile1);
            }

            if(empty($error)) {

                if(!empty($pdctfile1)){
                    $params_data['Product']['pdctfile'] = $pdctfile1;
                }
                else{
                    unset($params_data['Product']['pdctfile']);
                    $this->data = $params_data;
                    //unset($this->data['Product']['pdctfile']);
                }

            }
            //Uplaoding image for digital product
            $this->data = $params_data;

            $this->Product->save($this->data);


            //Code to change category of the product if a new category is selected ends here...

            #################  Function to Add product Images starts here(Added by Shyam)	#################

            $size_err='';

            for($i=0;$i<=$this->data["Product"]["totalimg"];$i++) {

                if($i==$this->data["Product"]["defaultimg"])

                    $dfltimg='Y'; else  $dfltimg='N';

                $pdctimage='';

                if(!empty($this->data["Product"]["pdctimg$i"]["tmp_name"])) {

                    list($width, $height,$type) = @getimagesize($this->data["Product"]["pdctimg$i"]["tmp_name"]);

                }

                if(!empty($this->data["Product"]["pdctimg$i"]["tmp_name"]) && isset($this->data["Product"]["imageid"][$i]) ) {

                    if($width >=25 && $height >=25) {

                        $pdctimgfile = $this->Product->generateUniqueFilename($this->data["Product"]["pdctimg$i"]["name"]);

                        $error = $this->Product->handleFileUpload($this->data["Product"]["pdctimg$i"], $pdctimgfile);

                        if(empty($error)) {
                            if(!empty($pdctimgfile))   $pdctimage = $pdctimgfile;
                        } else   $size_err.="<br />".$error;

                        $this->Product->updateProductImages($productid,$pdctimage,$dfltimg,$this->data["Product"]["imageid"][$i]);

                        $pdctimgfile='';
                        $error=false;
                    }

                    else {
                        $size_err="<br />Please Upload Images of size greater than 25x25 pixels for product images.";
                    }
                }

                else  if(!empty($this->data["Product"]["pdctimg$i"]["tmp_name"]) && !isset($this->data["Product"]["imageid"][$i]) ) {

                    if($width >=25 && $height >=25) {
                        $pdctimgfile = $this->Product->generateUniqueFilename($this->data["Product"]["pdctimg$i"]["name"]);
                        $error = $this->Product->handleFileUpload($this->data["Product"]["pdctimg$i"], $pdctimgfile);

                        if(empty($error)) {
                            if(!empty($pdctimgfile))   $pdctimage = $pdctimgfile;
                        } else   $size_err.="<br />".$error;

                        $this->Product->addProductImages($productid,$pdctimage,$dfltimg);
                        $pdctimgfile='';
                        $error=false;
                    }

                    else {
                        $size_err="<br />Please Upload Images of size greater than 25x25 pixels for product images.";
                    }

                }

                else  if(empty($this->data["Product"]["pdctimg$i"]["tmp_name"]) && isset($this->data["Product"]["imageid"][$i]) ) {
                    $this->Product->updateDefaultImage($productid,$dfltimg,$this->data["Product"]["imageid"][$i]);
                }
            }

            #################  Function to Add product Images ends here(Added by Shyam)	#################

            //echopre1($this->data);

            // Insert/Update product multiple categories
            $deletePMultiCategory = $this->Product->deleteProductMultiCategoryValues($productid);
            $savePMultiCategory = $this->Product->saveProductMultiCategoryValues($productid,$this->data["Product"]['additional_category_id']);
            // Insert/Update product multiple categories


            // Update product combinations
            if(isset($this->data['Product']['combn_cnt'])) {

                $pdctimage='';

                foreach($this->data['Product']['combn_cnt'] as $k => $v) {
                    $editid=explode('->',$v);
                    $indx=$editid[0];
                    foreach($this->data["Product"]["attributes$indx"] as $attribval) {
                        if($attribval!='') $attrib_array[]=$attribval;
                    }

                    if(isset($attrib_array))  $attributes=implode(',',$attrib_array); else  $attributes='';

                    $stock=$this->data["Product"]["stock$indx"];
                    $reorderlevel=$this->data["Product"]["reorderlevel$indx"];
                    $skuno=$this->data["Product"]["skuno$indx"];
                   
                    $extraprice=$this->data["Product"]["extraprice$indx"];
                    $pdctfile=$this->data["Product"]["pdctfile$indx"];
                    $productdetailid = $this->data["Product"]["pdctdetailid$indx"];

                    $productImageUrl = $this->data["Product"]["prodcutimageurlfront$indx"];
                    $pdctimageVal    = explode("tshirts/",$productImageUrl);
                    $pdctimage       =  $pdctimageVal[1];

                    $this->Product->updateProductCombinations($categoryid,$productid,$attributes,$stock,$reorderlevel,$skuno,$extraprice,$pdctimage,$productdetailid);
                    if(isset($attrib_array))  unset($attrib_array);

                    /*
                    //Uploading Image Starts here ..

                    if(!empty($this->data["Product"]["pdctfile$indx"]["tmp_name"])) {
                        list($width, $height,$type) = @getimagesize($this->data["Product"]["pdctfile$indx"]["tmp_name"]);
                    }

                    if(isset($editid[1]) && !empty($this->data["Product"]["pdctfile$indx"]["tmp_name"])) {

                        if($width >=25 && $height >=25) {

                            $pdet=$this->Productdetail->findById($editid[1]);

                            //Removing old images starts here..

                            $old_img=$pdet["Productdetail"]["pdctfile"];

                            $image	= explode(".",$old_img);

                            $this->Product->deleteMovedFile(WWW_ROOT.IMAGES_URL."products/".$old_img);

                            $this->Product->deleteMovedFile(WWW_ROOT.IMAGES_URL."products/".$image[0]."_thumb.jpg");

                            $this->Product->deleteMovedFile(WWW_ROOT.IMAGES_URL."products/".$image[0]."_disp.jpg");

                            //Removing old images ends here..

                            $pdctfile1 = $this->Product->generateUniqueFilename($this->data["Product"]["pdctfile$indx"]["name"]);

                            $error = $this->Product->handleFileUpload($this->data["Product"]["pdctfile$indx"], $pdctfile1);

                            if(empty($error)) {
                                if(!empty($pdctfile1))  $pdctimage1 = $pdctfile1;
                            }	else  $size_err.="<br />".$error;

                            $this->Product->updateProductCombinations($categoryid,$productid,$attributes,$stock,$reorderlevel,$skuno,$extraprice,$pdctimage1,$editid[1]);
                            if(isset($attrib_array))  unset($attrib_array);
                            if(isset($pdctfile1))  unset($pdctfile1);
                            if(isset($pdctimage1))  unset($pdctimage1);
                        }

                        else {
                            $size_err.="<br />Please Upload Image of size greater than 25x25 pixels for product combination.";
                        }

                    }

                    else if(isset($editid[1]) && empty($this->data["Product"]["pdctfile$indx"]["tmp_name"])) {
                        $pdet=$this->Productdetail->findById($editid[1]);
                        $pdctimage2 =$pdet["Productdetail"]["pdctfile"];
                        $this->Product->updateProductCombinations($categoryid,$productid,$attributes,$stock,$reorderlevel,$skuno,$extraprice,$pdctimage2,$editid[1]);
                        if(isset($attrib_array)) unset($attrib_array);
                        if(isset($pdctimage2)) unset($pdctimage2);
                    }

                    else if( isset($editid[0]) && !isset($editid[1]) && $attributes!='' && $stock!='') {

                        $pdctimage3='';

                        if(isset($this->data["Product"]["pdctfile$indx"]["name"]) && !empty($this->data["Product"]["pdctfile$indx"]["name"])) {

                            if($width >=25 && $height >=25) {

                                $pdctfile3 = $this->Product->generateUniqueFilename($this->data["Product"]["pdctfile$indx"]["name"]);

                                $error = $this->Product->handleFileUpload($this->data["Product"]["pdctfile$indx"], $pdctfile3);

                                if(empty($error)) {
                                    if(!empty($pdctfile3))  $pdctimage3 = $pdctfile3;
                                }	else  $size_err.="<br />".$error;

                            }

                            else {

                                $size_err.="<br />Please Upload Image of size greater than 25x25 pixels for product combination.";

                            }

                        }

                        $this->Product->addProductCombinations($categoryid,$productid,$attributes,$stock,$reorderlevel,$skuno,$extraprice,$pdctimage3);

                        if(isset($attrib_array)) unset($attrib_array);

                        if(isset($pdctfile3)) unset($pdctfile3);

                        if(isset($pdctimage3)) unset($pdctimage3);

                    } */


                } // end of For loop

            } // end of second if stmt

            if(isset($size_err) && !empty($size_err))
                $this->Session->setFlash('The Product details has been Updated.'.$size_err, 'default',array('class'=> 'success'));
            else
                $this->Session->setFlash('Product has been Updated Successfully.', 'default',array('class'=> 'success'));						// $this->redirect(array('controller' => 'products','action'=>'edit/'.$productid.'/'.$categoryid));

            $this->redirect(array('controller' => 'products','action'=>'index'));

        } // end of first if stmt

        else {

            //$ppcat	=	$this->Category->findleaf();

            //$this->set('pcat', $ppcat);
            //newly added for category tree listing
            $ppcat = $this->Category->find('threaded', array('order' => array('Category.position' => 'ASC')));
            $this->set('categoriesList', $ppcat);

            // Product Multicategory
            $productMultiCateValues = $this->Product->getProductMultiCategoryValues($id);
            $this->set('productMultiCateValues', $productMultiCateValues);

            // Delete temp product detail entries
            $deleteTempProductDetail = $this->Product->deleteTempProductDetailEntry($id);

            $this->data = $this->Product->read();

            //$pimg	=	$this->Productimages->findAllByProductId($id);
            $pimg	= $this->Productimages->find('all', array('conditions' => array('Productimages.product_id  IN ('.$id.') order by id ASC')));

            if(isset($pimg) && !empty($pimg) && sizeof($pimg) > 0) {

                $this->set('primcnt', sizeof($pimg));
                $this->set('imgarr', $pimg);
            }

            /* code for array empty */

            else {

                $this->set('primcnt', 0);

                $this->set('imgarr', 0);

            }

            $prod= array($this->data);
            $productDimensions[]= explode(',', $prod[0]['Product']['prod_dimensions']);
            //Dimensions are stored as length,width,height,grith in field 'prod_dimensions'
            $this->set('productLength',($productDimensions[0][0])!=0?$productDimensions[0][0]:'');
            $this->set('productWidth',($productDimensions[0][1])!=0?$productDimensions[0][1]:'');
            $this->set('productHeight',($productDimensions[0][2])!=0?$productDimensions[0][2]:'');
            $this->set('productGrith',($productDimensions[0][3])!=0?$productDimensions[0][3]:'');
            $this->set('productdet', $this->data);

            ############## Code to Fetch the Attributes for editing  Starts here (Added by Shyam) ##############

            $combinations=$this->Category->findById($catid);

            if($combinations['Category']['custom_combination']!='') {

                $combination=$combinations['Category']['custom_combination'];
                $split_combination=explode(',',$combination);

                foreach($split_combination as $combn) {

                    $cparent=$this->Customfieldvalue->findById($combn);
                    $cparents[$combn]=$cparent['Customfieldvalue']['customfield_id'];

                }

                $selected_cfields=array_unique(array_values($cparents));
                $selected_cvalues=array_keys($cparents);

                foreach($selected_cfields as $fieldid) {

                    $temp_array= $this->Customfield->findById($fieldid);
                    $selected_cfieldnames[]=$temp_array['Customfield']['custom_name'];
                    $selected_cfieldnames2[$fieldid]=$temp_array['Customfield']['custom_name'];
                }

                unset($temp_array);
                unset($fieldid);

                foreach($selected_cfields as $fieldid) {

                  if($fieldid!='')  {
                            $temp_array= $this->Customfieldvalue->find('list',array('fields'=>array('Customfieldvalue.id', 'Customfieldvalue.custom_value'),'conditions' =>'Customfieldvalue.customfield_id  IN ('.$fieldid.')'));
                            $selected_cfieldvalues[$fieldid]=$temp_array;
                    }
                }

                $this->set('selected_cfieldvalues', $selected_cfieldvalues);
                $this->set('selected_cfieldnames', $selected_cfieldnames);
                $this->set('selected_cfieldnames2', $selected_cfieldnames2);
            }


            $totcnt = $this->Productdetail->find('count', array('conditions' => array('Productdetail.product_id' => $id)));

            if($totcnt>0) {

                $prod_details	=	$this->Productdetail->findAllByProductId($id);
                $k=0;
                foreach($prod_details as $key => $val) {  //echopre($prod_details);

                    $edit_id[]          = $val['Productdetail']['id'];
                    $custom_combn[]     = $val['Productdetail']['customvalue_id'];
                    $edit_stock[]       = $val['Productdetail']['stock'];
                    $edit_reorderlevel[]= $val['Productdetail']['reorderlevel'];
                    $edit_skuno[]       = $val['Productdetail']['skuno'];
                    
                    $edit_extraprice[]  = $val['Productdetail']['extraprice'];
                    $edit_pdctfile[]    = $val['Productdetail']['id'].'->'.$val['Productdetail']['pdctfile'];
                    if($val['Productdetail']['pdctfile']!="")
                        $edit_pdctfrontfile[] = "tshirts/".$val['Productdetail']['pdctfile'];

                    $pSideImages[] = $this->populateCustomSideImageData($id,$val['Productdetail']['id'],$k);  //echopre($pSideImages);
                    $k++;
                    //$getCustomImages = $this->Customimage->find($val['Productdetail']['id']); echopre($getCustomImages);

                    $pFrontImages[] = $this->Customimage->getProductSideImage($val['Productdetail']['id'],'Front'); //echopre($pdtSideImage);

                }

                $j=0;

                foreach($custom_combn as $key => $val) {
                    $edit_combn["Combndetail$j"]=explode(',',$val);
                    $j++;

                }



                $this->set('prodid',$id);

                $this->set('edit_id', $edit_id);

                $this->set('edit_stock', $edit_stock);

                $this->set('edit_reorderlevel', $edit_reorderlevel);

                $this->set('edit_skuno', $edit_skuno);
            

                $this->set('edit_extraprice', $edit_extraprice);

                $this->set('edit_pdctfile', $edit_pdctfile);

                $this->set('edit_combn', $edit_combn);
                $this->set('pSideImages', $pSideImages);
                $this->set('pFrontImages', $pFrontImages);
                $this->set('edit_pdctfrontfile', $edit_pdctfrontfile);



            }

            // End of totcnt if statement

            ############## Code to Fetch the Attributes for editing  Starts here (Added by Shyam) ##############

            $this->set('totcnt',$totcnt);

            $this->layout = 'adm';

        }

    }





    function delProdcombn($catid,$prodid,$delid) {

        $admsess	=	$this->Session->read('Admin');

        if($admsess["products"] <> 1) {

            $this->redirect(array('controller' => 'admins', 'action' => 'index'));

            exit();

        }

        $this->Product->delpdctcmbn($catid,$delid);

        //----------------code to delete image combinations-----------------//
        $this->Customimage->delcombination($delid);
        //------------------------------------------------------------------//
        /***** Delete from product images ****/
        $this->Customimage->updateProductimages($prodid);

        $this->Session->setFlash('Product with the selected Combination has been  Deleted.', 'default',array('class'=> 'success'));

        $this->redirect(array('controller' => 'products','action'=>'edit/'.$prodid.'/'.$catid));

    }


    function delete($id) {

        $this->__validateLoginStatus();

        $admsess	=	$this->Session->read('Admin');

        if($admsess["products"] <> 1) {

            $this->redirect(array('controller' => 'admins', 'action' => 'index'));

            exit();

        }

        $del_prod=$this->Product->findById($id);
        //----------------code to delete image combinations-----------------//
        //$this->Customimage->delcombination($del_prod["Product"]["combination"]);
        //------------------------------------------------------------------//

        $this->Product->delpdct($id,$del_prod["Product"]["combination"]);

        $this->Session->setFlash('Product has been  Deleted.', 'default',array('class'=> 'success'));

        $this->redirect('index');

    }
    function productExternaldelete($id) {


            //$del_prod=$this->Product->findById($id);

            //echopre1($del_prod);
          
         $this->Productexternal->delete_Productexternals($id);

         $this->Productexternalsdetail->delete_Productexternalsdetails($id);

         $this->Session->setFlash('successfully deleted', 'default',array('class'=> 'success'));

         $this->redirect('externalupload');

          

    }

    function curURL() {
        $pageURL = 'http';
        $pageURL .= "://";
        if ($_SERVER["SERVER_PORT"] != "80") {
            $pageURL .= $_SERVER["SERVER_NAME"].":".$_SERVER["SERVER_PORT"].$_SERVER["REQUEST_URI"];
        } else {
            $pageURL .= $_SERVER["SERVER_NAME"].$_SERVER["REQUEST_URI"];
        }
        return $pageURL;
    }




    #### Function to show product details on User side........

    function show($name,$id=0) {



        $sus    =   $this->Session->read('Userlog');

        $fundraisermode     =  $this->Session->read('fundraisermode');
        
        $this->set('fundraisermode', $fundraisermode);
       
        

        if(isset($sus) && empty($sus)===false){
          $this->set('sus', $sus);
          $citem    =   $this->Cart->find('all', array('conditions' => array('Cart.type <>' => 'G','user_id' => $sus['id'])));
        }
        else {
          $this->set('sus', '');
          $sessid   =   $this->Session->id();
          $citem    =   $this->Cart->find('all', array('conditions' => array('Cart.type <>' => 'G','sess_id' => $sessid)));
        }




        if(!empty($sus))
        {
             $user_id = $sus['id'];
        }



        $this->set('cartcount', count($citem));

        $pageURL      = $this->curURL();
        $arrCurrentUrl = explode('/', $pageURL);
        if(is_array($arrCurrentUrl)  && count($arrCurrentUrl)>1) {
            $qryString     = end($arrCurrentUrl);
            if (preg_match("/SCRIPT/i",$qryString)) {
                $this->redirect(array('controller' => 'pages','action'=>'display'));
            }
        }
        $this->set('product_id',$id);
        $this->Customimage->delEntries1($this->Session->id());

        /*if (isset($this->Setting) && !empty($this->Setting->table)) {
            $this->Setting->load();
        }*/

        $this->loadModel('Setting');
        $this->Setting->load();
        $cnfg               =   Configure::read('Neutrino');
        $tieredprice	=	$cnfg['tiered_price'];
        $this->set('allowtieredprice', $tieredprice);
        global $page_title;

        global $sitefolder;


        $page_title			=	$name;
        if($cnfg["page_title"] <> '')
            $page_title.=' - '.$cnfg["page_title"];

        $this->set('sitefolder', $sitefolder);

        $this->pageTitle = $page_title	;
        //Facebook Setting
//        $facebookKeys='';
//        if($this->Session->check('facebookKey')) {
//            $facebookKeys=$this->Session->read('facebookKey');
//        }
//        $this->set('facebookKey', $facebookKeys);
        //Facebook Setting Ends

        //Twitter Setting
//        $twitterKeys='';
//        if($this->Session->check('twitterKey')) {
//            $twitterKeys=$this->Session->read('twitterKey');
//
//        }
//
//        $this->set('twitterKey', $twitterKeys);
        //Twitter Setting Ends

        $sus			=	$this->Session->read('Userlog');
        $uid = $sess_arr['id'];
        $this->set('sus', $sus);

        if($id == 0||$id=='') {
            //if(isset($name) && $name!='')
            //$pdet = $this->Product->find('first', array('conditions' => array('Product.pname' => $name)));
            $this->redirect(array('controller' => 'pages','action'=>'display'));
            exit();
        }
        else
            $pdet = $this->Product->find('first', array('conditions' => array('Product.id' => $id)));


        //echopre($pdet);
        
        
         $this->set('metaProductName',$pdet['Product']['pname']);
         $this->set('metaProductDescription',$pdet['Product']['descr']);

        if(isset($pdet["Product"]["id"])) {

            $id		=	$pdet["Product"]["id"];

            //Code Added By shyam for Category Menu Listing starts here..

            $lst	=	$this->Category->find('all');

            foreach($lst as $det)

                $menu_array[$det["Category"]["id"]] = array('name' => $det["Category"]["cname"],'parent' => $det["Category"]["parent_id"], 'position' => $det["Category"]["position"]);

            $this->set('menu_array', $menu_array);

            //Code Added By shyam for Category Menu Listing ends here..





            $this->Product->id = $id;

            $this->data = $this->Product->read();
//echopre($this->data);

$sizechart = $this->data['productdimensions'][0]['size'];
$this->set('sizechart', $sizechart);

           $this->data1 = $this->Productdetail->findAllByProductId($this->data['Product']['id']);
         //   echo "<pre>"; print_r($this->data1); exit;
         //   echo $this->data1['Productdetail']['id']; exit;
            //echopre($this->data1);
            $slideArray = array();
              foreach ($this->data1 as $data1)
              {

                  if($data1['Productdetail']['category_id']!=0){
              	$basepath=WWW_ROOT."/img/tshirts/";
              	if(is_file($basepath.$data1['Productdetail']['pdctfile']))
              		{
              			$img_name	= explode(".",$data1['Productdetail']['pdctfile']);
              			if(!is_file($basepath.$img_name[0]."_thumb_80.".end($img_name)))
              				{
              					$this->Resize->index($basepath.$data1['Productdetail']['pdctfile']);
              					$this->Resize->resizeImage(80,80, 'exact');
              					$this->Resize->saveImage($basepath.$img_name[0]."_thumb_80.".end($img_name), 100);
              				}
              			$data1['Productdetail']['pdctfile']=$img_name[0]."_thumb_80.".end($img_name);
              		}

				else
					{
						$data1['Productdetail']['pdctfile']="noimagessmall.gif";
					}

              	$slideArray[]=$data1;
              }
              }



              $this->set('slideArray',$slideArray);

           // echo"product detail";print_r($this->data1);exit;
            #################  Fetching the Product combination(Added by Shyam)	#################



            //Fetching Images starts here
            //echopre1($this->data);


            if(isset($this->data["Productimages"]) && !empty($this->data["Productimages"])) {
                foreach($this->data["Productimages"] as $key => $val) {
                    $imgarr[]=$val["imagename"];
                    $imgarr1[$key]['name']=$val["imagename"];
                    $imgDetail=  $this->Customimage->findByImage("tshirts/".$val["imagename"]);
                    $imgarr1[$key]['id']=$imgDetail["Customimage"]["productdetails_id"];
                    $imgarr1[$key]['type']=$imgDetail["Customimage"]["type"];
                    $imgarr1[$key]['default_img']=$val["default_img"];
                }

//echopre($imgarr);
                $this->set('imgarr', $imgarr);
                $this->set('imgarr1', $imgarr1);



            }
if($imgarr[0]){
            $fistimage = FULL_BASE_URL. $cnfg["sitebasefolder"].'/img/tshirts/'.$imgarr[0];
            $this->set('metaProductImage', $fistimage);
}
         $code_entities_match = array(' ','/','#','%','?','&','!');
    $code_entities_replace = array('-');
    $text = str_replace($code_entities_match, $code_entities_replace, $pdet['Product']['pname']);
         
         $fundUrl = FULL_BASE_URL. $cnfg["sitebasefolder"].'/'.$text.'/'.$pdet['Product']['id'];
         
         
        
          $this->set('metaProductUrl', $fundUrl);
            
            
//echo "<pre>";print_r($imgarr);exit;
            //Fetching Images ends here



//commented

          /*  if($this->data["Product"]["combination"]=='Y') {

                $pcombndet	=	$this->Productdetail->findAllByProductId($id);
//echo "<pre>";print_r($pcombndet);exit;
                for($i=0;$i<count($pcombndet);$i++) {

                    $pcmbnids=$pcombndet[$i]["Productdetail"]["customvalue_id"];

                    $pcmbnid=explode(',',$pcmbnids);

                    foreach($pcmbnid as $key => $val) {

                        if($val!='') {

                            $combnstr[]=$this->Product->getpdctcmbn($val);

                            $combinations=implode(", ",$combnstr);

                            $pcombndet[$i]["Productdetail"]["combinations"]= $combinations;

                        }

                    }

                    unset($combnstr);
                    unset($combinations);

                }

                $this->set('pcombndet', $pcombndet);

            }*/
            //commented


            //new option   $customfied = array();
            $combnstr = array();
            $combinations = array();
            $cutomfieldarray = array();
            $allcutomfieldarray = array();
            $customfied = array();
            $cunstomfield_name = array();

            $pcombndet	=	$this->Productdetail->findAllByProductId($id);

               for($i=0;$i<count($pcombndet);$i++) {

                  $pcmbnids=$pcombndet[$i]["Productdetail"]["customvalue_id"];

                  $pcmbnid=explode(',',$pcmbnids);

                    foreach($pcmbnid as $key => $val) {

                       if($val!='') {
                           $combnstr[]=$this->Product->getpdctcmbn($val);

                           $this->Product->getpdctcmbn($val);
                           $combinations=implode(", ",$combnstr);
                           $pcombndet[$i]["Productdetail"]["combinations"]= $combinations;
                           $customfied[$key][$val] = $this->Product->getpdctcmbn($val);
                           $cunstomfield_name[$key] = $this->Product->getpdctcmbnfield($val);
                        }

                    }

                   unset($combnstr);
                    unset($combinations);

                }
//                 echo "product combn";print_r($pcombndet);

                $this->set('pcombndet', $pcombndet);
                $this->set('customfied', $customfied);
                $this->set("cunstomfield_name",$cunstomfield_name);






            #################  Fetching the Product combination(Added by Shyam)	################

            if(isset($this->data["Productimages"][0]["imagename"])) {

                $defimg	=	$this->data["Productimages"][0]["imagename"];

                for($m=0; $m < sizeof($this->data["Productimages"]); $m++) {

                    if($this->data["Productimages"][$m]["default_img"] == "Y") {

                        $defimg	=	$this->data["Productimages"][$m]["imagename"];

                    }

                }
                $post_data = $this->data;
                $post_data["Productimages"]	=	$defimg;
                $this->data = $post_data;

            }else {
                $post_data = $this->data;
                $post_data["Productimages"]	= '';
                $this->data = $post_data;

            }




            $rate	=	$this->Rating->avgrate($id,'product');

            $this->set('avgrate', $rate);

            $isRated	=	$this->Rating->isRated($id,$uid,'product');

            $this->set('isRated', $rate);

           // echopre($this->data);

            $this->set('productdet', $this->data);

            global $currency;

            $curr		=	$this->Currency->findByCode($currency);

            $this->set('curlogo',$curr["Currency"]["logo"]);

            //--------------------code Aswin-------------//
            $sess_arr = $this->Session->read('Userlog');
            $uid = $sess_arr['id'];
            $this->set('uid', $uid);


        }

        else {

            $this->redirect(array('controller' => 'pages','action'=>'display'));

        }





        /*********** For Add Cart ******************/
        $sess_arr = $this->Session->read('Userlog');
        $uname = $sess_arr['uname'];
        $this->set('uname', $uname);
        $combID = ($id)?$id:20;
        $frontRear = 'Front';
        if($combID) {
            $divArray = $this->Customimage->findEntry($this->Session->id(), $frontRear);
            $this->set('divArray', $divArray);
            $coords = $this->Customimage->getcoords($combID, $frontRear);
            $regions = array("Front" => 'noimages.gif', "Rear" => 'noimages.gif');
            $img = $this->Customimage->findAllByProductdetailsId($combID);
            $prod = $this->Product->findById($combID);
            //echo "<pre>";print_r($prod);exit;

            $productname= $prod['Product']['pname'];
            $ID = '';
            if(is_array($img)) {
                foreach($img as $key=>$val) {
                    $regions[$img[$key]['Customimage']['type']] = $img[$key]['Customimage']['image'];
                    if($img[$key]['Customimage']['type'] == $frontRear) $ID = $img[$key]['Customimage']['productdetails_id'];
                }
            }
            if(!$ID) {
                $prod_detail = $this->Productdetail->findById($combID);
                $prod        = $this->Product->findById($prod_detail['Productdetail']['product_id']);
                //echo "<pre>";print_r($prod);exit;


            }
            $coords = $this->Customimage->getcoords($combID, $frontRear);//print_r($coords);
            $fonts = $this->Font->find('list', array('fields' => array('Font.name', 'Font.name'), 'conditions' => array('Font.status' => 1)));
            $txtsize = array("4" => "4", "6" => "6", "8" => "8", "10" => "10", "12" => "12", "14" => "14", "16" => "16");
            $outline = array("None" => "None", "Thin" => "Thin", "Medium" => "Medium", "Thick" => "Thick");
            $txtcurve = array("0" => "None", "140" => "Small", "180" => "Medium", "220" => "Large");

            $txtshape = array("normal" => "Normal", "roof" => "Roof", "arc" => "Arch", "curve" => "Curve", "wedge" => "Wedge");

            $txtshapeSettings["normal"] = array('0' => 'None');

            $txtshapeSettings["roof"]   = array('1' => 'Top Small',
                    '2' => 'Top Medium',
                    '3' => 'Top Large',
                    '4' => 'Middle Small',
                    '5' => 'Middle Medium',
                    '6' => 'Middle Large',
                    '7' => 'Bottom Small',
                    '8' => 'Bottom Medium',
                    '9' => 'Bottom Large',
                    '10' => 'Left Small',
                    '11' => 'Left Medium',
                    '12' => 'Left Large',
                    '13' => 'Right Small',
                    '14' => 'Right Medium',
                    '15' => 'Right Large');

            $txtshapeSettings["wedge"]  = array('1' => 'Up Widen Slow',
                    '2' => 'Up Widen Medium',
                    '3' => 'Up Widen Fast',
                    '4' => 'Up Narrow Slow',
                    '5' => 'Up Narrow Medium',
                    '6' => 'Up Narrow Fast',
                    '7' => 'Middle Widen Slow',
                    '8' => 'Middle Widen Medium',
                    '9' => 'Middle Widen Fast',
                    '10' => 'Middle Widen Slow',
                    '11' => 'Middle Widen Medium',
                    '12' => 'Middle Widen Fast',
                    '13' => 'Down Widen Slow',
                    '14' => 'Down Widen Medium',
                    '15' => 'Down Widen Fast',
                    '16' => 'Down Narrow Slow',
                    '17' => 'Down Narrow Medium',
                    '18' => 'Down Narrow Fast');

            $txtshapeSettings["arc"]    = array('1' => 'Up Very Small',
                    '2' => 'Up Small',
                    '3' => 'Up Medium',
                    '4' => 'Up Large',
                    '5' => 'Up Very Lage',
                    '6' => 'Down Very Small',
                    '7' => 'Down small',
                    '8' => 'Down Medium',
                    '9' => 'Down Large',
                    '10' => 'Down very Large');

            $txtshapeSettings["curve"]  = array('1' => 'Up Very Sharp',
                    '2' => 'Up Sharp',
                    '3' => 'Up Medium',
                    '4' => 'Up Slight',
                    '5' => 'Up Very Slight',
                    '6' => 'Up Super Slight',
                    '7' => 'Down Very Sharp',
                    '8' => 'Down Sharp',
                    '9' => 'Down Medium',
                    '10' => 'Down Slight',
                    '11' => 'Down Very Slight',
                    '12' => 'Down Super Slight');

            $this->set('limit', 12);
            $this->set('page', 1);
            //  $clipArray = $this->__readDirectory();

            //$imageArray = $this->__readCategory();

            $userclips = $this->Setting->findByFieldname('userclipart');
            $this->set('userclips', $userclips['Setting']['value']);

            //-------------------Get the entries from the settings table---------------------------------
            $data	=	$this->Setting->find('list',array('fields'=>array('Setting.fieldname', 'Setting.value')));
            $curr			=	$this->Currency->findByCode($data["currency"] );
            $this->set('pcurr', $curr["Currency"]["logo"]);

            $first_imagecost = $this->Setting->findByFieldname('first_image');
            $addn_imagecost = $this->Setting->findByFieldname('addn_image');
            $first_textcost = $this->Setting->findByFieldname('first_text');
            $addn_textcost = $this->Setting->findByFieldname('addn_text');

            $this->set("first_imagecost",$first_imagecost['Setting']['value']);
            $this->set("addn_imagecost",$addn_imagecost['Setting']['value']);
            $this->set("first_textcost",$first_textcost['Setting']['value']);
            $this->set("addn_textcost",$addn_textcost['Setting']['value']);
            //---------------------------------------------------------------------------------------------
            $frontRear = 'Front';
            $this->set('coords', $coords);
            $this->set('fonts', $fonts);
            $this->set('txtsize', $txtsize);
            $this->set('outline', $outline);
            $this->set('frontRear', $frontRear);
            $this->set('productdetailid', $combID);
            $this->set('image_front', $regions[$frontRear]);
            $this->set('imageArray', $imageArray);
            $this->set('clipArray', $clipArray);
            $this->set('txtcurve', $txtcurve);
            $this->set('txtshape', $txtshape);
            $this->set('txtshapeSettings', $txtshapeSettings);
            $palette = $this->Palette->find('all', array('conditions' => array('Palette.status' => '1'), 'orderby' => array('Palette.id')));
            $this->set('palette',$palette);
            $this->set('Productname', $productname);
            $this->set('coords', $coords);
            //---------------UID---------------//
            ($timestamp == '' || $timestamp == 0) ? $timestamp = time() : $timestamp;
            $this->set('timestamp', $timestamp);


        }   if

        ($sess_arr['id'] != "") {
            $logged_in = 1;
        }
        elseif($this->Session->read('tempUser')) {
            $logged_in = 1;
        }else {
            $logged_in = 0;
        }
        $this->set('userStatus', $logged_in);
        /***********       End Add cart ***********/

    }


    ########## Function to show reorder alert....................

    function reorder() {

        $criteria='Product.stock <= Product.reorderlevel AND status ="A"';

        list($order,$limit,$page) = $this->Pagination->init($criteria); // Added

        //$data = $this->Product->findAll($criteria, NULL, 'Product.id DESC', $limit, $page); // Extra parameters added
        $data   =   $this->Product->find('all',array("conditions"=>array("Product.stock <"=> "Product.reorderlevel","Product.status"=> 'A'),"limit"=>$limit,"page"=>$page));

        $this->set('product', $data);

        $this->layout = 'adm';

    }

    ########## Function to show search result###############################
    function search(){
        $cnfg   =   Configure::read('Neutrino');
        $sus    =   $this->Session->read('Userlog');
        $this->Session->write('fundraisermode', '0');
        if(isset($sus) && empty($sus)===false){
          $this->set('sus', $sus);
          $citem    =   $this->Cart->find('all', array('conditions' => array('Cart.type <>' => 'G','user_id' => $sus['id'])));
        }else{
          $this->set('sus', '');
          $sessid   =   $this->Session->id();
          $citem    =   $this->Cart->find('all', array('conditions' => array('Cart.type <>' => 'G','sess_id' => $sessid)));
        }
        $this->set('cartcount', count($citem));
        global $currency;
        $curr		=	$this->Currency->findByCode($currency);
        $this->set('curlogo',$curr["Currency"]["logo"]);
        //Code Added By shyam for Category Menu Listing starts here..
        $lst	=	$this->Category->find('all');
        foreach($lst as $det)
            $menu_array[$det["Category"]["id"]] = array('name' => $det["Category"]["cname"],'parent' => $det["Category"]["parent_id"]);
        $this->set('menu_array', $menu_array);
        //Code Added By shyam for Category Menu Listing ends here..
        $key	=	$_GET["srchProduct"];
        $this->pageTitle = 'Search Results';
        $criteria="Product.stock > 0 AND Product.status = 'A' AND (Product.pname  LIKE '%".addslashes($key)."%' OR Product.descr LIKE '%".addslashes($key)."%' OR Brand.brandname LIKE '%".addslashes($key)."%' OR Category.cname LIKE '%".addslashes($key)."%') ";

        $this->paginate = array(
        'conditions' => array("Product.stock >" => 'A','Product.status' => 'A','OR' => array('Product.pname LIKE' =>'%'.addslashes($key).'%','Product.descr LIKE' =>'%'.addslashes($key).'%','Brand.brandname LIKE' =>'%'.addslashes($key).'%','Category.cname LIKE' =>'%'.addslashes($key).'%')),
        'limit' =>$cnfg["items_perpage"] ,
        );
        $this->Paginator->settings = $this->paginate;
        $data = $this->paginate();

        //$log = $this->Product->getDataSource()->getLog(false, false);
        //debug($log);

        list($order,$limit,$page) = array($data,$this->request->params['paging']['Product']['limit'],$this->request->params['paging']['Product']['page']); // Added

        //list($order,$limit,$page) = $this->Pagination->init($criteria); // Added



         //$data = $this->Product->findAll($criteria, NULL, 'Product.id DESC', $limit, $page);

         $data   =   $this->Product->find('all',array("order" => array('Product.pname ASC'),"conditions" => array("Product.stock > "=> '0',"Product.status"=> 'A' ,"OR" => array("Product.pname LIKE "=> "%".addslashes($key)."%","Brand.brandname LIKE "=> "%".addslashes($key)."%","Product.descr LIKE "=> "%".addslashes($key)."%")),"limit"=>$limit,"page"=>$page));
         //echo "<pre>"; print_r($data); echo "</pre>";

        // Extra parameters added
         for($c=0; $c < sizeof($data); $c++){
            if(isset($data[$c]["Productimages"][0]["imagename"])){
                $defimg	=	$data[$c]["Productimages"][0]["imagename"];
                $data[$c]["Productimages"]	=	$defimg;
            }else{
                $data[$c]["Productimages"]	= '';
            }
        }
        $this->set('product', $data);
    }

    ######## Ajax Fuction To rate a product.........................................
    function rate($pid,$type,$rt) {
        global $sitefolder;
        $this->layout = null;
        $this->set('rated', $rt);
        $sus	=	$this->Session->read('Userlog');
        if(!empty($sus)===true) {
            /*$chk	=	$this->Rating->find('count',"Rating.user_id = ".$sus['id']." AND Rating.type = '$type' AND Rating.product_id = ".$pid);*/
            $this->loadModel('Rating');
            $chk    =   $this->Rating->find('count',array("Rating.user_id"=>$sus['id'],"Rating.type" => $type, "Rating.product_id" => $pid));
            if($chk > 0) {
                echo "err1";
                exit;
            }
            else {
                $dat["user_id"]		=	$sus["id"];
                $dat["product_id"]	=	$pid;
                $dat["rate"]		=	$rt;
                $dat["type"]		=	$type;
                if($this->Rating->save($dat)) {
                    echo "yes";
                   // $rate	=	$this->Rating->avgrate($pid);
                   // echo $rate;
                    exit;
                }
            }
        }else {
            echo "err2";
            //echo $sitefolder.'/users/login/';
            exit;
        }
    }







    ################### Function to show the Products details at adminside.............................

    function details($id) {

        $this->Product->id = $id;

        $this->data = $this->Product->read();

        $rate	=	$this->Rating->avgrate($id);

        $this->set('avgrate', $rate);

        $sus			=	$this->Session->read('Userlog');

        $this->set('sus', $sus);

        $k=0;

        $i = 0;

        $optname	=	'';

        $optionarr	=	array();

        $optionarnm	=	array();

        $inarr		=	false;

        if(isset($this->data["Productimages"][0]["imagename"])) {

            $defimg	=	$this->data["Productimages"][0]["imagename"];

            for($m=0; $m < sizeof($this->data["Productimages"]); $m++) {

                if($this->data["Productimages"][$m]["default"] == "Y") {

                    $defimg	=	$this->data["Productimages"][$m]["imagename"];

                }

            }
            $post_data = $this->data;
            $post_data["Productimages"]	=	$defimg;
            $this->data = $post_data;

        }else {
            $post_data = $this->data;
            $post_data["Productimages"]	= '';
            $this->data = $post_data;

        }

        for($m=0; $m < sizeof($this->data["Productcustomfields"]); $m++) {



            $copt	=	$this->Customfield->findById($this->data["Productcustomfields"][$m]["customfield_id"]);



            if (in_array($copt["Customfield"]["custom_name"], $optionarnm)) {

                $inarr	=	false;

            }else {

                $inarr	=	true;

            }

            if($optname <> $copt["Customfield"]["custom_name"] ) {

                $i 				=	0;

                $optname		=	$copt["Customfield"]["custom_name"];

                ///$optionarr[$k]	=	$optname."#$@^".$copt["Customfield"]["custom_value"];

                $k++;

            }

            $optionarr[$k]["name"]	=	$optname;

            $optionarr[$k]["value"][$i]	=	$copt["Customfield"]["custom_value"];

            $optionarnm[$k]	=	$copt["Customfield"]["custom_name"];

            $i++;

        }

        $this->data["Productcustomfields"]	=	$optionarr;

        $this->set('productdet', $this->data);

        global $currency;

        $curr		=	$this->Currency->findByCode($currency);

        $this->set('curlogo',$curr["Currency"]["logo"]);

        $this->layout = 'adm';

    }

    function addcrt() {

        if($_SERVER['REQUEST_METHOD'] == "POST") {

            $cid	=	$_POST["cid"];

            $pid	=	$_POST["pid"];

            $optar	=	implode("$!&*",$_POST["opt"]);

            $optar	=	base64_encode($optar);

            $this->redirect(array('controller' => 'carts','action'=>'add/'.$pid.'/'.$cid.'/'.$optar));

            exit;

        }

    }

    function addimage() {

        if($_SERVER['REQUEST_METHOD'] == "POST") {

            $pid	=	$_POST["pid"];

            $err = false;

            $i = 0;

            $ims	=	array();

            if(isset($_FILES)) {

                foreach($_FILES as $fl) {

                    if(!empty($fl['tmp_name'])) {

                        $fileName = $this->Product->generateUniqueFilename($fl['name']);

                        $error = $this->Product->handleFileUpload($fl, $fileName);

                        if(!isset($error) || $error == '') {

                            $ims[$i]	=	$fileName;

                            $i++;

                        }

                    }

                }



            }

            if(!empty($ims)) {

                foreach($ims as $img) {

                    $this->Productimages->create($csf = array());

                    $csf	=	array("product_id" => $pid, "imagename" =>$img);

                    $this->Productimages->save($csf);

                }

            }



            $this->redirect(array('controller' => 'products','action'=>'edit/'.$pid.'/img'));

            exit;

        }

    }

    function defaultimage($id,$pid) {

        if($this->Product->defaultimage($id,$pid)) {
            $this->Session->setFlash('Your default image selection have been saved.', 'default',array('class'=> 'success'));
            $this->redirect(array('controller' => 'products','action'=>'edit/'.$pid.'/img'));

            exit;

        }

    }

    function deleteimage($pid='',$cid='',$delid='',$type='') {

        if($type=='pdct') {

            $det	=	$this->Productimages->findById($delid);

            if(!empty($det["Productimages"])) {

                $imde	=	explode(".",$det["Productimages"]["imagename"]);

                $imgext  =  end(explode(".",$det["Productimages"]["imagename"]));

                $this->Product->deleteMovedFile(WWW_ROOT.IMAGES_URL."products/".$det["Productimages"]["imagename"]);

                $this->Product->deleteMovedFile(WWW_ROOT.IMAGES_URL."products/".$imde[0]."_thumb".$imgext);

                $this->Product->deleteMovedFile(WWW_ROOT.IMAGES_URL."products/".$imde[0]."_disp".$imgext);

            }

            if($this->Productimages->delete($delid)) {

                $this->Session->setFlash('Product Image has been deleted Successfully.', 'default',array('class'=> 'success'));

                $this->redirect(array('controller' => 'products','action'=>'edit/'.$pid.'/'.$cid));

                exit;

            }

        }

        if($type=='cmbn') {

            $det	=	$this->Productdetail->findById($delid);

            if(!empty($det["Productdetail"])) {

                $imde	=	explode(".",$det["Productdetail"]["pdctfile"]);

                $imgext  =  end(explode(".",$det["Productdetail"]["pdctfile"]));

                $this->Product->deleteMovedFile(WWW_ROOT.IMAGES_URL."products/".$det["Productdetail"]["pdctfile"]);

                $this->Product->deleteMovedFile(WWW_ROOT.IMAGES_URL."products/".$imde[0]."_thumb".$imgext);

                $this->Product->deleteMovedFile(WWW_ROOT.IMAGES_URL."products/".$imde[0]."_disp".$imgext);

            }

            $this->Productdetail->id = $delid;

            $this->Productdetail->saveField('pdctfile','');

            $this->Session->setFlash('Product Image has been deleted Successfully.', 'default',array('class'=> 'success'));

            $this->redirect(array('controller' => 'products','action'=>'edit/'.$pid.'/'.$cid));

            exit;

        }

    }

    ######## Ajax Fuction To show image of a product.........................................

    function shwajximg($img,$imarr,$j) {



        $this->set("img",$img);

        $this->set("imarr",$imarr);

        $this->set("j",$j);

        $this->layout = 'ajax';

    }

    ##################### Section for bulk upload and deletion of products.........................

    
    function externalupload($flag='') {
  set_time_limit(3600);



        $this->__validateLoginStatus();
        $maxpost=ini_get('post_max_size');
        $maxupload=ini_get('upload_max_filesize');
        $bulkuploadimagefolder=WWW_ROOT.IMAGES_URL.'bulkupload/';
        //echo $bulkuploadimagefolder;
        $this->set("bulkuploadimagefolder",$bulkuploadimagefolder);
        if($maxupload>$maxpost) {
            $maxupload=$maxpost;
        }

        $this->set("maxupload",$maxupload);
         $ppcat = $this->Category->find('threaded', array('order' => array('Category.position' => 'ASC')));

        $this->set('categoriesList', $ppcat);

            
           //echopre($data);
         
        
        if(isset($_POST['Import']))
        {
           
            
            $external_id = $_POST['external_id'];
            
            
            if($external_id)
            {
                foreach ($external_id as $k=>$v)
                {
                    
                    $this->Productexternal->id = $v;

              $data = $this->Productexternal->read();
              
              $consoldated_error1 = $this->checkexternalupload($data);
             //echopre($res);
              
                }
            }
            
        }
        
        
        
        if($_POST['alphaorder'])
        {
            // set up basic connection
//$conn_id = ftp_ssl_connect('ftp.appareldownload.com');
//ftp_set_option($conn_id, FTP_TIMEOUT_SEC, 50000000);
//// login with username and password
//$login_result = ftp_login($conn_id, 'A1pha', 'A1pha2oll');
//
//// get contents of the current directory
////$contents = ftp_nlist($conn_id, "/Hi-Res Web Images");
//
//// output $contents
//$local_file = "$bulkuploadimagefolder.inventory-v8-alp.txt";
//$server_file = "inventory-v8-alp.txt";
//
//
//
//ftp_pasv($conn_id, TRUE);
//// download server file
//if (ftp_get($conn_id, $local_file, $server_file, FTP_ASCII))
//  {
//  echo "Successfully written to $local_file";
//  }
//else
//  {
//  echo "Error downloading $server_file";
//  }
 
            
            $file=$bulkuploadimagefolder."inventory-alp.txt";
$linecount = 0;
$handle = fopen($file, "r");
$prodarray = array();
while(!feof($handle)){
  $line = fgets($handle);
$linearr = explode(',',$line);
  //echo "($linecount) ".$line.'<br>';
 //echo "<pre>"; print_r($linearr);
  if($linecount!=0){
  $prodarray[$linearr[4]][]=$line; 
  }
  //echo "<pre>"; print_r($linearr);
  //exit;
 
    $linecount++;
}

fclose($handle);
$i=0;
foreach ($prodarray as $k=>$v)
{
    
     if($i <= 600)
  {
            //echopre($v);
   //  if(preg_match("/(tee|polo)/i", $linearr[6])){
         
      $data = $this->data;
      
       $linearr = explode(',', $v[0]);
       //echopre($v);
      $data['Productexternal']['pname'] = $linearr[6];
      $data['Productexternal']['brand'] = $linearr[3];
      $data['Productexternal']['style_number'] = $k;
      $this->data = $data;
      $this->Productexternal->create();
      $this->Productexternal->save($this->data);
      $id = $this->Productexternal->getLastInsertID();
      foreach ($v as $k1=>$v1)
      {
          $linearr = explode(',', $v1);
          
      $data1 = $this->data;
      $data1['Productexternalsdetail']['item_number'] = $linearr[0];
      $data1['Productexternalsdetail']['gtin_number'] = $linearr[1];
      $data1['Productexternalsdetail']['color_code'] = $linearr[7];
      $data1['Productexternalsdetail']['color'] = $linearr[8];
      $data1['Productexternalsdetail']['size'] = $linearr[10];
      $data1['Productexternalsdetail']['productexternal_id'] = $id;
      $this->data = $data1;
      $this->Productexternalsdetail->create();
      $this->Productexternalsdetail->save($this->data);
     
        
      }
      
       $i++;  
      
      //}
      
      
  }else{
     // exit;
  }
    
   
}


       
            
//            $conn_id = ftp_connect('images.alphabroder.com');
//ftp_set_option($conn_id, FTP_TIMEOUT_SEC, 50000000);
//// login with username and password
//$login_result = ftp_login($conn_id, 'BBimages', 'brodimgs');
//
//// get contents of the current directory
////$contents = ftp_nlist($conn_id, "/Hi-Res Web Images");
//
//// output $contents
//$local_file = $bulkuploadimagefolder."ce401_ff_sd2.jpg";
//$server_file = "/Hi-Res Web Images/ce401_ff_sd.jpg";
//ftp_pasv($conn_id, TRUE);
//// download server file
//if (ftp_get($conn_id, $local_file, $server_file, FTP_BINARY))
//  {
//  echo "Successfully written to $local_file.";
//  }
//else
//  {
//  echo "Error downloading $server_file.";
//  }
            
            
        }
        
        
       
        
        
           if(isset($_GET["cmbSearchType"]) && isset($_GET["txtSearch"])) {
            $cmbSearchType	=	$_GET["cmbSearchType"];
            $txtSearch		=	$_GET["txtSearch"];
            if($cmbSearchType == "name") {
                $data = $this->paginate('Productexternal', array('Productexternal.pname  LIKE ' => "%".addslashes($txtSearch)."%"));
            }elseif($cmbSearchType == "brand") {
                $data = $this->paginate('Productexternal', array('Productexternal.brand  LIKE ' => "%".addslashes($txtSearch)."%"));
            }else {
                $data = $this->paginate('Productexternal');
            }
        }
        else if(isset($this->passedArgs["cmbSearchType"]) && isset($this->passedArgs["txtSearch"]) &&
                $this->passedArgs["txtSearch"] <> '') {
            $cmbSearchType	=	$this->passedArgs["cmbSearchType"];
            $txtSearch		=	$this->passedArgs["txtSearch"];
            if($cmbSearchType == "name") {
                $data = $this->paginate('Productexternal', array('Productexternal.pname  LIKE ' => "%".addslashes($txtSearch)."%"));
            }elseif($cmbSearchType == "brand") {
                $data = $this->paginate('Productexternal', array('Productexternal.brand  LIKE ' => "%".addslashes($txtSearch)."%"));
            }else {
                $data = $this->paginate('Productexternal');
            }
        }
        else {
            $data = $this->paginate('Productexternal');
        }

           
           $this->set('cmbSearchType', $cmbSearchType);
        $this->set('txtSearch', $txtSearch);
            $this->passedArgs['limit']=$this->paginate["limit"];
        $this->set('passedarg',$this->passedArgs);
         $this->set('product', $data);   
        
        
        $admsess	=	$this->Session->read('Admin');
        if($flag) {
            $consoldated_error	=	$this->Session->read('consoldated_error');
        }else {
            $this->Session->write('consoldated_error', '');
            $consoldated_error = '';
        }
        // print_r($consoldated_error);
        


      

            if($consoldated_error1) {



               // $consoldated_error1=$this->checkexternalupload($style_code);

                $this->Session->write('consoldated_error', $consoldated_error1[0]);
                $addedcount= $consoldated_error1[1]-$consoldated_error1[2];


                if($this->findKey($consoldated_error1[0],'warning')){

                     $this->set('flag',1);
                     $this->Session->setFlash('Successfully Imported '.count($_POST['external_id']).' Product(s) with some warnings, Check the error logs to see the error(s).', 'default',array('class'=> 'success'));
                }
                else {

                     $this->Session->setFlash('Successfully Imported '.count($_POST['external_id']).' Product(s)', 'default',array('class'=> 'success'));
            }


                $flag="succ";

                $this->set('consoldated_error',$consoldated_error1[0]);

                if($consoldated_error1[1]!=count($consoldated_error1[0])) {
                    $this->set('flag',$flag);
                }


                //$this->redirect(array('controller' => 'products','action'=>'bulkupload/succ'));
                //exit;

                //$this->redirect(array('controller' => 'products','action'=>'checkbulkupload/'.$pdctfile1));

                //exit;


            }else {
                if(isset($error)) {
                    $this->Session->setFlash($error, 'default',array('class'=> 'failure'));
                }
            }
        

        $this->layout = 'adm';

    }
    
    
    
    function bulkupload($flag='') {


        $this->__validateLoginStatus();
        $maxpost=ini_get('post_max_size');
        $maxupload=ini_get('upload_max_filesize');
        $bulkuploadimagefolder=WWW_ROOT.IMAGES_URL.'bulkupload/';
        $this->set("bulkuploadimagefolder",$bulkuploadimagefolder);
        if($maxupload>$maxpost) {
            $maxupload=$maxpost;
        }

        $this->set("maxupload",$maxupload);

        $admsess	=	$this->Session->read('Admin');
        if($flag) {
            $consoldated_error	=	$this->Session->read('consoldated_error');
        }else {
            $this->Session->write('consoldated_error', '');
            $consoldated_error = '';
        }
        // print_r($consoldated_error);
        if($admsess["products"] <> 1) {

            $this->redirect(array('controller' => 'admins', 'action' => 'index'));

            exit();

        }


        if (!empty($this->data)) {

            if(!empty($this->data['Product']['pdctfile']['tmp_name'])) {
                $pdctfile1 = $this->Product->generateUniqueFilename($this->data['Product']['pdctfile']['name'],WWW_ROOT.IMAGES_URL.'csv/');
                $error = $this->Product->csvUpload($this->data['Product']['pdctfile'], $pdctfile1,WWW_ROOT.IMAGES_URL.'csv/');

            }

            if(empty($error) && !empty($this->data['Product']['pdctfile']['tmp_name'])) {



                $consoldated_error1=$this->checkbulkupload($pdctfile1,true);

                $this->Session->write('consoldated_error', $consoldated_error1[0]);
                $addedcount= $consoldated_error1[1]-$consoldated_error1[2];


                if($this->findKey($consoldated_error1[0],'warning')){

                     $this->set('flag',1);
                     $this->Session->setFlash('Successfully Imported '.$addedcount.' And Updated '.$consoldated_error1[2].'Product(s) with some warnings, Check the error logs to see the error(s).', 'default',array('class'=> 'success'));
                }
                else {

                     $this->Session->setFlash('Successfully Imported '.$addedcount.' And Updated '.$consoldated_error1[2].'Product(s)', 'default',array('class'=> 'success'));
            }


                $flag="succ";

                $this->set('consoldated_error',$consoldated_error1[0]);

                if($consoldated_error1[1]!=count($consoldated_error1[0])) {
                    $this->set('flag',$flag);
                }


                //$this->redirect(array('controller' => 'products','action'=>'bulkupload/succ'));
                //exit;

                //$this->redirect(array('controller' => 'products','action'=>'checkbulkupload/'.$pdctfile1));

                //exit;


            }else {
                if(isset($error)) {
                    $this->Session->setFlash($error, 'default',array('class'=> 'failure'));
                }
            }
        }

        $this->layout = 'adm';

    }


     function findKey($array, $keySearch)
                {
                    foreach ($array as $key => $item) {
                        if ($key == $keySearch) {
                            return true;
                        }
                        else {
                            if (is_array($item) && $this->findKey($item, $keySearch)) {
                               return true;
                            }
                        }
                    }

                    return false;
          }

    function checkbulkupload($filename,$directupload=false) {

        $datfilename=WWW_ROOT.IMAGES_URL.'csv/'.$filename;

        $Seperator=",";
        $textDeliminator='"';

        if (($handle = fopen("sample.csv", "r")) !== FALSE) {
            $csvdata = fgetcsv($handle,1000, ",","'");
            $num = count($csvdata);
            for ($c=0; $c < $num; $c++) {
                $sampledata[$c]=$csvdata[$c];
            }
            fclose($handle);
        }
        //echo "<pre>"; print_r($sampledata); echo "</pre>";

        if (($handle = fopen($datfilename, "r")) !== FALSE) {
            $csvdata = fgetcsv($handle,0,$Seperator,$textDeliminator);
            $num = count($csvdata);
            for ($c=0; $c < $num; $c++) {
                $data[$c]=$csvdata[$c];
            }
            fclose($handle);
        }
        //echo "<pre>"; print_r($data); echo "</pre>";



        /*	$this->set("header",$data);
		$this->set("header_sample",$sampledata);
		$this->set("filename",$filename);
		$this->layout = 'adm';*/

        if($_SERVER['REQUEST_METHOD'] == "POST" || $directupload){
            //echo "<pre>"; print_r($sampledata);  echo "</pre>";
            //die();

            foreach ($sampledata as $key=>$value) {
                $sampledata[$key]=str_replace(" ","",$value);
            }


            if($directupload) {
                $categoryField		  =	0;
                $pnameField			    =	1;
                $descriptionField	  =	2;
                $compField          = 3;
                $stockField			    =	4;
                $priceField			    =	5;
                $weightField		    =	6;
                $imagenameField		  =	7;
                $featuredField		  =	8;
                $reorderField		    = 9;
                $skunoField			    = 10;
                $add_priceField		  =	11;
                $discountField		  =	12;
                $brandField		      =	13;
            }
            else {
                $categoryField		 = $_POST[$sampledata['0']];
                $pnameField			   = $_POST[$sampledata['1']];
                $descriptionField	 = $_POST[$sampledata['2']];
                $compField         = $_POST[$sampledata['3']];
                $stockField			   = $_POST[$sampledata['4']];
                $priceField			   = $_POST[$sampledata['5']];
                $weightField		   = $_POST[$sampledata['6']];
                $imagenameField		 = $_POST[$sampledata['7']];
                $featuredField		 = $_POST[$sampledata['8']];
                $reorderField		   = $_POST[$sampledata['9']];
                $skunoField			   = $_POST[$sampledata['10']];
                $add_priceField		 = $_POST[$sampledata['11']];
                $discountField		 = $_POST[$sampledata['12']];
                $brandField		     = $_POST[$sampledata['13']];
            }

            $row = 1;
            $sucess_count=0;
            $update_count=0;
            if (($handle = fopen($datfilename, "r")) !== FALSE) {
                while (($data = fgetcsv($handle,0,$Seperator,$textDeliminator)) !== FALSE) {
                    set_time_limit(20);
                    if($row > 1){
                        //echo "Row = ".$row."<br/>";
                        $error            = false;
                        $message          = "Success";
                        $updation         = true;
                        $message_warring  = '';
                        $skunovalue       = "";
                        $categoryid       = "";
                        $discounttype     = "";
                        $discountvalue    = "";
                        $featuredvalue    = "";
                        $reordervalue     = "";
                        $defaultcustomfield  = "";
                        $brand_id         = "";
                        //$pdctfileImage    = "";

                        //Image check
//                         $image=explode(",",$data[$imagenameField]);
//                         foreach ($image as $image) {
//                             if(!file_exists(WWW_ROOT.IMAGES_URL."bulkupload/".$image) && !is_file(WWW_ROOT.IMAGES_URL."bulkupload/".$image)) {
//                                 $error=true;
//                                 $message="Product Requires At Least One Image";
//                             }
//                         }

                        if(!$error) {
                            if(!empty($data[$compField])) {
                                //Custome Value Entries
                                $customvalues=explode(",",$data[$compField]);
                                $customevalueToCategories="";
                                //echopre1($customvalues);
                                foreach ($customvalues as $customvalue) {
                                    $customvalue=explode(":",$customvalue);
                                    $customefieldname=$customvalue[0];
                                    $customevalue=$customvalue[1];
                                    if(!empty($customevalue) && $customefieldname ) {
                                        $this->loadModel('Customfield');

                                        //$dups_id=$this->Customfield->findByCustomName(trim($customefieldname));

                                        //$dups_id=$this->Customfield->findByCustomName(trim($customefieldname));

                                        $dups_id =$this->Customfield->find('first',array('conditions' =>(array('custom_name'=>trim($customefieldname)))));
                        //echo($customefieldname);
                        
                        //echopre($dups_id);
                                        if(empty($dups_id)) {
                                            $data_customefield=array("Customfield"=>array("custom_name"=>$customefieldname));
                                            $this->Customfield->create();
                                            $this->Customfield->save($data_customefield);
                                            $updation=false;
                                        }


                                        $this->loadModel('Customfieldvalue');
                                        //$dups_id=$this->Customfield->findByCustomName(trim($customefieldname));

                                        $dups_id =$this->Customfield->find('first',array('conditions' =>(array('custom_name'=>trim($customefieldname)))));
                                        //$dups_val=$this->Customfieldvalue->checkAddDups(trim($customevalue),$dups_id["Customfield"]["id"]);
                                        $dups_val=$this->Customfieldvalue->find('all',array('conditions' => array('Customfieldvalue.customfield_id' => $dups_id["Customfield"]["id"],
                                                        'Customfieldvalue.custom_value' => $customevalue)));

                                        if(empty($dups_val)) {
                                            $data_customvalue=array("Customfieldvalue"=>array("customfield_id"=>$dups_id["Customfield"]["id"],"custom_value"=>$customevalue));
                                            $this->Customfieldvalue->create();
                                            $this->Customfieldvalue->save($data_customvalue);
                                            $updation=false;
                                        }

                                        $dups_val=$this->Customfieldvalue->find('all',array('conditions' => array('Customfieldvalue.customfield_id' => $dups_id["Customfield"]["id"],
                                                        'Customfieldvalue.custom_value' => $customevalue)));
                                        $customevalueToCategories=$dups_val[0]['Customfieldvalue']['id'].",".$customevalueToCategories;
                                    }
                                }
                            }
                            else {
                                $error=true;
                                $message="Product Combination Cannot be Empty";
                            }
                        }
                       // exit;

                        $defaultcustomfield=$dups_id["Customfield"]["id"];
                        $customevalueToCategories=rtrim($customevalueToCategories,",");


/////Customer Value Entries Disable


///Category Import
                        if(!$error) {
                            if(!empty($data[$categoryField])) {
                                $customevalueInCategories="";
                                $this->loadModel('Category');
//print_r($data[$categoryField]);
                                $category=explode("/",$data[$categoryField]);
//print_r($category);
                                $categoryCount=count($category);
                                $parentId=1;

                                for($i=0;($i<$categoryCount && !$error );$i++) {
                                    $productInCategoryCheck=null;
                                    $data_category=null;
                                    $categoryToProduct=$this->Category->find('all',array('conditions' => array('Category.parent_id' => $parentId,
                                                    'Category.cname' => $category[$i])));

                                    if(empty($categoryToProduct)) {

                                        $data_category=array("Category"=> array("parent_id" => $parentId,"cname" => $category[$i],"custom_combination" => 1));
                                        $this->Category->create();
                                        $this->Category->save($data_category);
                                        $cat_id = $this->Category->getLastInsertID();
                                        $this->Category->id =$cat_id;
                                        $this->Category->saveField('position', $cat_id);
                                        $updation=false;
                                        //sleep(2);
                                    }
                                    unset($categoryToProduct);


                                    //exit();
                                    $categoryToProduct=$this->Category->find('all',array('conditions' => array('Category.parent_id' => $parentId,
                                                    'Category.cname' => $category[$i])));
                                    if($categoryToProduct[0]['Category']['custom_combination']>0) {
                                        $customevalueInCategories=$categoryToProduct[0]['Category']['custom_combination'].",".$customevalueInCategories;
                                    }
                                    if((($i+1)<$categoryCount)) {
                                        //check is their product under parent category
                                        $productInCategoryCheck=null;
                                        $parentId=$categoryToProduct[0]['Category']['id'];
                                        $productInCategoryCheck=$this->Product->findByCategoryId($parentId);
                                        if(is_array($productInCategoryCheck)) {

                                            $error=true;
                                            $message="Product Already Exist in Parent Category";
                                        }

                                    }

                                }

                                $subcategorycheck=$this->Category->find('all',array('conditions' => array('Category.parent_id' => $categoryToProduct[0]['Category']['id']
                                )));

                                if(!empty($subcategorycheck)) {
                                    $error=true;
                                    $message="SubCategory exist under this category";
                                }


                            }

                            else {
                                $error=true;
                                $message="Category Field Cannot Be empty";
                            }
                        }

                        //Brand Import
                        if(!empty($data[$brandField])){
                            $brandToProduct  = $this->Brand->find('all',array('conditions' => array('Brand.brandname' => $data[$brandField])));
                            //echo "<pre>"; print_r($brandToProduct); echo "</pre>";

                            if(empty($brandToProduct)){
                                $data_brands = array("Brand"=> array("brandname" => $data[$brandField],"status" => "A"));
                                $this->Brand->create();
                                $this->Brand->save($data_brands);
                                $brand_id = $this->Brand->getLastInsertID();
                            }else{
                                $brand_id = $brandToProduct[0]['Brand']['id'];
                            }
                        }

                        if(empty($data[$pnameField])) {
                            $error=true;
                            $message="Product Field Cannot Be empty";
                        }

                        if(!$error){
                            $valueInCategories=null;
                            $customevalueInCategories=rtrim($customevalueInCategories,",");
                            $customevalueInCategories=explode(",",$customevalueInCategories);
                            $customevalueToCategories=explode(",",$customevalueToCategories);
// print_r($customevalueInCategories);
// print_r($customevalueToCategories);
                            $valueInCategories=array_merge($customevalueToCategories,$customevalueInCategories);
                            $valueInCategories=array_unique($valueInCategories);
                            //exit();
                            $valueInCategories=implode(",",$valueInCategories);
                            //echopre1($valueInCategories);

                            if($valueInCategories!=null) {
                                $valueInCategories=rtrim($valueInCategories,",1");
                                $this->Category->id = $categoryToProduct[0]['Category']['id']; // This avoids the query performed by read()
                                $this->Category->saveField('custom_combination', $valueInCategories);
                            }
                            $categoryid = $categoryToProduct[0]['Category']['id'];



                            if($skunoField=="NA" || empty($data[$skunoField])) {
                                $skunovalue="";
                            }
                            else {
                                $skunovalue=$data[$skunoField];
                            }


                            if(!(preg_match('/^[0-9]*$/', $data[$stockField])) || empty($data[$stockField])) {
                                $error=true;
                                $message="Stock Cannot Be Empty,It Should Be Numeric Value";
                            }

                            if($reorderField =="NA" || empty($data[$reorderField])) {
                                $reordervalue=0;
                            }
                            else {
                                if(!(preg_match('/^[0-9]*$/',$data[$reorderField])) || $data[$reorderField] > $data[$stockField] ) {
                                    $reordervalue=0;
                                    $message_warring="Improper Re-Order Value";
                                }
                                else {
                                    $reordervalue=$data[$reorderField];
                                }
                            }

                            if(!is_numeric($data[$priceField])) {
                                $error=true;
                                $message="Price Cannot Be Empty,It Should Be an Numeric Value";

                            }

                            if(!(strlen($data[$descriptionField])>0)) {
                                $error=true;
                                $message="Description Cannot Be Empty";
                            }

                            if($discountField=="NA" || empty($data[$discountField])) {
                                $discounttype=0;
                                $discountvalue="";
                            }
                            else {
                                if((strlen($data[$discountField])>0)) {

                                    $discountvalue=explode("%",$data[$discountField]);

                                    if(count($discountvalue)>1) {
                                        $discounttype="per";


                                        if(!(is_numeric($discountvalue[0]))) {
                                            $message_warring.="Wrong Entry In Discount Field";
                                            $discounttype="";
                                            $discountvalue=0;
                                        }
                                        else {
                                            $discountvalue=$discountvalue[0];
                                        }
                                    }

                                    else if((is_numeric($data[$discountField]))) {
                                        $discounttype="amnt";
                                        $discountvalue=$data[$discountField];
                                    }

                                    else {
                                        $discountvalue=trim($data[$discountField]);
                                        $discountvalue=substr($discountvalue, 0,-1);
                                        if(!(is_numeric($data[$discountField]))) {
                                            $discounttype="amnt";
                                            $discountvalue=$data[$discountField];
                                        }
                                        else {
                                            $message_warring.="Wrong Entry In Discount Field";
                                            $discounttype="";
                                            $discountvalue=0;
                                        }
                                    }
                                }
// 												echo $message_warring;
// 												echo $discounttype;
// 												echo $discountvalue;
// 												echo $row;
                            }

                            if($featuredField=="NA" || empty($data[$featuredField])) {
                                $featuredvalue=0;
                            }
                            else {
                                if($data[$featuredField]!="1")
                                    $featuredvalue=0;
                                else
                                    $featuredvalue=1;
                            }

                            if(!(is_numeric($data[$weightField]))) {
                                $error=true;
                                $message="Weight Field Cannot Be Empty";
                            }

                            if($add_priceField=="NA" ||empty($data[$add_priceField])) {
                                $add_pricevalue=0;
                            }
                            else {
                                if(!(is_numeric($data[$add_priceField]))) {
                                    $message_warring="Additional Price should be Numeric";
                                    $add_pricevalue=0;
                                }
                                else {
                                    $add_pricevalue=$data[$add_priceField];
                                }

                            }


                            if(!$error) {

                                $customevalueToCategories=implode(",", $customevalueToCategories);
                                $product_dup="";
                                $product_dup=$this->Product->find('all',array('conditions' => array('category_id' => $categoryid,
                                                'Product.pname' => $data[$pnameField],
                                                 'Product.descr'=>$data[$descriptionField],
                                				'Product.status'=>'A'
                                        )
                                        )
                                );

                                if(!empty($product_dup)) {
                                    $productid=$product_dup[0]["Product"]["id"];
                                    $data_product=array(
                                                    "Product"           => array(
                                                        "category_id"       => $categoryid,
                                                        "pname"             => Sanitize::escape($data[$pnameField]),
                                                        "stock"             => $data[$stockField],
                                                        "reorderlevel"      => $reordervalue,
                                                        "skuno"             => $skunovalue,
                                                        "price"             => $data[$priceField],
                                                        "descr"             => Sanitize::escape($data[$descriptionField]),
                                                        "discount_type"     => $discounttype,
                                                        "discount"          => $discountvalue,
                                                        "featured"          => $featuredvalue,
                                                        "weight"            => $data[$weightField],
                                                        "defaultattribute"  => $defaultcustomfield,
                                                        "combination"       => "Y",
                                                        "prodtype"          => "Physical",
                                                        "brand_id"          => $brand_id
                                                      )
                                                    );

                                    //echo '<pre>';  print_r($data_product); echo '</pre>';
                                    $this->Product->updateProductDetailData($productid, $data_product);

                                }
                                else {

                                    $data_product=array("Product"=> array("category_id"	=> 	$categoryid,
                                                    "pname"		          => Sanitize::escape($data[$pnameField]),
                                                    "stock"		          => $data[$stockField],
                                                    "reorderlevel"      => $reordervalue,
                                                    "attributes1"       => $customevalueToCategories,
                                                    "skuno"		          => $skunovalue,
                                                    "price"		          => $data[$priceField],
                                                    "descr"		          => Sanitize::escape($data[$descriptionField]),
                                                    "discount_type"     => $discounttype,
                                                    "discount"          => $discountvalue,
                                                    "featured"          => $featuredvalue,
                                                    "weight"		        => $data[$weightField],
                                                    "defaultattribute"  => $defaultcustomfield,
                                                    "combination"       => "Y",
                                                    "prodtype"          => "Physical",
                                                    "brand_id"          => $brand_id

                                    ));
                                    //echo "<pre>"; print_r($data_product); echo "</pre>";
                                    $this->Product->create();
                                    $this->Product->save($data_product);
                                    $productid = $this->Product->id;
                                    $updation=false;
                                }

                                //Product Combination finding
                                $productcomp_dup=$this->Productdetail->find('all',array('conditions' => array('category_id' => $categoryid,
                                                'product_id' => $productid,
                                                'customvalue_id'=>$customevalueToCategories,
                                                'skuno'=>$skunovalue
                                        )
                                        )
                                );
                                $pdctimage="";
                                if(!empty($productcomp_dup)){

                                    //$this->Product->updateProductCombinations($categoryid,$productid,$customevalueToCategories,$data[$stockField],$reordervalue,$skunovalue,$add_pricevalue,$pdctimage,$productcomp_dup[0]['Productdetail']['id']);

                                }
                                else {
                                    $this->Product->addProductCombinations($categoryid,$productid,$customevalueToCategories,$data[$stockField],$reordervalue,$skunovalue,$add_pricevalue,$pdctimage);

                                    $productcomp_dup=$this->Productdetail->find('all',array('conditions' => array('category_id' => $categoryid,
                                                    'product_id' => $productid,
                                                    'customvalue_id'=>$customevalueToCategories,
                                                    'skuno'=>$skunovalue
                                            )
                                            )
                                    );
                                    $updation=false;

                                }
//Array ( [Customimage] => Array ( [doublesided] => N [image_type] => Front [coord_top] => 89,138 [coord_left] => 306,399 [proddetail_id] => 68 [image_path] => tshirts/13683517812.png [img_field] => Array ( [name] => [type] => [tmp_name] => [error] => 4 [size] => 0 ) ) )

// 									print_r($data);
//echo $data[$imagenameField];


                                $images=explode(";",$data[$imagenameField]);
                                $i=0;
//print_r($image);
                                $imageexist=false;

                                $imgCount = 0;
                                //App::import('Controller', 'CustomimagesController');
                                foreach ($images as $imgKey => $image) { //echo WWW_ROOT.IMAGES_URL."bulkupload/".$image; exit;

                                    //$customimage = new CustomimagesController();
                                    $this->loadModel('Customimage');

                                    //Load model, components...
                                    //$this->customimage->constructClasses();
                                    if(file_exists(WWW_ROOT.IMAGES_URL."bulkupload/".$image) && is_file(WWW_ROOT.IMAGES_URL."bulkupload/".$image)) {




                                        $imageexist=true;

                                        $imgCount++;

                                        $imagedata['location']=WWW_ROOT.IMAGES_URL."bulkupload/".$image;
                                        $imagedata['name']=$image;
                                        $response=$this->upload(true,$imagedata);
                                        //echopre1($response);

                                        if($response['error_message']=="sucess") {

                                            if($i==0) {
                                                $type="Front";
                                            }
                                            else {
                                                $type="Side_".$i;

                                                $customimagetype = $this->Customimage->prdCustomimagetypes($productid, $type);
                                                /*$customimagetype= $this->Customimagetypes->find('all',array('conditions' => array('customimagetypes.productid' => $productid,
                                                                'customimagetypes.type' => $type
                                                        )
                                                        )
                                                );*/

                                                if(empty($customimagetype)) {



                                                    $data_customimage['productid']=$productid;
                                                    $data_customimage['type']=ucfirst($type);
                                                    $this->Customimagetypes->create();
                                                    $this->Customimagetypes->save($data_customimage);
                                                }

                                            }
                                            $i=$i+1;
                                            $image_duplicate=$this->Customimage->getImages($productcomp_dup[0]['Productdetail']['id'],$type);


                                            if(empty($image_duplicate)) {
                                                $this->Coordinate->create();
                                                $this->Coordinate->saveField('x1_axis',180);
                                                $this->Coordinate->saveField('y1_axis',180);
                                                $this->Coordinate->saveField('x2_axis',332);
                                                $this->Coordinate->saveField('y2_axis',332);
                                                $coordID = $this->Coordinate->id;

                                                //-------------save to customimages table------------------------//

                                                $this->Customimage->create();
                                                $this->Customimage->saveField('productdetails_id',$productcomp_dup[0]['Productdetail']['id']);
                                                $this->Customimage->saveField('type',$type);
                                                $this->Customimage->saveField('image',str_replace(WWW_ROOT.IMAGES_URL,"",$response['filename']));
                                                $custimgID = $this->Customimage->id;

                                                //--------------------save to imageregions table---------------//
                                                $this->Imageregion->create();
                                                $this->Imageregion->saveField('customimages_id',$custimgID);
                                                $this->Imageregion->saveField('coordinates_id',$coordID);


                                                $img = explode("/",str_replace(WWW_ROOT.IMAGES_URL,"",$response['filename']));
                                                $img1=end($img);
                                                $img2=explode(".",$img1);
                                                $imgNam=$img2[0];
                                                $imgArray       = explode(".",$response['filename']);
                                                $imgExt         = strtolower(end($imgArray));
                                                $thumbfileName  = $imgNam."_thumb".".".$imgExt;
                                                $dispfileName   = $imgNam."_disp".".".$imgExt;
                                                $sliderfileName   = $imgNam."_slider".".".$imgExt;
                                                $fileName       = $imgNam.".".$imgExt;
                                                /**********************/


                                                copy($response['filename'],WWW_ROOT.IMAGES_URL."products/".$fileName);

                                                $this->Resize->index($response['filename']);
                                                $this->Resize->resizeImage(170, 170, 'exact');
                                                $this->Resize->saveImage(WWW_ROOT.IMAGES_URL."products/".$dispfileName, 100);

                                                $this->Resize->index($response['filename']);
                                                $this->Resize->resizeImage(48, 48, 'exact');
                                                $this->Resize->saveImage(WWW_ROOT.IMAGES_URL."products/".$thumbfileName, 100);


                                                $this->Customimage->updateProduct($productcomp_dup[0]['Productdetail']['id'],$type,$fileName,'');

                                                //	$this->Productdetail->save($data);
                                            }
                                            else {

                                                $img = explode("/",str_replace(WWW_ROOT.IMAGES_URL,"",$response['filename']));
                                                $img1=end($img);
                                                $img2=explode(".",$img1);
                                                $imgNam=$img2[0];
                                                $defaultVal     =($this->data["Customimage"]["image_type"]=="Front")?"Y":"N";
                                                $imgArray       = explode(".",$this->data["Customimage"]["image_path"]);
                                                $imgExt         = strtolower(end($imgArray));
                                                if(empty($imgExt))
                                                    $imgExt = pathinfo($response['filename'], PATHINFO_EXTENSION);
                                                $thumbfileName  = $imgNam."_thumb".".".$imgExt;
                                                $dispfileName   = $imgNam."_disp".".".$imgExt;
                                                $fileName       = $imgNam.".".$imgExt;

                                                copy($response['filename'],WWW_ROOT.IMAGES_URL."products/".$fileName);
                                                $this->Resize->index($response['filename']);
                                                $this->Resize->resizeImage(170, 170, 'exact');
                                                $this->Resize->saveImage(WWW_ROOT.IMAGES_URL."products/".$dispfileName, 100);


                                                $this->Resize->index($response['filename']);
                                                $this->Resize->resizeImage(48, 48, 'exact');
                                                $this->Resize->saveImage(WWW_ROOT.IMAGES_URL."products/".$thumbfileName, 100);

                                                $this->Customimage->updateCustomimages('tshirts/'.$fileName,$image_duplicate[0]['CRD']['id']);

                                                $this->Customimage->updateProductimages($productcomp_dup[0]['Productdetail']['product_id']);

                                                    //$Productdetail->Session->read('prodID'));

                                                if(!$imgKey)

                                                    $this->Customimage->updateProduct($productcomp_dup[0]['Productdetail']['id'],$type,$fileName,'');
                                                //$this->Customimage->updateCustomimages($fileName,$productcomp_dup[0]['Productdetail']['id']);
                                                //if($defaultVal=="Y")
                                                    //$this->Customimage->updateProduct($productcomp_dup[0]['Productdetail']['id'],$type,$fileName);

                                                //$this->Customimage->updateProductimages($this->Session->read('prodID'));
                                                //------------update coordinates table-----------------------//

                                                $this->Customimage->updatecoords($productcomp_dup[0]['Productdetail']['id'],"180,180","332,332");


                                            }



                                        }

                                        else{

                                                $message_warring = $response['error_message'] ." for the product --".$data[$pnameField];
                                         }
                                    }
                                    else {


                                         $message_warring= "Image -  ".$image." - missing in upload folder for the product --". $data[$pnameField];
                                    }
                                }



                            }
                        }


                        if($imgCount==0)
                        {

                                    $message_warring="Requires at least one image for the product --".$data[$pnameField];

                        }




                        if($message=='Success') {
                            $consoldated_error[$row]['succ']=$message;
                            $sucess_count=$sucess_count+1;
                            if($updation) {
                                $update_count=$update_count+1;
                            }

                        if($message_warring!='')
                        {
                            $consoldated_error[$row]['warning']=$message_warring;
                        }

                        }else {


                            $consoldated_error[$row]['error']=$message;
                        }

                    }


                    $row++;


                }

//print_r($consoldated_error);

                fclose($handle);
            }




            /*
			$pname			=	$_POST["pname"];

			$description	=	$_POST["pdescr"];

			$wholesale_price =	$_POST["wholesale_price"];

			$retail_price    =	$_POST["retail_price"];

			$weight			=	$_POST["weight"];

			$reorder		=	$_POST["reorder"];

			$stock			=	$_POST["stock"];
            */

            unlink(WWW_ROOT.IMAGES_URL.'csv/'.$filename);

            $info[0]=$consoldated_error;
            $info[1]=$sucess_count;
            $info[2]=$update_count;
            return  $info;



        }



    }

    
    
    function externalComboAdd($data)
    {
        //echopre1($data);  
         $categoryField		  =	0;
                $pnameField			    =	1;
                $descriptionField	  =	2;
                $compField          = 3;
                $stockField			    =	4;
                $priceField			    =	5;
                $weightField		    =	6;
                $imagenameField		  =	7;
                $featuredField		  =	8;
                $reorderField		    = 9;
                $skunoField			    = 10;
                $add_priceField		  =	11;
                $discountField		  =	12;
                $brandField		      =	13;
        
        
        
                        //echo "Row = ".$row."<br/>";
                        $error            = false;
                        $message          = "Success";
                        $updation         = true;
                        $message_warring  = '';
                        $skunovalue       = "";
                        $categoryid       = "";
                        $discounttype     = "";
                        $discountvalue    = "";
                        $featuredvalue    = "";
                        $reordervalue     = "";
                        $defaultcustomfield  = "";
                        $brand_id         = "";
                        //$pdctfileImage    = "";

                        //Image check
//                         $image=explode(",",$data[$imagenameField]);
//                         foreach ($image as $image) {
//                             if(!file_exists(WWW_ROOT.IMAGES_URL."bulkupload/".$image) && !is_file(WWW_ROOT.IMAGES_URL."bulkupload/".$image)) {
//                                 $error=true;
//                                 $message="Product Requires At Least One Image";
//                             }
//                         }

                        if(!$error) {
                            if(!empty($data[$compField])) {
                                //Custome Value Entries
                                $customvalues=explode(",",$data[$compField]);
                               // echopre1($customvalues);
                                $customevalueToCategories="";
                                foreach ($customvalues as $customvalue) {
                                    $customvalue=explode(":",$customvalue);
                                    $customefieldname=$customvalue[0];
                                    $customevalue=$customvalue[1];
                                    if(!empty($customevalue) && $customefieldname ) {
                                        $this->loadModel('Customfield');

                                        //$dups_id=$this->Customfield->findByCustomName(trim($customefieldname));

                                        //$dups_id=$this->Customfield->findByCustomName(trim($customefieldname));

                                        $dups_id =$this->Customfield->find('first',array('conditions' =>(array('custom_name'=>trim($customefieldname)))));

                                        if(empty($dups_id)) {
                                            $data_customefield=array("Customfield"=>array("custom_name"=>$customefieldname));
                                            $this->Customfield->create();
                                            $this->Customfield->save($data_customefield);
                                            $updation=false;
                                        }


                                        $this->loadModel('Customfieldvalue');
                                        //$dups_id=$this->Customfield->findByCustomName(trim($customefieldname));

                                        $dups_id =$this->Customfield->find('first',array('conditions' =>(array('custom_name'=>trim($customefieldname)))));
                                        //$dups_val=$this->Customfieldvalue->checkAddDups(trim($customevalue),$dups_id["Customfield"]["id"]);
                                        $dups_val=$this->Customfieldvalue->find('all',array('conditions' => array('Customfieldvalue.customfield_id' => $dups_id["Customfield"]["id"],
                                                        'Customfieldvalue.custom_value' => $customevalue)));

                                        if(empty($dups_val)) {
                                            $data_customvalue=array("Customfieldvalue"=>array("customfield_id"=>$dups_id["Customfield"]["id"],"custom_value"=>$customevalue));
                                            $this->Customfieldvalue->create();
                                            $this->Customfieldvalue->save($data_customvalue);
                                            $updation=false;
                                        }

                                        $dups_val=$this->Customfieldvalue->find('all',array('conditions' => array('Customfieldvalue.customfield_id' => $dups_id["Customfield"]["id"],
                                                        'Customfieldvalue.custom_value' => $customevalue)));
                                        $customevalueToCategories=$dups_val[0]['Customfieldvalue']['id'].",".$customevalueToCategories;
                                    }
                                }
                            }
                            else {
                                $error=true;
                                $message="Product Combination Cannot be Empty";
                            }
                        }


                        $defaultcustomfield=$dups_id["Customfield"]["id"];
                        $customevalueToCategories=rtrim($customevalueToCategories,",");


/////Customer Value Entries Disable


///Category Import
                        if(!$error) {
                            if(!empty($data[$categoryField])) {
                                $customevalueInCategories="";
                                $this->loadModel('Category');
//print_r($data[$categoryField]);
                                $category=explode("/",$data[$categoryField]);
//print_r($category);
                                $categoryCount=count($category);
                                $parentId=1;

                                for($i=0;($i<$categoryCount && !$error );$i++) {
                                    $productInCategoryCheck=null;
                                    $data_category=null;
                                    $categoryToProduct=$this->Category->find('all',array('conditions' => array('Category.parent_id' => $parentId,
                                                    'Category.cname' => $category[$i])));

                                    if(empty($categoryToProduct)) {

                                        $data_category=array("Category"=> array("parent_id" => $parentId,"cname" => $category[$i],"custom_combination" => 1));
                                        $this->Category->create();
                                        $this->Category->save($data_category);
                                        $cat_id = $this->Category->getLastInsertID();
                                        $this->Category->id =$cat_id;
                                        $this->Category->saveField('position', $cat_id);
                                        $updation=false;
                                        //sleep(2);
                                    }
                                    unset($categoryToProduct);


                                    //exit();
                                    $categoryToProduct=$this->Category->find('all',array('conditions' => array('Category.parent_id' => $parentId,
                                                    'Category.cname' => $category[$i])));
                                    if($categoryToProduct[0]['Category']['custom_combination']>0) {
                                        $customevalueInCategories=$categoryToProduct[0]['Category']['custom_combination'].",".$customevalueInCategories;
                                    }
                                    if((($i+1)<$categoryCount)) {
                                        //check is their product under parent category
                                        $productInCategoryCheck=null;
                                        $parentId=$categoryToProduct[0]['Category']['id'];
                                        $productInCategoryCheck=$this->Product->findByCategoryId($parentId);
                                        if(is_array($productInCategoryCheck)) {

                                            $error=true;
                                            $message="Product Already Exist in Parent Category";
                                        }

                                    }

                                }

                                $subcategorycheck=$this->Category->find('all',array('conditions' => array('Category.parent_id' => $categoryToProduct[0]['Category']['id']
                                )));

                                if(!empty($subcategorycheck)) {
                                    $error=true;
                                    $message="SubCategory exist under this category";
                                }


                            }

                            else {
                                $error=true;
                                $message="Category Field Cannot Be empty";
                            }
                        }

                        //Brand Import
                        if(!empty($data[$brandField])){
                            $brandToProduct  = $this->Brand->find('all',array('conditions' => array('Brand.brandname' => $data[$brandField])));
                            //echo "<pre>"; print_r($brandToProduct); echo "</pre>";

                            if(empty($brandToProduct)){
                                $data_brands = array("Brand"=> array("brandname" => $data[$brandField],"status" => "A"));
                                $this->Brand->create();
                                $this->Brand->save($data_brands);
                                $brand_id = $this->Brand->getLastInsertID();
                            }else{
                                $brand_id = $brandToProduct[0]['Brand']['id'];
                            }
                        }

                        if(empty($data[$pnameField])) {
                            $error=true;
                            $message="Product Field Cannot Be empty";
                        }

                        if(!$error){
                            $valueInCategories=null;
                            $customevalueInCategories=rtrim($customevalueInCategories,",");
                            $customevalueInCategories=explode(",",$customevalueInCategories);
                            $customevalueToCategories=explode(",",$customevalueToCategories);
// print_r($customevalueInCategories);
// print_r($customevalueToCategories);
                            $valueInCategories=array_merge($customevalueToCategories,$customevalueInCategories);
                            $valueInCategories=array_unique($valueInCategories);
                            //exit();
                            $valueInCategories=implode(",",$valueInCategories);


                            if($valueInCategories!=null) {
                                $valueInCategories=rtrim($valueInCategories,",1");
                                $this->Category->id = $categoryToProduct[0]['Category']['id']; // This avoids the query performed by read()
                                $this->Category->saveField('custom_combination', $valueInCategories);
                            }
                            $categoryid = $categoryToProduct[0]['Category']['id'];



                            if($skunoField=="NA" || empty($data[$skunoField])) {
                                $skunovalue="";
                            }
                            else {
                                $skunovalue=$data[$skunoField];
                            }


                            if(!(preg_match('/^[0-9]*$/', $data[$stockField])) || empty($data[$stockField])) {
                                $error=true;
                                $message="Stock Cannot Be Empty,It Should Be Numeric Value";
                            }

                            if($reorderField =="NA" || empty($data[$reorderField])) {
                                $reordervalue=0;
                            }
                            else {
                                if(!(preg_match('/^[0-9]*$/',$data[$reorderField])) || $data[$reorderField] > $data[$stockField] ) {
                                    $reordervalue=0;
                                    $message_warring="Improper Re-Order Value";
                                }
                                else {
                                    $reordervalue=$data[$reorderField];
                                }
                            }

                            if(!is_numeric($data[$priceField])) {
                                $error=true;
                                $message="Price Cannot Be Empty,It Should Be an Numeric Value";

                            }

                            if(!(strlen($data[$descriptionField])>0)) {
                                $error=true;
                                $message="Description Cannot Be Empty";
                            }

                            if($discountField=="NA" || empty($data[$discountField])) {
                                $discounttype=0;
                                $discountvalue="";
                            }
                            else {
                                if((strlen($data[$discountField])>0)) {

                                    $discountvalue=explode("%",$data[$discountField]);

                                    if(count($discountvalue)>1) {
                                        $discounttype="per";


                                        if(!(is_numeric($discountvalue[0]))) {
                                            $message_warring.="Wrong Entry In Discount Field";
                                            $discounttype="";
                                            $discountvalue=0;
                                        }
                                        else {
                                            $discountvalue=$discountvalue[0];
                                        }
                                    }

                                    else if((is_numeric($data[$discountField]))) {
                                        $discounttype="amnt";
                                        $discountvalue=$data[$discountField];
                                    }

                                    else {
                                        $discountvalue=trim($data[$discountField]);
                                        $discountvalue=substr($discountvalue, 0,-1);
                                        if(!(is_numeric($data[$discountField]))) {
                                            $discounttype="amnt";
                                            $discountvalue=$data[$discountField];
                                        }
                                        else {
                                            $message_warring.="Wrong Entry In Discount Field";
                                            $discounttype="";
                                            $discountvalue=0;
                                        }
                                    }
                                }
// 												echo $message_warring;
// 												echo $discounttype;
// 												echo $discountvalue;
// 												echo $row;
                            }

                            if($featuredField=="NA" || empty($data[$featuredField])) {
                                $featuredvalue=0;
                            }
                            else {
                                if($data[$featuredField]!="1")
                                    $featuredvalue=0;
                                else
                                    $featuredvalue=1;
                            }

                            if(!(is_numeric($data[$weightField]))) {
                                $error=true;
                                $message="Weight Field Cannot Be Empty";
                            }

                            if($add_priceField=="NA" ||empty($data[$add_priceField])) {
                                $add_pricevalue=0;
                            }
                            else {
                                if(!(is_numeric($data[$add_priceField]))) {
                                    $message_warring="Additional Price should be Numeric";
                                    $add_pricevalue=0;
                                }
                                else {
                                    $add_pricevalue=$data[$add_priceField];
                                }

                            }


                            if(!$error) {

                                $customevalueToCategories=implode(",", $customevalueToCategories);
                                $product_dup="";
                                $product_dup=$this->Product->find('all',array('conditions' => array('category_id' => $categoryid,
                                                'Product.pname' => $data[$pnameField],
                                                 'Product.descr'=>$data[$descriptionField],
                                				'Product.status'=>'A'
                                        )
                                        )
                                );

                                if(!empty($product_dup)) {
                                    $productid=$product_dup[0]["Product"]["id"];
                                    $data_product=array(
                                                    "Product"           => array(
                                                        "category_id"       => $categoryid,
                                                        "pname"             => Sanitize::escape($data[$pnameField]),
                                                        "stock"             => $data[$stockField],
                                                        "reorderlevel"      => $reordervalue,
                                                        "skuno"             => $skunovalue,
                                                        "price"             => $data[$priceField],
                                                        "descr"             => Sanitize::escape($data[$descriptionField]),
                                                        "discount_type"     => $discounttype,
                                                        "discount"          => $discountvalue,
                                                        "featured"          => $featuredvalue,
                                                        "weight"            => $data[$weightField],
                                                        "defaultattribute"  => $defaultcustomfield,
                                                        "combination"       => "Y",
                                                        "prodtype"          => "Physical",
                                                        "brand_id"          => $brand_id
                                                      )
                                                    );

                                    //echo '<pre>';  print_r($data_product); echo '</pre>';
                                    $this->Product->updateProductDetailData($productid, $data_product);

                                }
                                else {

                                    $data_product=array("Product"=> array("category_id"	=> 	$categoryid,
                                                    "pname"		          => Sanitize::escape($data[$pnameField]),
                                                    "stock"		          => $data[$stockField],
                                                    "reorderlevel"      => $reordervalue,
                                                    "attributes1"       => $customevalueToCategories,
                                                    "skuno"		          => $skunovalue,
                                                    "price"		          => $data[$priceField],
                                                    "descr"		          => Sanitize::escape($data[$descriptionField]),
                                                    "discount_type"     => $discounttype,
                                                    "discount"          => $discountvalue,
                                                    "featured"          => $featuredvalue,
                                                    "weight"		        => $data[$weightField],
                                                    "defaultattribute"  => $defaultcustomfield,
                                                    "combination"       => "Y",
                                                    "prodtype"          => "Physical",
                                                    "brand_id"          => $brand_id

                                    ));
                                    //echo "<pre>"; print_r($data_product); echo "</pre>";
                                    $this->Product->create();
                                    $this->Product->save($data_product);
                                    $productid = $this->Product->id;
                                    $updation=false;
                                }

                                //Product Combination finding
                                $productcomp_dup=$this->Productdetail->find('all',array('conditions' => array('category_id' => $categoryid,
                                                'product_id' => $productid,
                                                'customvalue_id'=>$customevalueToCategories,
                                                'skuno'=>$skunovalue
                                        )
                                        )
                                );
                                $pdctimage="";
                                if(!empty($productcomp_dup)){

                                    //$this->Product->updateProductCombinations($categoryid,$productid,$customevalueToCategories,$data[$stockField],$reordervalue,$skunovalue,$add_pricevalue,$pdctimage,$productcomp_dup[0]['Productdetail']['id']);

                                }
                                else {
                                    $this->Product->addProductCombinations($categoryid,$productid,$customevalueToCategories,$data[$stockField],$reordervalue,$skunovalue,$add_pricevalue,$pdctimage);

                                    $productcomp_dup=$this->Productdetail->find('all',array('conditions' => array('category_id' => $categoryid,
                                                    'product_id' => $productid,
                                                    'customvalue_id'=>$customevalueToCategories,
                                                    'skuno'=>$skunovalue
                                            )
                                            )
                                    );
                                    $updation=false;

                                }
//Array ( [Customimage] => Array ( [doublesided] => N [image_type] => Front [coord_top] => 89,138 [coord_left] => 306,399 [proddetail_id] => 68 [image_path] => tshirts/13683517812.png [img_field] => Array ( [name] => [type] => [tmp_name] => [error] => 4 [size] => 0 ) ) )

// 									print_r($data);
//echo $data[$imagenameField];


                                $images=explode(";",$data[$imagenameField]);
                                
                                //echopre1($images);
                                $i=0;
//print_r($image);
                                $imageexist=false;

                                $imgCount = 0;
                                //App::import('Controller', 'CustomimagesController');
                                foreach ($images as $imgKey => $image) { //echo WWW_ROOT.IMAGES_URL."bulkupload/".$image; exit;

                                    //$customimage = new CustomimagesController();
                                    $this->loadModel('Customimage');

                                    //Load model, components...
                                    //$this->customimage->constructClasses();
                                    if(file_exists(WWW_ROOT.IMAGES_URL."bulkupload/".$image) && is_file(WWW_ROOT.IMAGES_URL."bulkupload/".$image)) {




                                        $imageexist=true;

                                        $imgCount++;

                                        $imagedata['location']=WWW_ROOT.IMAGES_URL."bulkupload/".$image;
                                        $imagedata['name']=$image;
                                       // echopre($this->imagedata);
                                        //exit;
                                        $response=$this->upload(true,$imagedata);


                                        if($response['error_message']=="sucess") {

                                            if($i==0) {
                                                $type="Front";
                                            }
                                            else {
                                                $type="Side_".$i;

                                                $customimagetype = $this->Customimage->prdCustomimagetypes($productid, $type);
                                                /*$customimagetype= $this->Customimagetypes->find('all',array('conditions' => array('customimagetypes.productid' => $productid,
                                                                'customimagetypes.type' => $type
                                                        )
                                                        )
                                                );*/

                                                if(empty($customimagetype)) {



                                                    $data_customimage['productid']=$productid;
                                                    $data_customimage['type']=ucfirst($type);
                                                    $this->Customimagetypes->create();
                                                    $this->Customimagetypes->save($data_customimage);
                                                }

                                            }
                                            $i=$i+1;
                                            $image_duplicate=$this->Customimage->getImages($productcomp_dup[0]['Productdetail']['id'],$type);


                                            if(empty($image_duplicate)) {
                                                $this->Coordinate->create();
                                                $this->Coordinate->saveField('x1_axis',180);
                                                $this->Coordinate->saveField('y1_axis',180);
                                                $this->Coordinate->saveField('x2_axis',332);
                                                $this->Coordinate->saveField('y2_axis',332);
                                                $coordID = $this->Coordinate->id;

                                                //-------------save to customimages table------------------------//

                                                $this->Customimage->create();
                                                $this->Customimage->saveField('productdetails_id',$productcomp_dup[0]['Productdetail']['id']);
                                                $this->Customimage->saveField('type',$type);
                                                $this->Customimage->saveField('image',str_replace(WWW_ROOT.IMAGES_URL,"",$response['filename']));
                                                $custimgID = $this->Customimage->id;

                                                //--------------------save to imageregions table---------------//
                                                $this->Imageregion->create();
                                                $this->Imageregion->saveField('customimages_id',$custimgID);
                                                $this->Imageregion->saveField('coordinates_id',$coordID);


                                                $img = explode("/",str_replace(WWW_ROOT.IMAGES_URL,"",$response['filename']));
                                                $img1=end($img);
                                                $img2=explode(".",$img1);
                                                $imgNam=$img2[0];
                                                $imgArray       = explode(".",$response['filename']);
                                                $imgExt         = strtolower(end($imgArray));
                                                $thumbfileName  = $imgNam."_thumb".".".$imgExt;
                                                $dispfileName   = $imgNam."_disp".".".$imgExt;
                                                $sliderfileName   = $imgNam."_slider".".".$imgExt;
                                                $fileName       = $imgNam.".".$imgExt;
                                                /**********************/


                                                copy($response['filename'],WWW_ROOT.IMAGES_URL."products/".$fileName);

                                                $this->Resize->index($response['filename']);
                                                $this->Resize->resizeImage(170, 170, 'exact');
                                                $this->Resize->saveImage(WWW_ROOT.IMAGES_URL."products/".$dispfileName, 100);

                                                $this->Resize->index($response['filename']);
                                                $this->Resize->resizeImage(48, 48, 'exact');
                                                $this->Resize->saveImage(WWW_ROOT.IMAGES_URL."products/".$thumbfileName, 100);

//                                                $this->Product->id = $productid;
//                                                //$post = $this->data;
//                                                $this->Product->saveField('image1', $response['filename']);
                                                
                                                $this->Customimage->updateProduct($productcomp_dup[0]['Productdetail']['id'],$type,$fileName,'');

                                                //	$this->Productdetail->save($data);
                                            }
                                            else {

                                                $img = explode("/",str_replace(WWW_ROOT.IMAGES_URL,"",$response['filename']));
                                                $img1=end($img);
                                                $img2=explode(".",$img1);
                                                $imgNam=$img2[0];
                                                $defaultVal     =($this->data["Customimage"]["image_type"]=="Front")?"Y":"N";
                                                $imgArray       = explode(".",$this->data["Customimage"]["image_path"]);
                                                $imgExt         = strtolower(end($imgArray));
                                                if(empty($imgExt))
                                                    $imgExt = pathinfo($response['filename'], PATHINFO_EXTENSION);
                                                $thumbfileName  = $imgNam."_thumb".".".$imgExt;
                                                $dispfileName   = $imgNam."_disp".".".$imgExt;
                                                $fileName       = $imgNam.".".$imgExt;

                                                copy($response['filename'],WWW_ROOT.IMAGES_URL."products/".$fileName);
                                                $this->Resize->index($response['filename']);
                                                $this->Resize->resizeImage(170, 170, 'exact');
                                                $this->Resize->saveImage(WWW_ROOT.IMAGES_URL."products/".$dispfileName, 100);


                                                $this->Resize->index($response['filename']);
                                                $this->Resize->resizeImage(48, 48, 'exact');
                                                $this->Resize->saveImage(WWW_ROOT.IMAGES_URL."products/".$thumbfileName, 100);

                                                $this->Customimage->updateCustomimages('tshirts/'.$fileName,$image_duplicate[0]['CRD']['id']);

                                                $this->Customimage->updateProductimages($productcomp_dup[0]['Productdetail']['product_id']);

                                                    //$Productdetail->Session->read('prodID'));

                                                if(!$imgKey)

                                                    $this->Customimage->updateProduct($productcomp_dup[0]['Productdetail']['id'],$type,$fileName,'');
                                                //$this->Customimage->updateCustomimages($fileName,$productcomp_dup[0]['Productdetail']['id']);
                                                //if($defaultVal=="Y")
                                                    //$this->Customimage->updateProduct($productcomp_dup[0]['Productdetail']['id'],$type,$fileName);

                                                //$this->Customimage->updateProductimages($this->Session->read('prodID'));
                                                //------------update coordinates table-----------------------//

                                                $this->Customimage->updatecoords($productcomp_dup[0]['Productdetail']['id'],"180,180","332,332");


                                            }



                                        }

                                        else{

                                                $message_warring = $response['error_message'] ." for the product --".$data[$pnameField];
                                         }
                                    }
                                    else {


                                         $message_warring= "Image -  ".$image." - missing in upload folder for the product --". $data[$pnameField];
                                    }
                                }



                            }
                        }


                        if($imgCount==0)
                        {

                                    $message_warring="Requires at least one image for the product --".$data[$pnameField];

                        }




                        if($message=='Success') {
                            $consoldated_error[$row]['succ']=$message;
                            $sucess_count=$sucess_count+1;
                            if($updation) {
                                $update_count=$update_count+1;
                            }

                        if($message_warring!='')
                        {
                            $consoldated_error[$row]['warning']=$message_warring;
                        }

                        }else {


                            $consoldated_error[$row]['error']=$message;
                        }

                    


                    $row++;


                    return $consoldated_error;
    }
    
    
    
      function checkexternalupload($products) {
 
//echopre1($_POST);
           $catid       = $_POST['data']['category_id'];
           //echo $catid;
           //exit;
          $catdetails   = $this->Category->findById($catid);

          $catname      = $catdetails['Category']['cname'];
        
          $uname        =  $_POST['data']['uname'];

          $userpassword =  $_POST['data']['userpassword'];



        $imagerror = array();
        $bulkuploadimagefolder=WWW_ROOT.IMAGES_URL.'bulkupload/';
          
        $style_code = $products['Productexternal']['style_number'];
          
          
       $url = "https://www.alphashirt.com/cgi-bin/online/xml/prod-detail-request.w?sr=$style_code&userName=$uname&password=$userpassword";
       //echopre1($url);
       $myXMLData = file_get_contents($url);
       //echopre1($myXMLData);
        $xml=simplexml_load_string($myXMLData); 
                if(!$xml)
                {
                     $error = "Error: Aplphaorder server is not responding,please try after some time"; 
                    $this->Session->setFlash($error, 'default',array('class'=> 'failure'));
                     $this->redirect(array('controller' => 'Products', 'action' => 'externalupload'));
                     exit;
                }
                
                              
        //echopre($xml);
       // echopre($xml);
        
        $catarray = array(10=>'Knits and Layering',15=>'Accessories',20=>'Bags and Accessories',30=>'Fleece',40=>'Headwear',50=>'Sweatshirts',65=>'Infants | Toddlers',70=>'Outerwear',80=>'Pants',90=>'Shorts',100=>'Polos',120=>'Woven Shirts',130=>'T-Shirts','CS'=>'Custom Style');
        
        //$cat = (array)$xml->item['prodcategory'];
       // $catId =    $cat[0];    
        //echo $catId; exit;
        $prodArray = array();
       // $prodArray[0] = 'Tshirt';
        $prodArray[0] = $catname;
        $prodArray[1] = $products['Productexternal']['pname'];
        $desc = (array)$xml->item->catalogdescription;
        $prodArray[2] = $desc[0];
        $prodArray[13] = $products['Productexternal']['brand'];
        $prodArray[8] = 0;
        $prodArray[9] = 10;
        $prodArray[5] = 0;
        $prodArray[6] = 1;    
        $prodArray[8] = 0;    
        //echopre1($prodArray); 
       // echo $xml->item->catalogdescription;
        
                $categoryField		  =	0;
                $pnameField			    =	1;
                $descriptionField	  =	2;
                $compField          = 3;
                $stockField			    =	4;
                $priceField			    =	5;
                $weightField		    =	6;
                $imagenameField		  =	7;
                $featuredField		  =	8;
                $reorderField		    = 9;
                $skunoField			    = 10;
                $add_priceField		  =	11;
                $discountField		  =	12;
                $brandField		      =	13;
            

            $row = 1;
            $sucess_count=0;
            $update_count=0;
            
            
            
            
            if ($products['Productexternalsdetail']) {
                
                 $conn_id = ftp_connect('images.alphabroder.com');
ftp_set_option($conn_id, FTP_TIMEOUT_SEC, 50000000);
// login with username and password
$login_result = ftp_login($conn_id, 'BBimages', 'brodimgs');
                
                foreach ($products['Productexternalsdetail'] as $key=>$val){
                    
                    //echopre($val);
                    $item_number = $val['item_number'];
                    
                    $comburl = "https://www.alphashirt.com/cgi-bin/online/xml/inv-request.w?in1=$item_number&pr=y&zp=20176&userName=$uname&password=$userpassword";

                    $CombXMLData = file_get_contents($comburl);
                    $combxml=simplexml_load_string($CombXMLData) or die("Error: Error: Aplphaorder server is not responding,please try after some time"); 
                    
                       
                     $price = (array)$combxml->item['price'];
                     $prodArray[11] = str_replace('$', '', $price[0]); 
                     $prodArray[10] = $val['item_number'];
                     $prodArray[4] = 100;
                     $color = $val['color'];
                     $size = $val['size'];
                     $prodArray[3] =   "Color:$color,Size:$size";
                     //echopre1($prodArray); 
                     $img1 = strtolower($products['Productexternal']['style_number']).'_'.strtolower($val['color_code']).'.jpg';
                     $img2 = strtolower($products['Productexternal']['style_number']).'_bk_'.strtolower($val['color_code']).'.jpg';
                     
                     
                     $imagfield  = "$img1;$img2";
                     $prodArray[7] = $imagfield;
                     
                     if(!file_exists($bulkuploadimagefolder.$img1)){
                     $local_file = $bulkuploadimagefolder."$img1";
                     $server_file = "/Hi-Res Web Images/$img1";
                     ftp_pasv($conn_id, TRUE);
                        // download server file
                     if (ftp_get($conn_id, $local_file, $server_file, FTP_BINARY))
                        {
                        //echo "Successfully written to $local_file.<br>";
                        }
                      else
                        {
                        $imagerror[]= "Error downloading image ".$prodArray[1]." ".$prodArray[3]." ". $img1."<br>";
                        }
                     }
                     if(!file_exists($bulkuploadimagefolder.$img2)){
                     $local_file = $bulkuploadimagefolder."$img2";
                     $server_file = "/Hi-Res Web Images/$img2";
                     ftp_pasv($conn_id, TRUE);
                        // download server file
                     if (ftp_get($conn_id, $local_file, $server_file, FTP_BINARY))
                        {
                        //echo "Successfully written to $local_file.<br>";
                        }
                      else
                        {
                        $imagerror[] = "Error downloading image ".$prodArray[1]." ".$prodArray[3]." ". $img2."<br>";
                        }
                     
                     }  
                     
                  $res =    $this->externalComboAdd($prodArray);
                     
                  
                  //echopre1($res);
                  
                  
               //  exit;    
                    $id =  $val['id'];
                     
                      $this->Productexternalsdetail->delete_externaluploads($id);
                     //echopre1($prodArray);   
                }
ftp_close($conn_id);

            }




            /*
			$pname			=	$_POST["pname"];

			$description	=	$_POST["pdescr"];

			$wholesale_price =	$_POST["wholesale_price"];

			$retail_price    =	$_POST["retail_price"];

			$weight			=	$_POST["weight"];

			$reorder		=	$_POST["reorder"];

			$stock			=	$_POST["stock"];
            */

           

            $info[0]=$res;
            $info[1]=$sucess_count;
            $info[2]=$update_count;
            $info[3]=$imagerror;;
            return  $info;



        



    }


    function bulkuploadimage() {

        $this->__validateLoginStatus();

        $admsess	=	$this->Session->read('Admin');

        if($admsess["products"] <> 1) {

            $this->redirect(array('controller' => 'admins', 'action' => 'index'));

            exit();

        }

        if (!empty($this->data)) {



            if(!empty($this->data['Product']['pdctfile']['tmp_name'])) {

                $pdctfile1 = $this->Product->generateUniqueFilename($this->data['Product']['pdctfile']['name'],WWW_ROOT.IMAGES_URL.'csv/');

                $error = $this->Product->csvUpload($this->data['Product']['pdctfile'], $pdctfile1,WWW_ROOT.IMAGES_URL.'csv/');

            }

            if(empty($error)) {
                $this->redirect(array('controller' => 'products','action'=>'checkimageupload/'.$pdctfile1));
                exit;

            }else {
                $this->Session->setFlash($error, 'default',array('class'=> 'failure'));
            }

        }

        $this->layout = 'adm';

    }

    function checkimageupload($filename) {
        $this->__validateLoginStatus();
        $admsess	=	$this->Session->read('Admin');
        if($admsess["products"] <> 1) {
            $this->redirect(array('controller' => 'admins', 'action' => 'index'));
            exit();
        }

        ########### Constatnts for pclZip class.........................

        // ----- Constants

        define( 'PCLZIP_READ_BLOCK_SIZE', 2048 );



        // ----- File list separator

        // In version 1.x of PclZip, the separator for file list is a space

        // (which is not a very smart choice, specifically for windows paths !).

        // A better separator should be a comma (,). This constant gives you the

        // abilty to change that.

        // However notice that changing this value, may have impact on existing

        // scripts, using space separated filenames.

        // Recommanded values for compatibility with older versions :

        //define( 'PCLZIP_SEPARATOR', ' ' );

        // Recommanded values for smart separation of filenames.

        define( 'PCLZIP_SEPARATOR', ',' );



        // ----- Error configuration

        // 0 : PclZip Class integrated error handling

        // 1 : PclError external library error handling. By enabling this

        //     you must ensure that you have included PclError library.

        // [2,...] : reserved for futur use

        define( 'PCLZIP_ERROR_EXTERNAL', 0 );



        // ----- Optional static temporary directory

        //       By default temporary files are generated in the script current

        //       path.

        //       If defined :

        //       - MUST BE terminated by a '/'.

        //       - MUST be a valid, already created directory

        //       Samples :

        // define( 'PCLZIP_TEMPORARY_DIR', '/temp/' );

        // define( 'PCLZIP_TEMPORARY_DIR', 'C:/Temp/' );

        define( 'PCLZIP_TEMPORARY_DIR', '' );



        // --------------------------------------------------------------------------------

        // ***** UNDER THIS LINE NOTHING NEEDS TO BE MODIFIED *****

        // --------------------------------------------------------------------------------



        // ----- Global variables

        $g_pclzip_version = "2.3";



        // ----- Error codes

        //   -1 : Unable to open file in binary write mode

        //   -2 : Unable to open file in binary read mode

        //   -3 : Invalid parameters

        //   -4 : File does not exist

        //   -5 : Filename is too long (max. 255)

        //   -6 : Not a valid zip file

        //   -7 : Invalid extracted file size

        //   -8 : Unable to create directory

        //   -9 : Invalid archive extension

        //  -10 : Invalid archive format

        //  -11 : Unable to delete file (unlink)

        //  -12 : Unable to rename file (rename)

        //  -13 : Invalid header checksum

        //  -14 : Invalid archive size

        define( 'PCLZIP_ERR_USER_ABORTED', 2 );
        define( 'PCLZIP_ERR_NO_ERROR', 0 );
        define( 'PCLZIP_ERR_WRITE_OPEN_FAIL', -1 );
        define( 'PCLZIP_ERR_READ_OPEN_FAIL', -2 );
        define( 'PCLZIP_ERR_INVALID_PARAMETER', -3 );
        define( 'PCLZIP_ERR_MISSING_FILE', -4 );
        define( 'PCLZIP_ERR_FILENAME_TOO_LONG', -5 );
        define( 'PCLZIP_ERR_INVALID_ZIP', -6 );
        define( 'PCLZIP_ERR_BAD_EXTRACTED_FILE', -7 );
        define( 'PCLZIP_ERR_DIR_CREATE_FAIL', -8 );
        define( 'PCLZIP_ERR_BAD_EXTENSION', -9 );
        define( 'PCLZIP_ERR_BAD_FORMAT', -10 );
        define( 'PCLZIP_ERR_DELETE_FILE_FAIL', -11 );
        define( 'PCLZIP_ERR_RENAME_FILE_FAIL', -12 );
        define( 'PCLZIP_ERR_BAD_CHECKSUM', -13 );
        define( 'PCLZIP_ERR_INVALID_ARCHIVE_ZIP', -14 );
        define( 'PCLZIP_ERR_MISSING_OPTION_VALUE', -15 );
        define( 'PCLZIP_ERR_INVALID_OPTION_VALUE', -16 );
        define( 'PCLZIP_ERR_ALREADY_A_DIRECTORY', -17 );
        define( 'PCLZIP_ERR_UNSUPPORTED_COMPRESSION', -18 );
        define( 'PCLZIP_ERR_UNSUPPORTED_ENCRYPTION', -19 );
        // ----- Options values

        define( 'PCLZIP_OPT_PATH', 77001 );
        define( 'PCLZIP_OPT_ADD_PATH', 77002 );
        define( 'PCLZIP_OPT_REMOVE_PATH', 77003 );
        define( 'PCLZIP_OPT_REMOVE_ALL_PATH', 77004 );
        define( 'PCLZIP_OPT_SET_CHMOD', 77005 );
        define( 'PCLZIP_OPT_EXTRACT_AS_STRING', 77006 );
        define( 'PCLZIP_OPT_NO_COMPRESSION', 77007 );
        define( 'PCLZIP_OPT_BY_NAME', 77008 );
        define( 'PCLZIP_OPT_BY_INDEX', 77009 );
        define( 'PCLZIP_OPT_BY_EREG', 77010 );
        define( 'PCLZIP_OPT_BY_PREG', 77011 );
        define( 'PCLZIP_OPT_COMMENT', 77012 );
        define( 'PCLZIP_OPT_ADD_COMMENT', 77013 );
        define( 'PCLZIP_OPT_PREPEND_COMMENT', 77014 );
        define( 'PCLZIP_OPT_EXTRACT_IN_OUTPUT', 77015 );
        define( 'PCLZIP_OPT_REPLACE_NEWER', 77016 );
        define( 'PCLZIP_OPT_STOP_ON_ERROR', 77017 );
        // Having big trouble with crypt. Need to multiply 2 long int

        // which is not correctly supported by PHP ...

        //define( 'PCLZIP_OPT_CRYPT', 77018 );



        // ----- Call backs values

        define( 'PCLZIP_CB_PRE_EXTRACT', 78001 );
        define( 'PCLZIP_CB_POST_EXTRACT', 78002 );
        define( 'PCLZIP_CB_PRE_ADD', 78003 );
        define( 'PCLZIP_CB_POST_ADD', 78004 );
        ########### Constatnts for pclZip class.........................

        $this->Pclzip->PclZip(WWW_ROOT.IMAGES_URL.'csv/' . $filename);
        if ($this->Pclzip->extract(PCLZIP_OPT_PATH, WWW_ROOT.IMAGES_URL.'csv/' ) == 0) {
            // die("Error : " . $archive->errorInfo(true));

            // $message

            $error	= "Can not extract files.";
            $this->Session->setFlash($error, 'default',array('class'=> 'failure'));
            $this->redirect(array('controller' => 'admins','action'=>'index'));
            exit;
        }

        $dirpath = WWW_ROOT.IMAGES_URL.'csv/'.$filename;
        if (file_exists($dirpath)) {

            unlink($dirpath);

        }

        $exp=explode(".",$filename);

        $zipfilename=$exp[0];


        $dirpaths= WWW_ROOT.IMAGES_URL.'csv/'.$zipfilename;



        if(is_dir($dirpaths) and file_exists($dirpaths)) {

            $image_file_path=$dirpaths;



        }else {

            $image_file_path=WWW_ROOT.IMAGES_URL.'csv/';

        }

        if(file_exists($image_file_path)) { // check file folder exists

            $d = dir($image_file_path) or die("Wrong path: $image_file_path");

            while (false !== ($entry = $d->read())) {

                if($entry != '.' && $entry != '..' && !is_dir($entry)) {

                    $Images[] = $entry;

                }



            } // end while



            $d->close();


            $cnfg 		= Configure::read('Neutrino');
            $imgcnt=0;
            foreach($Images as $img) {
                if($img <> "Thumbs.db" && $img <> "Thumbs.ini") {
                    $imgcnt++;
                }
            }


            if($cnfg["product_images"] < $imgcnt) {
                foreach($Images as $img) {
                    if(file_exists($image_file_path."/".$img)) {
                        unlink($image_file_path."/".$img);
                    }
                }
                if(file_exists($image_file_path)) {
                    if($image_file_path <> WWW_ROOT.IMAGES_URL.'csv/') {
                        rmdir($image_file_path);
                    }
                }
                $this->Session->setFlash('The zip file should contain only '.$cnfg["product_images"].' Images.', 'default',array('class'=> 'failure'));
                $this->redirect(array('controller' => 'products','action'=>'bulkuploadimage'));
                exit();
            }


            $prod_array = $this->Product->find('first', array('conditions' => array('Product.pname  LIKE ' => "".addslashes($zipfilename)."%")));
            if(isset($prod_array["Product"]["id"]) && $prod_array["Product"]["id"] <> 0) {
                $curr_cnt = $this->Productimages->find('count', array('conditions' => array('Productimages.product_id' => $prod_array["Product"]["id"])));
                if($curr_cnt > 0) {
                    $this->Session->setFlash('The product already contains some Images.Please remove all the images before uploading the zip file.', 'default',array('class'=> 'failure'));
                    $this->redirect(array('controller' => 'products','action'=>'bulkuploadimage'));
                    exit();
                }
                /*
			   else
			   {
			     $split_cnt=$cnfg["product_images"] - $curr_cnt;
			   }
                */
            }

            /*
			if($split_cnt > 0)
			$Images = array_slice($Images, $split_cnt);
            */




            foreach($Images as $img) {

                if($img <> "Thumbs.db") {

                    $pimname	=	substr($img,0,mb_strrpos($img,"."));

                    $parray		=	array();

                    //$criteria ="Product.pname  LIKE '".addslashes($pimname)."%'";
                    //$parray = $this->Product->find($criteria);

                    //$parray = $this->Product->find('first', array('Product.pname  LIKE ' => "%".addslashes($pimname)."%"));

                    $parray = $this->Product->find('first', array('conditions' => array('Product.pname  LIKE ' => "".addslashes($zipfilename)."%")));



                    if(isset($parray["Product"]["id"]) && $parray["Product"]["id"] <> 0) {

                        $pro	=	array();

                        $pro["Productimages"]["product_id"]	=	$parray["Product"]["id"];

                        $pro["Productimages"]["imagename"]	=	$img;

                        $pro["Productimages"]["default"]		=	"N";

                        $this->Productimages->create();

                        $this->Productimages->save($pro);
                        
                        

                        $path	=	WWW_ROOT.IMAGES_URL.'products/';

                        rename($image_file_path."/".$img, $path.$img);

                        $this->Product->resizeImg( $path."/".$img, 125 ,125, false, 100, 0,"_thumb");

                        $this->Product->resizeImg( $path."/".$img, 245 ,175, false, 100, 0,"_disp");

                        $error	=	"Images uploaded successfully";

                    }

                    #mb_strrpos(".",$img)."<br>";



                }

                if(file_exists($image_file_path."/".$img)) {

                    unlink($image_file_path."/".$img);

                }
            }

            if(file_exists($image_file_path)) {
                if($image_file_path <> WWW_ROOT.IMAGES_URL.'csv/') {
                    rmdir($image_file_path);
                }
            }
        }

        if(isset($error)) {
            $this->Session->setFlash($error, 'default',array('class'=> 'failure'));
        }

        $this->redirect(array('controller' => 'admins','action'=>'index'));
        exit;
    }


    function bulkdelete() {
        $this->__validateLoginStatus();
        $admsess	=	$this->Session->read('Admin');
        if($admsess["products"] <> 1) {
            $this->redirect(array('controller' => 'admins', 'action' => 'index'));
            exit();
        }
        $this->Product->delpdctbulk();
        $this->Session->setFlash('All Products Removed from Database.', 'default',array('class'=> 'success'));
        $this->redirect('index');
    }


    function samplecsv() {
        $this->__validateLoginStatus();
        $path  =   WWW_ROOT.IMAGES_URL.'bulkupload/sample11.csv'; //exit;
        $admsess	=	$this->Session->read('Admin');
        if($admsess["products"] <> 1) {
            $this->redirect(array('controller' => 'admins', 'action' => 'index'));
            exit();
        }

        $csvdat	=	file_get_contents($path);
        header("Content-type: application/octet-stream");
        header("Content-Transfer-Encoding: binary");
        header("Content-Disposition: attachment; filename=\"sample.csv\"");
        echo $csvdat;
        exit;
    }


    function prodlist() {
        $sus	=	$this->Session->read('Userlog');
        if(isset($sus) && empty($sus)===false) {
            $this->set('sus', $sus);
        }
        global $currency;
        $curr		=	$this->Currency->findByCode($currency);
        $this->set('curlogo',$curr["Currency"]["logo"]);
        $data = $this->paginate('Product', array('Product.status  = ' => "A"));
        for($c=0; $c < sizeof($data); $c++) {
            if(isset($data[$c]["Productimages"][0]["imagename"])) {
                $defimg	=	$data[$c]["Productimages"][0]["imagename"];
                for($m=0; $m < sizeof($data[$c]["Productimages"]); $m++) {
                    if($data[$c]["Productimages"][$m]["default_img"] == "Y") {
                        $defimg	=	$data[$c]["Productimages"][$m]["imagename"];
                    }
                }
                $data[$c]["Productimages"]	=	$defimg;
            }
            else {
                $data[$c]["Productimages"]	= '';
            }

            $data[$c]["Product"]["sellprice"]=$data[$c]["Product"]["wholesale_price"];
        }
        $this->set('product', $data);
    }


    function checksubcat($id='') {
        Configure::write('debug', 0);
        $this->layout = null;
        $cval	=	$this->Category->find('all', array('conditions' => array('Category.parent_id ='.$id)));
        $this->set('cval', $cval);
    }

    function allproducts() {
    	$sus	=	$this->Session->read('Userlog');
        $this->Session->write('fundraisermode', '0');
        if(isset($sus) && empty($sus)===false){
          $this->set('sus', $sus);
          $citem    =   $this->Cart->find('all', array('conditions' => array('Cart.type <>' => 'G','user_id' => $sus['id'])));
        }

        else {
          $this->set('sus', '');
          $sessid   =   $this->Session->id();
          $citem    =   $this->Cart->find('all', array('conditions' => array('Cart.type <>' => 'G','sess_id' => $sessid)));

        }
        $this->set('cartcount', count($citem));

       /* if (isset($this->Setting) && !empty($this->Setting->table)) {
            $this->Setting->load();
        }*/
        $this->loadModel('Setting');
        $this->Setting->load();
        global $page_title;
         $cnfg 				=	Configure::read('Neutrino');
         $sus	=	$this->Session->read('Userlog');
         $this->set('sus',$sus);
        if($cnfg["page_title"] <> '')
            $page_title = $cnfg["page_title"];
        $this->pageTitle = $page_title	;
        global $currency;
        $curr		=	$this->Currency->findByCode($currency);
        $this->set('curlogo',$curr["Currency"]["logo"]);
        //Facebook Setting
//        $facebookKeys='';
//        if($this->Session->check('facebookKey')) {
//            $facebookKeys=$this->Session->read('facebookKey');
//        }
//        $this->set('facebookKey', $facebookKeys);
        //Facebook Setting Ends
        // Twitter App Setting
//        $twitterKeys='';
//        if($this->Session->check('twitterKey')) {
//            $twitterKeys=$this->Session->read('twitterKey');
//        }
//        $this->set('twitterKey', $twitterKeys);
        // Twitter App Setting Ends
        //Code Added By shyam for Category Menu Listing starts here..
        $lst	=	$this->Category->find('all');

        foreach($lst as $det)

            $menu_array[$det["Category"]["id"]] = array('name' => $det["Category"]["cname"],'parent' => $det["Category"]["parent_id"]);
        $this->set('menu_array', $menu_array);

        $footer_links = $this->Cmspage->find('list',array('conditions' => array('Cmspage.type' => 'content','Cmspage.status' => 'Y')));
        $this->set('footerlinks', $footer_links);

        //Code Added By shyam for Category Menu Listing ends here..
        $criteria="Product.status = 'A' AND Product.stock > 0";
        //list($order,$limit,$page) = $this->Pagination->settings($criteria); // Added

        //list($order,$limit,$page) = $this->Paginator->settings(array("conditions" =>array("Product.status" => 'A','Product.stock' > 0))); // Added

        $this->paginate = array(
        'conditions' => array("Product.status" => 'A','Product.stock >' => 0),
        'limit' =>$cnfg["items_perpage"] ,
        );
        $this->Paginator->settings = $this->paginate;



        //list($order,$limit,$page) = array($data,$this->counter('{:limit}'),$this->counter('{:page}'));
        $data = $this->paginate();
        list($order,$limit,$page) = array($data,$this->request->params['paging']['Product']['limit'],$this->request->params['paging']['Product']['page']); // Added

        //$data = $this->Product->findAll($criteria, NULL, 'Product.id DESC', $limit, $page); // Extra parameters added
        $data   =   $this->Product->find('all',array("conditions"=>array("Product.status"=> 'A',"Product.stock >"=> '1'),"limit"=>$limit,"page"=>$page));
        //echo '<pre>';print_r($data);die;
        $pdct	=	$data;
        // echo "<pre>";
        // print_r($data);
        for($c=0; $c < sizeof($pdct); $c++) {
            if(isset($pdct[$c]["Productimages"][0]["imagename"])) {
                $defimg	=	$pdct[$c]["Productimages"][0]["imagename"];
//                for($m=0; $m < sizeof($pdct[$c]["Productimages"]); $m++) {
//                    if($pdct[$c]["Productimages"][$m]["default_img"] == "Y") {
//                        $defimg	=	$pdct[$c]["Productimages"][$m]["imagename"];
//                    }
//                }
                $pdct[$c]["Productimages"]	=	$defimg;
            }
            else {
                $pdct[$c]["Productimages"]	= '';
            }
        }

        $this->set('products', $pdct);
    }

    //-----------------------------------------Customize a product for user------------------------------------//

    function seluser() {
       // Configure::write('debug', 2);
        $this->__validateLoginStatus();


        global $currency;
        $curr		=	$this->Currency->findByCode($currency);
        $this->set('curlogo',$curr["Currency"]["logo"]);
        $currency_type=$curr["Currency"]["name"];
        $admsess	=	$this->Session->read('Admin');
        if($admsess["products"] <> 1) {
            $this->redirect(array('controller' => 'admins', 'action' => 'index'));
            exit();
        }
        $this->Customimage->delEntries1($this->Session->id());

        $cat_cnt = $this->Category->find('count', array('fields' => 'COUNT(Category.id) as count','conditions' => array('Category.id !=' => 1)));
        if($cat_cnt == 0) {
            $this->Session->setFlash('Please add a product category before adding a product.', 'default',array('class'=> 'failure'));
            $this->redirect(array('controller' => 'categories','action'=>'index'));
            exit();
        }

        $ppcat = $this->Category->find('threaded', array('order' => array('Category.position' => 'ASC')));

        $this->set('categoriesList', $ppcat);

        if(empty($this->data)) {
            $post_data = $this->data;
            $this->Session->write('tempUser', '');
            //$users = $this->User->find("list", array('order' => 'User.uname', 'conditions' => array('User.id <>' => 0), 'fields' => array('User.id', 'User.uname')));
            $users = $this->User->getUsernames();

            foreach($users as $key=>$val) {
                $userNames[$val['users']['id']] = (trim($val[0]['fullname'])==NULL)?$val['users']['uname']:$val[0]['fullname'];
            }
            $this->set('users', $userNames);

        }

        else {
            $post_data = $this->data;
            if($_REQUEST['uploadedImageName']=="") {
                $productDetails   = $this->Productdetail->findById($_REQUEST['combinationId']);
                $pImageFile = $productDetails['Productdetail']['pdctfile'];
                $pImage = "customized_tshirts/".$productDetails['Productdetail']['pdctfile'];
                copy(WWW_ROOT.IMAGES_URL."tshirts/".$pImageFile, WWW_ROOT.IMAGES_URL."customized_tshirts/".$pImageFile);
            }else {
                $pImage = $_REQUEST['uploadedImageName'];
            }

            $post_data['Product']['uploadedImageName'] = $pImage;
            $post_data['Product']['productId']         = $_REQUEST['productId'];
            $post_data['Product']['combinationId']     = $_REQUEST['combinationId'];
            $post_data['Product']['currency_type']     = $currency_type;
            $post_data['Product']['userId']            = $_REQUEST['data']['Product']['user'];



            $this->loadModel('Savedimages');
            $this->data = $post_data;

            $savedImagesID = $this->Savedimages->savePhoneOrderDetails($this->data);

            if($savedImagesID > 0) {
                $orderId = $this->saveOrderData($this->data,$savedImagesID);
                $this->Session->setFlash('Order has been placed successfully.', 'default',array('class'=> 'success'));
                $this->redirect(array('controller' => 'Orders','action'=>'index'));
                exit();
            }
        }

        $this->layout = 'adm';
    }
    function addtemplate() {

        $this->__validateLoginStatus();
        $admsess	=	$this->Session->read('Admin');

        if($admsess["products"] <> 1) {
            $this->redirect(array('controller' => 'admins', 'action' => 'index'));
            exit();
        }
        $this->Customimage->delEntries1($this->Session->id());

        $cat_cnt = $this->Category->find('count', array('fields' => 'COUNT(Category.id) as count','conditions' => array('Category.id !=' => 1)));
        if($cat_cnt == 0) {
            $this->Session->setFlash('Please add a product category before adding a product.', 'default',array('class'=> 'failure'));
            $this->redirect(array('controller' => 'categories','action'=>'index'));
            exit();
        }

        $ppcat = $this->Category->find('threaded', array('order' => array('Category.cname' => 'ASC')));
        $this->set('categoriesList', $ppcat);

        if(!empty($this->data) && $this->data['Product']['template_name']!='') {



            $tmpname = $this->data['Product']['template_name'];
            $tmpval	=	$this->Template->find('count', array('conditions' => array("template_name ='{$tmpname}'")));
            if($tmpval>0){
                $this->Session->setFlash('This template name has already used.', 'default',array('class'=> 'failure'));
                $this->redirect(array('controller' => 'products','action'=>'addtemplate'));
                exit();
            }


            $productDetId =  $_REQUEST['combinationId']  ;
            $this->Session->write('tempUser', $admsess['id']);
            $this->Session->write('temaplateCombId', $productDetId);
            $this->Session->write('templateName', $this->data['Product']['template_name']);
            $this->Session->write('published', $this->data['Product']['published']);
            $this->Session->write('product_id', $this->data['Product']['product_id']);
            //$users = $this->User->find("list", array('order' => 'User.uname', 'conditions' => array('User.id <>' => 0), 'fields' => array('User.id', 'User.uname')));

            $this->redirect(array('controller' => 'customimages/', 'action' => "admin_richeditor/$productDetId"));
            exit();
        }
        else {   //echopre($_REQUEST);






            //  $savedImagesID = $this->Product->savePhoneOrderDetails($this->data);


        }
        $this->layout = 'adm';
    }
    function edittemplate($producDetId,$side,$timestamp,$frontId,$rearId='') {

        extract($_POST);
        $this->__validateLoginStatus();
        $admsess	=	$this->Session->read('Admin');

        $templateDet =  $this->Customimage->getTemplateName($frontId);
        //print_r($templateDet);
        if($admsess["products"] <> 1) {
            $this->redirect(array('controller' => 'admins', 'action' => 'index'));
            exit();
        }
        $this->Customimage->delEntries1($this->Session->id());

        if(!empty($this->data) && $this->data['Product']['template_name']!='' && isset($_POST['editDesign'])) {
            $producDetId = $_POST['productId'];
            $side = $_POST['side'];
            $timestamp = $_POST['timestamp'];
            $frontId = $_POST['frontId'];

            if(!empty($this->data['Product']['template_name']) && $this->data['Product']['template_name']!='') {
                $tmpname = $this->data['Product']['template_name'];
                $tmpval	=	$this->Template->find('count', array('conditions' => array("template_name ='{$tmpname}' AND saveimage_id != '{$frontId}'")));
                if($tmpval>0){
                    $this->Session->setFlash('This template name has already used.', 'default',array('class'=> 'failure'));
                    $this->redirect(array('controller' => 'products/', 'action' => "edittemplate/$producDetId/$side/$timestamp/$frontId"));
                    exit();
                }
            }

            $this->Session->write('tempUser', $admsess['id']);
            $this->Session->write('templateName', $this->data['Product']['template_name']);
            $this->Session->write('published', $this->data['Product']['published']);
            //$users = $this->User->find("list", array('order' => 'User.uname', 'conditions' => array('User.id <>' => 0), 'fields' => array('User.id', 'User.uname')));
            //  print_r($_POST); exit;
            $this->redirect(array('controller' => 'customimages/', 'action' => "admin_richeditor/$producDetId/$side/$timestamp/$frontId"));
            exit();
        }
        elseif(!empty($this->data) && $this->data['Product']['template_name']!='' && isset($_POST['save'])) {   //echopre($_REQUEST);


          $producDetId = $_POST['productId'];
            $side = $_POST['side'];
            $timestamp = $_POST['timestamp'];
            $frontId = $_POST['frontId'];

            if(!empty($this->data['Product']['template_name']) && $this->data['Product']['template_name']!='') {
                $tmpname = $this->data['Product']['template_name'];
                $tmpval	=	$this->Template->find('count', array('conditions' => array("template_name ='{$tmpname}' AND saveimage_id != '{$frontId}'")));
                if($tmpval>0){
                    $this->Session->setFlash('This template name has already used.', 'default',array('class'=> 'failure'));
                    $this->redirect(array('controller' => 'products/', 'action' => "edittemplate/$producDetId/$side/$timestamp/$frontId"));
                    exit();
                }
            }

          $edit = $this->Customimage->saveTemplate($this->data['Product']['template_name'],$this->data['Product']['published'],$frontId,$timestamp);
          $this->Session->delete('Message.flash');

          $this->Session->setFlash('Product design saved successfully.', 'default',array('class'=> 'success'));

             $this->redirect(array('controller' => 'products/', 'action' => "edittemplate/$producDetId/$side/$timestamp/$frontId"));
           exit();
        }
        $this->set('templateDet', $templateDet);
        $this->set('producDetId', $producDetId);
        $this->set('side', $side);
        $this->set('timestamp', $timestamp);
        $this->set('frontId', $frontId);
        $this->set('rearId', $rearId);
        $this->layout = 'adm';
    }

    function customize() {
        $this->__validateLoginStatus();
        $admsess	=	$this->Session->read('Admin');
        if($admsess["products"] <> 1) {
            $this->redirect(array('controller' => 'admins', 'action' => 'index'));
            exit();
        }
        if(!$this->Session->read('tempUser')) {
            $this->redirect(array('controller' => 'products', 'action' => 'seluser'));
            exit();
        }

        $cat_cnt = $this->Category->find('count', array('fields' => 'COUNT(Category.id) as count','conditions' => array('Category.id !=' => 1)));
        if($cat_cnt == 0) {
            $this->Session->setFlash('Please add a product category before adding a product.', 'default',array('class'=> 'failure'));
            $this->redirect(array('controller' => 'categories','action'=>'index'));
            exit();
        }

        $ppcat = $this->Category->find('threaded', array('order' => array('Category.cname' => 'ASC')));
        $this->set('categoriesList', $ppcat);
        $this->layout = 'adm';
    }

    function getproducts($catID) {
        $prdList = $this->Product->find('list', array('order' => 'Product.pname', 'fields' => array('Product.id', 'Product.pname'), 'conditions' => array('category_id' => $catID,'status' => "A")));

        $op = "<select id='products' onchange='getCombinations(this.value);' class='box2_admin' name='data[Product][product_id]'><option value=''>Select</option>";
        if($prdList) {
            foreach($prdList as $key=>$val) {
                $op .= "<option value='$key'>$val</option>";
            }
        }
        $op .= "</select>";
        echo $op;
        echo "<input type='hidden' name='product_count' id='product_count' value='".count($prdList)."'>";
        //----------ajax--------------//
        Configure::write('debug', 0);
        $this->autoRender = false;
        exit;
    }

    function getCombinations($prodID) {
        $combList = $this->Customfieldvalue->productcomb($prodID);
        $op = "<select id='combinations' onchange='getImages(this.value);' class='box2_admin'><option value=''>Select</option>";
        if($combList) {
            foreach($combList as $key=>$val) {
                $op .= "<option value='{$val['PDT']['id']}'>{$val['PDT']['custom_value']}</option>";
            }
        }
        $op .= "</select>";
        echo "<input type='hidden' name='product_combination_count' id='product_combination_count' value='".count($combList)."'>";
        echo $op;

        //----------ajax--------------//
        Configure::write('debug', 0);
        $this->autoRender = false;
        exit;
    }

    function showajaxthumb($combID) {

        $combList     = $this->Productdetail->findById($combID);
        $productData  = $this->Product->findById($combList['Productdetail']['product_id']);
        $productPrice = $productData['Product']['price'];
        if($combList['Productdetail']['pdctfile']) $img = "products/".$combList['Productdetail']['pdctfile'];
        else $img = "noimagessmall.gif";

        $this->set('img',$img);
        $this->set('price',$productPrice);


        $this->layout = 'ajax';
    }

    function show_ajax($name,$id=0,$sideId,$timestamp,$savId,$flag='') {

        global $sitefolder;

        $this->set('sitefolder', $sitefolder);

        $sus	=	$this->Session->read('Userlog');

        $this->set('sus', $sus);
    $this->set('sideId', $sideId);
        $this->set('timestamp', $timestamp);
        $this->set('savId', $savId);
         $this->set('flag', $flag);
        $pdet = $this->Product->find('first', array('conditions' => array('Product.id' => $id)));

        if(isset($pdet["Product"]["id"])) {

            $id		=	$pdet["Product"]["id"];

            $this->Product->id = $id;

            $this->data = $this->Product->read();

            #################  Fetching the Product combination(Added by Shyam)	#################

            if(isset($this->data["Productimages"]) && !empty($this->data["Productimages"])) {
                foreach($this->data["Productimages"] as $key => $val)

                    $imgarr[]=$val["imagename"];

                $this->set('imgarr', $imgarr);
            }

            if($this->data["Product"]["combination"]=='Y') {
                $pcombndet	=	$this->Productdetail->findAllByProductId($id);

                for($i=0;$i<count($pcombndet);$i++) {
                    $pcmbnids=$pcombndet[$i]["Productdetail"]["customvalue_id"];

                    $pcmbnid=explode(',',$pcmbnids);

                    foreach($pcmbnid as $key => $val) {
                        if($val!='') {

                            $combnstr[]=$this->Product->getpdctcmbn($val);

                            $combinations=implode(" ,",$combnstr);

                            $pcombndet[$i]["Productdetail"]["combinations"]= $combinations;
                        }
                    }
                    unset($combnstr);
                    unset($combinations);
                }

                $this->set('pcombndet', $pcombndet);

            }

            #################  Fetching the Product combination(Added by Shyam)	################

            if(isset($this->data["Productimages"][0]["imagename"])) {
                $defimg	=	$this->data["Productimages"][0]["imagename"];

                for($m=0; $m < sizeof($this->data["Productimages"]); $m++) {

                    if($this->data["Productimages"][$m]["default_img"] == "Y") {

                        $defimg	=	$this->data["Productimages"][$m]["imagename"];

                    }

                }
                $post_data = $this->data;
                $post_data["Productimages"]	=	$defimg;
                $this->data = $post_data;
            }
            else {
                $post_data = $this->data;
                $post_data["Productimages"]	= '';
                $this->data = $post_data;
            }

        }

        $this->set('productdet', $this->data);
        $this->layout = 'ajax';

    }



    function saveOrderData($paramsArray,$custid) { //echopre($custid); echopre($paramsArray);
        $this->Order->create();
        $this->OrderDetail->create();
        global $currency;
        $curr		=	$this->Currency->findByCode($currency);
        $curlogo = $curr["Currency"]["logo"];
        $currency_type=$curr["Currency"]["code"];


        $orderData["user_id"]         = $paramsArray['Product']['user'];
        $orderData["date"]            = date('Y-m-d');
        $orderData["order_status_id"] = 8;
        $orderData["currency_type"]   = $paramsArray['Product']['currency_type'];

        $dat["product_id"]            =	$paramsArray['productId'];
        $optid                        = $paramsArray['combinationId'];
        $addedPrice                   = $paramsArray['Product']['price'];
        $qty                          = $paramsArray['Product']['quantity'];
        //$pdet                         = $this->Product->findById($paramsArray['productId']);
        $this->loadModel('Product');
        $pdet                         = $this->Product->findById($paramsArray['productId']);
        $dat["product_price"]	=	$addedPrice;
        $dat["discount_type"]	=	$pdet["Product"]["discount_type"];
        $dat["discount"]	=       $pdet["Product"]["discount"];
        $dat["quantity"]        =	$paramsArray['Product']['quantity'];
        $dat["prodtype"]	=	$pdet["Product"]["prodtype"];
        $dat["type"]		=	'P';
        $dat["savedimages_id"]	=       $custid;
        $productname            =       $pdet["Product"]["pname"];

        $dat["extra_price"]	=       0;


        if($dat["discount_type"]=='per' && $dat["discount"] > 0)
            $dis_amnt= $dat["product_price"] * $dat["discount"] / 100;
        else if($dat["discount_type"]=='amnt' && $dat["discount"] > 0)
            $dis_amnt=$dat["discount"];

        $dis_amnt=number_format($dis_amnt,2,'.','');

        if($optid<>'' && $optid<>0) {
            $dat["combination_id"] =	$optid;
            $pcmdet=$this->Productdetail->findById($dat["combination_id"]);
            $dat["extra_price"] += $pcmdet["Productdetail"]["extraprice"];
        }
        else
            $optid='';

        $netprice = ($addedPrice + $dat["extra_price"])-$dis_amnt;
        $orderData["total_price"] = $netprice * $qty ;

        if($optid<>'' && $optid<>0) {
            $orderId=$this->Order->savetoAdmin($orderData);
            $dat['order_id'] = $orderId;
            $this->OrderDetail->save($dat);
        }
        ################################## Section to send order confirmation mail................................
        $this->Order->id = $orderId;
        $data = $this->Order->read();
        $odr	=	$data;
        $content = "<table width='90%'  border='0' cellspacing='2' cellpadding='2' align='center'><tr><td colspan='2' align='center'><h2>Order Details</h2></td></tr><tr><td colspan='2' align='center'><table width='90%' border='0' cellpadding='0' cellspacing='0' class='manage_table' align='center'><tr><td><strong>Order Number</strong></td><td><strong>Order Status</strong></td><td><strong>Order Date</strong></td><td><strong>User Name</strong></td><td><strong>Currency</strong></td></tr><tr><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td></tr><tr><td> ".$orderId."</td><td> Phone Order </td><td>";

        $dt	= strtotime($orderData["date"]);
        $content .= date('m-d-Y',$dt );
        $content .= "</td><td> ".$odr['User']['uname']."</td><td>". $currency_type."</td></tr></table></td></tr>
                  <tr><td colspan='2' align='center'><h3>Item Details</h3></td></tr><tr><td colspan='2'><table width='90%' border='0' cellpadding='2' cellspacing='2' class='manage_table' align='center'> <tr><td colspan='2' width='24%' valign='top'><strong>Product Name</strong></td><td width='12%' valign='top'><strong>Quantity</strong></td><td width='15%' valign='top'><strong>Unit Price</strong></td><td width='15%' valign='top'><strong>Additional Cost</strong></td><td width='14%' valign='top'><strong>Discount</strong></td><td colspan='2' valign='top'><strong>Price</strong></td><td valign='top'></td></tr><tr><td colspan='3'>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td></tr>";

        $content2 = $content;

        $amt=0;
        foreach($odr['OrderDetail'] as $det) {
            $price=0;
            $combined_price=0;
            $dis_amnt=0;

            if($det["discount_type"]=='per' && $det["discount"] > 0)
                $dis_amnt= $det["product_price"] * $det["discount"] / 100;
            else if($det["discount_type"]=='amnt' && $det["discount"] > 0)
                $dis_amnt=$det["discount"];

            $dis_amnt=number_format($dis_amnt,2,'.','');
            $combined_price=($det["product_price"] + $det["extra_price"]);

            if(isset($det["discount_type"]) && $det["discount_type"] <> '') {
                if($det["discount_type"]=='per') {
                    if(isset($det["discount"]) && $det["discount"] <> '' && $det["discount"] > 0) {
                        $discounted_price=($det["product_price"]-(($det["product_price"] * $det['discount'])/100));
                        $price=($discounted_price + $det["extra_price"]) * $det['quantity'];
                        $amt += $price;
                    }
                    else
                        $amt+=($combined_price)*($det['quantity']);
                }

                else if($det["discount_type"]=='amnt') {
                    if(isset($det["discount"]) && $det["discount"] <> '' && $det["discount"] > 0) {
                        $discounted_price=($det["product_price"]-$det['discount']);
                        $price=($discounted_price + $det["extra_price"]) * ($det['quantity']);
                        $amt+= $price;
                    }
                    else
                        $amt+=($combined_price)*($det['quantity']);
                }
            }

            else {
                $price = ($combined_price)*($det['quantity']);
                $amt+= $price;
            }

            $price = number_format($price,2,".","");
            $amt   = number_format($amt,2,".","");

            $content .= "   <tr><td colspan='2'>".$productname."</td><td> ".$det['quantity']." </td>			<td> ".$det['product_price']." </td><td> ".$det['extra_price']." </td><td> ".$dis_amnt." </td><td>".$price." </td><td>&nbsp;</td></tr><tr><td colspan='2' ></td><td height='15' >&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td></tr><tr><td colspan='2' ><strong>Total Price</strong></td><td> ".$amt." </td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td></tr><tr><td colspan='2' ><strong>Tax Name</strong></td><td> ".$odr['Order']['tax_name']." </td><td>&nbsp;</td>	<td>&nbsp;</td>	<td>&nbsp;</td><td>&nbsp;</td> <td>&nbsp;</td><td>&nbsp;</td></tr><tr><td colspan='2' ><strong>Tax</strong></td><td> ".$odr['Order']['tax_price'] ." </td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td></tr><tr><td colspan='2' ><strong>Discount</strong></td><td> ".$discamt." </td>	<td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td></tr><tr><td colspan='2' ><strong>Grand Total</strong></td> <td> ".$odr['Order']['total_price']." </td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td></td></tr><tr><td colspan='3' height='15'>&nbsp;</td> <td>&nbsp;</td>	<td>&nbsp;</td>	<td>&nbsp;</td>	<td>&nbsp;</td>	<td>&nbsp;</td><td>&nbsp;</td></tr>";

            /****************************/
            $content2 .= " <tr><td colspan='2'>".$productname."</td><td> ".$det['quantity']." </td>			<td> ".$det['product_price']." </td><td> ".$det['extra_price']." </td><td> ".$dis_amnt." </td><td>".$price." </td><td>&nbsp;</td></tr><tr><td colspan='2' ></td><td height='15' >&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td></tr><tr><td colspan='2' ><strong>Total Price</strong></td><td> ".$amt." </td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td></tr><tr><td colspan='2' ><strong>Tax Name</strong></td><td> ".$odr['Order']['tax_name']." </td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td></tr><tr><td colspan='2' ><strong>Tax</strong></td><td> ".$odr['Order']['tax_price'] ." </td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td></tr><tr><td colspan='2' ><strong>Discount</strong></td><td> ".$discamt." </td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td></tr><tr><td colspan='2' ><strong>Grand Total</strong></td><td> ".$odr['Order']['total_price']." </td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td></td></tr><tr><td colspan='3' height='15'>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td>	<td>&nbsp;</td>	<td>&nbsp;</td><td>&nbsp;</td></tr>";
            /******************************/
        }

        if($odr["Order"]["discount"] > $amt)
            $discamt=number_format($amt,2,'.','');
        else
            $discamt=number_format($odr["Order"]["discount"],2,'.','');

        $content .= "</table></td> </tr> <tr><td width='50%'>";
        $content2 .= "</table></td> </tr> <tr><td width='50%'>";
        $content .="<tr><td>&nbsp;</td>  </tr></table> </td>  <td>&nbsp;</td> </tr></table>";
        $det['Product']."</td><td> ".$det['quantity']." </td><td> ".$det['product_price']." </td><td> ".$det['extra_price']." </td><td> ".$dis_amnt." </td><td>".$price." </td><td>&nbsp;</td></tr><tr><td colspan='3' height='15'>&nbsp;</td>	<td>&nbsp;</td>	<td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td> </tr>";
        $content2 .="<tr><td>&nbsp;</td>  </tr></table> </td>  <td>&nbsp;</td> </tr></table>";
        $det['Product']."</td><td> ".$det['quantity']." </td><td> ".$det['product_price']." </td><td> ".$det['extra_price']." </td><td> ".$dis_amnt." </td><td>".$price." </td><td>&nbsp;</td></tr> <tr><td colspan='3' height='15'>&nbsp;</td>	<td>&nbsp;</td>	<td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td> </tr>";


        if($odr["Order"]["discount"] > $amt)
            $discamt=number_format($amt,2,'.','');
        else
            $discamt=number_format($odr["Order"]["discount"],2,'.','');

        $content .= "</table></td> </tr> <tr><td width='70%'>";
        $content .="</td><td width='70%' colspan='2' ><table width='90%' border='0' cellpadding='0' cellspacing='0' class='manage_table' align='center'>";
        $content .="</table></td> </tr> <tr height='15'><td colspan='2' align='center'>&nbsp;</td> </tr> <tr><td>";

        $content .=" </td><td><table width='90%' border='0' cellpadding='0' cellspacing='0' class='manage_table' align='center'><tr><td>&nbsp;</td> </tr></table></td></tr>";
        $content .="<tr><td>&nbsp;</td> </tr></table> </td><td>&nbsp;</td> </tr></table>";
        /****************************/
        $content2 .= "</table></td> </tr><tr><td width='70%'>";
        $content2 .="</td><td width='70%' colspan='2' ><table width='90%' border='0' cellpadding='0' cellspacing='0' class='manage_table' align='center'>";
        $content2 .="</table></td> </tr> <tr height='15'><td colspan='2' align='center'>&nbsp;</td> </tr> <tr><td>";
        $content2 .=" </td><td><table width='90%' border='0' cellpadding='0' cellspacing='0' class='manage_table' align='center'><tr><td>&nbsp;</td> </tr></table></td></tr>";
        $content2 .="<tr><td>&nbsp;</td> </tr></table> </td><td>&nbsp;</td> </tr></table>";
        /******************************/

        $cnfg 			= Configure::read('Neutrino');
        $subject 		= "New Phone Order Placed At ".$cnfg["site_name"];
        $headers 		= "MIME-Version: 1.0\r\n";
        $headers                .= "Reply-To: ".$cnfg["site_name"]." <".$cnfg["admin_email"].">" . "\r\n";
        $headers                .= "Return-Path: ".$cnfg["site_name"]." <".$cnfg["admin_email"].">" . "\r\n";
        $headers 		.= "From: ".$cnfg["site_name"]."<".$cnfg["admin_email"].">\r\n";
        $headers                .= "Organization: ".$cnfg["site_name"]."\r\n";
        $headers 		.= "Content-type: text/html; charset=iso-8859-1\r\n";

        $pdt 			= 	$this->Cmspage->findByTitle('Order confirm mail');

        $path			=	"SiteLogo_disp.gif";

        $mcont			=	"<table width='90%'  border='0' cellspacing='2' cellpadding='2' align='center'>
        <tr><td><a href='".FULL_BASE_URL. $cnfg["sitebasefolder"]."' target='_blank'><img src='".FULL_BASE_URL. $cnfg["sitebasefolder"]."/app/webroot/".IMAGES_URL.$path."' border='0' width='300' ></a></td></tr></table>";

        $cnfg["site_name"]	=	"<a href='".FULL_BASE_URL. $cnfg["sitebasefolder"]."' target='_blank'>".$cnfg["site_name"]."</a>";

        //Mail for User

        $mailcontent            =	$mcont.$pdt["Cmspage"]["content"];
        $mailcontent = str_replace("[ORDER_DETAILS]", $content2, $mailcontent);
        $mailcontent = str_replace("[User_Name]", $odr['User']['uname'], $mailcontent);
        $mailcontent = str_replace("[SITE_NAME]", $cnfg["site_name"], $mailcontent);


         if($cnfg['smtpEnabled']=="YES"){  //for SMTP

                              $mailsent = $this->Email->send($odr['User']['email'], $subject, $mailcontent);
                              $this->set('mail',$mailsent);
                             // $this->render(false);

                           }
                           else
        $mailsent    = mail($odr['User']['email'],$subject,$mailcontent,$headers);

        //Mail for Admin

        $pdt1 		= $this->Cmspage->findByTitle('Admin order confirm mail');

        $mailcontent1	= $mcont.$pdt1["Cmspage"]["content"];
        $mailcontent1   = str_replace("[ORDER_DETAILS]", $content, $mailcontent1);
        $mailcontent1   = str_replace("[User_Name]", $odr['User']['uname'], $mailcontent1);
        $mailcontent1   = str_replace("[SITE_NAME]", $cnfg["site_name"], $mailcontent1);

         if($cnfg['smtpEnabled']=="YES"){  //for SMTP

                              $mailsent1 = $this->Email->send($cnfg["admin_email"], $subject, $mailcontent1);
                              $this->set('mail',$mailsent1);
                           //   $this->render(false);

                           }
                           else
        $mailsent1      = mail($cnfg["admin_email"],$subject,$mailcontent1,$headers);

        return $orderId;

    }
    function alltemplates() {

    	$sus	=	$this->Session->read('Userlog');
    	if(isset($sus) && empty($sus)===false){
          $this->set('sus', $sus);
          $citem    =   $this->Cart->find('all', array('conditions' => array('Cart.type <>' => 'G','user_id' => $sus['id'])));
        }
        else {
          $this->set('sus', '');
          $sessid   =   $this->Session->id();
          $citem    =   $this->Cart->find('all', array('conditions' => array('Cart.type <>' => 'G','sess_id' => $sessid)));
        }
        $this->set('cartcount', count($citem));

        $uid = 1;
        /*if (isset($this->Setting) && !empty($this->Setting->table)) {
            $this->Setting->load();
        }*/
        $this->loadModel('Setting');
        $this->Setting->load();
        global $page_title;
        $cnfg 				=	Configure::read('Neutrino');
        if($cnfg["page_title"] <> '')
            $page_title = $cnfg["page_title"];
        $this->pageTitle = $page_title	;
        global $currency;
        $curr		=	$this->Currency->findByCode($currency);
        $this->set('curlogo',$curr["Currency"]["logo"]);
        //Facebook Setting
//        $facebookKeys='';
//        if($this->Session->check('facebookKey')) {
//            $facebookKeys=$this->Session->read('facebookKey');
//        }
//        $this->set('facebookKey', $facebookKeys);
        //Facebook Setting Ends
        // Twitter App Setting
//        $twitterKeys='';
//        if($this->Session->check('twitterKey')) {
//            $twitterKeys=$this->Session->read('twitterKey');
//        }
//        $this->set('twitterKey', $twitterKeys);
        if($cnfg["page_title"] <> '')
            $page_title = $cnfg["page_title"];

        $this->Customimage->resetTable($uid);

        //-------------generate image for unsaved sides of images--------------//
        $imageArray = $this->Customimage->removeTemp($uid);

        if(is_array($imageArray)) {

            foreach($imageArray as $images) {

                if(!empty($images['design_items'])) {
                    //------------------background image--------------------//
                    $editedImg = $this->Customize->index($images['image_path']);
                    foreach($images['design_items'] as $designs) {

                        $designs['type'] == 'text' ? $this->Customize->addText($designs) : $this->Customize->addImage($designs);

                    }

                    //--------------------foreground image-----------------//
                    $editedImg_blank = $this->Customize->index("blank.png", true);

                    foreach($images['design_items'] as $designs) {

                        $designs['type'] == 'text' ? $this->Customize->addText($designs) : $this->Customize->addImage($designs);

                    }
                }
                else {
                    $editedImg = $this->Customize->index($images['image_path']);
                    $editedImg_blank = $this->Customize->index("blank.png", true);

                    copy(WWW_ROOT.IMAGES_URL.$images['image_path'], WWW_ROOT.IMAGES_URL.$editedImg);
                    copy(WWW_ROOT.IMAGES_URL."blank.png", WWW_ROOT.IMAGES_URL.$editedImg_blank);
                }

                $this->Customimage->updateSaveImage($editedImg, $editedImg_blank, $images['id']);

            }

        }

        if($redirect == 1) {
            $this->redirect(array('controller' => 'carts', 'action' => "show"));
            exit;
        }elseif($redirect == 2) {
            $this->redirect(array('controller' => 'orders', 'action' => "myorder/sendtoadmin/sucess"));
            exit;
        }

        $perPage = 6;
        isset($_GET['page']) ? $cur = $_GET['page'] - 1 : $cur = 0;
        $totalRecs = $this->Customimage->adminuserImages_userpage_count($uid);
        $max = ceil($totalRecs/$perPage);
        $pagingArray = array('cur' => $cur, 'max' => $max);
        $this->set("pagingArray", $pagingArray);
        $designOrder = array();
        $imgList = $this->Customimage->adminuserImages_userpage($uid, $perPage, $cur);

        //print_r($cartimageArray);exit;
        $this->set("imgList", $imgList);

    }


    function getproductsideimages($productId,$productDetailId,$sideType,$sideTypeId,$index) {


        // Get images by side type
        $sideType = trim($sideType);
        //$sideImage = $this->Customimage->getProductSideImage($productDetailId,$sideType);

        $sideImage = $this->Customimage->getData($sideType,$productDetailId); //echopre($sideImage);


        $this->set('productId',$productId);
        $this->set('productDetailId',$productDetailId);
        $this->set('sideType',$sideType);
        $this->set('sideTypeId',$sideTypeId);
        $this->set('index',$index);
        $this->set('sideImage',$sideImage);

        $this->layout = 'ajax';
    }
    function getproductdefaultimage($productId,$productDetailId,$sideType,$sideTypeId,$index) {


        // Get images by side type
        $sideType = trim($sideType);
        //$sideImage = $this->Customimage->getProductSideImage($productDetailId,$sideType);

        $sideImage = $this->Customimage->getData($sideType,$productDetailId); //echopre($sideImage);


        $this->set('productId',$productId);
        $this->set('productDetailId',$productDetailId);
        $this->set('sideType',$sideType);
        $this->set('sideTypeId',$sideTypeId);
        $this->set('index',$index);
        $this->set('sideImage',$sideImage);

        $this->layout = 'ajax';
    }


    function ajaxSaveCustomSide() {

        extract($_POST);
        $mode             = $_POST['mode'];
        $customSideValue  = trim($_POST['customSideValue']);
        $productId        = $_POST['productId'];

        if($mode =='check') {
            //checking for duplicate custom side
            $dups = $this->Product->checkCustomSideExists($customSideValue,$productId);
            if(isset($dups) && $dups > 0) {
                $message = 1;
            }else {
                $message = 0;
            }
        }else {
            $postarray = $this->data;
            $postarray['Customimagetypes']['productid'] = $productId;
            $postarray['Customimagetypes']['type']      = $customSideValue;
            $this->data = $postarray;
            $this->Customimagetypes->save($this->data);
            $customSideId = $this->Customimagetypes->id;

            $customSideDataArray  = $this->populateCustomSideValue($productId);
            $message = $customSideDataArray.'**'.$customSideId;
        }
        echo $message;
        //-----------ajax features--------------//
        Configure::write('debug', 0);
        $this->autoRender = false;
        exit;
    }

    function ajaxDeleteCustomSide() {

        extract($_POST);
        $customSideId    = trim($_POST['customSideId']);
        $customSideName  = trim($_POST['customSideName']);
        $productId       = $_POST['productId'];

        $this->Product->deleteCustomSide($customSideId);
        $prod_details	=	$this->Productdetail->findAllByProductId($productId);
        foreach($prod_details as $pDetail){
            $this->Product->deleteCustomSideImages($pDetail['Productdetail']['id'],$customSideName);
        }
        $customSideDataArray = $this->populateCustomSideValue($productId);
        $message = $customSideDataArray;

        echo $message;
        //-----------ajax features--------------//
        Configure::write('debug', 0);
        $this->autoRender = false;
        exit;
    }


    function ajaxUpdateCustomSide() {

        extract($_POST);
        $customSideId    = trim($_POST['customSideId']);
        $customSideName  = trim($_POST['customSideName']);
        $productId       = $_POST['productId'];

        $custoImageprev = $this->Customimage->getCustomSideNameBySideId($customSideId);

        $this->data['Customimagetypes']['productid'] = $productId;
        $this->data['Customimagetypes']['type']      = $customSideName;
        $this->data['Customimagetypes']['id']        = $customSideId;
        $this->Customimagetypes->save($this->data);

        $customSideDataArray = $this->populateCustomSideValue($productId);
        $productDetails      = $this->Productdetail->findAllByProductId($productId);
        foreach($productDetails as $pDetail) {
            $updateCustomImage   = $this->Customimage->updateCustomImageTableWithSideName($pDetail['Productdetail']['id'],$customSideName,$custoImageprev['type']);
        }

        $message = $customSideDataArray;

        echo $message;
        //-----------ajax features--------------//
        Configure::write('debug', 0);
        $this->autoRender = false;
        exit;
    }

    function ajaxLoadCustomSideImages() {

        extract($_POST);
        $productId       = $_POST['productId'];
        $productDetailId = $_POST['productDetailId'];
        $keyIndex        = $_POST['keyIndex'];

        $customSideImageArray = $this->populateCustomSideImageData($productId,$productDetailId,$keyIndex);

        echo $customSideImageArray;
        //-----------ajax features--------------//
        Configure::write('debug', 0);
        $this->autoRender = false;
        exit;
    }




    function populateCustomSideValue($productId) {

        $customSideData = $this->Customimagetypes->find('all',array('conditions' => array('Customimagetypes.productid' => $productId)));
        $customSideDataCount =  count($customSideData);

        $cnfg     = Configure::read('Neutrino');
        $crossUrl   = FULL_BASE_URL. $cnfg["sitebasefolder"].'/'.IMAGES_URL.'close.png';
        $customSideDataArray = '<div class="customfield_wrapper addnewwrapper"><ul>';
        $i=0;
        foreach($customSideData as $customSide) {
            $i++;
            $customSideName = ($customSide['Customimagetypes']['type'])?stripslashes($customSide['Customimagetypes']['type']):"-";
            $customSideId   = $customSide['Customimagetypes']['id'];
            $customSideEditArray = "<label id='edit_lbl".$i."' style='display:none;'>
                                    <input type='text' class='box3_admin' id='edit_box".$i."'  name='edit_box".$i."' value='".$customSideName."' />
                                    </label>
                                    <label id='btn_lbl".$i."' style='display:none;'>
                                        <input type='button' class='button white' value='Update' onClick='updateCustomSide(".$customSideId.",".$i.",".$productId.");' style='padding:0 5px;'>
                                        <input type='but  ton' class='button gray' value='Cancel' onClick='return hideUpdateDiv(".$i.");' style='padding:1px 5px; width:60px;'>
                                    </label>";
            $customSideDataArray .= "<li style='display:block;'><span id='customSideName".$i."' style='cursor:pointer' title=' Click to edit Custom Side' onclick='customSideEdit(".$i.",".$customSideDataCount.")' class='fieldname'> ".$customSideName."</span>".$customSideEditArray."<span class='deletelink'><img title='Delete Custom Side' onClick='customSideDelete(".$customSideId.",".$productId.",\"".$customSideName."\")' src='".$crossUrl."'/> </span></li>";
        }
        $customSideDataArray .= '</ul></div>';

        return $customSideDataArray;
    }


    function populateCustomSideImageData($productId,$productDetailId,$index) {

        $customSideData = $this->Customimagetypes->find('all',array('conditions' => array('Customimagetypes.productid' => $productId)));
        $customSideDataCount =  count($customSideData); //echopre($customSideData);

        $cnfg     = Configure::read('Neutrino');
        $crossUrl   = FULL_BASE_URL. $cnfg["sitebasefolder"].'/'.IMAGES_URL.'close.png';
        $customSideImageArray = '';
        $i=0;
        $pdtSideImage='';
        foreach($customSideData as $customSide) {
            $i++;
            $customSideName = ($customSide['Customimagetypes']['type'])?trim($customSide['Customimagetypes']['type']):"-";
            $customSideId   = $customSide['Customimagetypes']['id'];
            $pdtSideImage = $this->Customimage->getProductSideImage($productDetailId,$customSideName);

            $psideImagePath = FULL_BASE_URL. $cnfg["sitebasefolder"].'/'.IMAGES_URL;
            $pdtSideImageReal = ($pdtSideImage['image'])?$psideImagePath.$pdtSideImage['image']:$psideImagePath.'defaultimage.gif';


            $customSideImageArray .= "<div class='customsideimage_upload'>
                                      <a style='text-decoration: underline;' onclick='loadColorBox(".$productId.",".$productDetailId.",\"".$customSideName."\",".$customSideId.",".$index.");' href='javascript:void(0)'><span class='text'>Upload Image For ".$customSideName."</span>
                                      <img id='jQUpdateImage_".$index."_".$customSideId."' width='100' height='100' src='".$pdtSideImageReal."'>
                                      </a></div>
                                      <input type='hidden' name='data[Product][prodcutimageurl".$index."][".$customSideName."]'  id='prodcutimageurl".$index."'>";
        }


        return $customSideImageArray;
    }


    function ajaxSaveCustomImage() {

        extract($_POST);

       // echopre($this->data);

        if(!empty($this->data)) {  //echopre1($this->data);

            $sideImageData = $this->Customimage->getProductSideImage($this->data["Product"]["proddetail_id"],$this->data["Product"]["image_type"]);

            if($sideImageData['id'] > 0) {

                $this->Customimage->updateCustomSideImages($this->data["Product"]["image_path"],$this->data["Product"]["proddetail_id"],$this->data["Product"]["image_type"]);
                $this->Customimage->updatecoords($sideImageData['id'],$this->data["Product"]["coord_top"],$this->data["Product"]["coord_left"]);
            }else {
                //---------------save to coordinates table-----------------------//
                $coords1 = explode(',',$this->data["Product"]["coord_top"]);
                $this->Coordinate->saveField('x1_axis',$coords1[0]);
                $this->Coordinate->saveField('y1_axis',$coords1[1]);

                $coords2 = explode(',',$this->data["Product"]["coord_left"]);
                $this->Coordinate->saveField('x2_axis',$coords2[0]);
                $this->Coordinate->saveField('y2_axis',$coords2[1]);
                $coordID = $this->Coordinate->id;

                //-------------save to customimages table------------------------//
                $this->Customimage->saveField('productdetails_id',$this->data["Product"]["proddetail_id"]);
                $this->Customimage->saveField('type',$this->data["Product"]["image_type"]);
                $this->Customimage->saveField('image',$this->data["Product"]["image_path"]);
                $custimgID = $this->Customimage->id;

                //--------------------save to imageregions table---------------//
                $this->Imageregion->saveField('customimages_id',$custimgID);
                $this->Imageregion->saveField('coordinates_id',$coordID);

            }
            //---------------------update products table------------------//
            /* $imgArray = explode(".",$this->data["Customimage"]["image_path"]);
            $imgExt = strtolower(end($imgArray));
            $thumbfileName = time()."_thumb".".".$imgExt;
            $dispfileName = time()."_disp".".".$imgExt;
            $fileName = time().".".$imgExt;*/

            /*******************/
            $img = explode("/",$this->data["Product"]["image_path"]);
            $img1=end($img);
            $img2=explode(".",$img1);
            $imgNam=$img2[0];
            $imgArray       = explode(".",$this->data["Product"]["image_path"]);
            $imgExt         = strtolower(end($imgArray));
            $thumbfileName  = $imgNam."_thumb".".".$imgExt;
            $dispfileName   = $imgNam."_disp".".".$imgExt;
            $sliderfileName   = $imgNam."_slider".".".$imgExt;
            $fileName       = $imgNam.".".$imgExt;
            /**********************/

            copy(WWW_ROOT.IMAGES_URL.$this->data["Product"]["image_path"],WWW_ROOT.IMAGES_URL."products/".$fileName);

            $this->Resize->index(WWW_ROOT.IMAGES_URL.$this->data["Product"]["image_path"]);
            $this->Resize->resizeImage(170, 170, 'exact');
            $this->Resize->saveImage(WWW_ROOT.IMAGES_URL."products/".$dispfileName, 100);

            /* $width  = 170;  // changed to avoid white spaces
            $height = 170;
            $this->boxResize(WWW_ROOT.IMAGES_URL.'products/',$fileName,$dispfileName,WWW_ROOT.IMAGES_URL.'products/', $width, $height,"ZEBRA_IMAGE_BOXED");*/


            $this->Resize->index(WWW_ROOT.IMAGES_URL.$this->data["Product"]["image_path"]);
            $this->Resize->resizeImage(48, 48, 'exact');
            $this->Resize->saveImage(WWW_ROOT.IMAGES_URL."products/".$thumbfileName, 100);

            /*$width_thumb  = 48;  // changed to avoid white spaces
            $height_thumb = 48;
            $this->boxResize(WWW_ROOT.IMAGES_URL.'products/',$fileName,$thumbfileName,WWW_ROOT.IMAGES_URL.'products/', $width_thumb, $height_thumb,"ZEBRA_IMAGE_BOXED");*/

            $this->Customimage->updateProduct($this->data["Product"]["proddetail_id"], $this->data["Product"]["image_type"], $fileName,$this->data["Product"]["productid"]);

            $this->Session->setFlash('Image details have been saved.', 'default',array('class'=> 'success'));

            $prod_detailid = $this->data["Product"]["proddetail_id"];

            //update the productdetail table
            $data['Productdetail']['doublesided']   = $this->data["Product"]["doublesided"];
            $data['Productdetail']['id']            = $this->data["Product"]["proddetail_id"];

            if($this->data["Product"]["doublesided"]!='')
            {
                $data['Productdetail']['doublesided'] = $this->data["Product"]["doublesided"];
            }else{
                $data['Productdetail']['doublesided'] = 'X';
            }


            $this->Productdetail->save($data);
        }


        echo $this->data["Product"]["image_path"];
        //-----------ajax features--------------//
        Configure::write('debug', 0);
        $this->autoRender = false;
        exit;
    }

    function ajaxDeleteCombination() {

        extract($_POST);
        $productDetailId = $_POST['productDetailId'];

        $combinationDelete = $this->Product->deleteProductCombination($productDetailId);

        echo $combinationDelete;
        //-----------ajax features--------------//
        Configure::write('debug', 0);
        $this->autoRender = false;
        exit;
    }

    /***************************            Prdocut Template  ************************/
 function show_template($id=0,$savIds=0) {
        $sus    =   $this->Session->read('Userlog');
        if(isset($sus) && empty($sus)===false){
          $this->set('sus', $sus);
          $citem    =   $this->Cart->find('all', array('conditions' => array('Cart.type <>' => 'G','user_id' => $sus['id'])));
        }
        else {
          $this->set('sus', '');
          $sessid   =   $this->Session->id();
          $citem    =   $this->Cart->find('all', array('conditions' => array('Cart.type <>' => 'G','sess_id' => $sessid)));
        }
        $this->set('cartcount', count($citem));

        $pageURL      = $this->curURL();
        $arrCurrentUrl = explode('/', $pageURL);
        if(is_array($arrCurrentUrl)  && count($arrCurrentUrl)>1) {
            $qryString     = end($arrCurrentUrl);
            if (preg_match("/SCRIPT/i",$qryString)) {
                $this->redirect(array('controller' => 'pages','action'=>'display'));
            }
        }
        $this->Customimage->delEntries1($this->Session->id());
        /*if (isset($this->Setting) && !empty($this->Setting->table)) {
            $this->Setting->load();
        }*/
        $this->loadModel('Setting');
        $this->Setting->load();
        $this->set('pid',$id);
        global $page_title;

        global $sitefolder;

        $cnfg 				=	Configure::read('Neutrino');
        $page_title			=	$name;
        if($cnfg["page_title"] <> '')
            $page_title.=' - '.$cnfg["page_title"];

        $this->set('sitefolder', $sitefolder);

        $this->pageTitle = $page_title	;
        //Facebook Setting
//        $facebookKeys='';
//        if($this->Session->check('facebookKey')) {
//            $facebookKeys=$this->Session->read('facebookKey');
//        }
//        $this->set('facebookKey', $facebookKeys);
        //Facebook Setting Ends

        //Twitter Setting
//        $twitterKeys='';
//        if($this->Session->check('twitterKey')) {
//            $twitterKeys=$this->Session->read('twitterKey');
//
//        }
//
//        $this->set('twitterKey', $twitterKeys);
        //Twitter Setting Ends

        $sus			=	$this->Session->read('Userlog');

        $this->set('sus', $sus);

        if($id == 0||$id=='') {
            //if(isset($name) && $name!='')
            //$pdet = $this->Product->find('first', array('conditions' => array('Product.pname' => $name)));
            $this->redirect(array('controller' => 'pages','action'=>'display'));
            exit();
        }
        else
            $pdet = $this->Product->find('first', array('conditions' => array('Product.id' => $id)));
        
        
         
        

        if(isset($pdet["Product"]["id"])) {

            $id		=	$pdet["Product"]["id"];

            //Code Added By shyam for Category Menu Listing starts here..

            $lst	=	$this->Category->find('all');

            foreach($lst as $det)

                $menu_array[$det["Category"]["id"]] = array('name' => $det["Category"]["cname"],'parent' => $det["Category"]["parent_id"], 'position' => $det["Category"]["position"]);

            $this->set('menu_array', $menu_array);

            //Code Added By shyam for Category Menu Listing ends here..





            $this->Product->id = $id;

            $this->data = $this->Product->read();



            $this->data1 = $this->Productdetail->findAllByProductId($this->data['Product']['id']);

              $this->set('slideArray',$this->data1);

          //  echopre1($this->data1);
            #################  Fetching the Product combination(Added by Shyam)	#################



            //Fetching Images starts here
            //echopre1($this->data);


            if(isset($this->data["Productimages"]) && !empty($this->data["Productimages"])) {
                foreach($this->data["Productimages"] as $key => $val) {
                    $imgarr[]=$val["imagename"];
                    $imgarr1[$key]['name']=$val["imagename"];
                    $imgDetail=$this->Customimage->findByImage("tshirts/".$val["imagename"]);
                    $imgarr1[$key]['id']=$imgDetail["Customimage"]["productdetails_id"];
                    $imgarr1[$key]['type']=$imgDetail["Customimage"]["type"];
                    $imgarr1[$key]['default_img']=$val["default_img"];
                }





                $this->set('imgarr', $imgarr);
                $this->set('imgarr1', $imgarr1);



            }
//echo "<pre>";print_r($imgarr);exit;
            //Fetching Images ends here





            if($this->data["Product"]["combination"]=='Y') {

                $pcombndet	=	$this->Productdetail->findAllByProductId($id);
//echo "<pre>";print_r($pcombndet);exit;
                for($i=0;$i<count($pcombndet);$i++) {

                    $pcmbnids=$pcombndet[$i]["Productdetail"]["customvalue_id"];

                    $pcmbnid=explode(',',$pcmbnids);

                    foreach($pcmbnid as $key => $val) {

                        if($val!='') {

                            $combnstr[]=$this->Product->getpdctcmbn($val);

                            $combinations=implode(", ",$combnstr);

                            $pcombndet[$i]["Productdetail"]["combinations"]= $combinations;

                        }

                    }

                    unset($combnstr);
                    unset($combinations);

                }

                $this->set('pcombndet', $pcombndet);

            }





            #################  Fetching the Product combination(Added by Shyam)	################

            if(isset($this->data["Productimages"][0]["imagename"])) {

                $defimg	=	$this->data["Productimages"][0]["imagename"];

                for($m=0; $m < sizeof($this->data["Productimages"]); $m++) {

                    if($this->data["Productimages"][$m]["default_img"] == "Y") {

                        $defimg	=	$this->data["Productimages"][$m]["imagename"];

                    }

                }
                $post_data = $this->data;
                $post_data["Productimages"]	=	$defimg;
                $this->data = $post_data;

            }else {

                $post_data = $this->data;
                $post_data["Productimages"]	= '';
                $this->data = $post_data;

            }

            $rate	=	$this->Rating->avgrate($savIds,'template');

            $this->set('avgrate', $rate);

            $this->set('productdet', $this->data);

            global $currency;

            $curr		=	$this->Currency->findByCode($currency);

            $this->set('curlogo',$curr["Currency"]["logo"]);

            //--------------------code Aswin-------------//
            $sess_arr = $this->Session->read('Userlog');
            $uid = $sess_arr['id'];
            $this->set('uid', $uid);

        }

        else {

            $this->redirect(array('controller' => 'pages','action'=>'display'));

        }





        /*********** For Add Cart ******************/
        $sess_arr = $this->Session->read('Userlog');
        $uname = $sess_arr['uname'];
        $this->set('uname', $uname);
        $combID = ($id)?$id:20;
        $frontRear = 'Front';
        if($combID) {
            $divArray = $this->Customimage->findEntry($this->Session->id(), $frontRear);
            $this->set('divArray', $divArray);
            $coords = $this->Customimage->getcoords($combID, $frontRear);
            $regions = array("Front" => 'noimages.gif', "Rear" => 'noimages.gif');
            $img = $this->Customimage->findAllByProductdetailsId($combID);
            $prod = $this->Product->findById($combID);
            //echo "<pre>";print_r($prod);exit;

            $productname= $prod['Product']['pname'];
            $ID = '';
            if(is_array($img)) {
                foreach($img as $key=>$val) {
                    $regions[$img[$key]['Customimage']['type']] = $img[$key]['Customimage']['image'];
                    if($img[$key]['Customimage']['type'] == $frontRear) $ID = $img[$key]['Customimage']['productdetails_id'];
                }
            }
            if(!$ID) {
                $prod_detail = $this->Productdetail->findById($combID);
                $prod        = $this->Product->findById($prod_detail['Productdetail']['product_id']);
                //echo "<pre>";print_r($prod);exit;


            }
            $coords = $this->Customimage->getcoords($combID, $frontRear);//print_r($coords);
            $fonts = $this->Font->find('list', array('fields' => array('Font.name', 'Font.name'), 'conditions' => array('Font.status' => 1)));
            $txtsize = array("4" => "4", "6" => "6", "8" => "8", "10" => "10", "12" => "12", "14" => "14", "16" => "16");
            $outline = array("None" => "None", "Thin" => "Thin", "Medium" => "Medium", "Thick" => "Thick");
            $txtcurve = array("0" => "None", "140" => "Small", "180" => "Medium", "220" => "Large");

            $txtshape = array("normal" => "Normal", "roof" => "Roof", "arc" => "Arch", "curve" => "Curve", "wedge" => "Wedge");

            $txtshapeSettings["normal"] = array('0' => 'None');

            $txtshapeSettings["roof"]   = array('1' => 'Top Small',
                    '2' => 'Top Medium',
                    '3' => 'Top Large',
                    '4' => 'Middle Small',
                    '5' => 'Middle Medium',
                    '6' => 'Middle Large',
                    '7' => 'Bottom Small',
                    '8' => 'Bottom Medium',
                    '9' => 'Bottom Large',
                    '10' => 'Left Small',
                    '11' => 'Left Medium',
                    '12' => 'Left Large',
                    '13' => 'Right Small',
                    '14' => 'Right Medium',
                    '15' => 'Right Large');

            $txtshapeSettings["wedge"]  = array('1' => 'Up Widen Slow',
                    '2' => 'Up Widen Medium',
                    '3' => 'Up Widen Fast',
                    '4' => 'Up Narrow Slow',
                    '5' => 'Up Narrow Medium',
                    '6' => 'Up Narrow Fast',
                    '7' => 'Middle Widen Slow',
                    '8' => 'Middle Widen Medium',
                    '9' => 'Middle Widen Fast',
                    '10' => 'Middle Widen Slow',
                    '11' => 'Middle Widen Medium',
                    '12' => 'Middle Widen Fast',
                    '13' => 'Down Widen Slow',
                    '14' => 'Down Widen Medium',
                    '15' => 'Down Widen Fast',
                    '16' => 'Down Narrow Slow',
                    '17' => 'Down Narrow Medium',
                    '18' => 'Down Narrow Fast');

            $txtshapeSettings["arc"]    = array('1' => 'Up Very Small',
                    '2' => 'Up Small',
                    '3' => 'Up Medium',
                    '4' => 'Up Large',
                    '5' => 'Up Very Lage',
                    '6' => 'Down Very Small',
                    '7' => 'Down small',
                    '8' => 'Down Medium',
                    '9' => 'Down Large',
                    '10' => 'Down very Large');

            $txtshapeSettings["curve"]  = array('1' => 'Up Very Sharp',
                    '2' => 'Up Sharp',
                    '3' => 'Up Medium',
                    '4' => 'Up Slight',
                    '5' => 'Up Very Slight',
                    '6' => 'Up Super Slight',
                    '7' => 'Down Very Sharp',
                    '8' => 'Down Sharp',
                    '9' => 'Down Medium',
                    '10' => 'Down Slight',
                    '11' => 'Down Very Slight',
                    '12' => 'Down Super Slight');

            $this->set('limit', 12);
            $this->set('page', 1);
            //  $clipArray = $this->__readDirectory();

            //$imageArray = $this->__readCategory();

            $userclips = $this->Setting->findByFieldname('userclipart');
            $this->set('userclips', $userclips['Setting']['value']);

            //-------------------Get the entries from the settings table---------------------------------
            $data	=	$this->Setting->find('list',array('fields'=>array('Setting.fieldname', 'Setting.value')));
            $curr			=	$this->Currency->findByCode($data["currency"] );
            $this->set('pcurr', $curr["Currency"]["logo"]);

            $first_imagecost = $this->Setting->findByFieldname('first_image');
            $addn_imagecost = $this->Setting->findByFieldname('addn_image');
            $first_textcost = $this->Setting->findByFieldname('first_text');
            $addn_textcost = $this->Setting->findByFieldname('addn_text');

            $this->set("first_imagecost",$first_imagecost['Setting']['value']);
            $this->set("addn_imagecost",$addn_imagecost['Setting']['value']);
            $this->set("first_textcost",$first_textcost['Setting']['value']);
            $this->set("addn_textcost",$addn_textcost['Setting']['value']);
            //---------------------------------------------------------------------------------------------
            $frontRear = 'Front';
            $this->set('coords', $coords);
            $this->set('fonts', $fonts);
            $this->set('txtsize', $txtsize);
            $this->set('outline', $outline);
            $this->set('frontRear', $frontRear);
            $this->set('productdetailid', $combID);
            $this->set('image_front', $regions[$frontRear]);
            $this->set('imageArray', $imageArray);
            $this->set('clipArray', $clipArray);
            $this->set('txtcurve', $txtcurve);
            $this->set('txtshape', $txtshape);
            $this->set('txtshapeSettings', $txtshapeSettings);
            $palette = $this->Palette->find('all', array('conditions' => array('Palette.status' => '1'), 'orderby' => array('Palette.id')));
            $this->set('palette',$palette);
            $this->set('Productname', $productname);
            $this->set('coords', $coords);
            //---------------UID---------------//
            ($timestamp == '' || $timestamp == 0) ? $timestamp = time() : $timestamp;
            $this->set('timestamp', $timestamp);


        }   if($sess_arr['id'] != "") {
            $logged_in = 1;
        }
        elseif($this->Session->read('tempUser')) {
            $logged_in = 1;
        }else {
            $logged_in = 0;
        }
        $this->set('userStatus', $logged_in);
        /***********       End Add cart ***********/


         $pid = $this->Customimage->getFrontDetails($savIds);
         $customImages = $this->Customimage->getCustomizedImages($pid['productdetails_id'], $savIds);
         //echopre($customImages);
         $this->set('metaProductName',$pid['template_name']);
         $this->set('metaProductDescription',$pdet['Product']['descr']);
         
         $fistimage = FULL_BASE_URL. $cnfg["sitebasefolder"].'/img/'.$customImages[0]['image'];
         
         $code_entities_match = array(' ','/','#','%','?','&','!');
    $code_entities_replace = array('-');
    $text = str_replace($code_entities_match, $code_entities_replace, $pid['template_name']);
         
         $fundUrl = FULL_BASE_URL. $cnfg["sitebasefolder"].'/show_template/'.$id.'/'.$savIds;
         
         
         $this->set('metaProductImage', $fistimage);
          $this->set('metaProductUrl', $fundUrl);
         
         
        // print_r($customImages);
         $this->set('customImages', $customImages);
         $this->set('savIds', $savIds);
          $addnCost = $this->calculateAmt($savIds);
          if($pid['productdetails_id']!=NULL){
            $productDetails = $this->Productdetail->findById($pid['productdetails_id']);


            $productId = $productDetails['Productdetail']['product_id'];
            $imageName = $productDetails['Productdetail']['pdctfile'];
            $prod = $this->Product->findById($productId);
            $productname= $prod['Product']['pname'];
            $productDescription= $prod['Product']['descr'];
            $productPrice= $prod['Product']['price'];
            $this->set("imageName", $imageName);
            $this->set("productname", $productname);
            $this->set("productDescription", $productDescription);
            $this->set("productPrice", $productPrice);
             $sess_arr1 = $this->Session->read('Userlog');

        //Identifying the user

        if($sess_arr1['id'])
			{
            $uid = $sess_arr1['id'];
        }
        else{
        	$uid = $this->Session->id();
        	}
             if($prod['Product']["discount_type"]=='per' && $prod['Product']["discount"] > 0)

		  //$dis_amnt=(($det["product_price"] + $det["extra_price"])*$det["discount"])/100;
                    $dis_amnt= $productPrice * $prod['Product']["discount"] / 100;

		  else if($prod['Product']["discount_type"]=='amnt' && $prod['Product']["discount"] > 0)

		  $dis_amnt=$prod['Product']["discount"];
            $this->set("dis_amnt",$dis_amnt);
            $this->set('baseprice',$productPrice);
            $this->set('extraprice',$productDetails['Productdetail']['extraprice']);
            $this->set("price", ($productPrice+$addnCost+$productDetails['Productdetail']['extraprice'])-$dis_amnt);
            $this->set('addnCost',$addnCost);
             global $currency;
		$curr		=	$this->Currency->findByCode($currency);
		$this->set('curlogo',$curr["Currency"]["logo"]);


               /* $savedID = $this->Customimage->makeCustomizationUs($pid['productdetails_id'], $savIds,$uid);

                $row1 = $this->Customimage->getFrontDetails($savedID);



         $fid = $row1['id'];
         $side = $row1['type'];

         $timestamp = explode('_', $row1['ref_name']);
         $timestamp1 = $timestamp[1];
         $combId = $row1['productdetails_id'];
         $this->set('timestamp1',$timestamp[1]);
         $this->set('side',$side);
         $this->set('productdetailid',$combId);
         $this->set('lastId',$fid);*/

                 $this->set("productdetailid",$pid['productdetails_id']);
         $this->set("prod_Id",$pid['productdetails_id']);
         $this->set("sav_Ids",$savIds);
         $this->set("user_id",$uid);

            }
        //$this->__generateUserDesigns($uid,$combId);
    }


    public function makecustomization($prod_Id,$sav_Ids,$user_id)
    {
       // echo $sav_Ids;
        
        //$this->Savedimage->id       = $sav_Ids;          
        $refname = $this->Savedimage->find('first',array('conditions'=>array('id'=>$sav_Ids)));
        $cust_refname = $refname['Savedimage']['ref_name'];
        $saveIdArray = array();
        
        $refNameQry = $this->Savedimage->find('all',array('conditions'=>array('ref_name'=>$cust_refname)));
      //  echopre1($refNameQry);
        $ref_name = "Customization_" . time() . rand(0,999); 
           if($refNameQry){
                foreach($refNameQry as $savedImages){
                    $savedID = $savedImages['Savedimage']['id'];
                    $data1 = $this->data;
                     $data1['Savedimage']['ref_name'] = $ref_name;
                                                $data1['Savedimage']['productdetails_id'] =$savedImages['Savedimage']['productdetails_id'];
                                                $data1['Savedimage']['users_id'] = $user_id;
                                                $data1['Savedimage']['type'] =$savedImages['Savedimage']['type'];
                                                $data1['Savedimage']['image'] ='temp';
                                                $data1['Savedimage']['saved_date'] = date('Y-m-d H:i:s');
                                                $data1['Savedimage']['foreground_image'] = 'temp';


$this->data = $data1;  
                                                $this->Savedimage->create();
		        			$this->Savedimage->save($this->data);
		                    
		                    $insertedID = $this->Savedimage->getLastInsertID();
                                    //echo $insertedID.'<br>';
                                    $saveIdArray[] = $insertedID;
                                    
                                    $this->Customimage->duplicateItemCordinates($savedID,$insertedID,$savedImages['Savedimage']['productdetails_id']);
                                    
                                    
                                    
                                    
                                    
                }
           }
        
           
           //exit;
           
       
        
        
        
        
        //echo $savedID; exit;
$savedID = $saveIdArray[0];
                $row1 = $this->Customimage->getFrontDetails($savedID);



         $fid = $row1['id'];
         $side = $row1['type'];

         $timestamp = explode('_', $row1['ref_name']);
         $timestamp1 = $timestamp[1];
         $combId = $row1['productdetails_id'];
         //$this->set('timestamp1',$timestamp[1]);
         //$this->set('side',$side);
         //$this->set('productdetailid',$combId);
        // $this->set('lastId',$fid);
       //  $this->__generateUserDesigns($user_id,$prod_Id);
           $returnArray['productdetailid'] = $combId;
                     $returnArray['lastId'] = $fid;
                        $returnArray['timestamp1'] = $timestamp[1];
                        $returnArray['side'] = $side;
                    echo json_encode($returnArray); exit;
    }




    function __generateUserDesigns($uid,$Productdetailid=null)
    {
        //-----------fix to fill front/rear images in only 1 is present-------------//
        if($Productdetailid!=null)
        {
       		$this->Customimage->resetTable($uid,$Productdetailid);
        }
        else
        {
        	$this->Customimage->resetTable($uid);
        }
        //-------------generate image for unsaved sides of images--------------//
        $imageArray = $this->Customimage->removeTemp($uid);

        if(is_array($imageArray)) {

            foreach($imageArray as $images) {

                if(!empty($images['design_items'])) {
                    //------------------background image--------------------//
                    $editedImg = $this->Customize->index($images['image_path']);
                    foreach($images['design_items'] as $designs) {

                        $designs['type'] == 'text' ? $this->Customize->addText($designs) : $this->Customize->addImage($designs);

                    }

                    //--------------------foreground image-----------------//
                    $editedImg_blank = $this->Customize->index("blank.png", true);

 //For SVG FOREGROUND
                		 $tmp = explode(".", $editedImg_blank);
                    	 $this->Customize->editedImg_svg=$tmp[0].".svg";

                         copy(WWW_ROOT.IMAGES_URL."plain.svg", WWW_ROOT.IMAGES_URL.$this->Customize->editedImg_svg);
                         require_once WWW_ROOT."/svglib/svglib.php";
                  // echo "image". WWW_ROOT.IMAGES_URL.$this->Customize->editedImg_svg;




///////////////////
                    foreach($images['design_items'] as $designs) {


                        $designs['type'] == 'text' ? $this->Customize->addText($designs) : $this->Customize->addImage($designs);

                    }

                }
                else {
                    $editedImg = $this->Customize->index($images['image_path']);
                    $editedImg_blank = $this->Customize->index("blank.png", true);

                    copy(WWW_ROOT.IMAGES_URL.$images['image_path'], WWW_ROOT.IMAGES_URL.$editedImg);
                    copy(WWW_ROOT.IMAGES_URL."blank.png", WWW_ROOT.IMAGES_URL.$editedImg_blank);
                }

                $this->Customimage->updateSaveImage($editedImg, $editedImg_blank, $images['id']);

            }

        }
    }
/***************************            Prdocut Template  ************************/


function upload($bulkupload=false,$imagedata=null) {
        
        $bulkupload_return['error_message']="sucess";

        if($bulkupload)
        {   $post_data = $this->data;
            $post_data['Customimage']['img_field']['tmp_name']=$imagedata['location'];
            $post_data['Customimage']['img_field']['name']=" ".$imagedata['name'];
            $this->data = $post_data;
            
        }
        list($width,$height) = getimagesize($this->data['Customimage']['img_field']['tmp_name']);
               
        $find = array(" ","(",")","{","}","!","&","*","#","[","]");
        //$fileName = time().$this->data['Customimage']['img_field']['name'];
        $fileName = time().str_replace($find, "_", $this->data['Customimage']['img_field']['name']);
        
        
        /* if($width != $height ) {
            echo "ERROR: Image should be of Same Height and Width ";
            exit;
        }*/
        if($width < 515 || $height < 515) 
            {
                //echo "ERROR: Image size should be atleast 515x515";
                if($bulkupload)
                    {
                        $bulkupload_return['error_message']="Image size should be atleast 515x515";
                        return $bulkupload_return;
                    }
            }
        else
            {
                if($bulkupload)
                    {
                        copy($this->data['Customimage']['img_field']['tmp_name'], WWW_ROOT.IMAGES_URL.'tshirts/'."$fileName");
            
                    }
                        if(is_uploaded_file($this->data['Customimage']['img_field']['tmp_name']) || $bulkupload) 
                            {
                                if(!move_uploaded_file($this->data['Customimage']['img_field']['tmp_name'], WWW_ROOT.IMAGES_URL.'tshirts/'."$fileName") && !($bulkupload)) 
                                    {
                                        echo "ERROR: Sorry, an error occurred, please try again!";
                                    }
                
                                else 
                                    { 
                    
                                        $extension = strtolower(strrchr($fileName, '.'));
                                        $filename_new=str_replace($extension,".png",$fileName);
                    
                                        system("convert -density 400 -units pixelsperinch ".WWW_ROOT.IMAGES_URL.'tshirts/'.$fileName." ".WWW_ROOT.IMAGES_URL.'tshirts/'.$filename_new);
                    
                                        if(!$extension==".png")
                                            {
                                                unlink(WWW_ROOT.IMAGES_URL.'tshirts/'.$fileName);
                                            }
                                        $fileName=$filename_new;
                                        $bulkupload_return['filename']=WWW_ROOT.IMAGES_URL.'tshirts/'.$fileName;
                    /*$this->Resize->index( WWW_ROOT.IMAGES_URL.'tshirts/'."$fileName");
                    $this->Resize->resizeImage(515, 515, 'exact');
                    $this->Resize->saveImage( WWW_ROOT.IMAGES_URL.'tshirts/'."$fileName", 100);
                    echo 'tshirts/'."$fileName";*/ 
                    $width = 515;  // changed to avoid white spaces
                    $height = 515;
                    $this->boxResize(WWW_ROOT.IMAGES_URL.'tshirts/',$fileName,$fileName,WWW_ROOT.IMAGES_URL.'tshirts/', $width, $height,"ZEBRA_IMAGE_BOXED");
                    
                    if(!$bulkupload)
                    {
                    echo 'tshirts/'."$fileName";  
                    }                
                }
            }

            if($bulkupload)
            {
                return $bulkupload_return;
            }
        }
        //----------ajax--------------//
        Configure::write('debug', 0);
        $this->autoRender = false;
        exit;
    }


 function boxResize($path, $sourceFileName, $destFileName,$destination_path, $img_width, $img_height,$method,$bgcolor='FFFFFF')
    {
        
        $ObjImagehandle                         = new ImagehandleComponent();
        $ObjImagehandle->source_path            = $path.'/'.$sourceFileName;
        $ObjImagehandle->preserve_aspect_ratio  = true;
        $ObjImagehandle->enlarge_smaller_images = true;
        $ObjImagehandle->preserve_time          = true;  
        
        $ObjImagehandle->target_path = $destination_path.'/'.$destFileName;
        $ObjImagehandle =$ObjImagehandle->resize($img_width, $img_height,$method,$bgcolor);
        
    }   

}
?>
