<?php

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: 			*/

// +----------------------------------------------------------------------+

// | PHP version 4/5                                                      |

// +----------------------------------------------------------------------+

// | Copyright (c) 2004-2011 ARMIA INC                                    |

// +----------------------------------------------------------------------+

// | This source file is a part of iScripts PrintLogic                     |

// +----------------------------------------------------------------------+

// | Authors: Sarath Kumar<sarath.k@armiasystems.com>           		  |

// +----------------------------------------------------------------------+
App::uses('AppModel', 'Model');
class Brand extends AppModel
{
   var $name 	= 'Brand';

  ###### Function toget average rating of a product

 	function getTableName($tablename){
			$Db = ConnectionManager::getDataSource($this->useDbConfig);
			$tblnme = $Db->fullTableName($tablename);
			$tblnme=trim(str_replace('`','',$tblnme));
			return $tblnme;
		}

	function generateUniqueFilename($fileName, $path='') {
        $path = empty($path) ? WWW_ROOT.IMAGES_URL.'brands/' : $path;
        $no = 1;
        $newFileName = $fileName;
        while (file_exists("$path/".$newFileName)) {
            $no++;
            $newFileName = substr_replace($fileName, "_$no.", strrpos($fileName, "."), 1);
        }
        return $newFileName;
    }

    function getProductCountByBrand($brand_id){
        $Db       = ConnectionManager::getDataSource($this->useDbConfig);
        $pdtbl    = $Db->fullTableName('products');
        $brandtbl = $Db->fullTableName('brands');
        //$pdtcatbl = str_replace('`', '', $pdtcatbl);
        $sql = "SELECT count(DISTINCT P.id) as pCount FROM $pdtbl P
                LEFT JOIN $brandtbl B ON P.brand_id = B.id
                WHERE P.brand_id = $brand_id AND P.status = 'A' AND P.stock > 0";
        $result = $this->query($sql);
        return $result[0][0]['pCount'];
   }

   function getProductDataByBrand($brand_id, $perPage, $cur){
       $Db = ConnectionManager::getDataSource($this->useDbConfig);
       $pdtbl     = $Db->fullTableName('products');
       $pdtdetbl  = $Db->fullTableName('productdetails');
       $pdtimgtbl = $Db->fullTableName('productimages');
       $brandtbl  = $Db->fullTableName('brands');

       $from  = $cur*$perPage;
       $limit = $perPage;

       //$pdtcatbl = str_replace('`', '', $pdtcatbl);
       $sql = "SELECT Product.*,Brand.*,ProductDetail.*,Productimages.*
                FROM $pdtbl Product
                   INNER JOIN $brandtbl Brand ON Product.brand_id = Brand.id
                   INNER JOIN $pdtdetbl ProductDetail ON ProductDetail.product_id = Product.id
                   LEFT JOIN $pdtimgtbl Productimages ON Productimages.product_id = Product.id
               WHERE 1=1
               AND Product.brand_id = '$brand_id'
               AND Product.status = 'A'
               AND Product.stock > 0
               GROUP BY Product.id
               ORDER BY Product.pname ASC
               LIMIT $from, $limit";
       $result = $this->query($sql);
       return $result;
  }

    function handleFileUpload($fileData, $fileName){

        $error = false;
        //Get file type
        $typeArr = explode('/', $fileData['type']);
        //If size is provided for validation check with that size. Else compare the size with INI file
        if (($this->validateFile['size'] && $fileData['size'] > $this->validateFile['size']) || $fileData['error'] == UPLOAD_ERR_INI_SIZE) {
            $error = 'The Image File "'.$fileName.'" is too large to upload';
        }
        elseif ($this->validateFile['type'] && (strpos($this->validateFile['type'], strtolower($typeArr[1])) === false)) {

            //File type is not the one we are going to accept. Error!!
            $error = 'Invalid file type';
        }
        else {
            //Data looks OK at this stage. Let's proceed.
            if ($fileData['error'] == UPLOAD_ERR_OK) {
                //Oops!! File size is zero. Error!
                if ($fileData['size'] == 0) {

                    $error = 'Zero size file found.';
                }
                else {
                    if (is_uploaded_file($fileData['tmp_name'])) {
                        //Finally we can upload file now. Let's do it and return without errors if success in moving.
                        if (!move_uploaded_file($fileData['tmp_name'], WWW_ROOT.IMAGES_URL.'Brands/'."$fileName")) {
                            $error = true;
                        }
                        $this->resizeImg(WWW_ROOT.IMAGES_URL.'Brands/'."$fileName", 125 ,125, false, 100, 0,"_thumb");
                        //$this->resizeImg(WWW_ROOT.IMAGES_URL.'brands/'."$fileName", 245 ,175, false, 100, 0,"_thumb");
                        $this->resizeImg(WWW_ROOT.IMAGES_URL.'Brands/'."$fileName", 245 ,175, false, 100, 0,"_disp");
                        //echo WWW_ROOT.IMAGES_URL.'brands/'."$fileName"; exit;
                    }
                    else {
                        $error = true;
                    }
                }
            }
        }
        return $error;
    }

    function resizeImg($imgPath, $maxWidth, $maxHeight, $directOutput = true, $quality = 90, $verbose,$imageType) {

        $size = getimagesize($imgPath);
        // break and return false if failed to read image infos
        if(!$size) {
            if($verbose && !$directOutput)echo "<br />Not able to read image infos.<br />";
            return false;
        }
        // relation: width/height
        $relation = $size[0]/$size[1];
        // maximal size (if parameter == false, no resizing will be made)
        $maxSize = array($maxWidth?$maxWidth:$size[0],$maxHeight?$maxHeight:$size[1]);
        // declaring array for new size (initial value = original size)
        $newSize = $size;
        // width/height relation
        $relation = array($size[1]/$size[0], $size[0]/$size[1]);
        //print_r($size);
        //echo "<br>";
        //print_r($relation);exit;
        if(($newSize[0] > $maxWidth)) {
            $newSize[0]=$maxSize[0];
            $newSize[1]=$newSize[0]*$relation[0];
        }
        if(($newSize[1] > $maxHeight)) {
            $newSize[1]=$maxSize[1];
            $newSize[0]=$newSize[1]*$relation[1];
        }
        // create image
        $img_ext='';
        switch($size[2]) {
            case 1:
                if(function_exists("imagecreatefromgif")) {
                    $originalImage = imagecreatefromgif($imgPath);
                    $img_ext='.'.end(explode('.',$imgPath));
                } else {
                    if($verbose && !$directOutput)echo "<br />No GIF support in this php installation, sorry.<br />";
                    return false;
                }
                break;
            case 2:
                $originalImage = imagecreatefromjpeg($imgPath);
                $img_ext='.'.end(explode('.',$imgPath));
                break;
            case 3:
                $originalImage = imagecreatefrompng($imgPath);
                $img_ext='.'.end(explode('.',$imgPath));
                break;
            default:
                if($verbose && !$directOutput)echo "<br />No valid image type.<br />";
                return false;
        }
        // create new image
        $resizedImage = imagecreatetruecolor($newSize[0], $newSize[1]);
        imagecopyresampled($resizedImage, $originalImage,0, 0, 0, 0,$newSize[0], $newSize[1], $size[0], $size[1]);
        $rz=$imgPath;
        // output or save
        if($directOutput) {
            imagejpeg($resizedImage);
        } else {
            $rz=preg_replace("/\.([a-zA-Z]{3,4})$/","".$imageType.$img_ext,$imgPath);
            imagejpeg($resizedImage, $rz, $quality);
        }
        // return true if successfull
        return $rz;
    }

}

?>
