<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4:             */
// +----------------------------------------------------------------------+
// | PHP version 4/5                                                      |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004-2011 ARMIA INC                                    |
// +----------------------------------------------------------------------+
// | This source file is a part of iScripts PrintLogic                     |
// +----------------------------------------------------------------------+
// | Authors: Jipson<jipson.thomas@armiasystems.com>                      |
// +----------------------------------------------------------------------+
App::uses('AppModel', 'Model');

class Product extends AppModel {

    var $name = 'Product';
    //var $belongsTo = 'Category';
    var $belongsTo = array(
        'Category' => array(
            'className'   => 'Category',
            'foreignKey'  => 'category_id'
        ),
        'Brand' => array(
            'className'   => 'Brand',
            'foreignKey'  => 'brand_id'
        )
    );
    var $hasMany = array('Productcustomfields','Productimages','ProductCategoryRelation','Productpricetier','productdimensions');
    var $useTable = "products";
    var $validateFile = array(
            //'size' => 204800,
            'size' => 904800,
            'type' => 'jpg,pjpeg,jpeg,png,gif,zip,pdf,rar,psd,opf,azw,lit,pdb,pkg,mp3,mpeg,mp4,avi'
    );
function generateUniqueFilename($fileName, $path='') {

        $path = empty($path) ? WWW_ROOT.IMAGES_URL.'products/' : $path;
        $no = 1;
        $newFileName = $fileName;

        while (file_exists("$path/".$newFileName)) {
            $no++;
            $newFileName = substr_replace($fileName, "_$no.", strrpos($fileName, "."), 1);
        }
        return $newFileName;
    }


    function handleFileUpload($fileData, $fileName) {

        $error = false;
        //Get file type
        $typeArr = explode('/', $fileData['type']);
        //If size is provided for validation check with that size. Else compare the size with INI file
        if (($this->validateFile['size'] && $fileData['size'] > $this->validateFile['size']) || $fileData['error'] == UPLOAD_ERR_INI_SIZE) {
            $error = 'The Image File "'.$fileName.'" is too large to upload';
        }
        elseif ($this->validateFile['type'] && (strpos($this->validateFile['type'], strtolower($typeArr[1])) === false)) {

            //File type is not the one we are going to accept. Error!!
            $error = 'Invalid file type';
        }
        else {
            //Data looks OK at this stage. Let's proceed.
            if ($fileData['error'] == UPLOAD_ERR_OK) {
                //Oops!! File size is zero. Error!
                if ($fileData['size'] == 0) {

                    $error = 'Zero size file found.';
                }
                else {
                    if (is_uploaded_file($fileData['tmp_name'])) {
                        //Finally we can upload file now. Let's do it and return without errors if success in moving.
                        if (!move_uploaded_file($fileData['tmp_name'], WWW_ROOT.IMAGES_URL.'products/'."$fileName")) {
                            $error = true;
                        }
                        $this->resizeImg(WWW_ROOT.IMAGES_URL.'products/'."$fileName", 125 ,125, false, 100, 0,"_thumb");
                        //$this->resizeImg(WWW_ROOT.IMAGES_URL.'products/'."$fileName", 245 ,175, false, 100, 0,"_thumb");
                        $this->resizeImg(WWW_ROOT.IMAGES_URL.'products/'."$fileName", 245 ,175, false, 100, 0,"_disp");
                        //echo WWW_ROOT.IMAGES_URL.'products/'."$fileName"; exit;
                    }
                    else {
                        $error = true;
                    }
                }
            }
        }
        return $error;
    }





   public function resizeCropIMage($fileName)
   {

     $this->resizeImg(WWW_ROOT.IMAGES_URL.'products/'."$fileName", 125 ,125, false, 100, 0,"_thumb");
                        //$this->resizeImg(WWW_ROOT.IMAGES_URL.'products/'."$fileName", 245 ,175, false, 100, 0,"_thumb");
                        $this->resizeImg(WWW_ROOT.IMAGES_URL.'products/'."$fileName", 245 ,175, false, 100, 0,"_disp");



                        return true;
   }




    function deleteMovedFile($fileName) {



        if (!$fileName || !is_file($fileName)) {



            return true;



        }



        if(unlink($fileName)) {



            return true;



        }



        return false;



    }







    function resizeImg($imgPath, $maxWidth, $maxHeight, $directOutput = true, $quality = 90, $verbose,$imageType) {



        $size = getimagesize($imgPath);



        //print_r($size);exit;



        // break and return false if failed to read image infos



        if(!$size) {



            if($verbose && !$directOutput)echo "<br />Not able to read image infos.<br />";







            return false;



        }



        // relation: width/height



        $relation = $size[0]/$size[1];



        // maximal size (if parameter == false, no resizing will be made)



        $maxSize = array($maxWidth?$maxWidth:$size[0],$maxHeight?$maxHeight:$size[1]);



        // declaring array for new size (initial value = original size)



        $newSize = $size;



        // width/height relation



        $relation = array($size[1]/$size[0], $size[0]/$size[1]);



        //print_r($size);



        //echo "<br>";



        //print_r($relation);exit;



        if(($newSize[0] > $maxWidth)) {



            $newSize[0]=$maxSize[0];



            $newSize[1]=$newSize[0]*$relation[0];



        }



        if(($newSize[1] > $maxHeight)) {



            $newSize[1]=$maxSize[1];



            $newSize[0]=$newSize[1]*$relation[1];



        }



        // create image



        $img_ext='';



        switch($size[2]) {



            case 1:



                if(function_exists("imagecreatefromgif")) {



                    $originalImage = imagecreatefromgif($imgPath);



                    $img_ext='.'.end(explode('.',$imgPath));



                }



                else {



                    if($verbose && !$directOutput)echo "<br />No GIF support in this php installation, sorry.<br />";



                    return false;



                }



                break;



            case 2:



                $originalImage = imagecreatefromjpeg($imgPath);



                $img_ext='.'.end(explode('.',$imgPath));



                break;



            case 3:



                $originalImage = imagecreatefrompng($imgPath);



                $img_ext='.'.end(explode('.',$imgPath));



                break;



            default:



                if($verbose && !$directOutput)echo "<br />No valid image type.<br />";



                return false;



        }







        // create new image



        $resizedImage = imagecreatetruecolor($newSize[0], $newSize[1]);



        imagecopyresampled($resizedImage, $originalImage,0, 0, 0, 0,$newSize[0], $newSize[1], $size[0], $size[1]);



        $rz=$imgPath;



        // output or save



        if($directOutput) {



            imagejpeg($resizedImage);



        }



        else {



            $rz=preg_replace("/\.([a-zA-Z]{3,4})$/","".$imageType.$img_ext,$imgPath);



            imagejpeg($resizedImage, $rz, $quality);



        }



        // return true if successfull



        return $rz;



    }







    #################  Function to Update Stock After Checkout Starts here(Added by Shyam) #################



    function updatecombnstock($pid,$optid,$qty) {



        $Db = ConnectionManager::getDataSource($this->useDbConfig);



        $pdetailstbl = $Db->fullTableName('productdetails');



        $this->query("UPDATE $pdetailstbl SET stock = stock - ".$qty." WHERE id = ".$optid);



        return true;



    }



    function updatestock($pid,$qty) {



        $Db = ConnectionManager::getDataSource($this->useDbConfig);



        $pdtbl = $Db->fullTableName('products');


        $this->query("UPDATE $pdtbl SET stock = stock - ".$qty." WHERE id = ".$pid);



        return true;



    }



    #################  Function to Update Stock After Checkout Ends here(Added by Shyam) #################







    function reorderalrt() {



        $Db = ConnectionManager::getDataSource($this->useDbConfig);



        $pdtbl = $Db->fullTableName('products');



        $cnt    =   $this->query("SELECT COUNT(*) AS cnt FROM $pdtbl WHERE stock <= reorderlevel AND status ='A'");



        return $cnt[0][0]["cnt"];



    }



    ########### Function to return maximum number of products present in the cart........................................



    function getCntPdct() {



        $Db = ConnectionManager::getDataSource($this->useDbConfig);



        $pdtbl = $Db->fullTableName('products');



        $cnt    =   $this->query("SELECT COUNT(*) AS cnt FROM $pdtbl WHERE status ='A'");



        return $cnt[0][0]["cnt"];



    }

    ########################  Function to change the status of brand as deleted D ########################
    function delete_brand($id) {
        $Db     = ConnectionManager::getDataSource($this->useDbConfig);
        $pdtbl  = $Db->fullTableName('brands');
        $this->query("UPDATE $pdtbl SET status ='D' WHERE `id` = ".$id);
        return true;
    }
    ########################  Function to change the status of brand as deleted D ########################

    ########################  Function to change the status of product as deleted D ########################

    function delpdct($id,$cmbn) {



        $Db = ConnectionManager::getDataSource($this->useDbConfig);



        $pdtbl = $Db->fullTableName('products');



        $pdetailstbl = $Db->fullTableName('productdetails');



        $pdtimgsbl = $Db->fullTableName('productimages');



        $this->query("UPDATE $pdtbl SET status ='D', featured = 0 WHERE id= ".$id);







        //Deleting Details and Images from Product Details Tables



        if($cmbn=='Y') {



            $img_res=$this->query("SELECT PDT.pdctfile from $pdetailstbl PDT WHERE product_id= ".$id);



            if(isset($img_res) && !empty($img_res)) {



                foreach($img_res as $img_val) {



                    $img_large='';
                    $img_thumb='';
                    $img_disp='';



                    $img_delpath=WWW_ROOT.IMAGES_URL.'products/';



                    $img_det=explode('.',$img_val['PDT']["pdctfile"]);



                    if(isset($img_det1) && !empty($img_det1)) {



                        $img_large=$img_delpath.$img_val['PDT']["pdctfile"];



                        $img_thumb=$img_delpath.$img_det[0].'_thumb.'.$img_det[1];



                        $img_disp=$img_delpath.$img_det[0].'_disp.'.$img_det[1];



                        if(file_exists($img_large)) unlink($img_large);



                        if(file_exists($img_thumb)) unlink($img_thumb);



                        if(file_exists($img_disp)) unlink($img_disp);



                    }



                }



            }



        }



        $this->query("DELETE from $pdetailstbl WHERE product_id= '".$id."'" );







        //Deleting Details and Images from Product Images Tables



        /*



            $img_res1=$this->query("SELECT imagename from $pdtimgsbl WHERE product_id= ".$id);



            if(isset($img_res1) && !empty($img_res1))



            {



               foreach($img_res1 as $img_val1)



               {



                 $img_large1='';$img_thumb1='';$img_disp1='';



                 $img_delpath1=WWW_ROOT.IMAGES_URL.'products/';



                 $img_det1=explode('.',$img_val1["Vista_productimages"]["imagename"]);



                 if(isset($img_det1) && !empty($img_det1))



                 {



                     $img_large1=$img_delpath1.$img_val1["Vista_productimages"]["imagename"];



                     $img_thumb1=$img_delpath1.$img_det1[0].'_thumb.'.$img_det1[1];



                     $img_disp1=$img_delpath1.$img_det1[0].'_disp.'.$img_det1[1];



                     if(file_exists($img_large1)) unlink($img_large1);



                     if(file_exists($img_thumb1)) unlink($img_thumb1);



                     if(file_exists($img_disp1)) unlink($img_disp1);



                 }



               }



            }



        */



        $this->query("DELETE from $pdtimgsbl WHERE product_id= '".$id."'" );



        return true;



    }

    function defaultimage($id,$pid) {
        $Db     =   ConnectionManager::getDataSource($this->useDbConfig);



        $pitbl  =   $Db->fullTableName('productimages');



        $this->query("UPDATE $pitbl SET `default` = 'N' WHERE `product_id` =".$pid);



        $this->query("UPDATE $pitbl SET `default` = 'Y' WHERE `id` =".$id);



        return true;



    }



    function csvUpload($fileData, $fileName,$path='') {



        $error = false;



        $path = empty($path) ? WWW_ROOT.IMAGES_URL.'products/' : $path;



        //Get file type



        $typeArr = explode('/', $fileData['type']);



        //If size is provided for validation check with that size. Else compare the size with INI file



        if (($this->validateFile['size'] && $fileData['size'] > $this->validateFile['size']) || $fileData['error'] == UPLOAD_ERR_INI_SIZE) {



            $error = 'File is too large to upload';



        }







        else {



            //Data looks OK at this stage. Let's proceed.



            if ($fileData['error'] == UPLOAD_ERR_OK) {



                //Oops!! File size is zero. Error!



                if ($fileData['size'] == 0) {



                    $error = 'Zero size file found.';



                }



                else {



                    if (is_uploaded_file($fileData['tmp_name'])) {



                        //Finally we can upload file now. Let's do it and return without errors if success in moving.



                        if (!move_uploaded_file($fileData['tmp_name'], $path."$fileName")) {



                            $error = true;



                        }











                    }



                    else {



                        $error = true;



                    }



                }



            }



        }



        return $error;



    }



    function delpdctbulk() {



        $Db = ConnectionManager::getDataSource($this->useDbConfig);



        $pdtbl = $Db->fullTableName('products');



        $this->query("UPDATE $pdtbl SET status ='D', featured = 0 ");



        return true;



    }















    ###############  Function to Upload Product Images starts here(Added by Shyam)  #################



    function addProductImages($productid,$pdctimage,$default) {



        $Db = ConnectionManager::getDataSource($this->useDbConfig);



        $prodimgstbl = $Db->fullTableName('productimages');



        $this->query("INSERT into $prodimgstbl(product_id,imagename,default_img) values('".$productid."','".$pdctimage."','".$default."')");



        return true;



    }



    #################  Function to  Upload Product Images  Ends here(Added by Shyam) #################







    function updateProductImages($productid,$pdctimage,$default,$updateid) {



        $Db = ConnectionManager::getDataSource($this->useDbConfig);



        $prodimgstbl = $Db->fullTableName('productimages');



        $check = $this->query("SELECT * FROM $prodimgstbl  where product_id='".$productid."'");



        if(isset($check) && empty($check)===false)



            $this->query("UPDATE $prodimgstbl SET product_id='".$productid."',imagename='".$pdctimage."',default_img='".$default."' WHERE id='".$updateid."'");



        else



        //write your insert query here



            $this->query("INSERT INTO $prodimgstbl(product_id,imagename,default_img) values('".$productid."','".$pdctimage."','".$default."')");



        if($default=='Y')



            $this->query("UPDATE $prodimgstbl set default_img='N' WHERE id<>'".$updateid."' AND product_id='".$productid."'");



        return true;



    }







    ###############  Function to Upload Product Images starts here(Added by Shyam)  #################



    function updateDefaultImage($productid,$default,$updateid) {



        $Db = ConnectionManager::getDataSource($this->useDbConfig);



        $prodimgstbl = $Db->fullTableName('productimages');



        $this->query("UPDATE $prodimgstbl SET default_img='".$default."' WHERE id='".$updateid."'");



        if($default=='Y')



            $this->query("UPDATE $prodimgstbl set default_img='N' WHERE id<>'".$updateid."' AND product_id='".$productid."'");



        return true;



    }



    #################  Function to  Upload Product Images  Ends here(Added by Shyam) #################







    ###############  Function to Update category starts here(Added by Shyam)    #################



    function updateCategory($productid,$categoryid) {



        $Db = ConnectionManager::getDataSource($this->useDbConfig);



        $prodtbl = $Db->fullTableName('products');



        $this->query("UPDATE $prodtbl SET category_id='".$categoryid."' WHERE id='".$productid."'");



        return true;



    }



    #################  Function to Update category  Ends here(Added by Shyam) #################











    #################  Function to Add Product Combination details starts here(Added by Shyam)  #################

    function addProductCombinations($categoryid,$productid,$attributes,$stock,$reorderlevel,$skuno,$extraprice,$pdctimage) {

        $Db = ConnectionManager::getDataSource($this->useDbConfig);
        $prodetailstbl = $Db->fullTableName('productdetails');
        $this->query("INSERT into $prodetailstbl(category_id,product_id,customvalue_id,stock,reorderlevel,skuno,extraprice,pdctfile) values('".$categoryid."','".$productid."','".$attributes."','".$stock."','".$reorderlevel."','".$skuno."','".$extraprice."','".$pdctimage."')");

        /* $this->useTable = 'productdetails';
        $this->create();
        $this->set(
                    array("category_id"=>$categoryid,
                        "product_id" => $productid,
                        "customvalue_id" =>$attributes,
                        "stock"=> $stock,
                        "reorderlevel" => $reorderlevel,
                        "skuno" => $skuno,
                         "extraprice" => $extraprice,
                         "pdctfile" => $pdctimage
                 )
            );
        $this->save($data_product); */
        $productDetailId = $this->getLastInsertID();

        $prodtbl = $Db->fullTableName('products');
        $this->query("UPDATE $prodtbl SET stock = (SELECT SUM(stock) FROM $prodetailstbl WHERE product_id = '".$productid."') WHERE id = ".$productid);
        return $productDetailId;
    }

    #################  Function to  Add Product Combination details Ends here(Added by Shyam) #################







    #################  Function to Update Product Combination details starts here(Added by Shyam)   #################



    function updateProductCombinations($categoryid,$productid,$attributes,$stock,$reorderlevel,$skuno,$extraprice,$pdctimage,$updateid) {

        $Db = ConnectionManager::getDataSource($this->useDbConfig);
        $prodetailstbl = $Db->fullTableName('productdetails');

        $this->query("UPDATE $prodetailstbl set category_id='".$categoryid."',product_id='".$productid."',customvalue_id='".$attributes."',

            stock='".$stock."',reorderlevel='".$reorderlevel."',skuno='".$skuno."',extraprice='".$extraprice."',pdctfile='".$pdctimage."',doublesided='X' WHERE id='".$updateid."'");


        //update parent products table
        $prodtbl = $Db->fullTableName('products');

        $this->query("UPDATE $prodtbl SET stock = (SELECT SUM(stock) FROM $prodetailstbl WHERE product_id = '".$productid."') WHERE id = ".$productid);


        return true;



    }



    #################  Function to  Add Product Combination details Ends here(Added by Shyam) #################











    #################  Function to Update Stock starts starts here(Added by Shyam)  #################



    function updateTotalStock($productid) {

        $Db = ConnectionManager::getDataSource($this->useDbConfig);
        $prodetailstbl = $Db->fullTableName('productdetails');
        $pdtbl = $Db->fullTableName('products');
        $stk    =   $this->query("SELECT SUM(stock) AS stk FROM $prodetailstbl WHERE `product_id` =".$productid);

        $total_stock=$stk[0][0]["stk"];
        $this->query("UPDATE $pdtbl SET stock ='".$total_stock."', combination = 'Y', status = 'A' WHERE `id` =".$productid);
        return true;
    }

    #################  Function to Update Stock  Ends here(Added by Shyam) #################




    #################  Function to Delete a Combination of a product details starts here(Added by Shyam) #################

    function delpdctcmbn($catid,$delid) {

        $Db = ConnectionManager::getDataSource($this->useDbConfig);
        $pdetailstbl = $Db->fullTableName('productdetails');
        $this->query("DELETE from $pdetailstbl  WHERE id= '".$delid."'  AND category_id='".$catid."'" );
        return true;
    }

    #################  Function to Delete a Combination of a product details starts here(Added by Shyam) #################


    #################  Function to get  product combination details on user side starts here(Added by Shyam) #################



    function getpdctcmbn($id) {



        $Db = ConnectionManager::getDataSource($this->useDbConfig);



        $cstmfld = $Db->fullTableName('customfields');



        $cstmfldval = $Db->fullTableName('customfieldvalues');



        $res=$this->query("select $cstmfldval.id,$cstmfld.custom_name,$cstmfldval.custom_value



           FROM $cstmfldval INNER JOIN $cstmfld  ON $cstmfldval.customfield_id=$cstmfld.id



           WHERE $cstmfldval.id='".$id."'");



        $cstmfld=trim(str_replace('`','',$cstmfld));
        $cstmfldval=trim(str_replace('`','',$cstmfldval));



        // $attribute=ucwords($res[0]["$cstmfld"]["custom_name"])." : ".ucwords($res[0]["$cstmfldval"]["custom_value"]);

//print_r($res[0]);

        $attribute=ucwords($res[0]["$cstmfldval"]["custom_value"]);



        return $attribute;



    }

 function getpdctcmbnfield($id) {



        $Db = ConnectionManager::getDataSource($this->useDbConfig);



        $cstmfld = $Db->fullTableName('customfields');



        $cstmfldval = $Db->fullTableName('customfieldvalues');



        $res=$this->query("select $cstmfldval.id,$cstmfld.custom_name,$cstmfldval.custom_value



           FROM $cstmfldval INNER JOIN $cstmfld  ON $cstmfldval.customfield_id=$cstmfld.id



           WHERE $cstmfldval.id='".$id."'");



        $cstmfld=trim(str_replace('`','',$cstmfld));
        $cstmfldval=trim(str_replace('`','',$cstmfldval));



        // $attribute=ucwords($res[0]["$cstmfld"]["custom_name"])." : ".ucwords($res[0]["$cstmfldval"]["custom_value"]);



        $attribute=ucwords($res[0]["$cstmfld"]["custom_name"]);



        return $attribute;



    }

    #################  Function to get  product combination details on user side ends here(Added by Shyam) #################







    #################  Function to Delete a All the Combination of a product starts here(Added by Shyam) #################



    /*



        function delpdctcombinations($prodid){



            $Db = ConnectionManager::getDataSource($this->useDbConfig);



            $pdetailstbl = $Db->fullTableName('productdetails');



            $this->query("DELETE from $pdetailstbl  WHERE product_id= '".$prodid."'" );



            return true;



        }



    */


    #################  Function to Delete a Combination of a product details starts here(Added by Shyam) #################

    #################  Function to get combination product images starts here(Added by Shyam) #################

    function getcombnimages($cmbnid) {
        $Db = ConnectionManager::getDataSource($this->useDbConfig);
        $pdetailstbl = $Db->fullTableName('productdetails');
        $res=$this->query("SELECT extraprice,skuno,pdctfile from $pdetailstbl  WHERE id= '".$cmbnid."'" );
        $tblname=trim(str_replace('`','',$pdetailstbl));
        return $res[0][$tblname];
    }

    #################  Function to get combination product images ends here(Added by Shyam) #################
    function threshold_breached($prd_id) {

        $Db = ConnectionManager::getDataSource($this->useDbConfig);

        //$pdtbl = $Db->fullTableName('products'); commmented to correct reorder check
         $pdtbl = $Db->fullTableName('productdetails');

        $cnt    =   $this->query("SELECT COUNT(*) AS cnt FROM $pdtbl WHERE stock <= reorderlevel AND id = ".$prd_id);
        //print_r($cnt[0][0]["cnt"]);
        return $cnt[0][0]["cnt"];

    }


    // Save phone order details
    function savePhoneOrderDetails($paramsArray) {


        $Db = ConnectionManager::getDataSource($this->useDbConfig);
        $savedtbl = $Db->fullTableName('savedimages');
        $date = date('Y-m-d');
        $ref_name = "PhoneOrder_".time();


     /*   $this->query("INSERT INTO $savedtbl(ref_name,productdetails_id,users_id,type,image,saved_date,foreground_image,note) VALUES('$ref_name',{$paramsArray['Product']['combinationId']},{$paramsArray['Product']['user']},'Front','{$paramsArray['Product']['uploadedImageName']}','$date','{$paramsArray['Product']['uploadedImageName']}','{$paramsArray['Product']['note']}')");*/
        $this->useTable = 'savedimages';
        $this->create();
        $this->set(
                    array("ref_name"=>$ref_name,
                        "productdetails_id" => $paramsArray['combinationId'],
                        "users_id" =>$paramsArray['Product']['user'],
                        "type"=> 'Front',
                        "image" => $paramsArray['uploadedImageName'],
                        "saved_date" => $date,
                         "foreground_image" => $paramsArray['uploadedImageName'],
                         "note" =>$paramsArray['Product']['note']
                         )
            );
        $this->save();
        $savedImageId = $this->getLastInsertID();
        $this->useTable = false;
        return $savedImageId;
    }

    function checkCustomSideExists($customSideValue,$productId){

        $Db = ConnectionManager::getDataSource($this->useDbConfig);

        $csidetbl = $Db->fullTableName('customimagetypes');

        $res=$this->query("SELECT count(*)  as dups from $csidetbl WHERE `type` ='".addslashes($customSideValue)."' and `productid`='".$productId."'");

        return $res[0][0]["dups"];

   }


   function deleteCustomSide($customSideId){

        $Db = ConnectionManager::getDataSource($this->useDbConfig);
        $csidetbl = $Db->fullTableName('customimagetypes');
        $this->query("DELETE from $csidetbl WHERE `id` =".$customSideId);
        return  true;

   }

   function deleteCustomSideImages($productDetailId,$customSideName){

        $Db = ConnectionManager::getDataSource($this->useDbConfig);
        $csideimagetbl = $Db->fullTableName('customimages');

        $this->query("DELETE from $csideimagetbl WHERE type ='".$customSideName."' AND productdetails_id=".$productDetailId);
        return  true;

   }

   function insertProductDetailData($productId) {

        $Db = ConnectionManager::getDataSource($this->useDbConfig);
        $productDetailTbl = $Db->fullTableName('productdetails');

       // $this->query("INSERT INTO $productDetailTbl(product_id) VALUES('$productId')");
        $this->useTable = 'productdetails';
        $this->create();
        $this->set(
            array("product_id"=>$productId)
            );
        $this->save();

        $productDetailId = $this->getLastInsertID();

        return $productDetailId;
    }

    function updateProductDetailData($productId, $data) {

        $Db = ConnectionManager::getDataSource($this->useDbConfig);
        $productDetailTbl = $Db->fullTableName('products');
        $val=""; $i=0;
        foreach ($data['Product'] as $key => $value) {
            $val .= $key."='".$value."'";
            if((count($data['Product'])-1) != $i)
                $val .= ", ";
            $i++;
        }
        $this->query("UPDATE $productDetailTbl SET ".$val." WHERE id='$productId'");

        return 1;
    }


    // Update Product Combinations
    function updateProductCombinationsBkp($categoryid,$productid,$attributes,$stock,$reorderlevel,$skuno,$extraprice,$pdctimage,$productdetailid) {

        $Db = ConnectionManager::getDataSource($this->useDbConfig);
        $prodetailstbl = $Db->fullTableName('productdetails');
        $this->query("UPDATE $prodetailstbl SET (category_id,product_id,customvalue_id,stock,reorderlevel,skuno,extraprice,pdctfile) values('".$categoryid."','".$productid."','".$attributes."','".$stock."','".$reorderlevel."','".$skuno."','".$extraprice."','".$pdctimage."') WHERE id=".$productdetailid);
        //$productDetailId = mysql_insert_id();

        //update parent products table
        $prodtbl = $Db->fullTableName('products');
        $this->query("UPDATE $prodtbl SET stock = (SELECT SUM(stock) FROM $prodetailstbl WHERE product_id = '".$productid."') WHERE id = ".$productid);

        return true;
    }

    function deleteProductCombination($productDetailId){

        $Db = ConnectionManager::getDataSource($this->useDbConfig);
        $pdtdetbl = $Db->fullTableName('productdetails');
        $this->query("DELETE from $pdtdetbl WHERE `id` =".$productDetailId);
        return  true;

   }

   function deleteProductMultiCategoryValues($productId){

        $Db = ConnectionManager::getDataSource($this->useDbConfig);
        $pdtcatbl = $Db->fullTableName('product_category_relations');
        $this->query("DELETE from $pdtcatbl WHERE product_id =".$productId);
        return  true;

   }

   function saveProductMultiCategoryValues($productId,$categories){

        $Db = ConnectionManager::getDataSource($this->useDbConfig);
        $pdtcatbl = $Db->fullTableName('product_category_relations');
        foreach($categories as $key=>$val){
            $this->query("INSERT INTO $pdtcatbl (product_id,category_id) VALUES('$productId','$val')");
        }
        return  true;
   }

   function getProductMultiCategoryValues($productId){

        $Db = ConnectionManager::getDataSource($this->useDbConfig);
        $pdtcatbl = $Db->fullTableName('product_category_relations');
        $pdtcatbl = str_replace('`', '', $pdtcatbl);
        $result = $this->query("SELECT * FROM $pdtcatbl WHERE product_id =".$productId);
        foreach($result as $res){
            $pMultiCat[] = $res[$pdtcatbl]['category_id'];
        }

        return $pMultiCat;
   }

   function getTableName($tablename) {

    $Db = ConnectionManager::getDataSource($this->useDbConfig);

    $tblnme = $Db->fullTableName($tablename);

    $tblnme=trim(str_replace('`','',$tblnme));

    return $tblnme;

}


    function deleteTempProductDetailEntry($productId){

        $Db = ConnectionManager::getDataSource($this->useDbConfig);
        $pdtdetbl = $Db->fullTableName('productdetails');
        $this->query("DELETE from $pdtdetbl WHERE `product_id` =".$productId." AND category_id='0'");
        return  true;

   }



function delNullrows(){

        $Db = ConnectionManager::getDataSource($this->useDbConfig);
        $pdtdetbl = $Db->fullTableName('products');
        $this->query("DELETE from $pdtdetbl WHERE `pname`= ''");
        return  true;

}




}



?>
