<?php
/**
 * Load Config File
 */
Configure::load('PaypalWPP.paypal');

App::uses('Component', 'Controller');

/**
 * Paypal WPP Component
 *
 * @author Chris Pierce <cpierce@csdurant.com>
 */
class PaypalWPPComponent extends Component
{

	/**
	 * WPP Hash Method
	 *
	 * @throws BadRequestException
	 *
	 * @param string $method
	 * @param string $nvp
	 *
	 * @return mixed[mixed]
	 */
	public function wpp_hash($method = null, $nvp = null)
    {
    	$cnfg 					= 	Configure::read('Neutrino'); 
    	Configure::write('Paypal', array(
		'username' => $cnfg['paypal_pro_username'],
		'password' => $cnfg['paypal_pro_password'],
		'signature' => $cnfg['paypal_pro_signature'],
		'endpoint_test' => 'https://api-3t.sandbox.paypal.com/nvp',
		'endpoint_live' => 'https://api-3t.paypal.com/nvp',
		'version' => '53.0'
		));
    	$curl_handler = curl_init();
		if($cnfg['paypal_testmode'] == 'Y'){
			curl_setopt($curl_handler, CURLOPT_URL, Configure::read('Paypal.endpoint_test'));
		}else{
			curl_setopt($curl_handler, CURLOPT_URL, Configure::read('Paypal.endpoint_live'));
		}
		curl_setopt($curl_handler, CURLOPT_VERBOSE, true);
		curl_setopt($curl_handler, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($curl_handler, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($curl_handler, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($curl_handler, CURLOPT_POST, true);

		$required_nvp  = 'METHOD=' . $method;
		$required_nvp .= '&VERSION=' . urlencode(Configure::read('Paypal.version'));
		$required_nvp .= '&USER=' . urlencode(Configure::read('Paypal.username'));
		$required_nvp .= '&PWD=' . urlencode(Configure::read('Paypal.password'));
		$required_nvp .= '&SIGNATURE=' . urlencode(Configure::read('Paypal.signature'));

		curl_setopt($curl_handler, CURLOPT_POSTFIELDS, $required_nvp.$nvp);
		$http_responder = curl_exec($curl_handler);

		if (!$http_responder) {
			throw new BadRequestException(
                $method . ' failed: ' .
                curl_error($curl_handler) . ' (' .
                curl_errno($curl_handler) . ')'
            );
		}

		$responder = explode('&', $http_responder);
		$parsed_response = [];

		foreach($responder as $response) {
			$response_array = explode('=', $response);
			if (count($response_array) >= 1)
				$parsed_response[$response_array[0]] = urldecode($response_array[1]);
		}

		if (count($parsed_response) < 1 || !array_key_exists('ACK', $parsed_response)) {
			throw new BadRequestException(
                'Invalid HTTP Response for POST request (' .
                $required_nvp . $nvp . ') to ' .
                Configure::read('Paypal.endpoint')
            );
        }

		return $parsed_response;
	}
}
