DROP TABLE IF EXISTS `PrintLogic_admins`;
CREATE TABLE `PrintLogic_admins` (
  `id` int(11) NOT NULL auto_increment,
  `admin_name` varchar(100) NOT NULL default '',
  `admin_pword` varchar(100) NOT NULL default '',
  `settings` char(1) default NULL,
  `custom` char(1) default NULL,
  `category` char(1) default NULL,
  `products` char(1) default NULL,
  `feedback` char(1) default NULL,
  `users` char(1) default NULL,
  `orders` char(1) default NULL,
  `refund` char(1) default NULL,
  `promocodes` char(1) default NULL,
  `websitecontent` char(1) default NULL,
  `reports` char(1) default NULL,
  `cliparts` char(1) default NULL,
  `help` char(1) default NULL,
  `adminusers` char(1) default NULL,
  `newsletter` char(1) default NULL,
  `newsletterusers` char(1) default NULL,
  `sentnewsletters` char(1) default NULL,
  `vendors` char(1) default NULL,
  `email` varchar(200) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;
DROP TABLE IF EXISTS `PrintLogic_carts`;
CREATE TABLE `PrintLogic_carts` (
  `id` int(11) NOT NULL auto_increment,
  `sess_id` varchar(100) NOT NULL default '',
  `product_id` int(11) NOT NULL default '0',
  `product_price` decimal(10,2) NOT NULL default '0.00',
  `prodtype` varchar(20) NOT NULL default '',
  `extra_price` decimal(10,2) default '0.00',
  `discount_type` varchar(5) default NULL,
  `discount` decimal(10,2) default '0.00',
  `quantity` int(11) NOT NULL default '0',
  `user_id` int(11) NOT NULL default '0',
  `shipping_charge` decimal(10,2) NOT NULL default '0.00',
  `customvalue` text,
  `customfields_id` int(11) default NULL,
  `option_id` bigint(20) NOT NULL default '0',
  `type` varchar(150) NOT NULL default '',
  `price_type` char(1) default NULL,
  `savedimages_id` bigint(20) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;
DROP TABLE IF EXISTS `PrintLogic_categories`;
CREATE TABLE `PrintLogic_categories` (
  `id` int(11) NOT NULL auto_increment,
  `cname` varchar(100) NOT NULL default '',
  `parent_id` int(11) NOT NULL default '0',
  `custom_combination` varchar(255) NOT NULL default '',
  `cimage` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `parent_id` (`parent_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;
DROP TABLE IF EXISTS `PrintLogic_cmspages`;
CREATE TABLE `PrintLogic_cmspages` (
  `id` int(11) NOT NULL auto_increment,
  `title` varchar(100) NOT NULL default '',
  `content` text,
  `type` varchar(100) NOT NULL default 'email',
  `status` enum('Y','N') NOT NULL default 'N',
  PRIMARY KEY  (`id`),
  KEY `type` (`type`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;
DROP TABLE IF EXISTS `PrintLogic_contacts`;
CREATE TABLE `PrintLogic_contacts` (
  `id` bigint(20) NOT NULL auto_increment,
  `cname` varchar(50) NOT NULL default '',
  `cemail` varchar(200) NOT NULL default '',
  `cdate` varchar(25) NOT NULL default '',
  `cdescr` text NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;
DROP TABLE IF EXISTS `PrintLogic_coordinates`;
CREATE TABLE `PrintLogic_coordinates` (
  `id` bigint(20) NOT NULL auto_increment,
  `x1_axis` smallint(5) NOT NULL default '0',
  `y1_axis` smallint(5) NOT NULL default '0',
  `x2_axis` smallint(5) NOT NULL default '0',
  `y2_axis` smallint(5) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;
DROP TABLE IF EXISTS `PrintLogic_countries`;
CREATE TABLE `PrintLogic_countries` (
  `country_id` int(11) NOT NULL auto_increment,
  `country_name` varchar(64) NOT NULL default '',
  `country_iso_code_2` char(2) NOT NULL default '',
  PRIMARY KEY  (`country_id`),
  KEY `IDX_COUNTRY_NAME` (`country_name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;
DROP TABLE IF EXISTS `PrintLogic_coupons`;
CREATE TABLE `PrintLogic_coupons` (
  `id` bigint(20) NOT NULL auto_increment,
  `code` varchar(100) NOT NULL default '',
  `type` enum('Perc','Amt') NOT NULL default 'Perc',
  `giftvalue` decimal(10,2) NOT NULL default '0.00',
  `from_date` date NOT NULL default '0000-00-00',
  `to_date` date NOT NULL default '0000-00-00',
  `status` char(1) NOT NULL default 'A',
  `descr` text,
  `minamt` decimal(10,2) NOT NULL default '0.00',
  PRIMARY KEY  (`id`),
  KEY `code` (`code`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;
DROP TABLE IF EXISTS `PrintLogic_currencies`;
CREATE TABLE `PrintLogic_currencies` (
  `id` int(11) NOT NULL auto_increment,
  `code` varchar(10) NOT NULL default '',
  `name` varchar(100) default NULL,
  `logo` varchar(100) character set utf8 collate utf8_unicode_ci default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;
DROP TABLE IF EXISTS `PrintLogic_customcombinations`;
CREATE TABLE `PrintLogic_customcombinations` (
  `id` bigint(20) NOT NULL auto_increment,
  `category_id` bigint(20) NOT NULL default '0',
  `customfield_id` bigint(20) NOT NULL default '0',
  `customvalue_id` bigint(20) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;
DROP TABLE IF EXISTS `PrintLogic_customfields`;
CREATE TABLE `PrintLogic_customfields` (
  `id` bigint(20) NOT NULL auto_increment,
  `custom_name` varchar(200) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `custom_id` (`custom_name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;
DROP TABLE IF EXISTS `PrintLogic_customfieldvalues`;
CREATE TABLE `PrintLogic_customfieldvalues` (
  `id` bigint(20) NOT NULL auto_increment,
  `customfield_id` bigint(20) NOT NULL default '0',
  `custom_value` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;
DROP TABLE IF EXISTS `PrintLogic_customimages`;
CREATE TABLE `PrintLogic_customimages` (
  `id` bigint(20) NOT NULL auto_increment,
  `productdetails_id` bigint(20) NOT NULL default '0',
  `type` varchar(10) NOT NULL default '',
  `image` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;
DROP TABLE IF EXISTS `PrintLogic_feedbacks`;
CREATE TABLE `PrintLogic_feedbacks` (
  `id` int(11) NOT NULL auto_increment,
  `user_id` int(11) NOT NULL default '0',
  `product_id` int(11) NOT NULL default '0',
  `date` varchar(25) NOT NULL default '',
  `type` varchar(100) NOT NULL default '',
  `comment` text NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;
DROP TABLE IF EXISTS `PrintLogic_giftcard_details`;
CREATE TABLE `PrintLogic_giftcard_details` (
  `id` bigint(20) NOT NULL auto_increment,
  `user_id` bigint(20) NOT NULL default '0',
  `order_id` bigint(20) NOT NULL default '0',
  `card_id` bigint(20) NOT NULL default '0',
  `card_code` text NOT NULL,
  `amount` decimal(10,2) NOT NULL default '0.00',
  `balance` decimal(10,2) NOT NULL default '0.00',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;
DROP TABLE IF EXISTS `PrintLogic_giftcards`;
CREATE TABLE `PrintLogic_giftcards` (
  `id` bigint(20) NOT NULL auto_increment,
  `gift_code` varchar(255) NOT NULL default '',
  `gift_amnt` decimal(10,2) NOT NULL default '0.00',
  `from` date default '0000-00-00',
  `to` date default '0000-00-00',
  `stock` bigint(20) NOT NULL default '0',
  `status` char(1) NOT NULL default 'A',
  `descr` text,
  `gift_img` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `code` (`gift_code`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;
DROP TABLE IF EXISTS `PrintLogic_giftcardusers`;
CREATE TABLE `PrintLogic_giftcardusers` (
  `id` bigint(20) NOT NULL auto_increment,
  `user_id` bigint(20) NOT NULL default '0',
  `order_id` bigint(20) NOT NULL default '0',
  `card_id` bigint(20) NOT NULL default '0',
  `usercard_id` bigint(20) NOT NULL default '0',
  `date` varchar(20) NOT NULL default '',
  `amnt_used` decimal(10,2) NOT NULL default '0.00',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;
DROP TABLE IF EXISTS `PrintLogic_helps`;
CREATE TABLE `PrintLogic_helps` (
  `id` bigint(20) NOT NULL auto_increment,
  `title` varchar(255) NOT NULL default '',
  `content` longtext NOT NULL,
  `type` enum('A','U') NOT NULL default 'A',
  `order` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;
DROP TABLE IF EXISTS `PrintLogic_homelayouts`;
CREATE TABLE `PrintLogic_homelayouts` (
  `id` int(11) NOT NULL auto_increment,
  `prod_type` char(50) default NULL,
  `section` char(15) default NULL,
  `status` enum('Y','N') NOT NULL default 'Y',
  `ordering` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;
DROP TABLE IF EXISTS `PrintLogic_imageregions`;
CREATE TABLE `PrintLogic_imageregions` (
  `id` bigint(20) NOT NULL auto_increment,
  `customimages_id` bigint(20) NOT NULL default '0',
  `coordinates_id` bigint(20) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;
DROP TABLE IF EXISTS `PrintLogic_itemcoordinates`;
CREATE TABLE `PrintLogic_itemcoordinates` (
  `id` bigint(20) NOT NULL auto_increment,
  `savedimages_id` bigint(20) NOT NULL default '0',
  `productdetails_id` bigint(20) NOT NULL default '0',
  `x_axis` smallint(5) NOT NULL default '0',
  `y_axis` smallint(5) NOT NULL default '0',
  `content_type` varchar(10) NOT NULL default '',
  `content` varchar(255) NOT NULL default '',
  `font_color` varchar(20) NOT NULL default '',
  `font_size` tinyint(2) NOT NULL default '0',
  `font_type` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;
DROP TABLE IF EXISTS `PrintLogic_messages`;
CREATE TABLE `PrintLogic_messages` (
  `id` bigint(20) NOT NULL auto_increment,
  `parent_id` bigint(20) NOT NULL default '0',
  `user_id` bigint(20) NOT NULL default '0',
  `admin_id` bigint(20) NOT NULL default '0',
  `by_admin` tinyint(1) NOT NULL default '1',
  `content` text NOT NULL,
  `posted_date` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;
DROP TABLE IF EXISTS `PrintLogic_newsletters`;
CREATE TABLE `PrintLogic_newsletters` (
  `id` int(11) NOT NULL auto_increment,
  `title` varchar(255) NOT NULL default '',
  `content` longtext NOT NULL,
  `news_date` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;
DROP TABLE IF EXISTS `PrintLogic_newsletterusers`;
CREATE TABLE `PrintLogic_newsletterusers` (
  `id` int(11) NOT NULL auto_increment,
  `uname` varchar(255) NOT NULL default '',
  `email` varchar(255) NOT NULL default '',
  `sub_date` datetime NOT NULL default '0000-00-00 00:00:00',
  `status` enum('N','Y') NOT NULL default 'Y',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 PACK_KEYS=0 AUTO_INCREMENT=1 ;
DROP TABLE IF EXISTS `PrintLogic_order_details`;
CREATE TABLE `PrintLogic_order_details` (
  `id` int(11) NOT NULL auto_increment,
  `order_id` int(11) NOT NULL default '0',
  `product_id` int(11) NOT NULL default '0',
  `product_price` decimal(10,2) NOT NULL default '0.00',
  `prodtype` varchar(20) default NULL,
  `discount_type` varchar(5) default 'amnt',
  `discount` decimal(10,2) default '0.00',
  `quantity` int(11) NOT NULL default '0',
  `extra_price` decimal(10,2) NOT NULL default '0.00',
  `customfields_id` int(11) default NULL,
  `combination_id` bigint(20) NOT NULL default '0',
  `type` char(1) NOT NULL default '',
  `price_type` char(1) default NULL,
  `savedimages_id` bigint(20) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `orders_id` (`order_id`,`product_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 PACK_KEYS=0 AUTO_INCREMENT=1 ;
DROP TABLE IF EXISTS `PrintLogic_order_statuses`;
CREATE TABLE `PrintLogic_order_statuses` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;
DROP TABLE IF EXISTS `PrintLogic_orders`;
CREATE TABLE `PrintLogic_orders` (
  `id` int(11) NOT NULL auto_increment,
  `date` datetime NOT NULL default '0000-00-00 00:00:00',
  `exp_time` datetime NOT NULL default '0000-00-00 00:00:00',
  `user_id` int(11) NOT NULL default '0',
  `shipping_method` varchar(100) NOT NULL default '',
  `shipping_service` varchar(100) NOT NULL default '',
  `shipping_price` decimal(10,2) NOT NULL default '0.00',
  `tax_price` decimal(10,2) NOT NULL default '0.00',
  `total_price` decimal(10,2) NOT NULL default '0.00',
  `order_status_id` int(10) NOT NULL default '1',
  `ship_fname` varchar(50) NOT NULL default '',
  `ship_lname` varchar(50) NOT NULL default '',
  `ship_address` varchar(50) NOT NULL default '',
  `ship_city` varchar(50) NOT NULL default '',
  `ship_state` varchar(50) NOT NULL default '',
  `ship_country` varchar(50) NOT NULL default '',
  `ship_zip` varchar(50) NOT NULL default '',
  `ship_phone` varchar(50) NOT NULL default '',
  `ship_mobile` varchar(50) NOT NULL default '',
  `ship_fax` varchar(50) NOT NULL default '',
  `transaction_id` varchar(50) default NULL,
  `bill_fname` varchar(50) NOT NULL default '',
  `bill_lname` varchar(50) NOT NULL default '',
  `bill_address` varchar(50) NOT NULL default '',
  `bill_city` varchar(50) NOT NULL default '',
  `bill_state` varchar(50) NOT NULL default '',
  `bill_country` varchar(50) NOT NULL default '',
  `bill_zip` varchar(50) NOT NULL default '',
  `bill_phone` varchar(50) NOT NULL default '',
  `bill_mobile` varchar(50) NOT NULL default '',
  `bill_fax` varchar(50) NOT NULL default '',
  `payment_method` varchar(100) NOT NULL default '',
  `currency_type` varchar(10) NOT NULL default 'USD',
  `note` text,
  `comments` longtext NOT NULL,
  `tax_name` varchar(100) default NULL,
  `coupon_id` int(11) NOT NULL default '0',
  `discount` decimal(10,2) NOT NULL default '0.00',
  `tracking_no` text,
  `label_pdf` text,
  `pay_date` date NOT NULL default '0000-00-00',
  PRIMARY KEY  (`id`),
  KEY `users_id` (`user_id`,`order_status_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 PACK_KEYS=0 AUTO_INCREMENT=1 ;
DROP TABLE IF EXISTS `PrintLogic_productcustomfields`;
CREATE TABLE `PrintLogic_productcustomfields` (
  `id` bigint(20) NOT NULL auto_increment,
  `product_id` bigint(20) NOT NULL default '0',
  `customfield_id` bigint(20) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `product_id` (`product_id`,`customfield_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;
DROP TABLE IF EXISTS `PrintLogic_productdetails`;
CREATE TABLE `PrintLogic_productdetails` (
  `id` bigint(20) NOT NULL auto_increment,
  `category_id` bigint(20) NOT NULL default '0',
  `product_id` bigint(20) NOT NULL default '0',
  `customvalue_id` varchar(255) NOT NULL default '',
  `stock` bigint(20) NOT NULL default '0',
  `reorderlevel` bigint(20) NOT NULL default '0',
  `skuno` varchar(100) NOT NULL default '',
  `extraprice` bigint(20) NOT NULL default '0',
  `pdctfile` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;
DROP TABLE IF EXISTS `PrintLogic_productimages`;
CREATE TABLE `PrintLogic_productimages` (
  `id` bigint(20) NOT NULL auto_increment,
  `product_id` bigint(20) NOT NULL default '0',
  `imagename` varchar(200) NOT NULL default '',
  `default_img` enum('Y','N') NOT NULL default 'N',
  PRIMARY KEY  (`id`),
  KEY `product_id` (`product_id`,`imagename`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;
DROP TABLE IF EXISTS `PrintLogic_products`;
CREATE TABLE `PrintLogic_products` (
  `id` int(11) NOT NULL auto_increment,
  `pname` varchar(100) NOT NULL default '',
  `category_id` int(11) NOT NULL default '0',
  `descr` text NOT NULL,
  `price` decimal(10,2) NOT NULL default '0.00',
  `wholesale_price` decimal(10,2) NOT NULL default '0.00',
  `discount_type` varchar(5) NOT NULL default '',
  `discount` decimal(10,2) default '0.00',
  `image1` varchar(100) default NULL,
  `image2` varchar(100) default NULL,
  `featured` enum('0','1') NOT NULL default '1',
  `stock` int(11) default '0',
  `skuno` varchar(100) default NULL,
  `reorderlevel` int(11) default '0',
  `weight` decimal(10,2) NOT NULL default '0.00',
  `shipping_price` decimal(10,2) NOT NULL default '0.00',
  `status` varchar(10) NOT NULL default 'A',
  `pdctfile` varchar(250) NOT NULL default '',
  `prodtype` varchar(100) NOT NULL default 'Non-Digital',
  `combination` char(1) NOT NULL default '',
  `defaultattribute` bigint(20) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;
DROP TABLE IF EXISTS `PrintLogic_randoms`;
CREATE TABLE `PrintLogic_randoms` (
  `id` bigint(20) NOT NULL auto_increment,
  `rand_id` bigint(20) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;
DROP TABLE IF EXISTS `PrintLogic_ratings`;
CREATE TABLE `PrintLogic_ratings` (
  `id` int(11) NOT NULL auto_increment,
  `product_id` int(11) NOT NULL default '0',
  `user_id` int(11) NOT NULL default '0',
  `rate` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;
DROP TABLE IF EXISTS `PrintLogic_refundoptions`;
CREATE TABLE `PrintLogic_refundoptions` (
  `id` bigint(20) NOT NULL auto_increment,
  `title` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;
DROP TABLE IF EXISTS `PrintLogic_refundproducts`;
CREATE TABLE `PrintLogic_refundproducts` (
  `id` bigint(20) NOT NULL auto_increment,
  `refund_id` bigint(20) NOT NULL default '0',
  `product_id` bigint(20) NOT NULL default '0',
  `combination_id` bigint(20) NOT NULL default '0',
  `quantity` bigint(20) default NULL,
  `return_reason` text NOT NULL,
  `extra_price` decimal(10,2) NOT NULL default '0.00',
  `product_price` decimal(10,2) NOT NULL default '0.00',
  `discount` int(11) default '0',
  `discount_type` varchar(5) default NULL,
  `type` char(1) default NULL,
  `price_type` char(1) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;
DROP TABLE IF EXISTS `PrintLogic_refundreasons`;
CREATE TABLE `PrintLogic_refundreasons` (
  `id` bigint(20) NOT NULL auto_increment,
  `title` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;
DROP TABLE IF EXISTS `PrintLogic_refunds`;
CREATE TABLE `PrintLogic_refunds` (
  `id` bigint(20) NOT NULL auto_increment,
  `user_id` bigint(20) NOT NULL default '0',
  `order_id` bigint(20) NOT NULL default '0',
  `customer_feedback` text,
  `status` varchar(255) default NULL,
  `additional_info` text,
  `date` date NOT NULL default '0000-00-00',
  `refund_mode` varchar(255) default NULL,
  `reference_number` varchar(255) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;
DROP TABLE IF EXISTS `PrintLogic_refundstatuses`;
CREATE TABLE `PrintLogic_refundstatuses` (
  `id` int(11) NOT NULL auto_increment,
  `title` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;
DROP TABLE IF EXISTS `PrintLogic_reports`;
CREATE TABLE `PrintLogic_reports` (
  `id` int(11) NOT NULL default '0',
  `reports` varchar(255) NOT NULL default ''
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
DROP TABLE IF EXISTS `PrintLogic_savedimages`;
CREATE TABLE `PrintLogic_savedimages` (
  `id` bigint(20) NOT NULL auto_increment,
  `ref_name` varchar(100) NOT NULL default '',
  `productdetails_id` bigint(20) NOT NULL default '0',
  `users_id` bigint(20) NOT NULL default '0',
  `type` varchar(10) NOT NULL default '',
  `image` varchar(255) NOT NULL default '',
  `saved_date` date NOT NULL default '0000-00-00',
  `foreground_image` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;
DROP TABLE IF EXISTS `PrintLogic_sent_newsletters`;
CREATE TABLE `PrintLogic_sent_newsletters` (
  `id` bigint(20) NOT NULL auto_increment,
  `newsletter_id` bigint(20) NOT NULL default '0',
  `user_id` bigint(20) NOT NULL default '0',
  `send_date` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;
DROP TABLE IF EXISTS `PrintLogic_settings`;
CREATE TABLE `PrintLogic_settings` (
  `fieldname` varchar(100) NOT NULL default '',
  `value` varchar(100) NOT NULL default ''
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
DROP TABLE IF EXISTS `PrintLogic_statecodes`;
CREATE TABLE `PrintLogic_statecodes` (
  `id` int(11) NOT NULL auto_increment,
  `code` varchar(10) NOT NULL default '',
  `name` varchar(100) NOT NULL default '',
  `country_id` varchar(10) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `country_id` (`country_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;
DROP TABLE IF EXISTS `PrintLogic_states`;
CREATE TABLE `PrintLogic_states` (
  `id` int(11) NOT NULL auto_increment,
  `code` varchar(10) NOT NULL default '',
  `name` varchar(100) NOT NULL default '',
  `country_id` varchar(10) NOT NULL default '',
  `tax_rate` decimal(10,2) NOT NULL default '0.00',
  `tax_name` varchar(100) default NULL,
  PRIMARY KEY  (`id`),
  KEY `country_id` (`country_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;
DROP TABLE IF EXISTS `PrintLogic_user_addresses`;
CREATE TABLE `PrintLogic_user_addresses` (
  `id` int(11) NOT NULL auto_increment,
  `user_id` int(11) NOT NULL default '0',
  `addr_type` enum('Billing','Shipping') NOT NULL default 'Billing',
  `fname` varchar(50) NOT NULL default '',
  `lname` varchar(50) NOT NULL default '',
  `address` text NOT NULL,
  `city` varchar(100) NOT NULL default '',
  `state` varchar(100) NOT NULL default '',
  `country` varchar(100) NOT NULL default '',
  `zip` varchar(20) NOT NULL default '',
  `phone` varchar(25) NOT NULL default '',
  `fax` varchar(25) NOT NULL default '',
  `mobile` varchar(25) NOT NULL default '',
  `email` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `users_id` (`user_id`,`addr_type`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;
DROP TABLE IF EXISTS `PrintLogic_users`;
CREATE TABLE `PrintLogic_users` (
  `id` int(11) NOT NULL auto_increment,
  `uname` varchar(50) NOT NULL default '',
  `password` varchar(50) NOT NULL default '',
  `email` varchar(100) NOT NULL default '',
  `reg_date` datetime NOT NULL default '0000-00-00 00:00:00',
  `usertype` varchar(20) NOT NULL default 'R',
  `reg_status` varchar(50) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 PACK_KEYS=0 AUTO_INCREMENT=1 ;
DROP TABLE IF EXISTS `PrintLogic_vendororders`;
CREATE TABLE `PrintLogic_vendororders` (
  `id` int(11) NOT NULL auto_increment,
  `vendor_id` int(11) NOT NULL default '0',
  `order_detail_id` int(11) NOT NULL default '0',
  `quantity` mediumint(5) NOT NULL default '0',
  `email` enum('SENT','NOT SENT') NOT NULL default 'NOT SENT',
  `ordered_date` date NOT NULL default '0000-00-00',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;
DROP TABLE IF EXISTS `PrintLogic_vendors`;
CREATE TABLE `PrintLogic_vendors` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(100) NOT NULL default '',
  `address` text NOT NULL,
  `country` varchar(100) NOT NULL default '',
  `state` varchar(100) NOT NULL default '',
  `city` varchar(100) NOT NULL default '',
  `zip` varchar(20) NOT NULL default '',
  `phone1` varchar(25) NOT NULL default '',
  `phone2` varchar(25) NOT NULL default '',
  `fax` varchar(25) NOT NULL default '',
  `email` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;
DROP TABLE IF EXISTS `PrintLogic_itemcoordinate_sessions`;
CREATE TABLE IF NOT EXISTS `PrintLogic_itemcoordinate_sessions` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `session_id` varchar(250) NOT NULL DEFAULT '',
  `x_axis` smallint(5) NOT NULL DEFAULT '0',
  `y_axis` smallint(5) NOT NULL DEFAULT '0',
  `content_type` varchar(10) NOT NULL DEFAULT '',
  `content` varchar(255) NOT NULL DEFAULT '',
  `font_color` varchar(20) NOT NULL DEFAULT '',
  `font_size` tinyint(2) NOT NULL DEFAULT '0',
  `font_type` varchar(100) NOT NULL DEFAULT '',
  `created_time` varchar(50) NOT NULL,
  `frontrear` varchar(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `PrintLogic_palettes`;
CREATE TABLE IF NOT EXISTS `PrintLogic_palettes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `color` varchar(50) NOT NULL,
  `status` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;
DROP TABLE IF EXISTS `PrintLogic_fonts`;
CREATE TABLE IF NOT EXISTS `PrintLogic_fonts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `file_name` varchar(100) NOT NULL,
  `status` enum('0','1') NOT NULL DEFAULT '0',
  `image_path` varchar(250) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;
ALTER TABLE `PrintLogic_savedimages` CHANGE `users_id` `users_id` VARCHAR( 250 ) NOT NULL DEFAULT '0';
ALTER TABLE `PrintLogic_itemcoordinate_sessions` ADD `curve` SMALLINT( 5 ) NOT NULL;
ALTER TABLE `PrintLogic_itemcoordinates` ADD `curve` SMALLINT( 5 ) NOT NULL;
ALTER TABLE `PrintLogic_productdetails` ADD `doublesided` ENUM( 'Y', 'N' ) NOT NULL DEFAULT 'Y';
ALTER TABLE `PrintLogic_users` ADD `social_user_id` BIGINT NULL AFTER `reg_status`;
ALTER TABLE `PrintLogic_users` CHANGE `password` `password` VARCHAR( 50 ) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL , CHANGE `email` `email` VARCHAR( 100 ) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL;
ALTER TABLE `PrintLogic_categories` ADD `position` INT NULL;
ALTER TABLE `PrintLogic_admins` ADD `homepage` CHAR( 1 ) NULL DEFAULT '1';
ALTER TABLE `PrintLogic_itemcoordinates` ADD `shape` VARCHAR( 50 ) NOT NULL; 
ALTER TABLE `PrintLogic_itemcoordinates` ADD `align` ENUM( 'left', 'center', 'right' ) NOT NULL DEFAULT 'left';
ALTER TABLE `PrintLogic_itemcoordinate_sessions` ADD `shape` VARCHAR( 50 ) NOT NULL;
ALTER TABLE `PrintLogic_itemcoordinate_sessions` ADD `align` ENUM( 'left', 'center', 'right' ) NOT NULL DEFAULT 'left';
ALTER TABLE `PrintLogic_itemcoordinates` ADD `shape_settings` SMALLINT(5) NULL DEFAULT '0';
ALTER TABLE `PrintLogic_itemcoordinate_sessions` ADD `shape_settings` SMALLINT( 5 ) NOT NULL;
ALTER TABLE `PrintLogic_itemcoordinates` ADD `zindex` INT NOT NULL;
ALTER TABLE `PrintLogic_itemcoordinate_sessions` ADD `zindex` INT NOT NULL;
ALTER TABLE `PrintLogic_itemcoordinate_sessions` ADD `flip_count` TINYINT( 2 ) NOT NULL;
ALTER TABLE `PrintLogic_itemcoordinate_sessions` ADD `flop_count` TINYINT( 2 ) NOT NULL;
ALTER TABLE `PrintLogic_itemcoordinates` ADD `flip_count` TINYINT( 2 ) NOT NULL;
ALTER TABLE `PrintLogic_itemcoordinates` ADD `flop_count` TINYINT( 2 ) NOT NULL;
ALTER TABLE `PrintLogic_users` ADD `uphone` VARCHAR( 25 ) NULL AFTER `social_user_id`;
ALTER TABLE `PrintLogic_itemcoordinates` CHANGE  `font_size`  `font_size` FLOAT NOT NULL DEFAULT  '0';
ALTER TABLE `PrintLogic_itemcoordinate_sessions` CHANGE  `font_size`  `font_size` FLOAT NOT NULL DEFAULT  '0';
ALTER TABLE `PrintLogic_orders` ADD `customer_note` TEXT NOT NULL;
ALTER TABLE `PrintLogic_savedimages` ADD  `note` TEXT NULL AFTER `foreground_image`;
ALTER TABLE `PrintLogic_order_details` ADD COLUMN `custom_information` TEXT NULL AFTER `savedimages_id`;
ALTER TABLE `PrintLogic_carts` ADD COLUMN `custom_information` TEXT NULL AFTER `savedimages_id`;
ALTER TABLE `PrintLogic_savedimages` ADD COLUMN `template_name` VARCHAR(250) NULL AFTER `note`;
ALTER TABLE `PrintLogic_productdetails` CHANGE `doublesided` `doublesided` ENUM( 'Y', 'N', 'X' ) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT 'X';
CREATE TABLE IF NOT EXISTS `PrintLogic_customimagetypes` (
  `id` int(11) NOT NULL auto_increment,
  `productid` int(11) NOT NULL,
  `type` varchar(25) NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=latin1;
UPDATE `PrintLogic_categories` SET `cname`='---Select---' WHERE  `id`=1 LIMIT 1;
CREATE TABLE IF NOT EXISTS `PrintLogic_templates` (
  `template_id` int(10) NOT NULL auto_increment,
  `template_name` varchar(250) default NULL,
  `productdetail_id` int(11) default NULL,
  `product_id` int(11) default NULL,
  `saveimage_id` int(11) default NULL,
  `side` varchar(250) default NULL,
  `user_id` int(11) default NULL,
  PRIMARY KEY  (`template_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=latin1;
ALTER TABLE  `PrintLogic_productdetails` CHANGE  `extraprice`  `extraprice` FLOAT( 20 ) NOT NULL DEFAULT  '0';
ALTER TABLE `PrintLogic_templates` ADD COLUMN `published` INT(11) NULL DEFAULT '1' AFTER `user_id`;
CREATE TABLE `PrintLogic_product_category_relations` (
`id` INT(10) NOT NULL AUTO_INCREMENT,
`product_id` INT(10) NOT NULL DEFAULT '0',
`category_id` INT(10) NOT NULL DEFAULT '0',
PRIMARY KEY (`id`)
)
COLLATE='latin1_swedish_ci'
ENGINE=MyISAM;
ALTER TABLE  `PrintLogic_savedimages` CHANGE  `saved_date`  `saved_date` DATETIME NOT NULL DEFAULT  '0000-00-00 00:00:00';
ALTER TABLE  `PrintLogic_users` AUTO_INCREMENT = 2;
ALTER TABLE  `PrintLogic_cmspages` ADD COLUMN `label` VARCHAR(100) NULL DEFAULT '' AFTER `title`;

ALTER TABLE `PrintLogic_products` ADD COLUMN `prod_dimensions` VARCHAR(250) NULL AFTER `defaultattribute`;
ALTER TABLE `PrintLogic_products` CHANGE COLUMN `prod_dimensions` `prod_dimensions` VARCHAR(250) NULL COMMENT 'length,width,heigth,grith' AFTER `defaultattribute`;
ALTER TABLE `PrintLogic_admins` ADD COLUMN `templates` CHAR(1) NULL DEFAULT NULL AFTER `homepage`;
ALTER TABLE `PrintLogic_admins` CHANGE COLUMN `templates` `templates` CHAR(1) NULL DEFAULT '1' AFTER `homepage`;
ALTER TABLE `PrintLogic_products` ADD COLUMN `disable_design` INT(10) NULL DEFAULT '0' AFTER `prod_dimensions`;
CREATE TABLE IF NOT EXISTS `PrintLogic_productpricetiers` (
  `id` bigint(20) NOT NULL auto_increment,
  `product_id` bigint(20) default NULL,
  `quantity` varchar(50) default NULL,
  `type` varchar(50) default NULL,
  `rate` float default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
ALTER TABLE `PrintLogic_products` ADD COLUMN `vertical_ruler` INT(10) NULL DEFAULT '0' AFTER `disable_design`;
CREATE TABLE IF NOT EXISTS `PrintLogic_rulers` (
  `id` int(10) NOT NULL auto_increment,
  `ruler_name` varchar(50) NOT NULL,
  `ruler_status` enum('Y','N') NOT NULL default 'Y',
  `ruler_setting` int(8) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=20 DEFAULT CHARSET=latin1;
CREATE TABLE IF NOT EXISTS `PrintLogic_dynamicpages` (
  `id` int(11) NOT NULL auto_increment,
  `page_name` varchar(250) default NULL,
  `page_alias` varchar(250) default NULL,
  `page_type` varchar(45) default NULL,
  `show_in_front` varchar(45) default '0',
  `content` text,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=latin1;
ALTER TABLE `PrintLogic_orders` ADD COLUMN `coupon_code` VARCHAR(250) NULL AFTER `customer_note`, ADD COLUMN `reduced_amt` FLOAT NULL AFTER `coupon_code`;
ALTER TABLE `PrintLogic_ratings` ADD COLUMN `type` VARCHAR(50) NULL DEFAULT 'product' AFTER `rate`;

ALTER TABLE `PrintLogic_products` CHANGE `descr` `descr` TEXT CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL;

ALTER TABLE `PrintLogic_products` CHANGE `defaultattribute` `defaultattribute` BIGINT(20) NULL;


ALTER TABLE `PrintLogic_productdetails` CHANGE `reorderlevel` `reorderlevel` BIGINT(20) NULL DEFAULT '0';

ALTER TABLE `PrintLogic_productdetails` CHANGE `stock` `stock` BIGINT(20) NULL DEFAULT '0', CHANGE `skuno` `skuno` VARCHAR(100) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT '', CHANGE `pdctfile` `pdctfile` VARCHAR(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT '';

ALTER TABLE `PrintLogic_productdetails` CHANGE `extraprice` `extraprice` FLOAT NULL DEFAULT '0';

ALTER TABLE `PrintLogic_orders` CHANGE `currency_type` `currency_type` VARCHAR(10) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT 'USD';

ALTER TABLE `PrintLogic_orders` CHANGE `currency_type` `currency_type` VARCHAR(100) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT 'USD';


ALTER TABLE `PrintLogic_orders` CHANGE COLUMN `comments` `comments` LONGTEXT NULL;

ALTER TABLE `PrintLogic_orders`
  CHANGE COLUMN `customer_note` `customer_note` TEXT NULL;

ALTER TABLE `PrintLogic_itemcoordinate_sessions` CHANGE `flip_count` `flip_count` TINYINT(2) NULL DEFAULT '0';


ALTER TABLE `PrintLogic_itemcoordinate_sessions` CHANGE `flop_count` `flop_count` TINYINT(2) NULL DEFAULT '0';

ALTER TABLE `PrintLogic_itemcoordinates` CHANGE COLUMN `shape` `shape` VARCHAR(50) NULL;
ALTER TABLE `PrintLogic_itemcoordinates` CHANGE `flip_count` `flip_count` TINYINT( 2 ) NULL DEFAULT '0';
ALTER TABLE `PrintLogic_itemcoordinates` CHANGE `flop_count` `flop_count` TINYINT( 2 ) NULL DEFAULT '0';
ALTER TABLE `PrintLogic_settings` CHANGE `value` `value` TEXT NULL;

ALTER TABLE `PrintLogic_itemcoordinate_sessions` CHANGE `curve` `curve` INT( 11 ) NULL DEFAULT '0';
CREATE TABLE IF NOT EXISTS `PrintLogic_fundraisers` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `fundraiser_name` varchar(250) DEFAULT NULL,
  `productdetail_id` int(11) DEFAULT NULL,
  `product_id` int(11) DEFAULT NULL,
  `savedimage_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=42 DEFAULT CHARSET=latin1;
ALTER TABLE `PrintLogic_fundraisers` ADD COLUMN `min_qty` INT(11) NULL DEFAULT NULL AFTER `savedimage_id`, ADD COLUMN `max_qty` INT(11) NULL DEFAULT NULL AFTER `min_qty`;
ALTER TABLE `PrintLogic_fundraisers` ADD COLUMN `fundraiser_description` TEXT NULL DEFAULT NULL AFTER `fundraiser_name`;
ALTER TABLE `PrintLogic_fundraisers` ADD COLUMN `price` FLOAT NULL DEFAULT NULL AFTER `savedimage_id`;
ALTER TABLE `PrintLogic_fundraisers` ADD COLUMN `date_added` DATETIME NULL DEFAULT NULL AFTER `user_id`;
ALTER TABLE `PrintLogic_orders` ADD COLUMN `fundraiser_id` FLOAT NULL DEFAULT NULL AFTER `reduced_amt`;
ALTER TABLE `PrintLogic_orders` CHANGE COLUMN `fundraiser_id` `fundraiser_id` INT NULL DEFAULT '0' AFTER `reduced_amt`;
CREATE TABLE `PrintLogic_productexternals` (
	`id` INT NOT NULL AUTO_INCREMENT,
	`pname` VARCHAR(50) NOT NULL DEFAULT '0',
	`brand` VARCHAR(50) NOT NULL DEFAULT '0',
	`style_number` VARCHAR(50) NOT NULL DEFAULT '0',
	PRIMARY KEY (`id`)
)
COLLATE='latin1_swedish_ci' ENGINE=MyISAM;
CREATE TABLE `PrintLogic_productexternalsdetails` (
	`id` INT NOT NULL AUTO_INCREMENT,
	`item_number` VARCHAR(50) NULL,
	`gtin_number` VARCHAR(50) NULL,
	`color_code` VARCHAR(50) NULL,
	`color` VARCHAR(50) NULL,
	`size` VARCHAR(50) NULL,
	`productexternal_id` INT NOT NULL,
	PRIMARY KEY (`id`)
)
COLLATE='latin1_swedish_ci' ENGINE=MyISAM;
CREATE TABLE IF NOT EXISTS `PrintLogic_brands` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `brandname` varchar(100) NOT NULL DEFAULT '',
  `descr` text,
  `image1` varchar(355) DEFAULT NULL,
  `status` varchar(10) NOT NULL DEFAULT 'A',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=25 DEFAULT CHARSET=latin1;
ALTER TABLE `PrintLogic_products` ADD COLUMN `min_quantity` INT(10) NULL DEFAULT '0' AFTER `vertical_ruler`, ADD COLUMN `max_quantity` INT(10) NULL DEFAULT '0' AFTER `min_quantity`;
ALTER TABLE `PrintLogic_products` ADD COLUMN `brand_id` INT(11) NULL DEFAULT '0' AFTER `category_id`;
ALTER TABLE `PrintLogic_products` CHANGE COLUMN `featured` `featured` INT NULL DEFAULT '0' AFTER `image2`;
CREATE TABLE `PrintLogic_productdimensions` ( `id` int(11) NOT NULL AUTO_INCREMENT, `product_id` int(11) NOT NULL, `size` text, `inches` varchar(25) DEFAULT NULL, `centimeter` varchar(25) DEFAULT NULL, PRIMARY KEY (`id`) ) ENGINE=MyISAM DEFAULT CHARSET=latin1;
ALTER TABLE `PrintLogic_savedimages` ADD INDEX `ref_name` (`ref_name`),ADD INDEX `productdetails_id` (`productdetails_id`),ADD INDEX `users_id` (`users_id`);
ALTER TABLE `PrintLogic_itemcoordinates` ADD INDEX `savedimages_id_productdetails_id` (`savedimages_id`, `productdetails_id`);
ALTER TABLE `PrintLogic_customimages` ADD INDEX `productdetails_id` (`productdetails_id`),ADD INDEX `type` (`type`);
ALTER TABLE `PrintLogic_products` ADD INDEX `pname_category_id_brand_id` (`pname`, `category_id`, `brand_id`);
ALTER TABLE `PrintLogic_productdetails` ADD INDEX `category_id_product_id_customvalue_id` (`category_id`, `product_id`, `customvalue_id`);
ALTER TABLE `PrintLogic_productdimensions` ADD INDEX `product_id` (`product_id`);
ALTER TABLE `PrintLogic_customcombinations` ADD INDEX `category_id_customfield_id_customvalue_id` (`category_id`, `customfield_id`, `customvalue_id`);
ALTER TABLE `PrintLogic_customfieldvalues` ADD INDEX `customfield_id_custom_value` (`customfield_id`, `custom_value`);
ALTER TABLE `PrintLogic_customimagetypes` ADD INDEX `productid` (`productid`);
ALTER TABLE `PrintLogic_orders` ADD `email_id` VARCHAR(250) NULL AFTER `bill_lname`;
ALTER TABLE `PrintLogic_coupons` CHANGE `type` `type` enum('Perc','Amt','Free') COLLATE 'latin1_swedish_ci' NOT NULL DEFAULT 'Perc' AFTER `code`;
ALTER TABLE `PrintLogic_categories` ADD `sizechart` char NULL;
ALTER TABLE `PrintLogic_categories` CHANGE `sizechart` `sizechart` char(1) COLLATE 'latin1_swedish_ci' NULL DEFAULT '0' AFTER `position`;
ALTER TABLE `PrintLogic_orders` CHANGE `bill_fax` `bill_fax` varchar(50) COLLATE 'latin1_swedish_ci' NULL DEFAULT '' AFTER `bill_mobile`;
ALTER TABLE `PrintLogic_orders` CHANGE `bill_mobile` `bill_mobile` varchar(50) COLLATE 'latin1_swedish_ci' NULL DEFAULT '' AFTER `bill_phone`;
ALTER TABLE `PrintLogic_orders` CHANGE `ship_mobile` `ship_mobile` VARCHAR(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT '';
ALTER TABLE `PrintLogic_orders` CHANGE `ship_fax` `ship_fax` varchar(50) COLLATE 'latin1_swedish_ci' NULL DEFAULT '' AFTER `ship_mobile`;
ALTER TABLE `PrintLogic_orders` CHANGE `ship_fax` `ship_fax` varchar(50) COLLATE 'latin1_swedish_ci' NULL DEFAULT '' AFTER `ship_mobile`;
ALTER TABLE `PrintLogic_settings` CHANGE `value` `value` TEXT CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL;
ALTER TABLE `PrintLogic_fundraisers` ADD COLUMN `ref_name` VARCHAR(50) NULL DEFAULT NULL AFTER `savedimage_id`;
