CREATE TABLE IF NOT EXISTS `PrintLogic_fundraisers` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `fundraiser_name` varchar(250) DEFAULT NULL,
  `productdetail_id` int(11) DEFAULT NULL,
  `product_id` int(11) DEFAULT NULL,
  `savedimage_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=42 DEFAULT CHARSET=latin1;
ALTER TABLE `PrintLogic_fundraisers` ADD COLUMN `min_qty` INT(11) NULL DEFAULT NULL AFTER `savedimage_id`, ADD COLUMN `max_qty` INT(11) NULL DEFAULT NULL AFTER `min_qty`;
ALTER TABLE `PrintLogic_fundraisers` ADD COLUMN `fundraiser_description` TEXT NULL DEFAULT NULL AFTER `fundraiser_name`;
ALTER TABLE `PrintLogic_fundraisers` ADD COLUMN `price` FLOAT NULL DEFAULT NULL AFTER `savedimage_id`;
ALTER TABLE `PrintLogic_fundraisers` ADD COLUMN `date_added` DATETIME NULL DEFAULT NULL AFTER `user_id`;
ALTER TABLE `PrintLogic_orders` ADD COLUMN `fundraiser_id` FLOAT NULL DEFAULT NULL AFTER `reduced_amt`;
ALTER TABLE `PrintLogic_orders` CHANGE COLUMN `fundraiser_id` `fundraiser_id` INT NULL DEFAULT '0' AFTER `reduced_amt`;
CREATE TABLE `PrintLogic_productexternals` (
	`id` INT NOT NULL AUTO_INCREMENT,
	`pname` VARCHAR(50) NOT NULL DEFAULT '0',
	`brand` VARCHAR(50) NOT NULL DEFAULT '0',
	`style_number` VARCHAR(50) NOT NULL DEFAULT '0',
	PRIMARY KEY (`id`)
)
COLLATE='latin1_swedish_ci' ENGINE=MyISAM;
CREATE TABLE `PrintLogic_productexternalsdetails` (
	`id` INT NOT NULL AUTO_INCREMENT,
	`item_number` VARCHAR(50) NULL,
	`gtin_number` VARCHAR(50) NULL,
	`color_code` VARCHAR(50) NULL,
	`color` VARCHAR(50) NULL,
	`size` VARCHAR(50) NULL,
	`productexternal_id` INT NOT NULL,
	PRIMARY KEY (`id`)
)
COLLATE='latin1_swedish_ci' ENGINE=MyISAM;
CREATE TABLE IF NOT EXISTS `PrintLogic_brands` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `brandname` varchar(100) NOT NULL DEFAULT '',
  `descr` text,
  `image1` varchar(355) DEFAULT NULL,
  `status` varchar(10) NOT NULL DEFAULT 'A',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=25 DEFAULT CHARSET=latin1;
ALTER TABLE `PrintLogic_products` ADD COLUMN `min_quantity` INT(10) NULL DEFAULT '0' AFTER `vertical_ruler`, ADD COLUMN `max_quantity` INT(10) NULL DEFAULT '0' AFTER `min_quantity`;
ALTER TABLE `PrintLogic_products` ADD COLUMN `brand_id` INT(11) NULL DEFAULT '0' AFTER `category_id`;
ALTER TABLE `PrintLogic_products` CHANGE COLUMN `featured` `featured` INT NULL DEFAULT '0' AFTER `image2`;
CREATE TABLE `PrintLogic_productdimensions` ( `id` int(11) NOT NULL AUTO_INCREMENT, `product_id` int(11) NOT NULL, `size` text, `inches` varchar(25) DEFAULT NULL, `centimeter` varchar(25) DEFAULT NULL, PRIMARY KEY (`id`) ) ENGINE=MyISAM DEFAULT CHARSET=latin1;
ALTER TABLE `PrintLogic_savedimages` ADD INDEX `ref_name` (`ref_name`),ADD INDEX `productdetails_id` (`productdetails_id`),ADD INDEX `users_id` (`users_id`);
ALTER TABLE `PrintLogic_itemcoordinates` ADD INDEX `savedimages_id_productdetails_id` (`savedimages_id`, `productdetails_id`);
ALTER TABLE `PrintLogic_customimages` ADD INDEX `productdetails_id` (`productdetails_id`),ADD INDEX `type` (`type`);
ALTER TABLE `PrintLogic_products` ADD INDEX `pname_category_id_brand_id` (`pname`, `category_id`, `brand_id`);
ALTER TABLE `PrintLogic_productdetails` ADD INDEX `category_id_product_id_customvalue_id` (`category_id`, `product_id`, `customvalue_id`);
ALTER TABLE `PrintLogic_productdimensions` ADD INDEX `product_id` (`product_id`);
ALTER TABLE `PrintLogic_customcombinations` ADD INDEX `category_id_customfield_id_customvalue_id` (`category_id`, `customfield_id`, `customvalue_id`);
ALTER TABLE `PrintLogic_customfieldvalues` ADD INDEX `customfield_id_custom_value` (`customfield_id`, `custom_value`);
ALTER TABLE `PrintLogic_customimagetypes` ADD INDEX `productid` (`productid`);
ALTER TABLE `PrintLogic_orders` ADD `email_id` VARCHAR(250) NULL AFTER `bill_lname`;
ALTER TABLE `PrintLogic_coupons` CHANGE `type` `type` enum('Perc','Amt','Free') COLLATE 'latin1_swedish_ci' NOT NULL DEFAULT 'Perc' AFTER `code`;
ALTER TABLE `PrintLogic_categories` ADD `sizechart` char NULL;
ALTER TABLE `PrintLogic_categories` CHANGE `sizechart` `sizechart` char(1) COLLATE 'latin1_swedish_ci' NULL DEFAULT '0' AFTER `position`;
ALTER TABLE `PrintLogic_orders` CHANGE `bill_fax` `bill_fax` varchar(50) COLLATE 'latin1_swedish_ci' NULL DEFAULT '' AFTER `bill_mobile`;
ALTER TABLE `PrintLogic_orders` CHANGE `bill_mobile` `bill_mobile` varchar(50) COLLATE 'latin1_swedish_ci' NULL DEFAULT '' AFTER `bill_phone`;
ALTER TABLE `PrintLogic_orders` CHANGE `ship_mobile` `ship_mobile` VARCHAR(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci NULL DEFAULT '';
ALTER TABLE `PrintLogic_orders` CHANGE `ship_fax` `ship_fax` varchar(50) COLLATE 'latin1_swedish_ci' NULL DEFAULT '' AFTER `ship_mobile`;
ALTER TABLE `PrintLogic_orders` CHANGE `ship_fax` `ship_fax` varchar(50) COLLATE 'latin1_swedish_ci' NULL DEFAULT '' AFTER `ship_mobile`;
ALTER TABLE `PrintLogic_settings` CHANGE `value` `value` TEXT CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL;
ALTER TABLE `PrintLogic_fundraisers` ADD COLUMN `ref_name` VARCHAR(50) NULL DEFAULT NULL AFTER `savedimage_id`;