<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: 			*/
// +----------------------------------------------------------------------+
// | PHP version 4/5                                                      |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004-2011 ARMIA INC                                    |
// +----------------------------------------------------------------------+
// | This source file is a part of iScripts PrintLogic                     |
// +----------------------------------------------------------------------+
// | Authors: Jipson<jipson.thomas@armiasystems.com>             		  |
// +----------------------------------------------------------------------+
App::uses('AppController', 'Controller');
App::uses('Sanitize', 'Utility');
class CustomfieldsController extends AppController
{
    var $name = "Customfield";
   // var $helpers = array('Html', 'Form','Pagination');   
    var $helpers = array('Html', 'Form','Paginator','JS','Flash'); 
	var $components = array ('Pagination','Catmenu','History','Email'); 
	var $uses = array('Customfield','Customfieldvalue','Productcustomfield','Currency','Setting');
	var $paginate = array('limit' => 25,'order' => array('Customfield.custom_name' => 'asc'));


	function index(){

            $this->__validateLoginStatus();
            $admsess	=	$this->Session->read('Admin');
            if($admsess["custom"] <> 1){
                $this->redirect(array('controller' => 'admins', 'action' => 'index'));
                exit();
            }

            $customFieldValueTbl=$this->Customfield->getTableName("customfieldvalues");
            
            $cmbSearchType	=	"";
            $txtSearch		=	"";
            $this->paginate["fields"] = array("Customfield.id,Customfield.custom_name,(SELECT GROUP_CONCAT(custom_value) as customData FROM $customFieldValueTbl
                                                    WHERE Customfield.id = customfield_id  ) as customValues");
            
            $this->paginate["conditions"] = array(" Customfield.id <>'1'");
           
            if(isset($_GET["cmbSearchType"]) && isset($_GET["txtSearch"])){
                    $cmbSearchType	=	$_GET["cmbSearchType"];
                    $txtSearch	=	$_GET["txtSearch"];
                    if($cmbSearchType == "name"){
                        $data = $this->paginate('Customfield', array('Customfield.custom_name LIKE ' => "%".addslashes($txtSearch)."%"));
                    }else{
                        $data = $this->paginate('Customfield');
                    }
            }

            else if(isset($this->passedArgs["cmbSearchType"]) && isset($this->passedArgs["txtSearch"]) && $this->passedArgs["txtSearch"] <> '')
            {
                $cmbSearchType	=	$this->passedArgs["cmbSearchType"];
                    $txtSearch		=	$this->passedArgs["txtSearch"];
                    if($cmbSearchType == "name"){
                            $data = $this->paginate('Customfield', array('Customfield.custom_name LIKE ' => "%".addslashes($txtSearch)."%"));
                    }else{
                            $data = $this->paginate('Customfield');
                    }
            }
            else{

                
                $data = $this->paginate('Customfield'); //echopre($data);
            }

                
            $this->set('cmbSearchType', $cmbSearchType);
            $this->set('txtSearch', $txtSearch);
            $this->passedArgs['limit']=$this->paginate["limit"];
            $this->set('passedarg',$this->passedArgs);
            $this->set('customfield', $data);

            //For Edit in Place
            $this->set('totrows', 25);
            //For Edit in Place
            $this->layout = 'adm';
	} 



	function add() {

     //echo "yyyy";exit;
		 $this->__validateLoginStatus();	
		 $admsess	=	$this->Session->read('Admin');
		if($admsess["custom"] <> 1){
		 	$this->redirect(array('controller' => 'admins', 'action' => 'index')); 
			exit();
		}

      //  
		if (!empty($this->data)) 
		{
			//checking for duplicates starts here...
             //$dups=$this->Customfield->findByCustomName(trim($this->data["Customfield"]["custom_name"]));
			// $dups=$this->Customfield->find(array("custom_name"=>trim($this->data["Customfield"]["custom_name"])));	

             $dups=$this->Customfield->findBycustom_name(trim($this->data["Customfield"]["custom_name"])); 

			 if(isset($dups["Customfield"]["id"]) && $dups["Customfield"]["id"] <> '')
		     {
		         $this->Session->setFlash('CustomField Already exists.', 'default',array('class'=> 'failure'));
		         $this->redirect('/customfields');
		         exit();
		      } 
            
			 //checking for duplicates ends here...
			 $this->Customfield->save($this->data);
			 $this->Session->setFlash('CustomField has been saved.', 'default',array('class'=> 'success'));
			 $this->redirect(array('controller' => 'customfields','action'=>'index'));		
		}		
		$this->layout = 'adm';
	} 



	function edit() 
	{
		$this->__validateLoginStatus();		
		$admsess	=	$this->Session->read('Admin');
		if($admsess["custom"] <> 1){
		 	$this->redirect(array('controller' => 'admins', 'action' => 'index')); 
			exit();
		}


		$editindex=$_POST["editindex"];
		$editid=$_POST["editid"];
		$customname=trim($_POST["edit_cname$editindex"]);			
		//checking for duplicates starts here...

		 $dups=$this->Customfield->checkEditDups($customname,$editid);			
		 if(isset($dups) && $dups > 0)
		     {
		         $this->Session->setFlash('CustomField Already exists.', 'default',array('class'=> 'failure'));
		         $this->redirect('/customfields');
		         exit();
		      } 
		//checking for duplicates ends here...

		//Fetching the old custom name
		$this->Customfield->id = $editid; 
		$custom	=	$this->Customfield->findById($editid);
		$cname	=	$custom["Customfield"]["custom_name"];	
		//Fetching the old custom name		

		if ($customname!='') 
		{
	        $this->Customfield->updatecusval($customname,$editid); 
			$this->Session->setFlash('The CustomField '.$cname.' has been Edited Successfully.', 'default',array('class'=> 'success'));
			$this->redirect('/customfields');
		}
	}	




	function delete($id){
		$this->__validateLoginStatus();
		$admsess	=	$this->Session->read('Admin');
		if($admsess["custom"] <> 1){
		 	$this->redirect(array('controller' => 'admins', 'action' => 'index')); 
			exit();
		}		

		//Fetching the old custom name
		$this->Customfield->id = $id; 
		$custom	=	$this->Customfield->findById($id);
		$cname	=	$custom["Customfield"]["custom_name"];	
		//Fetching the old custom name			
		$child=$this->Customfieldvalue->findByCustomfieldId($id);
		if(isset($child["Customfieldvalue"]["id"]) && $child["Customfieldvalue"]["id"] <> '')
		{
		  $this->Session->setFlash('This custom field cannot be deleted because it contains custom values. First delete custom values and then you may delete the field.', 'default',array('class'=> 'failure'));
		  $this->redirect('/customfields');
		  exit();
		} 
		$this->Customfield->delcusval($id);
		$this->Session->setFlash('The custom field '.$cname.' has been deleted Successfully.', 'default',array('class'=> 'success'));
		  
		$this->redirect('/customfields');
	}


	function delcusnam($pid,$nam){
		$this->__validateLoginStatus();
		$admsess	=	$this->Session->read('Admin');
		if($admsess["custom"] <> 1){
		 	$this->redirect(array('controller' => 'admins', 'action' => 'index')); 
			exit();
		}

		$this->Customfield->delcusnam($nam);
		$this->Session->setFlash('CustomField Removed Successfully.', 'default',array('class'=> 'success'));
		$this->redirect(array('controller' => 'products','action'=>'edit/'.$pid.'/cust'));
	}

    function beforeFilter()
    {
		/*if (isset($this->Setting) && !empty($this->Setting->table))  
        {  
             $this->Setting->load();  
        } */
        $this->loadModel('Setting');
        $this->Setting->load();

		global $sitefolder; 
		global $meta_description;
		global $meta_keywords;
		global $page_title;
		$cnfg 				=	Configure::read('Neutrino');
		$sitefolder			=	$cnfg["sitebasefolder"];
		$meta_description	=	$cnfg["meta_description"];
		$meta_keywords		=	$cnfg["meta_keywords"];
		$page_title			=	$cnfg["page_title"];
		global $style; 
		$style				=	$cnfg["style"];
		$this->set('style', $style);
		$this->set('meta_description', $meta_description);
		$this->set('meta_keywords', $meta_keywords);
		$this->set('sitefolder', $sitefolder);
		$this->pageTitle = $page_title	; 
		$this->set('cnfg',$cnfg);
		$this->paginate["limit"]=$cnfg["items_perpage"]; //Setting pagination limit per page.
		$httpHost	=	$_SERVER['HTTP_HOST'];
		$this->set('sitebase',FULL_BASE_URL);
    }



	function beforeRender(){
				$lst	=	$this->Catmenu->getCatList(1);
				$this->set('catmenu', $lst);
				$this->layout = 'adm'; 
	}



    function __validateLoginStatus($typ='A')
    {
           if($typ == 'A'){
				if($this->Session->check('Admin') == false)
				{
					$this->Session->setFlash('The URL you have followed requires you login.', 'default',array('class'=> 'failure'));
					$this->redirect(array('controller' => 'admins', 'action' => 'login')); 
				}
		}else{
				if($this->Session->check('Userlog') == false)
				{
					$this->Session->setFlash('The URL you have followed requires you login.', 'default',array('class'=> 'failure'));
					$this->redirect(array('controller' => 'users', 'action' => 'login')); 
				}
			}
    }



    function ajaxsavecustomfieldvalue1($customFieldValue, $customFieldId) {

        $this->__validateLoginStatus();
        $admsess	=	$this->Session->read('Admin');

        if($admsess["custom"] <> 1) {
            $this->redirect(array('controller' => 'admins', 'action' => 'index'));
            exit();
        }

        if (!empty($this->data)) { 
            $post_data = $this->data;

            $customFieldId    = $this->data['Customfieldvalue']['customFieldId'];
            $customFieldValue = $this->data['Customfieldvalue']['customFieldValue'];

            //checking for duplicates starts here...
            $dups=$this->Customfieldvalue->checkAddDups(trim($customFieldValue),$customFieldId);
            if(isset($dups) && $dups > 0) {
                $this->Session->setFlash('Custom Field Value Already exists.', 'default',array('class'=> 'failure'));
            }else{
            //checking for duplicates ends here...
            $post_data['Customfieldvalue']['customfield_id'] = $customFieldId;
            $post_data['Customfieldvalue']['custom_value']   = $customFieldValue;
            $this->data = $post_data;
            $this->Customfieldvalue->save($this->data);
            $this->Session->setFlash('Custom Field value has been saved.', 'default',array('class'=> 'success'));
            }
        }
        $this->layout = 'ajax';
    }


    function ajaxSaveCustomFieldValue() {
        
        extract($_POST);
        $mode             = $_POST['mode']; 
        $customFieldValue = trim($_POST['customFieldValue']);
        $customFieldId    = $_POST['customFieldId']; 

        if($mode =='check'){
            //checking for duplicates starts here...
            $dups=$this->Customfieldvalue->checkAddDups(trim($customFieldValue),$customFieldId); 
            if(isset($dups) && $dups > 0) {
                $message = 1;
            }else{
                $message = 0;
            }
        }else{
            $post_data = $this->data;
            $post_data['Customfieldvalue']['customfield_id'] = $customFieldId;
            $post_data['Customfieldvalue']['custom_value']   = $customFieldValue;
            $this->data = $post_data;
            $this->Customfieldvalue->save($this->data);
            
            $customFieldDataArray = $this->populateCustomFieldData($customFieldId);
            $message = $customFieldDataArray;
        }
        echo $message;
        //-----------ajax features--------------//
        Configure::write('debug', 0);
        $this->autoRender = false;
        exit;
    }


    function ajaxGetCustomFieldValueArray() {

        extract($_POST);

        $customFieldId    = $_POST['customFieldId'];
        $divid            = $_POST['divid'];
        $mode             = $_POST['mode'];

        $customFieldDataArray = $this->populateCustomFieldData($customFieldId,$divid,$mode);
        
        echo $customFieldDataArray;
        //-----------ajax features--------------//
        Configure::write('debug', 0);
        $this->autoRender = false;
        exit;
    }
    
    function ajaxDeleteCustomvalue() {

        extract($_POST);
        $customFieldValueId    = $_POST['customFieldValueId'];
        $customFieldId         = $_POST['customFieldId'];
        
        $child_exists = $this->Customfieldvalue->checkChildExits($customFieldValueId);

        if($child_exists==1){
            $message = 1;
        }else{
            $this->Customfieldvalue->delcusfieldval($customFieldValueId);
            $customDataContent = $this->populateCustomFieldData($customFieldId);
            $message = $customDataContent;
        }
        
        echo $message;
        //-----------ajax features--------------//
        Configure::write('debug', 0);
        $this->autoRender = false;
        exit;
    }


    function populateCustomFieldData($customFieldId,$divid='',$mode=''){

        $customValuesData = $this->Customfield->getCustomFieldValues($customFieldId);

        $cnfg 	     = Configure::read('Neutrino');
        $dotUrl      = FULL_BASE_URL. $cnfg["sitebasefolder"].'/'.IMAGES_URL.'dot.png';
        $dotImageUrl = "<img src='".$dotUrl."'/>";
        $crossUrl    = FULL_BASE_URL. $cnfg["sitebasefolder"].'/'.IMAGES_URL.'close.png';
        $customFieldDataArray = '<div class="customfield_wrapper"><ul>';
        $i=0;
        
        foreach($customValuesData as $customValues){
          
            $i++;
            if($i==count($customValuesData)) $dotImageUrl = "";
            $customValueName = ($customValues['PrintLogic_customfieldvalues']['custom_value'])?$customValues['PrintLogic_customfieldvalues']['custom_value']:"-";
            if($mode=='hover'){
               $customFieldDataArray .= "<li><span class='fieldname'> ".$customValueName."</span><span  class='deletelink'><img title='Delete Custom Value' onClick='customValueDelete(".$customValues['PrintLogic_customfieldvalues']['id'].",".$divid.",".$customFieldId.")' src='".$crossUrl."'/> </span></li>";
            }else{
                $customFieldDataArray .= "<li><span class='fieldname'> ".$customValueName."</span><span class='deletelink'>".$dotImageUrl."</span></li>";
            }
        }
        $customFieldDataArray .= '</ul></div>';

        return $customFieldDataArray;
        
    }
    
}
?>