<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: 			*/
// +----------------------------------------------------------------------+
// | PHP version 4/5                                                      |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004-2011 ARMIA INC                                    |
// +----------------------------------------------------------------------+
// | This source file is a part of iScripts PrintLogic                     |
// +----------------------------------------------------------------------+
// | Authors: Aswin<aswin.j@armiasystems.com>             		  |
// +----------------------------------------------------------------------+
App::uses('AppController', 'Controller');
App::uses('Sanitize', 'Utility');
class FontsController extends AppController
{
    var $name = "Font";
    //var $helpers = array('Html', 'Form', 'Pagination');
    var $helpers = array('Html', 'Form','Paginator','JS','Flash'); 
    var $components = array ('Pagination','Catmenu','History','Email'); 
    var $uses = array('Font','Category','Currency','Setting');
    var $paginate = array('limit' => 25,'order' => array('Font.name' => 'asc'));


    function index()
    {
        $this->__validateLoginStatus();
        $admsess	=	$this->Session->read('Admin');        
        
        $data = $this->paginate('Font');
        
        $this->passedArgs['limit']=$this->paginate["limit"];
        $this->set('passedarg',$this->passedArgs);
        $this->set('font', $data);

        //For Edit in Place
        $this->set('totrows', 25);
        //For Edit in Place
        $this->layout = 'adm';
    }

    function add()
    {


        $this->__validateLoginStatus();
        $admsess	=	$this->Session->read('Admin');

       
        if(isset($_POST['savefont'])){
            if(isset($_FILES['font_name']) && $_FILES['font_name']['name'] <> ''){
                $file_extension = explode(".", $_FILES['font_name']['name']);
                $dups = $this->Font->findByFileName($_FILES['font_name']['name']);
                
                if(strtolower(end($file_extension)) <> 'ttf'){
                    $this->Session->setFlash('Invalid Font Type. Please Select TTF Fonts Only.', 'default', array('class'=> 'failure'));
                    $this->redirect('/Fonts/index');
                    exit();
                }
                elseif(file_exists(WWW_ROOT.IMAGES_URL.'editorfonts/'.preg_replace('/\s+/', '_', trim($_FILES['font_name']['name'])))){
                    $this->Session->setFlash('Font Already Exists.', 'default', array('class'=> 'failure'));
                    $this->redirect('/Fonts/index');
                    exit();
                }
                elseif(isset($dups["Font"]["id"]) && $dups["Font"]["id"] <> ''){
                    $this->Session->setFlash('Font Already Exists.', 'default', array('class'=> 'failure'));
                    $this->redirect('/Fonts/index');
                    exit();
                }
                else{
                    move_uploaded_file($_FILES['font_name']['tmp_name'], WWW_ROOT.IMAGES_URL.'editorfonts/'.preg_replace('/\s+/', '_', trim($_FILES['font_name']['name'])));
                    $file_name = '';
                    foreach($file_extension as $ext){
                        if($ext <> end($file_extension)){
                            $file_name .= $ext;
                        }
                    }

                    //generate the font preview image
                    $img_path  = $this->__saveFontImage(trim($file_name), preg_replace('/\s+/', '_', trim($file_name)));

                    $data['Font']['name']       = preg_replace('/\s+/', '_', trim($file_name));
                    $data['Font']['file_name']  = preg_replace('/\s+/', '_', trim($_FILES['font_name']['name']));
                    $data['Font']['status']     = 1;
                    $data['Font']['image_path'] = $img_path;

                    $this->Font->save($data);
                    $this->Session->setFlash('Font Has Been Saved.', 'default',array('class'=> 'success'));
                    $this->redirect('/Fonts/index');
                }
            }
            else{
                $this->Session->setFlash('Please Select A Font.', 'default',array('class'=> 'failure'));
                $this->redirect('/Fonts/index');
            }
        }        
    }


    function disable($id, $enableOrDisable = 'disable')
    {
            $this->__validateLoginStatus();
            $admsess	=	$this->Session->read('Admin');            

            $font	=	$this->Font->findById($id);
            $status = $enableOrDisable == 'disable' ? 0 : 1;
            if(isset($font["Font"]["id"]) && $font["Font"]["id"] <> '')
            {
                $this->Font->id = $id;
                $this->Font->saveField('status', $status);
            }            
            $this->Session->setFlash('The Selected Font Has Been '.ucfirst($enableOrDisable).'d.', 'default',array('class'=> 'success'));

            $this->redirect('/Fonts/index');
    }

    function beforeFilter()
    {
        /*if (isset($this->Setting) && !empty($this->Setting->table))
        {
             $this->Setting->load();
        }*/
        $this->loadModel('Setting');
        $this->Setting->load();
        global $sitefolder;
        global $meta_description;
        global $meta_keywords;
        global $page_title;
        $cnfg 				=	Configure::read('Neutrino');
        $sitefolder			=	$cnfg["sitebasefolder"];
        $meta_description	=	$cnfg["meta_description"];
        $meta_keywords		=	$cnfg["meta_keywords"];
        $page_title			=	$cnfg["page_title"];
        global $style;
        $style				=	$cnfg["style"];
        $this->set('style', $style);
        $this->set('meta_description', $meta_description);
        $this->set('meta_keywords', $meta_keywords);
        $this->set('sitefolder', $sitefolder);
        $this->pageTitle = $page_title	;
        $this->set('cnfg',$cnfg);
        $this->paginate["limit"]=$cnfg["items_perpage"]; //Setting pagination limit per page.
        $httpHost	=	$_SERVER['HTTP_HOST'];
        $this->set('sitebase',FULL_BASE_URL);
    }

    function __saveFontImage($font_name, $font_path)
    {
       

         if (file_exists(WWW_ROOT . IMAGES_URL . 'editorfonts/' . $font_path . '.ttf')) {
               $font = WWW_ROOT . IMAGES_URL . 'editorfonts/' . $font_path . '.ttf';
            } else {
                $font = WWW_ROOT . IMAGES_URL . 'editorfonts/' . $font_path . '.TTF';
            }
        
        system('convert -depth '.'64'.' -density '.'300'.' -units pixelsperinch -background transparent -gravity west -fill "#000000" -font '.$font.' -stroke none -pointsize 5 label:"'.$font_name.'" '.WWW_ROOT.IMAGES_URL.'/fontpreview/'.$font_path.'.png');
        return $font_path.'.png';
    }

    function generateFontPreview()
    {
        $fonts = $this->Font->find('all');
        if($fonts){
            foreach($fonts as $font){
                $font_name = $font['Font']['name'];
                $font_path = $font['Font']['file_name'];

                $img_path  = $this->__saveFontImage($font_name, $font_path);

                $data['Font']['id']         = $font['Font']['id'];
                $data['Font']['image_path'] = $img_path;

                $this->Font->save($data);
            }
        }
        exit;
    }

    function beforeRender()
    {
        $lst	=	$this->Catmenu->getCatList(1);
        $this->set('catmenu', $lst);
        $this->layout = 'adm';
    }

    function __validateLoginStatus($typ='A')
    {
       if($typ == 'A'){
            if($this->Session->check('Admin') == false)
            {
                    $this->Session->setFlash('The URL you have followed requires you login.', 'default',array('class'=> 'failure'));
                    $this->redirect(array('controller' => 'admins', 'action' => 'login'));
            }
        }else{
            if($this->Session->check('Userlog') == false)
            {
                    $this->Session->setFlash('The URL you have followed requires you login.', 'default',array('class'=> 'failure'));
                    $this->redirect(array('controller' => 'users', 'action' => 'login'));
            }
        }
    }  
}
?>