<?php

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: 			*/

// +----------------------------------------------------------------------+

// | PHP version 4/5                                                      |

// +----------------------------------------------------------------------+

// | Copyright (c) 2004-2011 ARMIA INC                                    |

// +----------------------------------------------------------------------+

// | This source file is a part of iScripts PrintLogic                     |

// +----------------------------------------------------------------------+

// | Authors: Jipson<jipson.thomas@armiasystems.com>             		  |

// +----------------------------------------------------------------------+
App::uses('AppController', 'Controller');
App::uses('Component', 'Controller');//missed
class HomelayoutController extends AppController {

    var $name = "Homelayout";

    var $helpers = array('Html', 'Form','Paginator','JS','Flash'); 

    var $uses = array('Homelayout','Report');



    function index() {

        $this->__validateLoginStatus();

        $layouttbl=$this->Report->getTableName("homelayouts");

        $layouttbl=trim(str_replace('`','',$layouttbl));

        $left_sec		=	$this->Homelayout->getLayout('left');

        $right_sec		=	$this->Homelayout->getLayout('right');

        $testimonial_status=   $this->Homelayout->getStatus('testimonial');

        $service_status=   $this->Homelayout->getStatus('service');

        $featured_status  =   $this->Homelayout->getStatus('featured');

        $category_status  =   $this->Homelayout->getStatus('category');
        //$site_promo_status  =   $this->Homelayout->getStatus('site_promo');


        $this->set('testimonial',$testimonial_status);

        $this->set('service',$service_status);

        $this->set('featured',$featured_status);

        $this->set('category',$category_status);
        //$this->set('site_promo',$site_promo_status);

        $this->set('left_sec',$left_sec);

        $this->set('right_sec',$right_sec);

        $this->set('tblindex',$layouttbl);

        $this->layout = 'adm';

    }

    function beforeFilter() {
        //$this->__validateLoginStatus();

    }

    function beforeRender() {
        /*if (isset($this->Setting) && !empty($this->Setting->table)) {
            $this->Setting->load();
        }*/
        $this->loadModel('Setting');
        $this->Setting->load();
        global $sitefolder;

        global $meta_description;

        global $meta_keywords;

        global $page_title;

        $cnfg 				=	Configure::read('Neutrino');

        $sitefolder			=	$cnfg["sitebasefolder"];

        $meta_description	=	$cnfg["meta_description"];

        $meta_keywords		=	$cnfg["meta_keywords"];

        $page_title			=	$cnfg["page_title"];

        global $style;

        $style				=	$cnfg["style"];

        $this->set('style', $style);

        $this->set('meta_description', $meta_description);

        $this->set('meta_keywords', $meta_keywords);

        $this->pageTitle = $page_title	;

        $this->set('cnfg',$cnfg);
    }

    function __validateLoginStatus() {
        if($this->Session->check('Admin') == false) {
            $this->redirect(array('controller' => 'admins', 'action' => 'login'));

            $this->Session->setFlash(__('The URL you\'ve followed requires you login.'));
        }
    }



    //Ajax Function
    function updatestatus($arg,$newstatus) {
        $this->layout = null;
        $this->__validateLoginStatus();
        $admsess	=	$this->Session->read('Admin');
        if($admsess["homepage"] <> 1) {

            $this->redirect(array('controller' => 'admins', 'action' => 'index'));

            exit();

        }

        $this->Homelayout->updateBlockStatus($arg,strtolower($newstatus));

    }



    //Ajax Function

    function enableall($middle='',$right='') {

        $this->layout = null;

        $this->__validateLoginStatus();

        $admsess	=	$this->Session->read('Admin');

        if($admsess["homepage"] <> 1) {

            $this->redirect(array('controller' => 'admins', 'action' => 'index'));

            exit();

        }



        $mdl_cnts='';
        $rght_cnts='';

        if(isset($middle) && $middle!='')  $middle=explode(",",$middle);

        if(isset($right) && $right!='') $right=explode(",",$right);

        if(isset($middle[0])) {

            foreach($middle as $val) {

                if(trim($val)<>'')

                    $middle_contents[]=$val;

            }

        }

        if(isset($right[0])) {

            foreach($right as $val) {

                if($val<>'')

                    $right_contents[]=$val;

            }

        }

        if(isset($middle_contents))$mdl_cnts=implode(",",$middle_contents);

        if(isset($right_contents))$rght_cnts=implode(",",$right_contents);

        $this->Homelayout->updateLayout($mdl_cnts,$rght_cnts);

    }

    function updateorder() {
        $flag=0;
        if(isset($_GET['listItem'])) {
            foreach ($_GET['listItem'] as $position => $item) {
                $this->Homelayout->id = $item;
                $this->Homelayout->set('ordering', $position);
                $this->Homelayout->save();
            }

            $flag = 1;

        }

        echo $flag;

        //----------ajax--------------//
        Configure::write('debug', 0);
        $this->autoRender = false;
        exit;

    } // End Function

}

?>