<?php

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: 			*/

// +----------------------------------------------------------------------+

// | PHP version 4/5                                                      |

// +----------------------------------------------------------------------+

// | Copyright (c) 2004-2011 ARMIA INC                                    |

// +----------------------------------------------------------------------+

// | This source file is a part of iScripts PrintLogic                     |

// +----------------------------------------------------------------------+

// | Authors: Jipson<jipson.thomas@armiasystems.com>             		  |

// +----------------------------------------------------------------------+
App::uses('AppController', 'Controller');
App::uses('Sanitize', 'Utility');

class NewsletterusersController extends AppController

{

    var $name = "Newsletteruser";

    //var $helpers = array('Html', 'Form','Pagination');   
    var $helpers = array('Html', 'Form','Pagination','Js','Flash');   

	var $components = array ('Pagination','Catmenu','History','Email'); // Added

	var $uses = array('Newsletteruser'); 

	var $paginate = array('limit' => 25,'order' => array('Newsletteruser.uname' => 'asc'));

    function index()

    {
       $this->loadModel('Setting');
       $this->Setting->load();
       $this->__validateLoginStatus(); 

	   $admsess	=	$this->Session->read('Admin');


		if($admsess["newsletterusers"] <> 1){

			$this->redirect(array('controller' => 'admins', 'action' => 'index')); 

			exit();

		}

		$criteria=NULL;

		$cmbSearchType	=	"";

		$txtSearch		=	"";

		if(isset($_GET["cmbSearchType"]) && isset($_GET["txtSearch"])){

			$cmbSearchType	=	$_GET["cmbSearchType"];

			$txtSearch		=	$_GET["txtSearch"];			

			$data = $this->paginate('Newsletteruser', array('Newsletteruser.'.$cmbSearchType.' LIKE ' => "%".addslashes($txtSearch)."%"));

		}

		else if(isset($this->passedArgs["cmbSearchType"]) && isset($this->passedArgs["txtSearch"]) && 

		 $this->passedArgs["txtSearch"] <> '')

		{

		    $cmbSearchType	=	$this->passedArgs["cmbSearchType"];

			$txtSearch		=	$this->passedArgs["txtSearch"];	

			$data = $this->paginate('Newsletteruser', array('Newsletteruser.'.$cmbSearchType.' LIKE ' => "%".addslashes($txtSearch)."%"));

		}

		else{

			$data = $this->paginate('Newsletteruser');

		}

		$this->set('cmbSearchType', $cmbSearchType);

		$this->set('txtSearch', $txtSearch);

		$this->set('usr', $data);

		$this->passedArgs['limit']=$this->paginate["limit"];

		$this->set('passedarg',$this->passedArgs);

		$this->layout = 'adm'; 

    } 

    function beforeFilter()

    {

        /*if (isset($this->Setting) && !empty($this->Setting->table))  

        {  

             $this->Setting->load();  

        }*/ 
        $this->loadModel('Setting');
        $this->Setting->load();
        
		global $sitefolder; 

		global $meta_description;

		global $meta_keywords;

		global $page_title;

		$cnfg 				=	Configure::read('Neutrino');

		$sitefolder			=	$cnfg["sitebasefolder"];

		$meta_description	=	$cnfg["meta_description"];

		$meta_keywords		=	$cnfg["meta_keywords"];

		$page_title			=	$cnfg["page_title"];

		global $style; 

		$style				=	$cnfg["style"];

		$this->set('style', $style);

		$this->set('meta_description', $meta_description);

		$this->set('meta_keywords', $meta_keywords);

		$this->pageTitle = $page_title	; 

		$this->set('cnfg',$cnfg);

		$this->paginate["limit"]=$cnfg["items_perpage"]; //Setting pagination limit per page.

		$this->set('sitefolder', $sitefolder);

		$httpHost	=	$_SERVER['HTTP_HOST'];

		$this->set('sitebase',FULL_BASE_URL);

    }

	function beforeRender(){				

		

	}

	

	function add() {

		$this->__validateLoginStatus();

		$admsess	=	$this->Session->read('Admin');

		if($admsess["newsletterusers"] <> 1){

		 	$this->redirect(array('controller' => 'admins', 'action' => 'index')); 

			exit();

		}

		if (!empty($this->data)) {		

		        $dups = $this->Newsletteruser->findByEmail($this->data["Newsletteruser"]["email"]);				

				if (!empty($dups['Newsletteruser']['email'])){

					$this->Session->setFlash('Email Id Already Exists!', 'default',array('class'=> 'failure'));

					$this->redirect(array('controller'=>'newsletterusers','action'=>'index'));

					exit;

				}

		        $this->data["Newsletteruser"]["sub_date"]= date('Y-m-d h:i:s');

				if ($this->Newsletteruser->save($this->data)) {

					$this->Session->setFlash('Subscriber has been saved successfully!', 'default',array('class'=> 'success'));

			        $this->redirect(array('controller' => 'newsletterusers','action'=>'index'));

					exit;

				}

		}

		$this->layout = 'adm';

	}

	

		function edit($id=0) {

		if($id == 0){

			$this->redirect(array('controller' => 'newsletterusers','action'=>'index'));

			exit();

		}

		$this->__validateLoginStatus();

		$admsess	=	$this->Session->read('Admin');

		if($admsess["newsletterusers"] <> 1){

		 	$this->redirect(array('controller' => 'admins', 'action' => 'index')); 

			exit();

		}

		$this->Newsletteruser->id = $id; 

		if (!empty($this->data)) {			  

			   $dups = $this->Newsletteruser->find('count', array('conditions' => array('Newsletteruser.id <> '.$id,'Newsletteruser.email' => $this->data["Newsletteruser"]["email"])));						   	

				if ($dups > 0){

					$this->Session->setFlash('Email Id Already Exists!', 'default',array('class'=> 'failure'));

					$this->redirect(array('controller'=>'newsletterusers','action'=>'index'));

					exit;

				}

				

			$this->data["Newsletteruser"]["sub_date"]= date('Y-m-d h:i:s');

				if ($this->Newsletteruser->save($this->data)) {

					$this->Session->setFlash('Subscriber details has been updated successfully!', 'default',array('class'=> 'success'));

			        $this->redirect(array('controller' => 'newsletterusers','action'=>'index'));

					exit;

				}

		}else{

			$this->data = $this->Newsletteruser->read();			

		}

		$this->layout = 'adm';

	} 

	

	function setStatus($uid='',$status='')

	{

	    $this->Newsletteruser->id = $uid;

		$this->Newsletteruser->saveField('status',$status);

	    $this->Session->setFlash('Subscriber status has been updated successfully!', 'default',array('class'=> 'success'));

	    $this->redirect(array('controller' => 'newsletterusers','action'=>'index'));

	}

	

	function delete($delid='')

	{

	  if($delid==''){

			$this->redirect(array('controller' => 'newsletterusers','action'=>'index'));

			exit();

		}


	  if($this->Newsletteruser->delete($delid)){

			$this->Session->setFlash('Subscriber has been deleted Successfully.', 'default',array('class'=> 'success'));

			$this->redirect(array('controller' => 'newsletterusers','action'=>'index'));

			exit;

	}

	}	   
 function __validateLoginStatus($typ='A')
    {
           if($typ == 'A'){
				if($this->Session->check('Admin') == false)
				{
					$this->Session->setFlash('The URL you have followed requires you login.', 'default',array('class'=> 'failure'));
					$this->redirect(array('controller' => 'admins', 'action' => 'login')); 
				}
		}else{
				if($this->Session->check('Userlog') == false)
				{
					$this->Session->setFlash('The URL you have followed requires you login.', 'default',array('class'=> 'failure'));
					$this->redirect(array('controller' => 'users', 'action' => 'login')); 
				}
			}
    }  	

}

?>